!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 


  SUBROUTINE proc_make_variable_metadata(domain_id,date,time)
    ! This subroutine populates the variable metadata records
    ! found in module_gridded_data.
    ! 
    ! HISTORY
    ! =======
    ! Nov 2000 - Brent L. Shaw, NOAA/FSL
    !            Original Version
    ! Apr 2001 - Brent L. Shaw, NOAA/FSL
    !            A few mods to support hinterp re-structure and
    !            LSM support
    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    USE hinterp_setup
    USE domain_info
    USE gridded_data
    USE wrf_metadata

    IMPLICIT NONE

    INTEGER, INTENT(IN)    :: domain_id
    INTEGER, INTENT(IN)    :: date  ! YYYYJJJ
    REAL, INTENT(IN)       :: time  !  Seconds since 00UTC of date
    INTEGER :: i, nz
   
    nz = number_of_original_levels + num_new_levels

    ! We need to make the metadata record for each of the variables
    ! by running through each of them, first by 3d then by 2d

    ! Set the defaults for the 3d variables and change by exception

    var_up(:)%domain_id = domain_id
    var_up(:)%ndim = 3
    var_up(:)%dim_val(1) = nx
    var_up(:)%dim_val(2) = ny
    var_up(:)%dim_val(3) = nz
    var_up(:)%dim_desc(1) = 'W-E '
    var_up(:)%dim_desc(2) = 'S-N '
    var_up(:)%dim_desc(3) = 'VERT'
    var_up(:)%start_index(1) = 1
    var_up(:)%start_index(2) = 1
    var_up(:)%start_index(3) = 1
    var_up(:)%stop_index(1) = nx
    var_up(:)%stop_index(2) = ny
    var_up(:)%stop_index(3) = nz
    var_up(:)%h_stagger_index = n_ind ! Non-staggered
    var_up(:)%v_stagger_index = 1
    var_up(:)%array_order = '+X+Y+Z  '
    var_up(:)%field_type  = 'REAL'
    var_up(:)%field_source_prog = 'SI      '
   
    header_3d : DO i = 1 , fg_variables_up_index
        var_up(i)%name = all_names_up(i)(1:8)
        var_up(i)%units(1:16) = all_names_up(i)(10:26)
        var_up(i)%description(1:46) = all_names_up(i)(35:80)
        var_up(i)%source_desc = all_sources_up(i)
        var_up(i)%vt_date_start = date
        var_up(i)%vt_date_stop = date
        var_up(i)%vt_time_start = time
        var_up(i)%vt_time_stop = time
        var_up(i)%field_time_type = 'INSTANT '
        var_up(i)%h_stagger_index= n_ind
    END DO header_3d

    ! Set the defaults for the 2d variables and change by exception

    var_up(:)%domain_id = domain_id
    var_sfc(:)%ndim = 2
    var_sfc(:)%dim_val(1) = nx
    var_sfc(:)%dim_val(2) = ny
    var_sfc(:)%dim_desc(1) = 'W-E '
    var_sfc(:)%dim_desc(2) = 'S-N '
    var_sfc(:)%start_index(1)   = 1
    var_sfc(:)%start_index(2) = 1
    var_sfc(:)%stop_index(1) = nx
    var_sfc(:)%stop_index(2) = ny
    var_sfc(:)%h_stagger_index = n_ind
    var_sfc(:)%v_stagger_index = 1
    var_sfc(:)%array_order = '+X+Y    '
    var_sfc(:)%field_type  = 'REAL'
    var_sfc(:)%field_source_prog = 'SI      '

    header_2d : DO i = 1 , fg_variables_sfc_index
        var_sfc(i)%name = all_names_sfc(i)(1:8)
        var_sfc(i)%units(1:16) = all_names_sfc(i)(10:26)
        var_sfc(i)%description(1:46) = all_names_sfc(i)(35:80)
        var_sfc(i)%source_desc = all_sources_sfc(i)
        var_sfc(i)%vt_date_start = date
        var_sfc(i)%vt_date_stop = date
        var_sfc(i)%vt_time_start = time
        var_sfc(i)%vt_time_stop = time
        var_sfc(i)%field_time_type = 'INSTANT '
        IF ( (var_sfc(i)%name(1:2) .EQ. 'ST').OR. &
             (var_sfc(i)%name(1:2) .EQ. 'SM').OR. &
             (var_sfc(i)%name(1:2) .EQ. 'SW').OR.&
             (var_sfc(i)%name(1:4) .EQ. 'SNOW').OR. &
             (var_sfc(i)%name(1:5) .EQ. 'WEASD') .OR. &
             (var_sfc(i)%name(1:3) .EQ. 'SEA') .OR. &
             (var_sfc(i)%name(1:3) .EQ. 'SST') .OR. &
             (var_sfc(i)%name(1:8) .EQ. 'T_AVGANN').OR.&
             (var_sfc(i)%name(1:4) .EQ. 'SOIL').OR.&
             (var_sfc(i)%name(1:4) .EQ. 'SKIN').OR.&
             (var_sfc(i)%name(1:6) .EQ. 'CANWAT').OR.&
             (var_sfc(i)%name(1:6) .EQ. 'CANOPY').OR.&
             (var_sfc(i)%name(1:4) .EQ. 'LAND').OR.&
             (var_sfc(i)%name(1:5) .EQ. 'RHOSN').OR.&
             (var_sfc(i)%name(1:5) .EQ. 'TSNOW').OR.&
             (var_sfc(i)%name(1:3) .EQ. 'VEG') ) THEN
          ! LSM variables are staggered to t_grid
          var_sfc(i)%h_stagger_index = t_ind
        END IF
    END DO header_2d

  END SUBROUTINE proc_make_variable_metadata

