!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 

SUBROUTINE proc_output_variable(time)

  USE hinterp_setup
  USE wrf_metadata
  USE gridded_data
  
  IMPLICIT NONE
  CHARACTER(LEN=19),INTENT(IN) :: time
  CHARACTER(LEN=200) :: outfile_name
  CHARACTER (LEN=2) :: domain_id_string
  INTEGER  :: i,nz, output_file, output_unit, file_index, open_status
  REAL, ALLOCATABLE :: dum3d(:,:,:)
  REAL, ALLOCATABLE :: dum2d(:,:)
  TYPE(wrfvar_metadata) :: var_dummy
  REAL :: current_min_top = 0
  LOGICAL :: already_opened
  LOGICAL :: have_soilhgt
  LOGICAL :: keep_sfc
  REAL, ALLOCATABLE :: diffarr(:,:)
  INTEGER :: zstart, zend
  LOGICAL :: ua_is_isobaric
  nz = number_of_original_levels+ num_new_levels
 
  have_soilhgt = .false. 
  ALLOCATE (dum3d (dom_meta%xdim,dom_meta%ydim,nz) )
  ALLOCATE (dum2d (dom_meta%xdim,dom_meta%ydim))

  WRITE(domain_id_string, '(I2.2)') dom_meta%id
  outfile_name = TRIM(output_prefix) // '.d' //domain_id_string // &
               '.' // time(1:19)
  output_file = -1
  find_unit : DO file_index = 10, 99
    INQUIRE (UNIT=file_index, OPENED=already_opened)
    IF ( .NOT. already_opened) THEN
      output_file = file_index
      EXIT find_unit
     END IF
  END DO find_unit

  IF ( output_file .EQ. -1 ) THEN
    PRINT '(A)','Could not find a spare unit for the REGRID data.'
    STOP 'output_file_unit'
  END IF

  PRINT '(A,A)', 'Opening output file: ', outfile_name

  OPEN ( UNIT=output_file , &
         FILE=TRIM(outfile_name) , &
         STATUS = 'UNKNOWN' , &
         FORM = 'UNFORMATTED' , &
         IOSTAT = open_status )
  IF ( open_status .NE. 0 ) THEN
    PRINT '(A,A,A)' , 'Error opening ',outfile_name,' file.'
    STOP 'output_file_open'
  END IF
  REWIND(output_file) ! for safety

  ! If this is isobaric data, we need to make sure real data
  ! is in the 2001 mb level, which is always present by default
  ! We will check the critical values for interpolation...namely
  ! T, RH, and HGT.  If any of those has the 1000mb data replicated
  ! then we will throw away the first level for all variables.

  ! First decide if ua_is_isobaric.  Non-isobaric data sets
  ! will just have a numerical index as the output_levels,
  ! with the first level begin 1 and the last being NZ, 
  ! ordered from the bottom of the atmos to the top. Thus
  ! we can simply compute the difference of the last
  ! and first output_levels.  If the diff is negative
  ! then we are on isobaric levels (e.g., 100 - 1000.)

  IF ( (output_levels(nz) - output_levels(1)) .GT. 0) THEN
   ua_is_isobaric = .false.
  ELSE
   ua_is_isobaric = .true.
  ENDIF
    
  IF (ua_is_isobaric)THEN
    keep_sfc = .TRUE.  
    ALLOCATE(diffarr(dom_meta%xdim,dom_meta%ydim))
    check_critical: DO i = 1, fg_variables_up_index
      IF ((var_up(i)%name(1:8) .EQ. 'T       ').OR. &
          (var_up(i)%name(1:8) .EQ. 'HGT     ').OR. &
          (var_up(i)%name(1:8) .EQ. 'RH      ').OR. &
          (var_up(i)%name(1:8) .EQ. 'U       ').OR. &
          (var_up(i)%name(1:8) .EQ. 'V       ')) THEN
        diffarr = all_3d(:,:,2,i) - all_3d(:,:,1,i)
        IF ( ( NINT(MAXVAL(diffarr)) .EQ. 0 ) .AND. &
           ( NINT(MINVAL(diffarr)) .EQ. 0) ) THEN
          ! 1st (2001) and second levels are same, so
          ! sfc data is invalid
          keep_sfc = .FALSE. 
        ENDIF  
        IF (.NOT. keep_sfc) EXIT check_critical
      ENDIF
    ENDDO check_critical
    DEALLOCATE(diffarr)
    zend = dom_meta%zdim
    IF (.NOT. keep_sfc) THEN
      print *, 'ISOBARIC DATA: SFC T, HGT, RH, U, or V missing,'
      print *, '  IGNORING ALL SFC VALUES IN 3D ARRAYS'
      dom_meta%zdim = dom_meta%zdim - 1
      zstart = 2
    ELSE
      zstart = 1
    ENDIF
    print *, 'ISOBARIC OUTPUT LEVELS:', output_levels(zstart:zend)
  ELSE 
    zstart = 1
    zend = dom_meta%zdim
  ENDIF
    
  ! Put the domain metadata as the first record of this file.  There is a 
  ! different file for each time period.  

  PRINT '(A)', 'Writing domain metadata...'
print *, dom_meta%xdim, dom_meta%ydim
  WRITE(output_file) dom_meta%id, dom_meta%parent_id, &
    dom_meta%dyn_init_src, dom_meta%static_init_src, &
    dom_meta%vt_date, dom_meta%vt_time, dom_meta%origin_parent_x, &
    dom_meta%origin_parent_y, dom_meta%ratio_to_parent, &
    dom_meta%delta_x, dom_meta%delta_y, dom_meta%top_level, &
    dom_meta%origin_parent_z, dom_meta%corner_lats, dom_meta%corner_lons, &
    dom_meta%xdim, dom_meta%ydim, dom_meta%zdim

  ! If this is isobaric data, then output the pressure levels
  ! used as a 1D array.
  IF (ua_is_isobaric) THEN  

    PRINT '(A)', 'Writing output levels...'
    var_dummy%name = pressure_id
    var_dummy%units = 'Pa              '
    var_dummy%description = 'Pressure levels used for vertical coordinate ' // &
                       '(200100 = sfc)'
    var_dummy%dim_desc(1) = 'PRES'
    var_dummy%source_desc ='User defined pressure levels'
    var_dummy%domain_id = dom_meta%id
    var_dummy%ndim = 1
    var_dummy%dim_val(1) = dom_meta%zdim
    var_dummy%dim_val(2:4) = 0
    var_dummy%start_index(1) = 1
    var_dummy%start_index(2:4) = 0
    var_dummy%stop_index(1) = dom_meta%zdim
    var_dummy%stop_index(2:4) = 0
    var_dummy%h_stagger_index = 0
    var_dummy%v_stagger_index = 1             
    var_dummy%array_order = '-P      '
    var_dummy%field_type = 'REAL'
    var_dummy%field_source_prog = 'SI  '
    var_dummy%field_time_type = 'CONSTANT'
    var_dummy%vt_date_start = dom_meta%vt_date
    var_dummy%vt_time_start = dom_meta%vt_time
    var_dummy%vt_date_stop = dom_meta%vt_date
    var_dummy%vt_time_stop = dom_meta%vt_time

    ! Output the levels.

    WRITE (output_file) var_dummy%name, var_dummy%units, var_dummy%description, &
     var_dummy%domain_id, var_dummy%ndim, var_dummy%dim_val, var_dummy%dim_desc, &
     var_dummy%start_index, var_dummy%stop_index, var_dummy%h_stagger_index, &
     var_dummy%v_stagger_index, var_dummy%array_order, var_dummy%field_type, &
     var_dummy%field_source_prog, var_dummy%source_desc, var_dummy%field_time_type, &
     var_dummy%vt_date_start, var_dummy%vt_time_start, var_dummy%vt_date_stop, &
     var_dummy%vt_time_stop

    WRITE (output_file) REAL(output_levels(zstart:zend))
 
  ENDIF
  ! Now loop through 3-d and 2-d variables and output their metadata followed
  ! by the arrays

  PRINT '(A)', 'Writing 3-d variables...'
  loop_3d: DO i = 1,fg_variables_up_index
    var_up(i)%dim_val(3) = dom_meta%zdim
    var_up(i)%stop_index(3) = dom_meta%zdim 
    WRITE (output_file) var_up(i)%name, var_up(i)%units, &
      var_up(i)%description, var_up(i)%domain_id, var_up(i)%ndim, &
      var_up(i)%dim_val, var_up(i)%dim_desc, var_up(i)%start_index, &
      var_up(i)%stop_index, var_up(i)%h_stagger_index, &
      var_up(i)%v_stagger_index, var_up(i)%array_order, &
      var_up(i)%field_type, var_up(i)%field_source_prog, &
      var_up(i)%source_desc, var_up(i)%field_time_type, &
      var_up(i)%vt_date_start, var_up(i)%vt_time_start, &
      var_up(i)%vt_date_stop, var_up(i)%vt_time_stop

    dum3d = all_3d(:,:,:,i)
    WRITE (output_file) dum3d(:,:,zstart:zend)
    PRINT '(A,A)', 'Wrote ', var_up(i)%name
 
    ! Check to see if this is GPH so we can determine the minimum height of the top
    ! level to help the user in setting model top in the zeta coordinate system.  

   IF (var_up(i)%name(1:8).EQ. height_id) THEN
     current_min_top = MINVAL(dum3d(:,:,nz))
     !IF (verbose) THEN 
       PRINT '(A,F10.2)', 'Minimum height of top level for this time = ',current_min_top
     !END IF
     IF (current_min_top .LT. min_top_height) THEN
         min_top_height = current_min_top
         PRINT '(A,F10.2)', 'New min top = ', min_top_height
     END IF
   ENDIF
  END DO loop_3d

  PRINT '(A)', 'Writing 2-d variables...'
  loop_2d: DO i = 1, fg_variables_sfc_index
    IF  (var_sfc(i)%name .EQ. 'LANDSEA ') THEN
      ! We do not want to write out the source models land mask
      CYCLE loop_2d
    ENDIF
    WRITE (output_file) var_sfc(i)%name, var_sfc(i)%units, &
    var_sfc(i)%description, var_sfc(i)%domain_id, var_sfc(i)%ndim, &
    var_sfc(i)%dim_val, var_sfc(i)%dim_desc, var_sfc(i)%start_index, &
    var_sfc(i)%stop_index, var_sfc(i)%h_stagger_index, &
    var_sfc(i)%v_stagger_index, var_sfc(i)%array_order, &
    var_sfc(i)%field_type, var_sfc(i)%field_source_prog, &
    var_sfc(i)%source_desc, var_sfc(i)%field_time_type, &
    var_sfc(i)%vt_date_start, var_sfc(i)%vt_time_start, &
    var_sfc(i)%vt_date_stop, var_sfc(i)%vt_time_stop 
    dum2d = all_2d(:,:,i)
    WRITE (output_file) dum2d
    PRINT '(A,A)', 'Wrote ', var_sfc(i)%name
    IF (var_sfc(i)%name .EQ. 'SOILHGT ') have_soilhgt = .true.
  END DO loop_2d

  ! If we did not have a soil height field explicitly read in, then output
  ! the one we generated
  IF ( (.NOT.have_soilhgt).AND.(ALLOCATED(soilhgt_bg))) THEN
    IF (MAXVAL(soilhgt_bg) .GT. -9999.) THEN
      var_dummy%name = soilhgt_id
      var_dummy%units = 'm      '
      var_dummy%description = 'Terrain height of source data        '
      var_dummy%domain_id = dom_meta%id
      var_dummy%ndim=2
      var_dummy%h_stagger_index = t_ind
      var_dummy%dim_val(1) = dom_meta%xdim
      var_dummy%dim_val(2) = dom_meta%ydim
      var_dummy%dim_val(3:var_maxdims) = 1
      var_dummy%dim_desc(1) = 'E-W'
      var_dummy%dim_desc(2) = 'N-S'
      var_dummy%dim_desc(3:var_maxdims) = '    '
      var_dummy%start_index(1) = 1
      var_dummy%start_index(2) = 1
      var_dummy%start_index(3:var_maxdims) = 0
      var_dummy%stop_index(1) = dom_meta%xdim
      var_dummy%stop_index(2) = dom_meta%ydim
      var_dummy%stop_index(3:var_maxdims) = 0
      var_dummy%v_stagger_index =  0
      var_dummy%array_order = '+X+Y  '
      var_dummy%field_type = 'REAL'
      var_dummy%field_source_prog = 'SI'
      var_dummy%source_desc = 'Horizon. interpolation by SI'
      var_dummy%field_time_type = 'CONSTANT'
      var_dummy%vt_date_start = dom_meta%vt_date
      var_dummy%vt_time_start = dom_meta%vt_time
      var_dummy%vt_date_stop = dom_meta%vt_date
      var_dummy%vt_time_stop = dom_meta%vt_time

      WRITE(output_file)  var_dummy%name, var_dummy%units, var_dummy%description, &
        var_dummy%domain_id, var_dummy%ndim, var_dummy%dim_val, var_dummy%dim_desc, &
        var_dummy%start_index, var_dummy%stop_index, var_dummy%h_stagger_index, &
        var_dummy%v_stagger_index, var_dummy%array_order, var_dummy%field_type, &
        var_dummy%field_source_prog, var_dummy%source_desc, var_dummy%field_time_type, &
        var_dummy%vt_date_start, var_dummy%vt_time_start, var_dummy%vt_date_stop, &
        var_dummy%vt_time_stop

      WRITE(output_file) soilhgt_bg
      DEALLOCATE(soilhgt_bg)
    ENDIF
  ENDIF
  DEALLOCATE (dum2d)
  DEALLOCATE (dum3d)
  CLOSE (output_file)
  PRINT '(A)', 'Done with variable output.'
END subroutine proc_output_variable
