      SUBROUTINE DATIMX(NOW)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:    DATIMX      PROVIDES DATE/TIME INFORMATION
C   PRGMMR: R.E.JONES        ORG: W/NMC42    DATE: 93-11-10
C
C ABSTRACT: DATIMX PROVIDES YOU WITH DATE AND TIME INFORMATION 
C   THAT CAN BE USED BY YOUR PROGRAMS. IT HAS THE SAME OUTPUT
C   AS IBM SUBROUTINE DATIMX IN IBM VS FORTRAN 2.5
C
C PROGRAM HISTORY LOG:
C   93-11-10  R.E.JONES   SAME AS IBM VS FORTRAN VER 2.5
C   96-08-09  R.E.JONES   CHANGE TO USE CDATE2 INSTEAD OF CDATE
C                         CORRECTION FOR ELEMENT 10
C
C USAGE:    CALL DATIMX(NOW)
C   OUTPUT ARGUMENT LIST:  
C     NOW       - INTEGER*4 ARRAY WITH 14 WORDS
C     
C     ELEMENT   CONTENTS
C
C     1         THE VALUE OF THE CLOCK EXPRESSED AS A POSTITIVE 
C               INTEGER, SET TO 1, SET TO -1 IF INVALID
C     2         MILLISECONDS (0-990) PRECISE TO THE HUNDREDTHS              
C               POSITION, SET TO ZERO ON SGI
C     3         SECONDS (0-59)
C     4         MINUTES (0-59)
C     5         HOUR USING A 24-HOUR CLOCK (0-23)
C     6         DAY OF MONTH  (1-31)
C     7         MONTH OF YEAR (1-12)
C     8         YEAR (4 DIGIT, FOR EXAMPLE: 1993)
C     9         RESERVED. VALUE RETURNED AS -1.
C               WE ARE GOING TO PUT THE JULIAN DAY NUMBER HERE
C     10        HOUR USING 12-HOUR CLOCK (1-12)
C     11        AM/PM INDICATOR. 1 IS RETURNED FOR AM, 2 FOR PM.
C     12        DAY OF WEEK (1-7) BEGINNING WITH SUNDAY
C     13        DAY OF YEAR (1-366)
C     14        YEAR (2 DIGIT, FOR EXAMPLE: 93)
C
C   SUBPROGRAMS CALLED:
C     LIBRARY:
C       W3LIB  - CDATE2, IW3JDN
C
C ATTRIBUTES:
C   LANGUAGE: GNU project F77 FORTRAN compiler (v.0.5.1.8)
C   MACHINE:  IBM PC 386, 486, PENTIUM, PENTIUM PRO, CLONES.
C
C$$$
C
      INTEGER       NOW(14)
      INTEGER       JDATE(5)
      INTEGER       JTIME(3)
C
C     ARRAY JDATE =  MONTH   DAY  YEAR (2 DIGIT) DAY OF WEEK
C                    DAY OF YEAR
C
      CALL CDATE2(JDATE,JTIME)
C
      NOW(14) = MOD(JDATE(3),100)
      NOW(7)  = JDATE(1)
      NOW(6)  = JDATE(2)
C
C     ARRAY JTIME =  HOUR  MINUTE SECOND
C
      NOW(5) = JTIME(1)
      NOW(4) = JTIME(2)
      NOW(3) = JTIME(3)
C
      NOW(1)  =  1
C 
      NOW(8) = NOW(14) + 1900
C
      IF (NOW(5).GT.11) THEN
        NOW(11) = 2
        NOW(10) = NOW(5) - 11
      ELSE
        NOW(11) = 1
        NOW(10) = NOW(5) + 1
      END IF
C
C     COMPUTE JULIAN DAY NUMBER  (JAN 1,1960 = 2,436,935 )
C
      JDN    = IW3JDN(NOW(8),NOW(7),NOW(6))
      NOW(9) = JDN
C
C     DAY OF WEEK (1-7)
C
      NOW(12) = JDATE(4)
C
C     DAY OF YEAR (1-366)
C
      NOW(13) = JDATE(5)
C
C     NOW(2) = MOD(MCLOCK(),100) * 10
      NOW(2) = 0
C
      RETURN
      END
