C-----------------------------------------------------------------------
      SUBROUTINE GETGI(LUGI,MNUM,MBUF,CBUF,NLEN,NNUM,IRET)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM: GETGI          READS A GRIB INDEX FILE
C   PRGMMR: IREDELL          ORG: W/NMC23     DATE: 95-10-31
C
C ABSTRACT: READ A GRIB INDEX FILE AND RETURN ITS CONTENTS.
C   VERSION 1 OF THE INDEX FILE HAS THE FOLLOWING FORMAT:
C     81-BYTE S.LORD HEADER WITH 'GB1IX1' IN COLUMNS 42-47 FOLLOWED BY
C     81-BYTE HEADER WITH NUMBER OF BYTES TO SKIP BEFORE INDEX RECORDS,
C     NUMBER OF BYTES IN EACH INDEX RECORD, NUMBER OF INDEX RECORDS,
C     AND GRIB FILE BASENAME WRITTEN IN FORMAT ('IX1FORM:',3I10,2X,A40).
C     EACH FOLLOWING INDEX RECORD CORRESPONDS TO A GRIB MESSAGE
C     AND HAS THE INTERNAL FORMAT:
C       BYTE 001-004: BYTES TO SKIP IN DATA FILE BEFORE GRIB MESSAGE
C       BYTE 005-008: BYTES TO SKIP IN MESSAGE BEFORE PDS
C       BYTE 009-012: BYTES TO SKIP IN MESSAGE BEFORE GDS (0 IF NO GDS)
C       BYTE 013-016: BYTES TO SKIP IN MESSAGE BEFORE BMS (0 IF NO BMS)
C       BYTE 017-020: BYTES TO SKIP IN MESSAGE BEFORE BDS
C       BYTE 021-024: BYTES TOTAL IN THE MESSAGE
C       BYTE 025-025: GRIB VERSION NUMBER
C       BYTE 026-053: PRODUCT DEFINITION SECTION (PDS)
C       BYTE 054-095: GRID DEFINITION SECTION (GDS) (OR NULLS)
C       BYTE 096-101: FIRST PART OF THE BIT MAP SECTION (BMS) (OR NULLS)
C       BYTE 102-112: FIRST PART OF THE BINARY DATA SECTION (BDS)
C       BYTE 113-172: (OPTIONAL) BYTES 41-100 OF THE PDS
C       BYTE 173-184: (OPTIONAL) BYTES 29-40 OF THE PDS
C       BYTE 185-320: (OPTIONAL) BYTES 43-178 OF THE GDS
C
C PROGRAM HISTORY LOG:
C   95-10-31  IREDELL
C   96-10-31  IREDELL   AUGMENTED OPTIONAL DEFINITIONS TO BYTE 320
C
C USAGE:    CALL GETGI(LUGI,MNUM,MBUF,CBUF,NLEN,NNUM,IRET)
C   INPUT ARGUMENTS:
C     LUGI         INTEGER UNIT OF THE UNBLOCKED GRIB INDEX FILE
C     MNUM         INTEGER NUMBER OF INDEX RECORDS TO SKIP (USUALLY 0)
C     MBUF         INTEGER LENGTH OF CBUF IN BYTES
C   OUTPUT ARGUMENTS:
C     CBUF         CHARACTER*1 (MBUF) BUFFER TO RECEIVE INDEX DATA
C     NLEN         INTEGER LENGTH OF EACH INDEX RECORD IN BYTES
C     NNUM         INTEGER NUMBER OF INDEX RECORDS
C     IRET         INTEGER RETURN CODE
C                    0      ALL OK
C                    1      CBUF TOO SMALL TO HOLD INDEX BUFFER
C                    2      ERROR READING INDEX FILE BUFFER
C                    3      ERROR READING INDEX FILE HEADER
C
C SUBPROGRAMS CALLED:
C   BAREAD         BYTE-ADDRESSABLE READ
C
C REMARKS: SUBPROGRAM CAN BE CALLED FROM A MULTIPROCESSING ENVIRONMENT.
C   DO NOT ENGAGE THE SAME LOGICAL UNIT FROM MORE THAN ONE PROCESSOR.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  CRAY, WORKSTATIONS
C
C$$$
      CHARACTER CBUF(MBUF)
      CHARACTER CHEAD*162
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      NLEN=0
      NNUM=0
      IRET=3
      CALL BAREAD(LUGI,0,162,LHEAD,CHEAD)
      IF(LHEAD.EQ.162.AND.CHEAD(42:47).EQ.'GB1IX1') THEN
        READ(CHEAD(82:162),'(8X,3I10,2X,A40)',IOSTAT=IOS) NSKP,NLEN,NNUM
        IF(IOS.EQ.0) THEN
          NSKP=NSKP+MNUM*NLEN
          NNUM=NNUM-MNUM
          NBUF=NNUM*NLEN
          IRET=0
          IF(NBUF.GT.MBUF) THEN
            NNUM=MBUF/NLEN
            NBUF=NNUM*NLEN
            IRET=1
          ENDIF
          IF(NBUF.GT.0) THEN
            CALL BAREAD(LUGI,NSKP,NBUF,LBUF,CBUF)
            IF(LBUF.NE.NBUF) IRET=2
          ENDIF
        ENDIF
      ENDIF
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      RETURN
      END
