! Module that handles both binary file and wrf IO API output.
!
!  HISTORY
!     Nov 2002 - Original version -- Jacques Middlecoff, NOAA/FSL (CIRA)
!     Mar 2003 - exact output dimensions - John Michalakes, NCAR/MMM
!     Mar 2003 - use WRF names - Dave Gill, NCAR/MMM

MODULE WriteField
 use wrfsi_io
 use wrf_data
 use staticpost_setup
 implicit none

 INTERFACE write_field
    MODULE PROCEDURE write0Dfield
    MODULE PROCEDURE write1Dfield
    MODULE PROCEDURE write2Dfield
    MODULE PROCEDURE write3Dfield
 END INTERFACE

  ! Variables shared among contained subroutines
   CHARACTER(LEN=19),PRIVATE :: DateStr = '0000-00-00-00:00:00'
   CHARACTER(LEN=10),PRIVATE :: Stagger                ! Dummy field
   INTEGER,PRIVATE           :: Comm,IOComm,DomainDesc ! Dummy fields
   character(LEN=4),PRIVATE  :: fileType
   CHARACTER (len=8),PRIVATE :: WrfName                ! Name used in netCDF file

 contains

  subroutine write0Dfield(Name,A,VarMeta)
! This routine writes scalar A to the binary file domfile 
! and also writes A using the wrf I/O API.
  CHARACTER*(*)         , INTENT (IN) :: Name
  REAL                  , INTENT (IN) :: A
  TYPE(wrfvar_metadata) , INTENT (IN) :: VarMeta
  CHARACTER(LEN=80)                   :: DimNames
  INTEGER                             :: Start,End

  fileType = setup_info%output_file_type
  if(.not.DryRun) then
    if(fileType == 'BIN' .or. fileType == 'BOTH') then
      PRINT *, 'write0Dfield ... BIN output of ', NAME
      CALL output_variable_metadata(VarMeta)
      WRITE (domfile_out) A
    endif
  endif
  call WriteFieldSetup
  DimNames = '0'
  Start    = 1
  End      = 1

  if(fileType == 'WRF' .or. fileType == 'BOTH') then
    call ext_ncd_write_field(WrfDataHandle,DateStr,Name,A,WRF_REAL,Comm,       &
    IOComm,DomainDesc,'0',Stagger,DimNames,Start,End,Start,End,Start,End,Status)
    CALL output_variable_wrf_metadata(VarMeta,Name,DateStr)
  endif
  end subroutine write0Dfield

  subroutine write1Dfield(Name,A,VarMeta)
! This routine writes vector A to the binary file domfile 
! and also writes A using the wrf I/O API.
  CHARACTER*(*)         , INTENT (IN) :: Name
  REAL                  , INTENT (IN) :: A(:)
  TYPE(wrfvar_metadata) , INTENT (IN) :: VarMeta
  CHARACTER(LEN=80)                    :: DimNames(3)
  INTEGER,DIMENSION(3)                :: Start,End
  INTEGER,DIMENSION(3)                :: Start_patch,End_patch

  fileType = setup_info%output_file_type
  if(.not.DryRun) then
    if(fileType == 'BIN' .or. fileType == 'BOTH') then
      PRINT *, 'write1Dfield ... BIN output of ', NAME
      CALL output_variable_metadata(VarMeta)
      WRITE (domfile_out) A
    endif
  endif
  call WriteFieldSetup
  DimNames = 'z'
  Start    = 1
  End      = size(A)

  IF (setup_info%nmmcore) THEN
    call wrf_stagger_nmm( VarMeta, Stagger, DimNames(3), DimNames(2), DimNames(1),            &
                             Start_patch(3), Start_patch(2), Start_patch(1),   &
                             End(3),  End(2), End(1),                          &
                             End_patch(3), End_patch(2), End_patch(1) , &
                             Name )
  ELSE
    call wrf_stagger( VarMeta, Stagger, DimNames(3), DimNames(2), DimNames(1),            &
                             Start_patch(3), Start_patch(2), Start_patch(1),   &
                             End(3),  End(2), End(1),                          &
                             End_patch(3), End_patch(2), End_patch(1) , &
                             Name )
  ENDIF

  if(fileType == 'WRF' .or. fileType == 'BOTH') then
    write(6,*)'WRF Name ',WrfName,' NAME ', Name, ' Stagger ', Stagger

    call ext_ncd_write_field(WrfDataHandle,DateStr,WrfName,A,WRF_REAL,Comm,       &
    IOComm,DomainDesc,'z',Stagger,DimNames,Start_patch,End_patch,Start,End,Start_patch,End_patch,Status)
    CALL output_variable_wrf_metadata(VarMeta,WrfName,DateStr)
  endif
  end subroutine write1Dfield

  subroutine write2Dfield(Name,A,VarMeta)
! This routine writes the 2D array A to the binary file domfile 
! and also writes A using the wrf I/O API.
  CHARACTER*(*)         , INTENT (IN) :: Name
  REAL                  , INTENT (IN) :: A(:,:)
  TYPE(wrfvar_metadata) , INTENT (IN) :: VarMeta
  CHARACTER(LEN=80)                    :: DimNames(3)
  INTEGER,DIMENSION(3)                :: Start,End
  INTEGER,DIMENSION(3)                :: Start_patch,End_patch

  fileType = setup_info%output_file_type



  if(.not.DryRun) then
    if(fileType == 'BIN' .or. fileType == 'BOTH') then
      PRINT *, 'write2Dfield ... BIN output of ', NAME, ' to ',domfile_out
      CALL output_variable_metadata(VarMeta)
      WRITE (domfile_out) A
    endif
  endif
  call WriteFieldSetup
  DimNames(1) = 'x'
  DimNames(2) = 'y'
  Start = 1
  End(1) = size(A,1)
  End(2) = size(A,2)

   IF (setup_info%nmmcore) THEN
  call wrf_stagger_nmm( VarMeta, Stagger, DimNames(1), DimNames(2), DimNames(3),            &
                           Start_patch(1), Start_patch(2), Start_patch(3),   &
                           End(1),  End(2), End(3),                          &
                           End_patch(1), End_patch(2), End_patch(3) , &
                           Name )
   ELSE
  call wrf_stagger( VarMeta, Stagger, DimNames(1), DimNames(2), DimNames(3),            &
                             Start_patch(1), Start_patch(2), Start_patch(3),   &
                             End(1),  End(2), End(3),                          &
                             End_patch(1), End_patch(2), End_patch(3) , &
                             Name )
   ENDIF

  if(fileType == 'WRF' .or. fileType == 'BOTH') then
    call ext_ncd_write_field(WrfDataHandle,DateStr,WrfName,A,WRF_REAL,Comm, &
    IOComm, DomainDesc, 'XY', Stagger,  DimNames,                      &
    Start_patch,End_patch,Start,End,Start_patch,End_patch,Status)
    CALL output_variable_wrf_metadata(VarMeta,WrfName,DateStr)
    write(6,*)'WRF Name ',WrfName,' NAME ', Name, ' Stagger ', Stagger
  endif
  end subroutine write2Dfield

  subroutine write3Dfield(Name,A,VarMeta,DimName3)
! This routine writes the 3D array A to the binary file domfile 
! and also writes A using the wrf I/O API.
  CHARACTER*(*)         , INTENT (IN) :: Name
  REAL                  , INTENT (IN) :: A(:,:,:)
  TYPE(wrfvar_metadata) , INTENT (IN) :: VarMeta
  CHARACTER(LEN=17)     , INTENT (IN) :: DimName3
  CHARACTER(LEN=80)                   :: DimNames(3)
  INTEGER,DIMENSION(3)                :: Start,End
  CHARACTER(LEN=2)                    :: str
  INTEGER,DIMENSION(3)                :: Start_patch,End_patch

  fileType = setup_info%output_file_type
  if(.not.DryRun) then
    if(fileType == 'BIN' .or. fileType == 'BOTH') then
      PRINT *, 'write3Dfield ... BIN output of ', NAME 
      CALL output_variable_metadata(VarMeta)
      WRITE (domfile_out) A
    endif
  endif
  call WriteFieldSetup
  Start = 1
  End(1) = size(A,1)
  End(2) = size(A,2)
  End(3) = size(A,3)

  IF (setup_info%nmmcore) THEN
    call wrf_stagger_nmm( VarMeta, Stagger, DimNames(1), DimNames(2), DimNames(3),            &
                             Start_patch(1), Start_patch(2), Start_patch(3),   &
                             End(1),  End(2), End(3),                          &
                             End_patch(1), End_patch(2), End_patch(3) ,        &
                             Name )
  ELSE
    call wrf_stagger( VarMeta, Stagger, DimNames(1), DimNames(2), DimNames(3),            &
                             Start_patch(1), Start_patch(2), Start_patch(3),   &
                             End(1),  End(2), End(3),                          &
                             End_patch(1), End_patch(2), End_patch(3) ,        &
                             Name )
  ENDIF

  if(fileType == 'WRF' .or. fileType == 'BOTH') then
    write(6,*)'WRF Name ',WrfName,' NAME ', Name, ' Stagger ', Stagger
    call ext_ncd_write_field(WrfDataHandle,DateStr,WrfName,A,WRF_REAL,Comm, &
    IOComm, DomainDesc, 'XYZ', Stagger,  DimNames,                     &
    Start_patch,End_patch,Start,End,Start_patch,End_patch,Status)
    CALL output_variable_wrf_metadata(VarMeta,WrfName,DateStr)
  endif
  end subroutine write3Dfield

 subroutine WriteFieldSetup
  use staticpost_setup

! call split_date_char ( date , century_year , month , day , hour , minute , second )
! setup_info%current_date has time 19 character mm5 date that I want to set DateStr to
  DateStr    = setup_info%current_date
  Comm       = 1   !not used
  IOComm     = 1   !not used
  DomainDesc = 1   !not used
  Stagger    = ' ' !not used

  return
 end subroutine WriteFieldSetup

!--------------------------------------------------------------------

! added by JM
 subroutine wrf_stagger ( VarMeta, Stagger, Dimname1, Dimname2, Dimname3,    &
                                            Start1, Start2, Start3,          &
                                            size1, size2, size3,             &
                                            End1,   End2,   End3    ,        &
                                            Name )
  IMPLICIT NONE
  TYPE(wrfvar_metadata) , INTENT (IN) :: VarMeta
  CHARACTER*(*) Stagger, Dimname1, Dimname2, Dimname3
  Integer Start1, Start2, Start3
  Integer size1,  size2,  size3
  Integer End1,   End2,   End3
  CHARACTER *(*) :: Name

  Start1 = 1 ; Start2 = 1 ; Start3 = 1
     

  IF      ( VarMeta%h_stagger_index .EQ. u_ind ) THEN
    Stagger = 'X'
    Dimname1 = 'west_east_stag'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2-1
  ELSE IF ( VarMeta%h_stagger_index .EQ. v_ind ) THEN
    Stagger = 'Y'
    DimName1 = 'west_east'
    End1 = size1-1
    Dimname2 = 'south_north_stag'
    End2 = size2
  ELSE IF ( VarMeta%h_stagger_index .EQ. t_ind ) THEN
    Stagger = ' '
    DimName1 = 'west_east'
    End1 = size1-1
    Dimname2 = 'south_north'
    End2 = size2-1
  ELSE
    Stagger = ' '
    DimName1 = 'west_east'
    End1 = size1-1
    Dimname2 = 'south_north'
    End2 = size2-1
  ENDIF

  IF      ( name(1:8) .EQ. 'MAPFAC_U') THEN
    Stagger = 'X'
    Dimname1 = 'west_east_stag'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2-1
  ELSE IF ( name(1:8) .EQ. 'MAPFAC_V') THEN
    Stagger = 'Y'
    DimName1 = 'west_east'
    End1 = size1-1
    Dimname2 = 'south_north_stag'
    End2 = size2
  END IF

! IF      ( VarMeta%v_stagger_index .EQ. zstag_full_index ) THEN
!   Stagger = 'Z'
!   End3 = size3
!   DimName3 = 'bottom_top_stag'
! ELSE IF ( VarMeta%v_stagger_index .EQ. zstag_half_index ) THEN
    Stagger = ' '
    End3 = size3-1
    DimName3 = 'bottom_top'
! ELSE 
! ENDIF

!  make SI output variables consistent with WRF Registry names

!  1d
  if( name(1:8) == 'ETAPFULL' ) then
    WrfName = 'ZNW     '

! 2d

  else if(name(1:8) == 'MU_M    ' ) then
    WrfName = 'MU0     '
!  else if(name(1:8) == 'SNWDPTH ' ) then
!    WrfName = 'SNO     '
  else if(name(1:8) == 'SEAICE  ' ) then
    WrfName = 'XICE    '
!!!!!!	 HOW CAN THIS DO DOUBLE DUTY?
!
!	Registry will read "XICE" into both SI and XICE...solver will use what
!	it needs
!
!    WrfName = 'SI      '
  else if(name(1:8) == 'SKINTEMP' ) then
    WrfName = 'TSK     '
  else if(name(1:8) == 'LAT_M   ' ) then
    WrfName = 'XLAT    '
  else if(name(1:8) == 'LON_M   ' ) then
    WrfName = 'XLONG   '
  else if(name(1:8) == 'TOPO_M  ' ) then
    WrfName = 'HGT     '
! else if(name(1:8) == 'COSALPHA' ) then
!   WrfName = 'COSA    '
! else if(name(1:8) == 'SINALPHA' ) then
!   WrfName = 'SINA    '
  else if(name(1:8) == 'H_CORIOL' ) then
    WrfName = 'F       '
  else if(name(1:8) == 'V_CORIOL' ) then
    WrfName = 'E       '
! else if(name(1:8) == 'MAPFAC_M' ) then
!   WrfName = 'MSFT    '
! else if(name(1:8) == 'MAPFAC_U' ) then
!   WrfName = 'MSFU    '
! else if(name(1:8) == 'MAPFAC_V' ) then
!   WrfName = 'MSFV    '
  else if(name(1:8) == 'GREENFRC' ) then
    WrfName = 'VEGFRA  '
!
!
   else if(name(1:8) == 'T_AVGANN' ) then
    WrfName = 'TMN     '

! 3d

  else if(name(1:8) == 'THETA   ' ) then
    WrfName = 'T       '
  else if(name(1:8) == 'QVAPOR  ' ) then
    WrfName = 'QVAPOR  '
  else if(name(1:8) == 'QLIQUID ' ) then
    WrfName = 'QCLOUD  '
  else if(name(1:8) == 'QRAIN   ' ) then
    WrfName = 'QRAIN   '
  else if(name(1:8) == 'QICE    ' ) then
    WrfName = 'QICE    '
  else if(name(1:8) == 'QSNOW   ' ) then
    WrfName = 'QSNOW   '
  else if(name(1:8) == 'QGRAUPEL' ) then
    WrfName = 'QGRAUP  '
  else if(name(1:8) == 'LANDUSEF' ) then
    WrfName = 'LANDUSEF'
    End3 = size3
    DimName3(1:20) = 'land_cat            '
  else if(name(1:8) == 'SOILCTOP' ) then
    WrfName = 'SOILCTOP'
    End3 = size3
    DimName3(1:20) = 'soil_cat            '
  else if(name(1:8) == 'SOILCBOT' ) then
    WrfName = 'SOILCBOT'
    End3 = size3
    DimName3(1:20) = 'soil_cat            '
  else if(name(1:8) == 'GREEN12M') then
    WrfName = 'GREEN12M'
    End3 = size3
    DimName3(1:20) = 'month               '
  else if(name(1:8) == 'ALBDO12M') then
    WrfName = 'ALBDO12M'
    End3 = size3
    DimName3(1:20) = 'month               '

! otherwise

  else
    WrfName(1:8) = Name(1:8)
  endif

 end subroutine wrf_stagger

 subroutine wrf_stagger_nmm( VarMeta, Stagger, Dimname1, Dimname2, Dimname3,    &
                                            Start1, Start2, Start3,          &
                                            size1, size2, size3,             &
                                            End1,   End2,   End3    ,        &
                                            Name )
  IMPLICIT NONE
  TYPE(wrfvar_metadata) , INTENT (IN) :: VarMeta
  CHARACTER*(*) Stagger, Dimname1, Dimname2, Dimname3
  Integer Start1, Start2, Start3
  Integer size1,  size2,  size3
  Integer End1,   End2,   End3
  CHARACTER *(*) :: Name

  Start1 = 1 ; Start2 = 1 ; Start3 = 1

!! obliterate all "-1" stuff.  full dimensions, regardless of
!! h_stagger_index for NMM purposes.
     

  IF      ( VarMeta%h_stagger_index .EQ. u_ind ) THEN
    Stagger = 'X'
    Dimname1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  ELSE IF ( VarMeta%h_stagger_index .EQ. v_ind ) THEN
    Stagger = 'Y'
    DimName1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  ELSE IF ( VarMeta%h_stagger_index .EQ. t_ind ) THEN
    Stagger = ' '
    DimName1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  ELSE IF ( VarMeta%h_stagger_index .EQ. w_ind ) THEN
!
!mp - full dimensions for NMM business
!
    Stagger = ' '
    DimName1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  ELSE
    Stagger = ' '
    DimName1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  ENDIF

  IF      ( name(1:8) .EQ. 'MAPFAC_U') THEN
    Stagger = 'X'
    Dimname1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  ELSE IF ( name(1:8) .EQ. 'MAPFAC_V') THEN
    Stagger = 'Y'
    DimName1 = 'west_east'
    End1 = size1
    Dimname2 = 'south_north'
    End2 = size2
  END IF

! IF      ( VarMeta%v_stagger_index .EQ. zstag_full_index ) THEN
!   Stagger = 'Z'
!   End3 = size3
!   DimName3 = 'bottom_top_stag'
! ELSE IF ( VarMeta%v_stagger_index .EQ. zstag_half_index ) THEN
    Stagger = ' '
    End3 = size3-1
    DimName3 = 'bottom_top'
! ELSE 
! ENDIF

!  make SI output variables consistent with WRF Registry names

!  1d
  if( name(1:8) == 'ETAPFULL' ) then
    WrfName = 'ZNW     '

! 2d

  else if(name(1:8) == 'MU_M    ' ) then
    WrfName = 'MU0     '
!  else if(name(1:8) == 'SNWDPTH ' ) then
!    WrfName = 'SNO     '
  else if(name(1:8) == 'SEAICE  ' ) then
    WrfName = 'XICE    '
!!!!!!	 HOW CAN THIS DO DOUBLE DUTY?
!
!	Registry will read "XICE" into both SI and XICE...solver will use what
!	it needs
!
!    WrfName = 'SI      '
  else if(name(1:8) == 'SKINTEMP' ) then
    WrfName = 'TSK     '
  else if(name(1:8) == 'LAT_M   ' ) then
    WrfName = 'XLAT    '
  else if(name(1:8) == 'LON_M   ' ) then
    WrfName = 'XLONG   '
  else if(name(1:8) == 'TOPO_M  ' ) then
    WrfName = 'HGT     '
! else if(name(1:8) == 'COSALPHA' ) then
!   WrfName = 'COSA    '
! else if(name(1:8) == 'SINALPHA' ) then
!   WrfName = 'SINA    '
  else if(name(1:8) == 'H_CORIOL' ) then
    WrfName = 'F       '
  else if(name(1:8) == 'V_CORIOL' ) then
    WrfName = 'E       '
! else if(name(1:8) == 'MAPFAC_M' ) then
!   WrfName = 'MSFT    '
! else if(name(1:8) == 'MAPFAC_U' ) then
!   WrfName = 'MSFU    '
! else if(name(1:8) == 'MAPFAC_V' ) then
!   WrfName = 'MSFV    '
  else if(name(1:8) == 'GREENFRC' ) then
    WrfName = 'VEGFRC  '
!
!
   else if(name(1:8) == 'T_AVGANN' ) then
    WrfName = 'TMN     '

! 3d

  else if(name(1:8) == 'THETA   ' ) then
    WrfName = 'T       '
  else if(name(1:8) == 'QVAPOR  ' ) then
    WrfName = 'QVAPOR  '
  else if(name(1:8) == 'QLIQUID ' ) then
    WrfName = 'QCLOUD  '
  else if(name(1:8) == 'QRAIN   ' ) then
    WrfName = 'QRAIN   '
  else if(name(1:8) == 'QICE    ' ) then
    WrfName = 'QICE    '
  else if(name(1:8) == 'QSNOW   ' ) then
    WrfName = 'QSNOW   '
  else if(name(1:8) == 'QGRAUPEL' ) then
    WrfName = 'QGRAUP  '
  else if(name(1:8) == 'LANDUSEF' ) then
    WrfName = 'LANDUSEF'
    End3 = size3
    DimName3(1:20) = 'land_cat            '
  else if(name(1:8) == 'SOILCTOP' ) then
    WrfName = 'SOILCTOP'
    End3 = size3
    DimName3(1:20) = 'soil_cat            '
  else if(name(1:8) == 'SOILCBOT' ) then
    WrfName = 'SOILCBOT'
    End3 = size3
    DimName3(1:20) = 'soil_cat            '
  else if(name(1:8) == 'GREEN12M') then
    WrfName = 'GREEN12M'
    End3 = size3
    DimName3(1:20) = 'month               '
  else if(name(1:8) == 'ALBDO12M') then
    WrfName = 'ALBDO12M'
    End3 = size3
    DimName3(1:20) = 'month               '

! otherwise

  else
    WrfName(1:8) = Name(1:8)
  endif

 end subroutine wrf_stagger_nmm


END MODULE WriteField
