!dis
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis
!dis                                   
MODULE staticpost_setup
   USE date_pack
   USE wrfsi_maxdims
   USE wrfsi_nl
   USE wrf_metadata

    IMPLICIT NONE
   CHARACTER(LEN=256)           :: moad_dataroot
   INTEGER,ALLOCATABLE  :: domain_list(:)
   INTEGER :: num_domains_to_proc
   TYPE r1
    INTEGER             :: num_domains
    INTEGER             :: parent_id(max_domains) 
    INTEGER             :: ratio_to_parent(max_domains)
    INTEGER             :: domain_origin_parent_lli(max_domains)
    INTEGER             :: domain_origin_parent_llj(max_domains)
    INTEGER             :: domain_origin_parent_uri(max_domains)
    INTEGER             :: domain_origin_parent_urj(max_domains)
    INTEGER             :: output_vars 
    INTEGER             :: wrfdate
    REAL                :: wrftime
    REAL                :: moad_delta_x
    CHARACTER (LEN=19)  :: current_date
    CHARACTER(LEN=4)    :: output_file_type
    CHARACTER(LEN=256)  :: output_prefix
    LOGICAL             :: nmmcore
   END TYPE r1
  
   TYPE (r1) :: setup_info
  
 CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 SUBROUTINE setup(moad_dataroot)
    
   IMPLICIT NONE   

   CHARACTER(LEN=256),INTENT(IN) :: moad_dataroot

   INTEGER             :: num_domains
   INTEGER             :: parent_id(max_domains)
   INTEGER             :: ratio_to_parent(max_domains)
   INTEGER             :: domain_origin_lli(max_domains)
   INTEGER             :: domain_origin_llj(max_domains)
   INTEGER             :: domain_origin_uri(max_domains)
   INTEGER             :: domain_origin_urj(max_domains)
   INTEGER             :: xdim,ydim
 
   REAL                :: moad_known_lat, moad_known_lon 
   REAL                :: moad_delta_x,moad_delta_y
   REAL                :: moad_stand_lats(2), moad_stand_lons
   REAL                :: silavwt_parm_wrf, toptwvl_parm_wrf

   CHARACTER(LEN=32)   :: map_proj_name
   CHARACTER(LEN=256)  :: syscmd
   CHARACTER(LEN=256)  :: timefile
   CHARACTER(LEN=256)  :: wrfsinl
   CHARACTER(LEN=10)   :: a10date_file
   INTEGER             :: wrfdate_file 
   LOGICAL             :: foundnl

   NAMELIST / hgridspec / num_domains, xdim, ydim, parent_id, &
      ratio_to_parent, domain_origin_lli, domain_origin_llj,&
      domain_origin_uri, domain_origin_urj, map_proj_name, &
      moad_known_lat, moad_known_lon, moad_stand_lats,moad_stand_lons, &
      moad_delta_x, moad_delta_y, silavwt_parm_wrf, toptwvl_parm_wrf

   ! Hard code to tell the writefield module to use the API for output 
   setup_info%output_file_type = 'WRF'  
   setup_info%output_vars = 2
   ! Get the current date based on the system clock for recording purposed
   timefile = TRIM(moad_dataroot) // '/static/created_wrf_static.dat'
   syscmd = 'date -u +%Y-%m-%d > ' // TRIM(timefile)  
   CALL system(syscmd)
   syscmd = 'date -u +%Y%j >> ' // TRIM(timefile)
   CALL system(syscmd)
   
   OPEN(FILE=timefile,UNIT=10,FORM='FORMATTED',STATUS='OLD')
!   READ(10,'(A10,"_00:00:00")') setup_info%current_date
   READ(10,'(A10)') a10date_file
   setup_info%current_date = a10date_file // "_00:00:00"
!   READ(10, '(I7)') setup_info%wrfdate
   READ(10, '(I7)') wrfdate_file
   setup_info%wrfdate = wrfdate_file
   
   CLOSE(10)
   setup_info%wrftime = 0.
   PRINT '(2a)', 'Using a creation time of ',setup_info%current_date

   ! Read the hgridspec namelist...
   wrfsinl = TRIM(moad_dataroot) // '/static/wrfsi.nl'
   INQUIRE(FILE=wrfsinl,EXIST=foundnl)
   IF (.NOT. foundnl) THEN
     PRINT '(2a)', 'Namelist not found: ', wrfsinl
     STOP
   ENDIF
   OPEN(FILE=wrfsinl, UNIT=10, FORM='FORMATTED',STATUS='OLD')
   READ(10, NML = hgridspec)
   CLOSE(10)
 
   setup_info%num_domains = num_domains
   setup_info%parent_id = parent_id
   setup_info%ratio_to_parent = ratio_to_parent
   setup_info%domain_origin_parent_lli = domain_origin_lli
   setup_info%domain_origin_parent_llj = domain_origin_llj
   setup_info%domain_origin_parent_uri = domain_origin_uri
   setup_info%domain_origin_parent_urj = domain_origin_urj
   setup_info%moad_delta_x = moad_delta_x
   IF (TRIM(map_proj_name) .EQ. 'rotlat') THEN
     setup_info%nmmcore = .true.
     global_meta%output_vcoord = 4
     global_meta%vertical_coord = 'NMMH    '
   ELSE
     setup_info%nmmcore = .false.
     global_meta%output_vcoord = 2
     global_meta%vertical_coord = 'ETAP    '
   ENDIF 
   setup_info%output_prefix = TRIM(moad_dataroot) //'/static/wrfstatic'

   ! Populate some of the global metadata
   global_meta%num_domains = setup_info%num_domains
   global_meta%init_date = setup_info%wrfdate
   global_meta%init_time = setup_info%wrftime
   global_meta%end_date = setup_info%wrfdate
   global_meta%end_time = setup_info%wrftime
   global_meta%si_version = 2
   global_meta%anal_version = 0
   global_meta%wrf_version = 0
   global_meta%post_Version = 0

   RETURN
END SUBROUTINE setup
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
END MODULE staticpost_setup
