PROGRAM siscan

  ! Utility program to scan a file written by hinterp or vinterp and 
  ! print summary info for each variable found.

  USE wrfsi_io
  USE date_pack
  USE wrf_metadata

  IMPLICIT NONE
  INTEGER, PARAMETER       :: siunit = domfile_in
  CHARACTER(LEN=255)       :: sifile
  INTEGER                  :: nx,ny,nz,i,j,k
  REAL                     :: varsum,varmin, varmax, varavg,totalpts 

  CALL GETARG(1,sifile)
  PRINT *, 'Scanning ', TRIM(sifile)

  OPEN(UNIT=siunit,FILE=sifile,STATUS='OLD',FORM='UNFORMATTED', &
       ACCESS='SEQUENTIAL')
  domfile_in_opened = .true.

  ! Read the domain metadata
  READ (siunit) dom_meta%id,dom_meta%parent_id,dom_meta%dyn_init_src,&
        dom_meta%static_init_src, dom_meta%vt_date, dom_meta%vt_time, &
        dom_meta%origin_parent_x, dom_meta%origin_parent_y, &
        dom_meta%ratio_to_parent, dom_meta%delta_x, dom_meta%delta_y, &
        dom_meta%top_level, dom_meta%origin_parent_z, &
        dom_meta%corner_lats, dom_meta%corner_lons, dom_meta%xdim, &
        dom_meta%ydim, dom_meta%zdim    

  PRINT *, 'Domain Metadata Information'
  PRINT *, '-----------------------------------------------------'
  PRINT '(A,I2)', 'Domain Number ......... ', dom_meta%id
  PRINT '(A,I2)', 'Parent ID ............. ', dom_meta%parent_id
  PRINT '(2A)',   'Dynamic Init. Source .. ', TRIM(dom_meta%dyn_init_src)
  PRINT '(2A)',   'Static Init. Source ... ', TRIM(dom_meta%static_init_src)
  PRINT '(A,I7)', 'Valid Date (YYYDDD) ... ',dom_meta%vt_date
  PRINT '(A,F7.1)','Valid Time (sec UTC) .. ',dom_meta%vt_time
  PRINT '(A,I5)', 'Origin X in Parent .... ', dom_meta%origin_parent_x
  PRINT '(A,I5)', 'Origin Y in Parent .... ', dom_meta%origin_parent_y
  PRINT '(A,I5)', 'Nest Ratio to Parent .. ', dom_meta%ratio_to_parent
  PRINT '(A,F7.1)','Delta X ............... ', dom_meta%delta_x
  PRINT '(A,F7.1)','Delta Y ............... ', dom_meta%delta_y 
  PRINT '(A,F8.1)','Top Level ............. ', dom_meta%top_level
  PRINT '(A,I5)',  'Origin Z in Parent .... ', dom_meta%origin_parent_z
  PRINT '(A,I5)',  'X dimension ........... ', dom_meta%xdim
  PRINT '(A,I5)',  'Y dimension ........... ', dom_meta%ydim
  PRINT '(A,I5)',  'Z dimension ........... ', dom_meta%zdim
  PRINT *, ' ---------------------------------------------------'
  PRINT *, ' '
  PRINT *, 'Variables found:'
  PRINT *, 'NAME    S D   NX   NY   NZ  UNITS        DESCRIPTION       MINVAL   MAXVAL   AVGVAL'
  PRINT *, '------- - - ----- ----- --- ------------ ---------------- -------- -------- --------'

  status = 0
  varloop: DO WHILE (status .eq. 0)
    CALL read_next_variable
    IF (status .EQ. 2) THEN
      PRINT *, 'End of file reached.'
      EXIT varloop
    ELSE
      PRINT '(a8,1x,I1,1x,I1,1x,I5,1x,I5,1x,I3,1x,A12,1x,A16,$)', var_info%name, &
      var_info%h_stagger_index, var_info%ndim, var_info%dim_val(1),&
      var_info%dim_val(2), var_info%dim_val(3), var_info%units(1:8), &
      var_info%description(1:16)
      IF (var_info%ndim .EQ. 3) THEN
        nz = var_info%dim_val(3)
        IF (var_info%h_stagger_index .EQ. t_ind) THEN
          nx = var_info%dim_val(1) - 1
          ny = var_info%dim_val(2) - 1
        ELSEIF (var_info%h_stagger_index .EQ. n_ind) THEN
          nx = var_info%dim_val(1)
          ny = var_info%dim_val(2)
        ELSEIF (var_info%h_stagger_index .EQ. u_ind) THEN
          nx = var_info%dim_val(1)
          ny = var_info%dim_val(2) - 1
        ELSEIF (var_info%h_stagger_index .EQ. v_ind) THEN
          nx = var_info%dim_val(1) - 1
          ny = var_info%dim_val(2)
        ELSE
          var_info%h_stagger_index = t_ind
          nx = var_info%dim_val(1) - 1
          ny = var_info%dim_val(2) - 1
        ENDIF
        ! We need to filter for "missing points", so computing 
        ! varmin, varmax, and varavg needs to be a bit more
        ! complicated than simple MINVAL, MAXVAL, etc. 
        varmin = 999999.
        varmax = -999999.
        varsum = 0.
        totalpts = 0.
        DO k = 1,nz
          DO j = 1,ny
            DO i = 1,nx
              IF (ABS(real_array(i,j,k,1,1)) .LT. 9999999.) THEN
                totalpts = totalpts + 1.
                varsum = varsum + real_array(i,j,k,1,1)
                IF (real_array(i,j,k,1,1) .LT. varmin) THEN
                  varmin = real_array(i,j,k,1,1)
                ENDIF
                IF (real_array(i,j,k,1,1) .GT. varmax) THEN
                  varmax = real_array(i,j,k,1,1)
                ENDIF

              ENDIF
            ENDDO
          ENDDO
        ENDDO
        varavg = varsum/totalpts
 
     ELSEIF (var_info%ndim .EQ. 2) THEN
        nz = 1
        IF (var_info%h_stagger_index .EQ. t_ind) THEN
          nx = var_info%dim_val(1) - 1
          ny = var_info%dim_val(2) - 1
        ELSEIF (var_info%h_stagger_index .EQ. n_ind) THEN
          nx = var_info%dim_val(1)
          ny = var_info%dim_val(2)
        ELSEIF (var_info%h_stagger_index .EQ. u_ind) THEN
          nx = var_info%dim_val(1)
          ny = var_info%dim_val(2) - 1
        ELSEIF (var_info%h_stagger_index .EQ. v_ind) THEN
          nx = var_info%dim_val(1) - 1
          ny = var_info%dim_val(2)
        ELSE
          nx = var_info%dim_val(1) - 1
          ny = var_info%dim_val(2) - 1
        ENDIF

        ! We need to filter for "missing points", so computing 
        ! varmin, varmax, and varavg needs to be a bit more
        ! complicated than simple MINVAL, MAXVAL, etc. 
        varmin = 999999.
        varmax = -999999.
        varsum = 0.
        totalpts = 0.
        DO j = 1,ny
          DO i = 1,nx
            IF (ABS(real_array(i,j,1,1,1)) .LT. 9999999.) THEN 
              totalpts = totalpts + 1.
              varsum = varsum + real_array(i,j,1,1,1)
              IF (real_array(i,j,1,1,1) .LT. varmin) THEN
                varmin = real_array(i,j,1,1,1)
              ENDIF
              IF (real_array(i,j,1,1,1) .GT. varmax) THEN
                varmax = real_array(i,j,1,1,1)
              ENDIF
              
            ENDIF
          ENDDO
        ENDDO
        varavg = varsum/totalpts 
      ELSEIF (var_info%ndim .EQ. 1) THEN
        nz = 1
        ny = 1
        nx = var_info%dim_val(1)
        varmin = 999999.
        varmax = -999999.
        varsum = 0.
        totalpts = 0.
        DO i = 1,nx
          IF (ABS(real_array(i,1,1,1,1)) .LT. 9999999.) THEN
            totalpts = totalpts + 1.
            varsum = varsum + real_array(i,1,1,1,1)
            IF (real_array(i,1,1,1,1) .LT. varmin) THEN
              varmin = real_array(i,1,1,1,1)
            ENDIF
            IF (real_array(i,1,1,1,1) .GT. varmax) THEN
              varmax = real_array(i,1,1,1,1)
            ENDIF

          ENDIF
        ENDDO
        varavg = varsum/totalpts
      ELSE
        PRINT *, 'Cannot determine proper dimension'
        STOP
      ENDIF 
      IF ((varmax .GT. 10000.) .OR. (varmin .LT. -10000.)) THEN
        PRINT '(1x,F8.0,1x,F8.0,1x,F8.0)', varmin,varmax,varavg
      ELSEIF((varmax .GT. 1000.) .OR. (varmin .LT. -1000.)) THEN
        PRINT '(1x,F8.2,1x,F8.2,1x,F8.2)', varmin,varmax,varavg
      ELSEIF((varmax .GT. 100.) .OR. (varmin .LT. -100)) THEN
        PRINT '(1x,F8.3,1x,F8.3,1x,F8.3)', varmin,varmax,varavg
      ELSEIF((varmax .GT. 10.).OR. (varmin .LT. -10.)) THEN
        PRINT '(1x,F8.4,1x,F8.4,1x,F8.4)', varmin,varmax,varavg
      ELSEIF((varmax .GT. 1.).OR.(varmin .LT. -1.)) THEN
        PRINT '(1x,F8.5,1x,F8.5,1x,F8.5)', varmin,varmax,varavg
      ELSE
        PRINT '(1x,F8.6,1x,F8.6,1x,F8.6)', varmin,varmax,varavg
      ENDIF
    
    ENDIF
  ENDDO varloop
  CLOSE (siunit)

  domfile_in_opened = .false.
 
END PROGRAM siscan
