PRO read_gribprep_output, pgfile, varname, level, data

data_found = 0
level_req = ROUND(level)
varname_req = STRUPCASE(STRTRIM(varname,2))

hdr_rec1 = 	{ version: LONG(0)}
hdr_rec2 = 	{ hdate: BYTARR(24), $
	    	xfcst: FLOAT(0), $
		source: BYTARR(32), $
		field: BYTARR(9), $
		units: BYTARR(25), $
		description: BYTARR(46), $
		level: FLOAT(0),$
		idim: LONG(0),$
		jdim: LONG(0),$
		proj_flag: LONG(0) }

hdr_rec3_ce =	{ startloc: BYTARR(8), $
		knownlat: FLOAT(0), $
		knownlon: FLOAT(0), $
		deltalat: FLOAT(0), $
		deltalon: FLOAT(0) }

hdr_rec3_mc =	{ startloc: BYTARR(8), $
		knownlat: FLOAT(0), $
 		knownlon: FLOAT(0), $
		deltax: FLOAT(0), $
		deltay: FLOAT(0) }

hdr_rec3_lc =	{startloc: BYTARR(8), $
		knownlat: FLOAT(0), $
 		knownlon: FLOAT(0), $
		deltax: FLOAT(0), $
		deltay: FLOAT(0), $
		xlonc: FLOAT(0), $
		truelat1: FLOAT(0), $
		truelat2: FLOAT(0) }

hdr_rec3_ps = 	{startloc: BYTARR(8), $
		knownlat: FLOAT(0), $
 		knownlon: FLOAT(0), $
		deltax: FLOAT(0), $
		deltay: FLOAT(0), $
		xlonc: FLOAT(0), $
		truelat1: FLOAT(0) }

OPENR, pg_unit, pgfile, /GET_LUN, /F77

WHILE (data_found EQ 0) DO BEGIN
  READU,pg_unit, hdr_rec1
  READU, pg_unit, hdr_rec2

  CASE hdr_rec2.proj_flag OF
    0: BEGIN
       print, 'Projection is CYLINDRICAL EQUIDISTANT'
       READU,pg_unit, hdr_rec3_ce

       END
    1: BEGIN
       PRINT, 'Projection is MERCATOR'
       READU, pg_unit, hdr_rec3_me
     
       END

    3: BEGIN
       PRINT, 'Projection is LAMBERT CONFORMAL'
       READU, pg_unit, hdr_rec3_lc

       END

    5: BEGIN
       PRINT, 'Projection is POLAR STEREOGRAPHIC'
       READU, pg_unit, hdr_rec3_ps
 
       END

    ELSE: BEGIN
       PRINT, 'Unknown procjection indicator flag: ', hdr_rec2.proj_flag
       STOP
       END
  ENDCASE
  data_array = FLTARR(hdr_rec2.idim,hdr_rec2.jdim)
  READU, pg_unit, data_array
  IF (STRTRIM(hdr_rec2.field,2) EQ varname_req) AND $
     (ROUND(hdr_rec2.level) EQ level_req) THEN BEGIN
     data_found = 1
     PRINT, 'Found requested variable: ', varname_req, ' at level ', level_req
     data = data_array
  ENDIF ELSE BEGIN
  
     PRINT, 'Skipping variable ', STRING(hdr_rec2.field), $
             ' at level ', hdr_rec2.level

  ENDELSE

ENDWHILE
CLOSE, pg_unit
FREE_LUN, pg_unit
RETURN
END



