      subroutine write_wrfsi_file(atime,llflag,la1,lo1,lov,dx,dy, 
     +                            latin1,latin2,nx,ny,nz,nsfcfld,
     +                            pr,tp,ht,rh,uw,vw,slp,outdir)

c      Subroutine to write out the reassmbled Eta218 data into
c      the WRFSI hinterp intermediate format.

       use date_pack
       implicit none
 
       character(len=11) atime
       integer llflag, nx,ny,nz,nsfcfld
       real la1,lo1,lov,latin1,latin2,dx,dy,dx_km,dy_km
       real pr(nz), tp(nx,ny,nz), 
     +      ht(nx,ny,nz),rh(nx,ny,nz),
     +      uw(nx,ny,nz),vw(nx,ny,nz),
     +      slp(nx,ny,nsfcfld)

       integer luna,lunl,gp_version,k
       integer year,year2,mon,day,inithr,fhour
       parameter(gp_version = 4)
       parameter(luna=50)
       parameter(lunl=51)
       real xfcst,xfcst_sec,level
       character(len=19) hdate_short,init_date
       character(len=24) hdate
       character(len=32) source
       character(len=9)  field
       character(len=25) units
       character(len=46) desc
       character(len=255) outfilea,outfilel
       character(len=255) outdir
       character(len=255) prefixa,prefixl
       character(len=8) knownloc
       character(len=9) sfcfields(19)
       character(len=25) sfcunits(19)
       character(len=46) sfcdesc(19)
       real sfclevels(19)
       parameter(knownloc = 'SWCORNER')

       source = 'NCEP 12km Eta from CONUS 218 tile GRIB files'
       data sfcfields /'LANDSEA  ','PMSL     ','PSFC     ' ,
     +                  'HGT      ', 'T        ', 'RH       ',
     +                  'U        ', 'V        ', 'ST000010 ', 
     +                  'SM000010 ', 'ST010040 ', 'SM010040 ',
     +                  'ST040100 ', 'SM040100 ', 'ST100200 ',
     +                  'SM100200 ', 'SKINTEMP ', 'WEASD    ', 
     +                  'SEAICE   ' /
       data sfcunits / '0/1 Flag ' , 'Pa       ', 'Pa       ',
     +                 'm        ' , 'K        ', '%        ',
     +                 'm s{-1}  ' , 'm s{-1}  ', 'K        ',  
     +                 'fraction ' , 'K        ', 'fraction ', 
     +                 'K        ' , 'fraction ', 'K        ',
     +                 'fraction ' , 'K        ', 'kg m{-2} ', 
     +                 '0/1 Flag ' /
       data sfcdesc / 'Land/Water flag                        ', 
     +               'Sea-level Pressure                     ',
     +               'Surface Pressure                       ',
     +               'Surface Height                         ',
     +               'Temperature                            ',
     +               'Relative Humidity                      ',
     +               'U-component (grid-relative) wind       ',
     +               'V-component (grid-relative) wind       ',
     +               'T of 0-10cm soil layer                 ',
     +               'Soil moisture of 0-10cm soil layer     ',
     +               'T of 10-40cm soil layer                ',
     +               'Soil moisture of 10-40cm soil layer    ',
     +               'T of 40-100cm soil layer               ',
     +               'Soil moisture of 40-100cm soil layer   ',
     +               'T of 100-200cm soil layer              ',
     +               'Soil moisture of 100-200cm soil layer  ',
     +               'Skin temperature                       ',
     +               'Water equivalent snow depth            ',
     +               'Sea ice flag                           '/
      data sfclevels / 200100., 201300., 200100., 
     +                 200100., 200100., 200100.,
     +                 200100., 200100., 200100.,
     +                 200100., 200100., 200100.,
     +                 200100., 200100., 200100.,
     +                 200100., 200100., 200100.,
     +                 200100./
c       Create hdate from atime

c       -- Read initial time from the first 8 characters
c       -- and the forecast hour from the last 3

       read(atime,10) year2,mon,day,inithr,fhour
 10    format(I2.2,I2.2,I2.2,I2.2,I3.3)
       year = year2 + 2000
       write(init_date,20) year,mon,day,inithr
 20    format(I4.4,'-',I2.2,'-',I2.2,'_',I2.2,':00:00')
       xfcst = FLOAT(fhour)
       xfcst_sec = xfcst * 3600.

c       -- Create the valid time using initial time 
c       -- and xfcst_sec
   
       CALL geth_newdate(hdate_short,init_date,NINT(xfcst_sec))
       hdate = hdate_short // '.0000'

c      Build the output file names
       prefixl = TRIM(outdir) // '/ETAL218:'
       outfilel = TRIM(prefixl) // hdate_short(1:13)
       prefixa = TRIM(outdir) // '/ETA218:'
       outfilea = TRIM(prefixa) // hdate_short(1:13)

c      Open the files
       print *, 'Opening ',outfilea
       open(UNIT=luna, FILE=outfilea, FORM='unformatted', 
     +      ACCESS='sequential')

       print *, 'Opening ',outfilel
       open(UNIT=lunl, FILE=outfilel, FORM='unformatted',
     +      ACCESS='sequential') 

c      Set up the map parameters for the header
       dx_km = dx*0.001
       dy_km = dy*0.001
       print *, 'WRITE_WRFSI_FILE: Map projection info:'
       print *, '  NX/NY = ', nx,ny
       print *, '  SW Lat/Lon = ',la1,lo1    
       print *, '  Standard lon = ', lov
       print *, '  Dx/Dy (km)= ', dx_km,dy_km  
       print *, '  Latin1/Latin2 = ', latin1,latin2

c      Write out surface fields
       if (nsfcfld .ne. 19) then
         print *, 'Problem...expected 19 surface fields, but'
         print *, 'main driver passed in ', nsfcfld
         stop
       endif
       
       print *, 'WRITING SURFACE/2D FIELDS:'
       print *, '======================================================'
       
       sfcloop: DO k = 1, nsfcfld
         field = sfcfields(k)
         units = sfcunits(k)
         desc  = sfcdesc(k)
         level = sfclevels(k)
         IF (MAXVAL (slp(:,:,k)) .LT. -90000) CYCLE sfcloop

         write(6,30) field(1:8),units(1:10),level,MINVAL(slp(:,:,k)),
     +               MAXVAL(slp(:,:,k))
 30      format(A8,1x,A10,1x,F8.1,1x,2F12.4)

         IF ((field .NE. 'T        ').AND.(field .NE. 'RH      ').AND.
     +       (field .NE. 'PMSL     ').AND.(field .NE. 'PSFC    ').AND.
     +       (field .NE. 'U        ').AND.(field .NE. 'V       ').AND.
     +       (field .NE. 'HGT      '))THEN
           CALL write_gribprep_header(gp_version,hdate,xfcst,source,
     +        field,units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,lunl)
           write(lunl) slp(:,:,k)
         ELSE
           CALL write_gribprep_header(gp_version,hdate,xfcst,source,
     +        field,units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,luna)
           write(luna) slp(:,:,k)
         ENDIF


       ENDDO sfcloop

c      Loop over pressure levels and write out upper air stuff

       DO k = 1, nz
         level = FLOAT(NINT(pr(k))*100)

         ! Temperature
         field = 'T        ' 
         units = 'K          ' 
         desc  = 'Temperature                                 ' 
         write(6,30) field(1:8),units(1:10),level,MINVAL(tp(:,:,k)),
     +               MAXVAL(tp(:,:,k))
         CALL write_gribprep_header(gp_version,hdate,xfcst,source,field,
     +        units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,luna)
         write (luna) tp(:,:,k)


         ! Height
         field = 'HGT      '
         units = 'm          '
         desc  = 'Height                                      '
         write(6,30) field(1:8),units(1:10),level,MINVAL(ht(:,:,k)),
     +               MAXVAL(ht(:,:,k))
         CALL write_gribprep_header(gp_version,hdate,xfcst,source,field,
     +        units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,luna)
         write (luna) ht(:,:,k)

         ! Relative Humidity
         field = 'RH       ' 
         units = '%          ' 
         desc  = 'Relative Humidity                           ' 
         write(6,30) field(1:8),units(1:10),level,MINVAL(rh(:,:,k)),
     +               MAXVAL(rh(:,:,k))
         CALL write_gribprep_header(gp_version,hdate,xfcst,source,field,
     +        units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,luna)
         write (luna) rh(:,:,k)

         ! U wind               
         field = 'U        ' 
         units = 'm s{-1}    ' 
         desc  = 'U-component (grid-relative) wind            ' 
         write(6,30) field(1:8),units(1:10),level,MINVAL(uw(:,:,k)),
     +               MAXVAL(uw(:,:,k))
         CALL write_gribprep_header(gp_version,hdate,xfcst,source,field,
     +        units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,luna)
         write (luna) uw(:,:,k)

         ! V wind                   
         field = 'V        ' 
         units = 'm s{-1}    ' 
         desc  = 'V-component (grid-relative) wind            ' 
         write(6,30) field(1:8),units(1:10),level,MINVAL(vw(:,:,k)),
     +               MAXVAL(vw(:,:,k))
         CALL write_gribprep_header(gp_version,hdate,xfcst,source,field,
     +        units,desc,level,nx,ny,llflag,knownloc,la1,lo1,lov,
     +        dx_km,dy_km,latin1,latin2,luna)
         write (luna) vw(:,:,k)

       ENDDO 

       CLOSE(luna)
       CLOSE(lunl)
       print *, 'Completed output for WRFSI.'
       return
       end subroutine write_wrfsi_file     

       subroutine write_gribprep_header(version,hdate,xfcst,source,
     +      field, units, desc, level, nx, ny, proj, knownloc, 
     +      la1,lo1,lov,dx_km,dy_km,latin1,latin2,lun)

         implicit none

         integer version, nx, ny, proj, lun
         real xfcst, level, la1, lo1, lov, dx_km, dy_km, latin1, latin2
         character(len=24) hdate
         character(len=32) source
         character(len=9) field
         character(len=25) units
         character(len=46) desc
         character(len=8) knownloc

c        Write first record

         write(lun) version

c        Write second record
         write(lun) hdate,xfcst,source,field,units,desc,
     +              level, nx, ny, proj

c        Write third record

         select case(proj)

           case(1)   ! Mercator
             write(lun) knownloc,la1,lo1,dx_km,dy_km,latin1

           case(3)   ! Lambert Conformal
             write(lun) knownloc,la1,lo1,dx_km,dy_km,lov,latin1,latin2
           
           case(5)   ! Polar stereographic
             write(lun) knownloc,la1,lo1,dx_km,dy_km,lov,latin1

           case default
             print *, 'Unsupported projection code: ', proj
             stop

         end select
         return
       end subroutine write_gribprep_header
        


