      subroutine prlevel(ipdtn,ipdtmpl,labbrev)
      
      integer,intent(in) :: ipdtn
      integer,intent(in) :: ipdtmpl(*)
      character(len=20),intent(out) :: labbrev

      character(len=10) :: tmpval1,tmpval2
      
      labbrev(1:20)=" "

      if ( ipdtmpl(10) .eq. 100 .and.           ! Pressure Level
     &     ipdtmpl(13) .eq. 255 ) then
         !write(tmpval1,*) ipdtmpl(12)/100
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11)+2)
         labbrev=trim(tmpval1)//" mb"

      elseif ( ipdtmpl(10) .eq. 100 .and.           ! Pressure Layer
     &         ipdtmpl(13) .eq. 100 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11)+2)
         call frmt(tmpval2,ipdtmpl(15),ipdtmpl(14)+2)
         labbrev=trim(tmpval1)//" - "//trim(tmpval2)//" mb"

      elseif ( ipdtmpl(10) .eq. 101 ) then       ! Mean Sea Level
         labbrev(1:20)=" Mean Sea Level "

      elseif ( ipdtmpl(10) .eq. 102 .and.        ! Altitude above MSL
     &     ipdtmpl(13) .eq. 255 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         labbrev=trim(tmpval1)//" m above MSL"

      elseif ( ipdtmpl(10) .eq. 103 .and.        ! Height above Ground
     &     ipdtmpl(13) .eq. 255 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         labbrev=trim(tmpval1)//" m above ground"

      elseif ( ipdtmpl(10) .eq. 104 .and.        ! Sigma Level
     &     ipdtmpl(13) .eq. 255 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         labbrev=trim(tmpval1)//" sigma"

      elseif ( ipdtmpl(10) .eq. 104 .and.        ! Sigma Layer
     &     ipdtmpl(13) .eq. 104 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         call frmt(tmpval2,ipdtmpl(15),ipdtmpl(14))
         labbrev=trim(tmpval1)//" - "//trim(tmpval2)//" sigma"

      elseif ( ipdtmpl(10) .eq. 105 .and.        ! Hybrid Level
     &     ipdtmpl(13) .eq. 255 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         labbrev=trim(tmpval1)//" hybrid lvl"

      elseif ( ipdtmpl(10) .eq. 106 .and.        ! Depth Below Land Sfc
     &     ipdtmpl(13) .eq. 255 ) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         labbrev=trim(tmpval1)//" m below land"

      elseif ( ipdtmpl(10).eq.106 .and.          ! Depth Below Land Sfc Layer
     &         ipdtmpl(13).eq.106) then
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11))
         call frmt(tmpval2,ipdtmpl(15),ipdtmpl(14))
         labbrev=trim(tmpval1)//" - "//trim(tmpval2)//" m DBLY"

      elseif ( ipdtmpl(10).eq.108 .and.          ! Press Diff from Ground Layer
     &         ipdtmpl(13).eq.108) then
         !write(tmpval1,*) ipdtmpl(12)/100
         !write(tmpval2,*) ipdtmpl(15)/100
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11)+2)
         call frmt(tmpval2,ipdtmpl(15),ipdtmpl(14)+2)
         labbrev=trim(tmpval1)//" - "//trim(tmpval2)//" mb SPDY"

      elseif ( ipdtmpl(10).eq.109 .and.          ! Potential Vorticity Sfc
     &         ipdtmpl(13).eq.255) then
         !write(tmpval1,*) ipdtmpl(12)
         call frmt(tmpval1,ipdtmpl(12),ipdtmpl(11)-6)
         labbrev=trim(tmpval1)//" pv surface"

      elseif ( ipdtmpl(10) .eq. 1 ) then         ! Ground/Water Surface
         labbrev(1:20)=" Surface "

      elseif ( ipdtmpl(10) .eq. 4 ) then         ! Freezing Level
         labbrev(1:20)=" 0 Deg Isotherm"

      elseif ( ipdtmpl(10) .eq. 6 ) then         ! Max Wind Level
         labbrev(1:20)=" Max wind lvl"

      elseif ( ipdtmpl(10) .eq. 7 ) then         ! Tropopause
         labbrev(1:20)=" Tropopause"

      elseif ( ipdtmpl(10) .eq. 8 ) then         ! Nominal top of Atmosphere
         labbrev(1:20)=" Nom. top"

      else
         write(labbrev,fmt='(1x,i4," (Unknown Lvl)")') 
     &         ipdtmpl(10)
      endif

      return
      end


      subroutine frmt(cval,ival,iscal)
     
      character(len=20),intent(out) :: cval
      integer,intent(in) :: ival,iscal

      real :: rval
      integer :: newscal
      character(len=7) :: cformat

      if  ( iscal .eq. 0 ) then
         write(cval,*) ival
      else
         newscal=-1*iscal
         rval=real(ival)*(10.0**newscal)
         if ( rval .eq. real(nint(rval)) ) then
            write(cval,*) nint(rval)
         else
            write(cformat,fmt='("(f0.",I1,")")') iabs(iscal)
            write(6,*) "SAGF:",cformat
            write(cval,fmt=cformat) rval
         endif
      endif

      return
      end
