      subroutine prvtime(ipdtn,ipdtmpl,listsec1,tabbrev)
      
      integer,intent(in) :: ipdtn
      integer,intent(in) :: ipdtmpl(*),listsec1(*)
      character(len=80),intent(out) :: tabbrev

      character(len=16) :: reftime,endtime
      character(len=10) :: tmpval
      character(len=10) :: tunit

      integer,dimension(200) :: ipos
      data ipos /7*0,16,23,17,19,18,32,31,186*0/

      tabbrev(1:80)=" "
      write(reftime,fmt='(i4,3i2.2,":",i2.2,":",i2.2)') 
     &        (listsec1(j),j=6,11)
 
      write(tmpval,*) ipdtmpl(9)
      write(tabbrev,fmt='("valid at ",i4)') ipdtmpl(9)
      selectcase( ipdtmpl(8) )
         case (0) 
            tunit="min"
         case (1) 
            tunit="hr"
         case (2) 
            tunit="day"
         case (3) 
            tunit="mo"
         case (4) 
            tunit="yr"
      end select

      if ( ipdtn.ge.0 .and. ipdtn.le.7) then           ! Point in time

        tabbrev="valid at "//trim(tmpval)//" "//trim(tunit)//
     &          " after "//reftime

      elseif ( ipdtn.ge.8 .and. ipdtn.le.14) then      ! Time Range

         is=ipos(ipdtn)
         write(endtime,fmt='(i4,3i2.2,":",i2.2,":",i2.2)') 
     &           (ipdtmpl(j),j=is,is+5)

        tabbrev="valid "//trim(tmpval)//" "//trim(tunit)//
     &          " after "//reftime//" to "//endtime

      endif

      return
      end
