!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 

MODULE gridded_data

   ! Contains the fields read in during the dynamic data ingest portion
   ! of hinterp.  At this point they have been converted from a linked
   ! list of 2D fields into 2D and 3D variables as appropriate.  
   ! The all_3d contains all 3D variables, where the level value assigned
   ! to surface variables is 200100 Pa if the data is isobaric, and the 
   ! level value assigned to surface variables is 0 if non-isobaric.  The all_2d
   ! array has the variables which are only 2D, and are assigned a pressure
   ! of 200100 Pa, except for Sea Level variables, which are assigned
   ! a level of 201300 Pa.  The dimensions are as follows:
   !
   !  all_3d (nx,ny,nz,number_of_3d_vars)
   !  all_2d (nx,ny,number_of_2d_vars) 
   !
   !  These arrays are allocated and filled by the proc_list_to_array.F
   !  subroutine, which is called by the ingest routine for the 
   !  particular data source.  Thus, if new ingest sources other
   !  than gribprep format are added, those new ingest routines do
   !  not necessarily need to call proc_list_to_array, provided they
   !  can simply populate these arrays properly.  
   !
   !  Finally, this module also contains an array of variable
   !  metadata structures corresponding to the all_3d and all_2d
   !  data arrays. 
   !


   USE wrfsi_maxdims
   USE wrf_metadata
   REAL , DIMENSION(:,:,:,:) , ALLOCATABLE :: all_3d
   REAL , DIMENSION(:,:,:)   , ALLOCATABLE :: all_2d
   REAL , DIMENSION(:,:)     , ALLOCATABLE :: soilhgt_bg
   REAL :: min_top_height
   INTEGER :: max_fg_variables_index , fg_variables_sfc_index , &
              fg_variables_up_index
   INTEGER :: num3d_fg, num2d_fg, num1d_fg
   INTEGER :: number_of_original_levels
   CHARACTER (LEN=80) , DIMENSION(max_fg_variables) :: all_names_sfc ,&
                        all_names_up, all_sources_sfc, all_sources_up
   LOGICAL :: found_name
   INTEGER , DIMENSION(:) , ALLOCATABLE :: output_levels
   TYPE (wrfvar_metadata) :: var_up(max_fg_variables)
   TYPE (wrfvar_metadata) :: var_sfc(max_fg_variables)

END MODULE gridded_data
