SUBROUTINE proc_store_global_metadata

  USE wrf_metadata
  USE hinterp_setup
  IMPLICIT NONE
  INTEGER  :: out_unit, open_status
  LOGICAL  :: unit_used
  CHARACTER(LEN=200) :: metafile

  metafile = TRIM(output_prefix) // '.global.metadata'

  output_unit : DO out_unit = 10, 99
    INQUIRE (UNIT=out_unit, OPENED=unit_used)
    IF ( .NOT. unit_used) EXIT output_unit
  END DO output_unit

   OPEN ( UNIT=out_unit , &
         FILE=metafile , &
         STATUS = 'UNKNOWN' , &
         FORM = 'UNFORMATTED' , &
         IOSTAT = open_status )

  IF ( open_status .NE. 0 ) THEN
    PRINT '(A,A,A)' , 'Error opening ',metafile,' file.'
    STOP 'meta_file_open'
  END IF

  ! Write out the global metadata.  We cannot just write the 
  ! struture, because the byte-swap conversion will not be done 
  ! properly if you are on a little-endian machine.  So, write
  ! each element of the structure

  WRITE (out_unit)    global_meta%simulation_name, &
                      global_meta%user_desc, &
                      global_meta%si_version,  &
                      global_meta%anal_version, &
		      global_meta%wrf_version, &
                      global_meta%post_version, &
                      global_meta%map_projection, &
                      global_meta%moad_known_lat, &
                      global_meta%moad_known_lon, &
                      global_meta%moad_known_loc, &
                      global_meta%moad_stand_lats, &
                      global_meta%moad_stand_lons, &
                      global_meta%moad_delta_x, &
                      global_meta%moad_delta_y, &
                      global_meta%horiz_stagger_type, &
                      global_meta%num_stagger_xy, &
                      global_meta%stagger_dir_x, &
                      global_meta%stagger_dir_y, &
                      global_meta%num_stagger_z, &
                      global_meta%stagger_dir_z, &
                      global_meta%vertical_coord, &
                      global_meta%num_domains, &
                      global_meta%init_date, &
                      global_meta%init_time, &
                      global_meta%end_date, &
                      global_meta%end_time, &
                      global_meta%lu_source, & 
                      global_meta%lu_water, &
                      global_meta%lu_ice, & 
                      global_meta%st_water
  CLOSE (out_unit)

END SUBROUTINE proc_store_global_metadata


