!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 
MODULE gribprep_io
  ! Contains routines to interact with the gribprep output
CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  SUBROUTINE get_gribprep_var(varname, unit, xdim, ydim, data, found)
 
    ! Gets a variable from a gribprep output file associated
    ! with unit. 

    IMPLICIT NONE
    CHARACTER(LEN=8), INTENT(IN)      :: varname
    INTEGER, INTENT(IN)               :: unit
    INTEGER, INTENT(IN)               :: xdim
    INTEGER, INTENT(IN)               :: ydim
    REAL, INTENT(OUT)                 :: data(xdim,ydim)
    LOGICAL, INTENT(OUT)              :: found

    INTEGER                           :: version
    CHARACTER(LEN=24)                 :: hdate
    REAL                              :: xfcst
    CHARACTER(LEN=32)                 :: source
    CHARACTER(LEN=9)  :: field
    CHARACTER(LEN=25) :: units
    CHARACTER(LEN=46) :: description
    INTEGER	     :: llflag
    INTEGER           :: idim, jdim
    REAL              :: level
    CHARACTER(LEN=8)  :: startloc
    REAL              :: knownlat, knownlon, deltalat, deltalon
    REAL              :: lat1, lon1, deltax, deltay, xlonc, truelat1, truelat2
    INTEGER           :: eof_status
    REAL              :: dum2d(xdim,ydim)
           
    found = .false.
    REWIND(unit)
    
    read_file: DO
      READ(UNIT=unit, IOSTAT=eof_status) version
      IF (eof_status .LT. 0) THEN
        EXIT read_file
      ENDIF  
      READ ( UNIT=unit ) &
             hdate, xfcst, source, field, units, description, &
             level, idim, jdim, llflag
      SELECT CASE(llflag)
        CASE(0)
          READ(UNIT=unit) startloc, knownlat,knownlon,deltalat,deltalon
        CASE(1)
          READ(UNIT=unit) startloc, lat1,lon1,deltax,deltay,truelat1
        CASE(3)
          READ(UNIT=unit) startloc, lat1,lon1,deltax,deltay,xlonc,truelat1,truelat2
        CASE(5)
          READ(UNIT=unit) startloc, lat1,lon1,deltax,deltay,xlonc,truelat1
        CASE DEFAULT
          PRINT '(A,I4)', 'Unknown projection ID: ', llflag
          STOP 'get_gribprep_var'
      END SELECT
      IF ((idim .NE. xdim).or.(jdim .NE. ydim)) THEN
        PRINT '(A)', 'GET_GRIBPREP_VAR: dimension mismatch!'
        PRINT '(A,2I5)', 'Dims from file: ', idim, jdim
        PRINT '(A,2I5)', 'Dims from args: ', xdim, ydim
        STOP 'GET_GRIBPREP_VAR'
      ENDIF
      READ(UNIT=unit) dum2d
      IF ( field(1:8) .EQ. varname) THEN
         data = dum2d
         found = .true.
         EXIT read_file
      ENDIF
    ENDDO read_file
    RETURN
  END SUBROUTINE get_gribprep_var
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
END MODULE gribprep_io
