!dis
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis
!dis                                   
MODULE physical_constants

  ! Specific heat of dry air 
  REAL, PARAMETER		:: Cp 		= 1004.67  ! J deg{-1} kg{-1}

  ! Gravitational acceleration
  REAL, PARAMETER		:: g		=    9.81  ! m s{-2}

  ! Gas constant for dry air
  REAL, PARAMETER		:: Rd       	=  287.04  ! J deg{-1} kg{-1}

  ! Rd divided by Cp
  REAL, PARAMETER		:: RovCp        = Rd/Cp    ! dimensionless

  ! Reference pressure for computing potential temperature
  REAL, PARAMETER		:: Pref         = 100000.0 ! Pa

  ! Lapse rate used for extrapolating temperatures
  REAL, PARAMETER		:: dTdz         = .0070   ! deg m{-1}

  ! Pressure lapse rate (near sea level) for extrapolating pressure
  ! (from Wallace and Hobbs, 1977, p. 60)
  REAL, PARAMETER               :: dPdz         = 12.5     ! Pa m{-1}

  ! Reference temperature for when to convert from saturation
  ! vapor pressure wrt liquid to saturation vapor pressure wrt ice
  ! during computation of mixing ratio from RH. 
  REAL, PARAMETER		:: Tref_frz	= 273.15 ! K

END MODULE physical_constants  

