  MODULE wrf_metadata

!   This module defines the items needed for the WRF metadata
!   which is broken up into three levels:  
!      Global metadata:  Those things which apply to the
!                        entire simulation that are 
!                        independent of time, domain, or
!                        variable
!
!      Domain metadata:  Those things which apply to 
!                        a single domain (this may
!                        or may not be time dependent)
!
!      Variable metadata: Those things which apply to 
!                        a specific variable at a 
!                        specific time
!
!      The variable names and definitions can be 
!      found in the wrf_metadata spec, which is still
!      a living document as coding goes on.   The names
!      may not match exactly, but you should be able 
!      to figure things out.  
!
!   HISTORY
!   -------
!   Sep 00 - Original Version, Brent Shaw, NOAA/OAR/FSL/FRD
!   2 Nov 00 - Added lu_source, lu_water,lu_ice to global 
!              metadata... B. Shaw
!   23 Aug 01 - Added st_water to global metadata to store
!               index indicating water category in soil-type data

    USE wrfsi_maxdims

    TYPE wrfvar_metadata
      CHARACTER (LEN=8)		:: name 
      CHARACTER (LEN=16)	:: units
      CHARACTER (LEN=80)	:: description
      INTEGER			:: domain_id
      INTEGER                   :: ndim
      INTEGER          	 	:: dim_val (var_maxdims)
      CHARACTER(LEN=4)		:: dim_desc (var_maxdims)
      INTEGER                   :: start_index(var_maxdims)
      INTEGER			:: stop_index(var_maxdims)
      INTEGER			:: h_stagger_index
      INTEGER              	:: v_stagger_index
      CHARACTER(LEN=8)		:: array_order
      CHARACTER(LEN=4)		:: field_type
      CHARACTER(LEN=8)          :: field_source_prog
      CHARACTER(LEN=80)         :: source_desc
      CHARACTER(LEN=8)          :: field_time_type
      INTEGER			:: vt_date_start
      REAL                      :: vt_time_start
      INTEGER              	:: vt_date_stop
      REAL			:: vt_time_stop
    END TYPE wrfvar_metadata

    TYPE(wrfvar_metadata)  :: var_meta

    TYPE wrf_domain_metadata
      INTEGER			:: id
      INTEGER			:: parent_id
      CHARACTER(LEN=8)		:: dyn_init_src
      CHARACTER(LEN=8)		:: static_init_src 
      INTEGER			:: vt_date
      REAL			:: vt_time
      INTEGER			:: origin_parent_x
      INTEGER			:: origin_parent_y
      INTEGER                   :: end_parent_x
      INTEGER                   :: end_parent_y
      INTEGER			:: ratio_to_parent
      REAL                      :: delta_x
      REAL                      :: delta_y
      REAL                      :: top_level
      INTEGER			:: origin_parent_z
      REAL			:: corner_lats(4,max_staggers_xy)
      REAL			:: corner_lons(4,max_staggers_xy)
      INTEGER			:: xdim
      INTEGER			:: ydim
      INTEGER			:: zdim
    END TYPE wrf_domain_metadata
    TYPE(wrf_domain_metadata) :: dom_meta

    TYPE wrf_global_metadata
      CHARACTER(LEN=80)		:: simulation_name
      CHARACTER(LEN=80)        	:: user_desc
      INTEGER			:: si_version
      INTEGER			:: anal_version  
      INTEGER			:: wrf_version
      INTEGER			:: post_version
      CHARACTER(LEN=32)		:: map_projection
      REAL			:: moad_known_lat
      REAL			:: moad_known_lon
      CHARACTER(LEN=8)		:: moad_known_loc
      REAL			:: moad_stand_lats(max_standard_lats)
      REAL			:: moad_stand_lons(max_standard_lons)
      REAL			:: moad_delta_x
      REAL			:: moad_delta_y
      CHARACTER(LEN=4)		:: horiz_stagger_type
      INTEGER                   :: num_stagger_xy
      REAL			:: stagger_dir_x(max_staggers_xy)
      REAL			:: stagger_dir_y(max_staggers_xy)
      INTEGER			:: num_stagger_z    
      REAL   			:: stagger_dir_z(max_staggers_z)
      CHARACTER(LEN=8)		:: vertical_coord
      INTEGER			:: num_domains
      INTEGER			:: init_date
      REAL			:: init_time
      INTEGER			:: end_date
      REAL			:: end_time
      CHARACTER(LEN=4)          :: lu_source
      INTEGER                   :: lu_water
      INTEGER                   :: lu_ice 
      INTEGER                   :: st_water  ! Index for water in soil-types
      INTEGER                   :: output_vcoord
    END TYPE wrf_global_metadata
    TYPE(wrf_global_metadata)   :: global_meta

    ! Define values of stagger indices
    INTEGER, PARAMETER          :: t_ind = 1 ! Mass grid
    INTEGER, PARAMETER          :: u_ind = 2 ! U grid
    INTEGER, PARAMETER          :: v_ind = 3 ! V grid
    INTEGER, PARAMETER          :: n_ind = 4 ! Non-staggered grid
!
!mp - dont believe this is being used (30 June 2003)
!
!
    INTEGER, PARAMETER          :: w_ind = 5 ! NMM Wind point (U & V)
!mp

    REAL, PARAMETER             :: rmissing = -99999.9
    INTEGER, PARAMETER          :: imissing = -99999

    ! Define some values for the var_meta%name tags

    CHARACTER (LEN=8), PARAMETER  :: pressure_id          = 'PRESSURE'
    CHARACTER (LEN=8), PARAMETER  :: height_id            = 'HGT     '
    CHARACTER (LEN=8), PARAMETER  :: soilhgt_id           = 'SOILHGT '
    CHARACTER (LEN=8), PARAMETER  :: u_id                 = 'U       '
    CHARACTER (LEN=8), PARAMETER  :: v_id                 = 'V       '
    CHARACTER (LEN=8), PARAMETER  :: t_id                 = 'T       '
    CHARACTER (LEN=8), PARAMETER  :: rh_id                = 'RH      '
    CHARACTER (LEN=8), PARAMETER  :: spechum_id           = 'Q       '
    CHARACTER (LEN=8), PARAMETER  :: press_msl_id         = 'PMSL    '
    CHARACTER (LEN=8), PARAMETER  :: press_sfc_id         = 'PSFC    '
    CHARACTER (LEN=8), PARAMETER  :: terrain_id           = 'TOPO_M  '  ! Mass grid
    CHARACTER (LEN=8), PARAMETER  :: landmask_id          = 'LANDMASK'
    CHARACTER (LEN=8), PARAMETER  :: landusec_id          = 'LANDUSEC'  ! Dom category
    CHARACTER (LEN=8), PARAMETER  :: landusef_id          = 'LANDUSEF'  ! Cat fractions
    CHARACTER (LEN=8), PARAMETER  :: latitude_id          = 'LATITUDE'  ! Non staggered
    CHARACTER (LEN=8), PARAMETER  :: longitude_id         = 'LONGITUD'
    CHARACTER (LEN=8), PARAMETER  :: latitudem_id         = 'LAT_M   '  ! Mass grid lats
    CHARACTER (LEN=8), PARAMETER  :: longitudem_id        = 'LON_M   '        
    CHARACTER (LEN=8), PARAMETER  :: rho_id               = 'RHO     '
    CHARACTER (LEN=8), PARAMETER  :: theta_id             = 'THETA   '
    CHARACTER (LEN=8), PARAMETER  :: thetam_id            = 'THETAM  '
    CHARACTER (LEN=8), PARAMETER  :: zetahalf_id          = 'ZETAHALF'
    CHARACTER (LEN=8), PARAMETER  :: zetafull_id          = 'ZETAFULL'
    CHARACTER (LEN=8), PARAMETER  :: etapfull_id          = 'ETAPFULL'
    CHARACTER (LEN=8), PARAMETER  :: etaphalf_id          = 'ETAPHALF'
!mp
    CHARACTER (LEN=8), PARAMETER  :: hybfull_id           = 'HYBPFULL'
    CHARACTER (LEN=8), PARAMETER  :: hybhalf_id           = 'HYBPHALF'
!! Kludgy change here.  NMM model wants DETA,AETA,ETA
    CHARACTER (LEN=8), PARAMETER  :: dsg_id               = 'DETA    '
    CHARACTER (LEN=8), PARAMETER  :: dsg1_id              = 'DETA1   '
    CHARACTER (LEN=8), PARAMETER  :: dsg2_id              = 'DETA2   '
    CHARACTER (LEN=8), PARAMETER  :: sg_id                = 'ETAX    '
    CHARACTER (LEN=8), PARAMETER  :: sg1_id               = 'ETA1    '
    CHARACTER (LEN=8), PARAMETER  :: sg2_id               = 'ETA2    '
    CHARACTER (LEN=8), PARAMETER  :: sgml_id              = 'AETA    '
    CHARACTER (LEN=8), PARAMETER  :: sgml1_id             = 'AETA1   '
    CHARACTER (LEN=8), PARAMETER  :: sgml2_id             = 'AETA2   '
    CHARACTER (LEN=8), PARAMETER  :: dfl_id               = 'DFL     '
!mp
    CHARACTER (LEN=8), PARAMETER  :: mumass_id            = 'MU_M    '
    CHARACTER (LEN=8), PARAMETER  :: qvapor_id            = 'QVAPOR  '
    CHARACTER (LEN=8), PARAMETER  :: qliquid_id           = 'QLIQUID '
    CHARACTER (LEN=8), PARAMETER  :: qice_id              = 'QICE    '
    CHARACTER (LEN=8), PARAMETER  :: qrain_id             = 'QRAIN   '
    CHARACTER (LEN=8), PARAMETER  :: qsnow_id             = 'QSNOW   '
    CHARACTER (LEN=8), PARAMETER  :: qgraupel_id          = 'QGRAUPEL'
    CHARACTER (LEN=8), PARAMETER  :: rhotheta_id          = 'RHOTHETA'
    CHARACTER (LEN=8), PARAMETER  :: tmoist_id            = 'TMOIST  '
    CHARACTER (LEN=8), PARAMETER  :: dzdzeta_id           = 'DZDZETA '
    CHARACTER (LEN=8), PARAMETER  :: dzetadz_id           = 'DZETADZ '
    CHARACTER (LEN=8), PARAMETER  :: dzdx_id              = 'DZDX    '
    CHARACTER (LEN=8), PARAMETER  :: dzdy_id              = 'DZDY    '
    CHARACTER (LEN=8), PARAMETER  :: map_factor_id        = 'MAPFAC  '
    CHARACTER (LEN=8), PARAMETER  :: map_factor_m_id      = 'MAPFAC_M'
    CHARACTER (LEN=8), PARAMETER  :: map_factor_u_id      = 'MAPFAC_U'
    CHARACTER (LEN=8), PARAMETER  :: map_factor_v_id      = 'MAPFAC_V'
    CHARACTER (LEN=8), PARAMETER  :: hcoriolis_id         = 'H_CORIOL'
    CHARACTER (LEN=8), PARAMETER  :: vcoriolis_id         = 'V_CORIOL'
    CHARACTER (LEN=8), PARAMETER  :: cosalpha_id          = 'COSALPHA'
    CHARACTER (LEN=8), PARAMETER  :: sinalpha_id          = 'SINALPHA'
    CHARACTER (LEN=8), PARAMETER  :: tskin_id             = 'SKINTEMP'
    CHARACTER (LEN=8), PARAMETER  :: sst_id               = 'SST     '
    CHARACTER (LEN=8), PARAMETER  :: snow_id              = 'SNOWCOVR'
    CHARACTER (LEN=8), PARAMETER  :: weasd_id             = 'WEASD   '  
    CHARACTER (LEN=8), PARAMETER  :: seaice_id            = 'SEAICE  '
    CHARACTER (LEN=8), PARAMETER  :: soilm0_10_id         = 'SM000010'
    CHARACTER (LEN=8), PARAMETER  :: soilm10_40_id        = 'SM010040' 
    CHARACTER (LEN=8), PARAMETER  :: soilm40_100_id       = 'SM040100' 
    CHARACTER (LEN=8), PARAMETER  :: soilm100_200_id      = 'SM100200'
    CHARACTER (LEN=8), PARAMETER  :: soilm10_200_id       = 'SM010200'
    CHARACTER (LEN=8), PARAMETER  :: soilt0_10_id         = 'ST000010'
    CHARACTER (LEN=8), PARAMETER  :: soilt10_40_id        = 'ST010040'
    CHARACTER (LEN=8), PARAMETER  :: soilt40_100_id       = 'ST040100'
    CHARACTER (LEN=8), PARAMETER  :: soilt100_200_id      = 'ST100200'
    CHARACTER (LEN=8), PARAMETER  :: soilt10_200_id       = 'ST010200'
    CHARACTER (LEN=8), PARAMETER  :: soilt200_400_id      = 'T_AVGANN'
 END MODULE wrf_metadata
