!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 

MODULE wrfsi_nl
 
  ! Module to read/populate interpolation program namelist variables

  USE wrfsi_maxdims

  INTEGER                        :: num_active_subnests
  INTEGER                        :: active_subnests(max_domains)
  REAL                           :: ptop_pa
  INTEGER                        :: hinterp_method
  INTEGER                        :: lsm_hinterp_method
  INTEGER                        :: num_init_times
  CHARACTER(LEN=200)             :: init_root(10)
  CHARACTER(LEN=200)             :: lbc_root(10)
  CHARACTER(LEN=200)             :: lsm_root
  CHARACTER(LEN=200)             :: constants_full_name(10)
  LOGICAL                        :: verbose_log
  CHARACTER(LEN=4)               :: output_coord
  REAL                           :: levels(max_vertical_levels)
  LOGICAL                        :: rh_wrt_liquid
  INTEGER                        :: output_vars
  CHARACTER(LEN=4)               :: output_file_type



CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  SUBROUTINE read_interp_nl(moad_dataroot)

    IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN)         :: moad_dataroot
    INTEGER                             :: nl_unit
    LOGICAL                             :: file_opened,file_exists
    CHARACTER(LEN=255)                  :: nl_file
    INTEGER                             :: status
    INTEGER                             :: I,n

    NAMELIST /interp_control / num_active_subnests, active_subnests, ptop_pa, &
                          hinterp_method, lsm_hinterp_method, &
                          num_init_times,init_root, lbc_root, &
                          lsm_root,constants_full_name, &
                          verbose_log, output_coord, levels, rh_wrt_liquid, &
                          output_vars,output_file_type
    
   ! Build the namelist file name and make sure it is present

    nl_file = TRIM(moad_dataroot) // '/static/wrfsi.nl'
    INQUIRE(FILE=nl_file, EXIST=file_exists)
    IF (.NOT. file_exists) THEN
      PRINT '(2a)', 'WRFSI Namelist not found: ', nl_file
      STOP 'READ_INTERP_NL'
    ENDIF                
 
    ! Set the defaults
    num_active_subnests = 0
    active_subnests(1) = 0
    hinterp_method = 1
    lsm_hinterp_method = 0
    ptop_pa = 5000.
    verbose_log = .FALSE.
    hinterp_method = 2
    num_init_times = 1
    init_root         = (/ ( "                    ",I=1,10 ) /)
    lbc_root          = (/ ( "                    ",I=1,10 ) /)
    lsm_root = "                              "
    constants_full_name = (/ ( "                    ",I=1,10 ) /)   
    output_coord = 'ETAP'
    levels(:) = -1
    rh_wrt_liquid = .true.
    output_vars = 2
    output_file_type = 'WRF'

    !  Find a spare UNIT number for the NAMELIST file.

    namelist_unit : DO nl_unit = 10, 99
       INQUIRE (UNIT=nl_unit, OPENED=file_opened)
       IF ( .NOT. file_opened) THEN
          EXIT namelist_unit
       END IF
    END DO namelist_unit 

    !  OPEN the NAMELIST file with the given name and UNIT.

    OPEN ( UNIT=nl_unit , &
          FILE=nl_file , &
          STATUS = 'OLD' , &
          FORM = 'FORMATTED' , &
          IOSTAT = status )

    IF ( status .NE. 0 ) THEN
       PRINT '(A)' , 'Error opening NAMELIST file.'
       STOP 'READ_INTERP_NL'
    END IF
    REWIND(UNIT=nl_unit)    

    READ (UNIT=nl_unit, NML = interp_control)
    CLOSE (nl_unit)

    ! Process the active subnests portion of the namelist
    IF (num_active_subnests .LT. 0) THEN
      PRINT *,"NUM_ACTIVE_SUBNESTS < 0 :", num_active_subnests
      PRINT *,"Resetting to 0"
      num_active_subnests = 0
    ELSEIF(num_active_subnests .GT. 0) THEN
      IF (num_active_subnests .GT. 10) THEN
         PRINT *, "NUM_ACTIVE_SUBNESTS > 10!"
         PRINT *, "Only 10 nests allowed for now."
         STOP 'too_many_active_subnests'
      ENDIF
    
      ! Make sure one of the active subnests is not 1
      DO n = 1,num_active_subnests
        IF (active_subnests(n) .LE. 1) THEN
          PRINT *, 'ACTIVE_SUBNESTS contains value 1'
          PRINT *, 'It is only used to specify children nests of the MOAD.'
          PRINT *, 'Valid values must be 2 or greater.'
          STOP 'bad_active_subnest'
        ENDIF
      ENDDO
    ENDIF  
    RETURN
  END SUBROUTINE read_interp_nl

END MODULE wrfsi_nl                                    
