PROGRAM staticpost

!  This Fortran90 program is used to read each static.wrfsi.dxx file
!  within a MOAD_DATAROOT and create a static_wrf.dxx file that is in
!  the netCDF format compliant with the WRF system API.
!
!  Original version:  Nov 2003, Brent Shaw
!
!

  USE wrfsi_static
  USE wrf_metadata
  USE map_utils
  USE wrfsi_io
  USE staticpost_setup
 
  IMPLICIT NONE

  INTEGER                      :: domain  
  INTEGER                      :: dr

  REAL                         :: lat1, lon1
  REAL                         :: truelat1,truelat2,stdlon
  REAL                         :: dx, dy
  CHARACTER(LEN=2)             :: domain_str
  CHARACTER(LEN=32)            :: projection
  CHARACTER(LEN=256)           :: static_grid_file
  CHARACTER(LEN=256)           :: static_wrf_file
  CHARACTER(LEN=256)           :: wrfsinl

  LOGICAL                      :: file_exists

  TYPE (proj_info)             :: proj_dom(max_domains)

  ! Get the MOAD_DATAROOT so we can find the namelist 
  CALL GETENV('MOAD_DATAROOT',moad_dataroot)

  CALL setup(moad_dataroot) 
  ! Loop over all domains
  DO domain = 1, setup_info%num_domains
    WRITE (domain_str, '(I2.2)') domain
    static_grid_file = TRIM(moad_dataroot) //'/static/static.wrfsi.d'//domain_str

    ! We only process the static files we find
    INQUIRE(FILE=static_grid_file, EXIST=file_exists)
    IF ((domain .eq. 1) .AND. (.NOT. file_exists)) THEN
      ! Try the old file name format...
      static_grid_file = TRIM(moad_dataroot) //'/static/static.wrfsi'
      INQUIRE(FILE=static_grid_file, EXIST=file_exists)
      IF (.NOT. file_exists) THEN
        PRINT '(A)', 'No static file found for the MOAD!'
        STOP
      ENDIF
    ENDIF
    IF (file_exists) THEN
      static_wrf_file = TRIM(setup_info%output_prefix) // '.d'//domain_str
      PRINT '(2A)', 'Input file: ', TRIM(static_grid_file)
      PRINT '(2A)', 'Output file: ', TRIM(static_wrf_file)
      call ext_ncd_ioinit(Status)

      ! Populate the domain metadata...the subroutine being called
      ! sets up the projection information for the domain and popluates
      ! most of the domain metadata (dom_meta from the wrf_metadata modue).
      ! Additionally, if domain = 1, it populates some portions of the
      ! global_meta structure
      CALL init_domain(moad_dataroot,domain,proj_dom(domain)) 
      DryRun = .true.
      dryrun_loop:  DO dr = 1,2
   
        ! Finish populating domain metadata
        dom_meta%parent_id = setup_info%parent_id(domain)
        dom_meta%vt_date   = setup_info%wrfdate
        dom_meta%vt_time   = setup_info%wrftime
        dom_meta%origin_parent_x = setup_info%domain_origin_parent_lli(domain)
        dom_meta%origin_parent_y = setup_info%domain_origin_parent_llj(domain)
        dom_meta%end_parent_x = setup_info%domain_origin_parent_uri(domain)
        dom_meta%end_parent_y = setup_info%domain_origin_parent_urj(domain)
        dom_meta%ratio_to_parent = setup_info%ratio_to_parent(domain)
        dom_meta%top_level = 0.
        dom_meta%origin_parent_z = 1
        dom_meta%zdim = 1
        ! Get each static field required.  As we get each one, populate its variable
        ! metadata and write it out using the API.
        IF (.NOT.setup_info%nmmcore) THEN
          CALL proc_static
        ELSE
          CALL proc_static_nmm
        ENDIF
        ! Commit the file for writing if this is 1st time thru dryrun loop
        IF (DryRun) call ext_ncd_open_for_write_commit(WrfDataHandle, Status)
        DryRun = .FALSE.
      ENDDO dryrun_loop 
  
      ! Write global metadata
      CALL wrf_write_global_metadata (global_meta%vertical_coord) 

      ! Close the file before moving on
      CALL ext_ncd_ioclose(WrfDataHandle, Status)
    ENDIF 
  ENDDO 
  CALL ext_ncd_ioexit(Status)
END PROGRAM staticpost
 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!   
SUBROUTINE wrf_debug(level,str)
  IMPLICIT NONE
  INTEGER       , INTENT (IN) :: level
  CHARACTER*(*) , INTENT (IN) :: str

  write(0,*) str
  print*, str

  return
END SUBROUTINE wrf_debug
