!dis
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis
!dis                                   
MODULE vinterp_domain
  USE wrf_metadata
  USE wrfsi_static

  CHARACTER(LEN=8)		:: input_vcoord
  CHARACTER(LEN=8)              :: output_vcoord
  INTEGER			:: input_nz, output_nz
  REAL, ALLOCATABLE		:: input_levels(:,:)
  REAL, ALLOCATABLE 		:: output_levels(:,:)
  INTEGER			:: nx,ny,nsh,nsv_out,nsv_in
  INTEGER, PARAMETER		:: zstag_full_index = 2
  INTEGER, PARAMETER            :: zstag_half_index = 1
  REAL, ALLOCATABLE             :: terrain_hgt_n(:,:) ! non-stagg topo
  REAL, ALLOCATABLE             :: terrain_hgt_t(:,:) ! T-grid topo
  TYPE (wrf_domain_metadata)	:: dom_old,dom_out

CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  SUBROUTINE fill_domain_topo(domain_info,dataroot)

    IMPLICIT NONE
    TYPE(wrf_domain_metadata),INTENT(IN)       :: domain_info
    CHARACTER(LEN=*),INTENT(IN)                :: dataroot
 
    IF (ALLOCATED(terrain_hgt_n)) DEALLOCATE (terrain_hgt_n)
    IF (ALLOCATED(terrain_hgt_t)) DEALLOCATE (terrain_hgt_t)
    ALLOCATE(terrain_hgt_n(domain_info%xdim,domain_info%ydim))
    ALLOCATE(terrain_hgt_t(domain_info%xdim,domain_info%ydim))           
    CALL get_wrfsi_static_2d(dataroot, domain_info%id,NAME_TER_N, terrain_hgt_n)
    CALL get_wrfsi_static_2d(dataroot, domain_info%id, NAME_TER_T, terrain_hgt_t)
   
    RETURN
  END SUBROUTINE fill_domain_topo
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

END MODULE vinterp_domain
