!dis
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis
!dis                                                          

MODULE vinterp_nmmhyb

!  General Procedure:
!
!     1.  Compute hybrid interface values.
!     2.  Interpolate grids to desired hybrid levels.
!     3.  Diagnose WRF state variables 
!     4.  Output
!
!  HISTORY
!     Feb 2002 - Original version -- B. Shaw, NOAA/FSL
!     Jun 2003 - NMM version -- M. Pyle, NOAA/NCEP (builds on original infrastructure)

  USE wrfsi_io
  USE wrf_metadata
  USE vinterp_domain
  USE vinterp_setup
  USE date_pack
  USE grid_utils
  USE physical_constants
  USE diagnostic_vars
  USE wrfsi_static          
  USE vinterp_utils
  USE WriteField
  IMPLICIT NONE

  PRIVATE
  
   ! Variables shared among contained subroutines

   
   INTEGER, ALLOCATABLE             :: sfc_k_ind(:,:)
   CHARACTER(LEN=8)                 :: processed_var_list(200)
   INTEGER                          :: num_processed
   LOGICAL                          :: use_sfc
   LOGICAL                          :: skip_lowest
   TYPE(wrfvar_metadata)            :: var_meta_out

  PUBLIC nmmhyb_driver

CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  SUBROUTINE nmmhyb_driver

    IMPLICIT NONE

	write(6,*) 'call setup_nmmhyb'
    CALL setup_nmmhyb
	write(6,*) 'call interp_state_nmmhyb'
    CALL interp_state_nmmhyb
	write(6,*) 'call process_others'
    CALL process_others
    IF (ALLOCATED(sfc_k_ind)) DEALLOCATE(sfc_k_ind)
	write(6,*) 'leaving nmmhyb_driver'
    RETURN

  END SUBROUTINE nmmhyb_driver
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
  SUBROUTINE setup_nmmhyb
    IMPLICIT NONE
    character(LEN=4) fileType
  
    num_processed = 0
    processed_var_list(:) = '        '    
    dom_out = dom_meta
    dom_out%zdim = output_nz
    fileType = setup_info%output_file_type
    if(fileType == 'BIN' .or. fileType == 'BOTH') then
      CALL init_new_output_file(dom_out,setup_info%output_prefix, &
      setup_info%current_date)
    endif
    if(fileType == 'WRF' .or. fileType == 'BOTH') then
      CALL init_new_wrf_output_file(dom_out,setup_info%wrf_output_prefix, &
        setup_info%current_date)
    endif

!mp
!mp	zstag_full_index?????
!mp

    ! Output the Full EtaP level values
   var_meta_out%name = hybfull_id
   var_meta_out%units = 'Dimensionless'
 var_meta_out%description = 'sigma value on vertical full levels (for sig/hyb) '
    var_meta_out%domain_id = dom_meta%id
    var_meta_out%ndim=1
    var_meta_out%dim_val(1) = output_nz
    var_meta_out%dim_val(2) = 0
    var_meta_out%dim_val(3) = 0
    var_meta_out%dim_val(4) = 0
    var_meta_out%dim_val(5) = 0
    var_meta_out%dim_desc(1) = 'VERT'
    var_meta_out%dim_desc(2) = '    '
    var_meta_out%dim_desc(3) = '    '
    var_meta_out%dim_desc(4) = '    '
    var_meta_out%dim_desc(5) = '    '
    var_meta_out%start_index(1) = 1
    var_meta_out%start_index(2) = 0
    var_meta_out%start_index(3) = 0
    var_meta_out%start_index(4) = 0
    var_meta_out%start_index(5) = 0
    var_meta_out%stop_index(1) = output_nz
    var_meta_out%stop_index(2) = 0
    var_meta_out%stop_index(3) = 0
    var_meta_out%stop_index(4) = 0
    var_meta_out%stop_index(5) = 0
    var_meta_out%h_stagger_index = 0
    var_meta_out%v_stagger_index = zstag_full_index
    var_meta_out%array_order = '+Z      '
    var_meta_out%field_type = 'REAL'
    var_meta_out%field_source_prog = 'SI'
    var_meta_out%source_desc = 'User defined levels generated by WRFSI/vinterp'
    var_meta_out%field_time_type = 'CONSTANT'
    var_meta_out%vt_date_start = dom_meta%vt_date
    var_meta_out%vt_time_start = dom_meta%vt_time
    var_meta_out%vt_date_stop = dom_meta%vt_date
    var_meta_out%vt_time_stop = dom_meta%vt_time
    num_processed = num_processed + 1
    processed_var_list(num_processed) = hybfull_id 
!1001    call write_field ( var_meta_out%name,output_levels(:,zstag_full_index),var_meta_out)
    RETURN
  END SUBROUTINE setup_nmmhyb
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  SUBROUTINE interp_state_nmmhyb

 
    IMPLICIT NONE
    INTEGER                     :: i,j,k,l,ld,lko
    LOGICAL                     :: found_k,elim_lowest
    REAL                        :: deltap
    REAL                        :: wgt0
    INTEGER                     :: adjustz_cnt
    REAL, ALLOCATABLE           :: press3d_in(:,:,:)
    REAL, ALLOCATABLE           :: t3d_in(:,:,:)
    REAL, ALLOCATABLE           :: rh3d_in(:,:,:)
    REAL, ALLOCATABLE           :: z3d_in(:,:,:)            
    REAL, ALLOCATABLE           :: z3d_out(:,:,:)            
    REAL, ALLOCATABLE           :: t3d_out(:,:,:)
    REAL, ALLOCATABLE           :: qv3d_in(:,:,:)
    REAL, ALLOCATABLE           :: q3d_out(:,:,:)
    REAL, ALLOCATABLE           :: u3d_in(:,:,:)
    REAL, ALLOCATABLE           :: v3d_in(:,:,:)
    REAL, ALLOCATABLE           :: u3d_out(:,:,:) 
    REAL, ALLOCATABLE           :: v3d_out(:,:,:)
    REAL, ALLOCATABLE           :: dum2d(:,:),pdo(:,:),pmidi(:,:)
!mp
    REAL, ALLOCATABLE,DIMENSION(:)  :: sg1,sg2,dsg1,dsg2,sgml1,sgml2,dsg
    REAL, ALLOCATABLE,DIMENSION(:)  :: pmo,pio,pin,rhin,zin,y2,dum1,dum2,pmcol
    REAL, ALLOCATABLE,DIMENSION(:)  :: uin,vin,dfl

    REAL(SELECTED_REAL_KIND(8)), ALLOCATABLE :: ALP(:),ALPR(:)
    REAL                        :: ptsgm,pt,pl,pt2,pdtop,pdvp,d1
    REAL(SELECTED_REAL_KIND(8))	:: dlnpdz,dlnqdlnp,alpout,cf
    INTEGER                     :: lpt2, LL, LMAX, KK

    REAL, PARAMETER:: CM1=2937.4,CM2=4.9283,CM3=23.5518,EPS=0.622
    REAL, PARAMETER:: CP=1004.6,GAMMA=.0065,PRF0=101325.,T0=288.
    REAL, PARAMETER:: RD=287.04,G=9.806
    REAL           :: qsmx,qsx,cloges,ese,qtmp,pmido,tmp,qld,rgog
    REAL           :: qest,tnew
!mp

    ! Initialize some variables

    ! Allocate space for the temp/RH/pressure arrays. 
    ! The input data
    ! has already been horizontally interpolated to the WRF-NMM stagger

	write(6,*) 'allocating _in variables with zdim: ', dom_meta%zdim
    ALLOCATE(press3d_in(dom_meta%xdim,dom_meta%ydim,dom_meta%zdim ))
    ALLOCATE(t3d_in(dom_meta%xdim,dom_meta%ydim,dom_meta%zdim ))
    ALLOCATE(rh3d_in(dom_meta%xdim,dom_meta%ydim,dom_meta%zdim ))
    ALLOCATE(z3d_in(dom_meta%xdim,dom_meta%ydim,dom_meta%zdim ))
    ALLOCATE (u3d_in(dom_meta%xdim,dom_meta%ydim,dom_meta%zdim))
    ALLOCATE (v3d_in(dom_meta%xdim,dom_meta%ydim,dom_meta%zdim))
 
    ! Get the temperature, RH, and surface pressure fields. 
    ! Determine whether or not input data is isobaric.

    IF(.not.Dryrun)PRINT '(A,A)', &
	'INTERP_STATE_NMMH: Getting 3D temperature field...'
	write(6,*) 'call get_variable'
	write(6,*) 'setup_info%input_prefix: ', setup_info%input_prefix
	write(6,*) 'setup_info%current_date: ', setup_info%current_date
	write(6,*) ' '
    CALL get_variable(setup_info%input_prefix, t_id, dom_meta%id, &
      setup_info%current_date,status) 
	write(6,*) 'return get_variable'
    IF (status.EQ.0) THEN
      t3d_in = real_array(:,:,:,1,1)
      num_processed = num_processed + 1
      processed_var_list(num_processed) = t_id
    ELSE      
      PRINT *,'Problem getting ', t_id
      DEALLOCATE(real_array)
      STOP 'No_T3D_data'  
    ENDIF   
    if(.not.DryRun)print '(A,2F9.1)','Min/Max values = ', &
		 MINVAL(t3d_in),MAXVAL(t3d_in)

    IF(.not.Dryrun)PRINT '(A,A)', & 
		'INTERP_STATE_NMMH: Getting 3D height field...'
    CALL get_variable(setup_info%input_prefix, height_id, dom_meta%id, &
      setup_info%current_date,status)
    IF (status.EQ.0) THEN
      z3d_in = real_array(:,:,:,1,1)
      num_processed = num_processed + 1
      processed_var_list(num_processed) = height_id
    ELSE
      PRINT *,'Problem getting ', height_id
      STOP 'No_Z3D_data'
    ENDIF
    if(.not.DryRun)print '(A,2F9.1)','Min/Max values = ',MINVAL(z3d_in), &
      MAXVAL(z3d_in)
	write(6,*) 'z3d(1,1,1), z3d(1,1,2): ', z3d_in(1,1,1),&
		z3d_in(1,1,2)
      
    IF(.not.Dryrun)PRINT '(A,A)', 'INTERP_STATE_NMMH: Getting 3D RH field...'
    CALL get_variable(setup_info%input_prefix, rh_id, dom_meta%id, &
      setup_info%current_date,status)
    IF (status.EQ.0) THEN
      rh3d_in = real_array(:,:,:,1,1)
      num_processed = num_processed + 1
      processed_var_list(num_processed) = rh_id
    ELSE
      PRINT *,'Problem getting ', rh_id
      STOP 'No_RH3D_data'
    ENDIF
    if(.not.DryRun)print '(A,2F9.1)','Min/Max values = ',MINVAL(rh3d_in), &
       MAXVAL(rh3d_in)                                               
	write(6,*) 'rh3d(1,1,1), rh3d(1,1,2): ', rh3d_in(1,1,1),&
		rh3d_in(1,1,2)
 
    ! Get the pressures
    IF(.not.Dryrun)PRINT '(A,A)', 'INTERP_STATE_NMMH: Getting pressure array'
      CALL get_variable(setup_info%input_prefix, pressure_id, dom_meta%id, &
        setup_info%current_date,status)                                      
    IF (status .NE. 0) THEN
      PRINT *, 'No pressure data found using: ',pressure_id
      STOP 'Need_pressure_data'
    ELSE 
      num_processed = num_processed + 1
      processed_var_list(num_processed) = pressure_id  
      IF (var_info%ndim .eq. 1) THEN
        ! Isobaric input:
        ! Create a 3D array from the 1D aray
        IF(.not.Dryrun)PRINT *,"Creating 3D pressure array from 1D"
        IF(.not.Dryrun)PRINT *,'Levels found = ', real_array(:,1,1,1,1)
        DO j = 1,dom_meta%ydim
          DO i = 1,dom_meta%xdim
            press3d_in(i,j,:) = real_array(:,1,1,1,1)
          ENDDO
        ENDDO
      ELSE IF (var_info%ndim .eq. 3) THEN
        IF(.not.Dryrun)PRINT *, 'Pressure array already 3D'
        press3d_in = real_array(:,:,:,1,1)
        IF(.not.Dryrun)PRINT '(A,2F10.1)',  &
	'Min/Max pressures: ',MINVAL(press3d_in), MAXVAL(press3d_in)
      ELSE
         PRINT *, 'Pressure array not 1D or 3d; ndim = ', var_info%ndim
         STOP 'Help_I_am_not_ready_for_this'
      ENDIF
    ENDIF



!mp	if P(1,1,1)=200100, eliminate lowest level for all fields

	elim_lowest=.false.
	LMAX=dom_meta%zdim
	if (press3d_in(1,1,1) .ge. 200100.) then

	elim_lowest=.true.

	LMAX=dom_meta%zdim-1

	do L=1,LMAX
	 do J=1,dom_meta%ydim
	  do I=1,dom_meta%xdim
             press3d_in(I,J,L)=press3d_in(I,J,L+1)
             z3d_in(I,J,L)=z3d_in(I,J,L+1)
             t3d_in(I,J,L)=t3d_in(I,J,L+1)
             rh3d_in(I,J,L)=rh3d_in(I,J,L+1)
	  enddo
	 enddo
	enddo

	endif

	I=dom_meta%xdim/2
	J=dom_meta%ydim/2

	do L=1,LMAX
	write(6,*) 'center column L,P,Z: ', L,press3d_in(I,J,L),z3d_in(I,J,L)
	enddo

    IF (MAXVAL(press3d_in(:,:,1)).LT.200000.) THEN
      use_sfc = .false.
      skip_lowest = .false.
    ELSE

!        CALL shift_sfc_slab(z3d_in)
        ! Here is the sanity check...
!        adjustz_cnt = 0
!        DO j = 1,dom_meta%ydim
!          DO i = 1,dom_meta%xdim 
!            k = sfc_k_ind(i,j)
!            IF ( k .EQ. 1)  THEN
!              IF ( z3d_in(i,j,k).GT.z3d_in(i,j,k+1) ) THEN
!                ! PRINT *, 'Height problem at i/j/k/k+1',i,j,k,k+1, 'Values =',&
!                !       z3d_in(i,j,k), z3d_in(i,j,k+1)
!                ! If we are within 10 mb, do a simple correction, otherwise
!                ! stop with an error
!                deltap = press3d_in(i,j,k) - press3d_in(i,j,k+1)
!                IF ((deltap .LT. 1000.).AND.(deltap.GE.0)) THEN
!                  ! PRINT *, 'Applying simple correction.'
!                  adjustz_cnt = adjustz_cnt + 1
!                  z3d_in(i,j,k) = z3d_in(i,j,k+1) - deltap/10.
!                ELSE
!                  PRINT *, 'Cannot correct.  Need to debug...'
!                  STOP 'bad_surface_height_vs_press'
!                ENDIF
!              ENDIF
!            ELSE
!              IF ( (z3d_in(i,j,k).LT.z3d_in(i,j,k-1)) .OR. &
!                   (z3d_in(i,j,k).GT.z3d_in(i,j,k+1)) ) THEN
!                adjustz_cnt = adjustz_cnt+1
!                ! PRINT *, 'Bad height at i/j/k = ', i,j,k
!                ! PRINT *, 'Z0/Z/Z1 = ', z3d_in(i,j,k-1:k+1) 
! PRINT *, 'Replacing with interpolated value'
!                wgt0 = 1.0 - ( ALOG( press3d_in(i,j,k-1)/press3d_in(i,j,k))/&
!                               ALOG( press3d_in(i,j,k-1)/press3d_in(i,j,k+1)))  
!                z3d_in(i,j,k) = wgt0*z3d_in(i,j,k-1) + &
!                                (1.-wgt0)*z3d_in(i,j,k+1)     
!                ! PRINT *, 'New Z0/Z/Z1 = ',z3d_in(i,j,k-1:k+1)
!              ENDIF
!            ENDIF
!          ENDDO
!        ENDDO
! IF(.not.Dryrun)PRINT *, 'Number of columns where Zsfc had to be adjusted: ', &
!                  adjustz_cnt
    ! ELSE
        ! Sort by height and derive surface pressure 
        ! COMPLETE THIS WORK LATER.  FOR NOW, JUST MENTION
        ! NOT SUPPORTED AND SET USE_SFC = .FALSE. 
    !   PRINT *, 'Sorting by ZSFC and deriving PSFC'
    !   use_sfc = .true.
    !   skip_lowest = .false.

!      ENDIF

    ENDIF 

    ! Generate the 3d array of Eta values on the background gridpoints.
    ! Subroutine also returns the 2D mu array, which is computed using
    ! the WRF topography to ensure a pressure field consistent with the
    ! forecast model.


!mp
!mp	here is where we start deviating dramatically
!mp

	write(6,*) 'dom_out%zdim= ', dom_out%zdim

!-----------------------------------------------------------------------
!  ptsgm is the approximate pressure at the boundary between pressure
!  and sigma in Pa.
!-----------------------------------------------------------------------
      ptsgm=42000.  ! Pa
	lpt2=0
	pt=setup_info%max_top

	write(6,*) 'pt= ', pt

	DO L=dom_out%zdim,1,-1
	  pl=output_levels(L,zstag_full_index)*(101300.-pt)+pt
	  if(pl.lt.ptsgm) lpt2=l
        ENDDO

      IF(lpt2.gt.0) THEN
        pt2=output_levels(lpt2,zstag_full_index)*(101300.-pt)+pt
      ELSE
        pt2=pt
      ENDIF

      print*,'*** Sigma system starts at ',pt2,' Pa, from level ',lpt2

      pdtop=pt2-pt

	write(6,*) 'allocating dsg,dsg1,dsg2 as ', dom_out%zdim-1

	ALLOCATE(DSG(dom_out%zdim-1))
	ALLOCATE(DSG1(dom_out%zdim-1))
	ALLOCATE(DSG2(dom_out%zdim-1))

	DSG=-99.
	DSG1=-99.
	DSG2=-99.

      DO L=1,dom_out%zdim-1
	dsg(L)=output_levels(L,zstag_full_index)- &
	       output_levels(L+1,zstag_full_index)

      ENDDO

	dsg1=0.
	dsg2=0.

      DO L=dom_out%zdim-1,1,-1

       IF(L.ge.lpt2) then
        dsg1(L)=dsg(L)
       ELSE
        dsg2(L)=dsg(L)
       ENDIF

!	write(6,*) 'INITIALLY...L,dsg1,dsg2: ', L, dsg1(L), dsg2(L)

      ENDDO

	ALLOCATE(SG1(dom_out%zdim))
	ALLOCATE(SG2(dom_out%zdim))
	ALLOCATE(SGML1(dom_out%zdim-1))
	ALLOCATE(SGML2(dom_out%zdim-1))

	SGML1=-99.
	SGML2=-99.

      IF(lpt2.gt.0) THEN

!	dsg2 defined from 1 to lpt2-2

!?	DO L=dom_out%zdim,lpt2-1,-1
	DO L=dom_out%zdim,lpt2,-1
	sg2(L)=0.
	ENDDO

       DO L=lpt2,2,-1
        sg2(L-1)=sg2(L)+dsg2(L-1)
       ENDDO

	DO L=lpt2-1,1,-1
	sg2(L)=sg2(L)/sg2(1)
	ENDDO
	sg2(1)=1.

       DO L=lpt2-1,1,-1
	dsg2(L)=sg2(L)-sg2(L+1)
        sgml2(l)=(sg2(l)+sg2(l+1))*0.5
       ENDDO
	
!!	SGML2(LPT2-1)=0.

      ENDIF

      DO L=dom_out%zdim-1,lpt2,-1
        dsg2(L)=0.
        sgml2(L)=0.
      ENDDO

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


	sg1(dom_out%zdim)=0.

      DO L=dom_out%zdim,lpt2,-1
       sg1(L-1)=sg1(L)+dsg1(L-1)
      ENDDO

      DO L=dom_out%zdim-1,lpt2,-1
       sg1(L)=sg1(L)/sg1(lpt2-1)
      ENDDO

	sg1(lpt2-1)=1.

       do l=lpt2-2,1,-1
        sg1(l)=1.
       enddo


      DO L=dom_out%zdim-1,lpt2,-1
       dsg1(L)=sg1(L)-sg1(L+1)
       sgml1(L)=(sg1(L)+sg1(L+1))*0.5
      ENDDO

      DO L=lpt2-1,1,-1
               dsg1(L)=0.
               sgml1(L)=1.
      ENDDO

	do L=dom_out%zdim,1,-1
	write(6,*) 'L,sg1,sg2: ', L,sg1(L),sg2(L)
	enddo

	write(6,*) ' '

	do L=dom_out%zdim-1,1,-1
	write(6,*) 'L,dsg1,dsg2: ', L,dsg1(L),dsg2(L)
	enddo

	do L=dom_out%zdim-1,1,-1
	write(6,*) 'L,sgml1,sgml2: ', L,sgml1(L),sgml2(L)
	enddo

  632	format(f9.6)

	write(6,*) 'sg1'
	do L=dom_out%zdim,1,-1
	write(6,632) sg1(L)
	enddo 
	write(6,*) 'sg2'
	do L=dom_out%zdim,1,-1
	write(6,632) sg2(L)
	enddo 
	write(6,*) 'dsg1'
	do L=dom_out%zdim-1,1,-1
	write(6,632) dsg1(L)
	enddo 
	write(6,*) 'dsg2'
	do L=dom_out%zdim-1,1,-1
	write(6,632) dsg2(L)
	enddo 
	write(6,*) 'sgml1'
	do L=dom_out%zdim-1,1,-1
	write(6,632) sgml1(L)
	enddo 
	write(6,*) 'sgml2'
	do L=dom_out%zdim-1,1,-1
	write(6,632) sgml2(L)
	enddo 





	rgog=(rd*gamma)/g

	allocate(DFL(dom_out%zdim))
      DO L=1,dom_out%zdim
        DFL(L)=g*T0*(1.-((pt+sg1(L)*pdtop+sg2(L)*(prf0-pt2)) &
                       /prf0)**rgog)/gamma

	write(6,*) 'L, DFL(L): ', L, DFL(L)
      ENDDO


!!! 	TERRAIN_HGT_T has H-POINT TERRAIN

	write(6,*) 'dom_meta%xdim,dom_meta%ydim: ', dom_meta%xdim, &
			dom_meta%ydim

!	write(6,*) 'H points'
	do J=dom_meta%ydim,1,-dom_meta%ydim/20
!	write(6,633) (terrain_hgt_t(I,J),I=1,dom_meta%xdim,dom_meta%xdim/10)
	enddo

  633	format(20(f5.0,1x))

!!	 many ways to compute surface pressure

	allocate(dum2d(dom_meta%xdim,dom_meta%ydim))

	dum2d=-9.

	write(6,*) 'dum2d dims: ', dom_meta%xdim, dom_meta%ydim

       DO J=1,dom_meta%ydim
       DO I=1,dom_meta%xdim


	IF (terrain_hgt_t(I,J) .lt. z3d_in(i,j,1)) THEN

!	target is below lowest input...extrapolate

	dlnpdz= (log(press3d_in(i,j,1))-log(press3d_in(i,j,2)) ) / &
		(z3d_in(i,j,1)-z3d_in(i,j,2))

	dum2d(I,J)= exp( &
			log(press3d_in(i,j,1)) + dlnpdz * &
			(terrain_hgt_t(I,J) - z3d_in(i,j,1)) &
			)

!
!	NOTE:  The above ln P formulation and below P formulation
!		agree to within less than 1 mb.  Typically within
!		.01-.1 mb

!	dum2ds(I,J)= (press3d_in(i,j,2)-press3d_in(i,j,1))/ &
!		(z3d_in(i,j,2)-z3d_in(i,j,1))* &
!		(terrain_hgt_t(i,j)-z3d_in(i,j,1))+press3d_in(i,j,1)

	ELSE ! target level bounded by input levels

	DO L=1,LMAX-1

	   if (terrain_hgt_t(I,J) .gt. z3d_in(i,j,L) .and. &
	      terrain_hgt_t(I,J) .lt. z3d_in(i,j,L+1) ) then

	dlnpdz= (log(press3d_in(i,j,l))-log(press3d_in(i,j,L+1)) ) / &
		(z3d_in(i,j,l)-z3d_in(i,j,L+1))

	dum2d(I,J)= log(press3d_in(i,j,l)) +   &
	            dlnpdz * (terrain_hgt_t(I,J) - z3d_in(i,j,L) )
	dum2d(i,j)=exp(dum2d(i,j))

	   endif

	ENDDO

	ENDIF

	if (dum2d(I,J) .eq. -9.) then
	write(6,*) 'must have flukey situation'
	DO L=1,LMAX-1
	if ( terrain_hgt_t(I,J) .eq. z3d_in(i,j,L) ) then
	dum2d(i,j)=press3d_in(I,J,L)
	endif
	ENDDO
	endif

	if (dum2d(I,J) .eq. -9.) then
	write(6,*) 'HOPELESS, I QUIT'
	STOP
	endif

	enddo
	enddo

	write(6,*) 'psfc points'
	do J=dom_meta%ydim,1,-dom_meta%ydim/20
	write(6,633) (dum2d(I,J)/100.,I=1,dom_meta%xdim,dom_meta%xdim/10)
	enddo

	write(6,*) 'PSFC extremes'
	write(6,*) minval(dum2d),maxval(dum2d)


!!!	BUILD PRESSURES at HYBRID INTERFACES/MIDLAYERS

	allocate(PMO(dom_out%zdim-1))
	allocate(PIO(dom_out%zdim))
	allocate(pin(LMAX+1))
	allocate(rhin(LMAX))
	allocate(zin(LMAX+1))
	allocate(y2(LMAX+2))
	allocate(dum1(LMAX+2))
        allocate(dum2(LMAX+2))
	allocate(z3d_out(dom_out%xdim,dom_out%ydim,dom_out%zdim)) 
	allocate(pdo(dom_out%xdim,dom_out%ydim)) 
	allocate(t3d_out(dom_out%xdim,dom_out%ydim,dom_out%zdim)) 

       DO J=1,dom_meta%ydim
       DO I=1,dom_meta%xdim
	pdo(I,J)=dum2d(I,J)-pdtop-pt
       ENDDO
       ENDDO

       DO J=1,dom_meta%ydim
       DO I=1,dom_meta%xdim

!	swap press3d order
	do L=1,LMAX
	pin(L)=press3d_in(I,J,LMAX-L+1)
	zin(L)=z3d_in(I,J,LMAX-L+1)
	rhin(L)=rh3d_in(I,J,LMAX-L+1)
	enddo


!---------now output pressure levels can be defined---------------------


          DO L=1,dom_out%zdim-1
      pmo(L)=sgml2(L)*pdo(I,J)+sgml1(L)*pdtop+pt
	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2 ) then
!	write(6,*) 'L,pdo,sgml2,sgml1,pdtop, pmo: ', L,pdo(I,J), &
!                       sgml2(L),sgml1(L),pdtop, pmo(L)
	endif
          ENDDO

          DO L=1,dom_out%zdim
      pio(L)=sg2(L)*pdo(I,J)+sg1(L)*pdtop+pt

	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
	if (L .eq. 1) then
	write(6,*) 'PDO,PDTOP: ', PDO(I,J),PDTOP
	endif
!	write(6,*) 'L,sg2,sg1,pio: ', L, &
!                       sg2(L),sg1(L),pio(L)
	endif

	y2(L)=0.    !!!! big enough vector?
          ENDDO

	if ( (zin(LMAX)-terrain_hgt_t(I,J)) .gt. 0.5) then

!	basically use computed surface pressure as another data point

	zin(LMAX+1)=terrain_hgt_t(I,J)
	pin(LMAX+1)=pio(1)

!!!
!!!	z3d_out only used for T generation.  Want it on the interfaces.
!!!	

	call SPLINE2(I,J,LMAX+1,pin,zin,y2,dom_out%zdim, &
		pio,z3d_out(I,J,:),dum1,dum2 )

	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
	do L=1,dom_out%zdim
	write(6,*) 'mid column: pio, z3d_out: ', L, pio(L),z3d_out(I,J,L)
	enddo
	endif

	else   ! not using surface pressure as another data point

	call SPLINE2(I,J,LMAX,pin,zin,y2,dom_out%zdim, &
		pio,z3d_out(I,J,:),dum1,dum2 )

	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
	do L=1,dom_out%zdim
	write(6,*) 'mid column: pio, z3d_out: ', L, pio(L),z3d_out(I,J,L)
	enddo
	endif

	endif


!!!	VIRTUAL TEMPERATURE FOR THE TIME BEING

	do L=1,dom_out%zdim-1

	if (Z3d_out(I,J,L+1) .lt. z3d_out(I,J,L)) then
	write(6,*) 'z3d_out is out of order at ', I,J
	do LL=1,dom_out%zdim-1
	write(6,*) 'LL, z3d_out(I,J,LL): ', LL, z3d_out(I,J,LL)
	enddo
	write(6,*) 'pin: ', pin
	write(6,*) 'zin: ', zin
	STOP
	endif
	

	if (I .eq. 1 .and. J .eq. 1) then
!	write(6,*) 'z3d_out(L),z3d_out(L+1): ', z3d_out(I,J,L),z3d_out(I,J,L+1)
	endif
	
!old		t3d_out(I,J,L)=-(pmo(L)*g/rd)* &
!old		   (z3d_out(I,J,L)-z3d_out(I,J,L+1))/(pio(L)-pio(L+1))


! 030925 test

	t3d_out(I,J,L)=-(g/rd)* &
             (z3d_out(I,J,L)-z3d_out(I,J,L+1))/(log(pio(L))-log(pio(L+1)))


	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2 ) then
            write(6,*) 'z3d_out,t3d_out, pio,pmo : ', L, z3d_out(I,J,L),&
                                        t3d_out(I,J,L), pio(L),pmo(L)
	endif

	
	if (t3d_out(i,j,l) .gt. 150 .and. t3d_out(i,j,l) .lt. 400) then
	else
	  write(6,*) 'corrupted t3d_out!!!! ', i,j,l,t3d_out(i,j,l)
	   do LL=1,dom_out%zdim
	    write(6,*) 'column of z3d_out: ', LL, z3d_out(I,J,LL)
	   enddo
	   write(6,*) 'pmo(L),g,rd: ', pmo(L),g,rd
	   do LL=1,LMAX
	    write(6,*) 'column of pin, zin: ', LL, pin(LL), zin(LL)
	   enddo

	STOP

	endif

	enddo

	
	ENDDO
	ENDDO


!	write(6,*) 'check z3d_out, level 1'
	do J=dom_meta%ydim,1,-dom_meta%ydim/20
!	write(6,634) (z3d_out(I,J,1),I=1,dom_meta%xdim,dom_meta%xdim/10)
	enddo

!	write(6,*) 'check t3d_out(virtual), level nz-1'
	do J=dom_meta%ydim,1,-dom_meta%ydim/20
!	write(6,634) (t3d_out(I,J,dom_out%zdim-1),I=1,dom_meta%xdim,dom_meta%xdim/10)
	enddo

!	write(6,*) 'check z3d_out, level 29'
	do J=dom_meta%ydim,1,-dom_meta%ydim/20
!	write(6,634) (z3d_out(I,J,29),I=1,dom_meta%xdim,dom_meta%xdim/10)
	enddo

   634	format(20(f6.0,1x))

	DEALLOCATE(z3d_out)

!!!
!!!	WIND INTERP
!!!

	write(6,*) 'uin, vin allocated with zdim: ', LMAX+1
	allocate(uin(LMAX+1))
	allocate(vin(LMAX+1))

   ! Process the u wind field
    IF(.not.Dryrun)PRINT '(A,A)', 'INTERP_STATE_NMMH: Getting 3D U field...'
    CALL get_variable(setup_info%input_prefix, u_id, dom_meta%id, &
      setup_info%current_date,status)
    IF (status.EQ.0) THEN
      u3d_in = real_array(:,:,:,1,1)
      num_processed = num_processed + 1
      processed_var_list(num_processed) = u_id
    ELSE
      PRINT *,'Problem getting ', u_id
      STOP 'No_U3D_data'
    ENDIF

   ! Process the v wind field
    IF(.not.Dryrun)PRINT '(A,A)', 'INTERP_STATE_NMMH: Getting 3D V field...'
    CALL get_variable(setup_info%input_prefix, v_id, dom_meta%id, &
      setup_info%current_date,status)
    IF (status.EQ.0) THEN
      v3d_in = real_array(:,:,:,1,1)
      num_processed = num_processed + 1
      processed_var_list(num_processed) = v_id
    ELSE
      PRINT *,'Problem getting ', v_id
      STOP 'No_V3D_data'
    ENDIF


	if (elim_lowest) then


	do L=1, LMAX
	 do J=1,dom_meta%ydim
	  do I=1,dom_meta%xdim
             u3d_in(I,J,L)=u3d_in(I,J,L+1)
             v3d_in(I,J,L)=v3d_in(I,J,L+1)

	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
	write(6,*) 'L,p3d_in,u3d_in,v3d_in: ', L,press3d_in(I,J,L), &
                   u3d_in(I,J,L),v3d_in(I,J,L)
	endif

	  enddo
	 enddo
	enddo

	endif

    ALLOCATE (u3d_out(dom_out%xdim,dom_out%ydim,dom_out%zdim))
    ALLOCATE (v3d_out(dom_out%xdim,dom_out%ydim,dom_out%zdim))
	
	do J=1,dom_meta%ydim
	 do I=1,dom_meta%xdim

          DO L=1,dom_out%zdim-1
      pmo(L)=sgml2(L)*pdo(I,J)+sgml1(L)*pdtop+pt
          ENDDO

         IF(J .EQ. 1 .AND. I .LT. dom_meta%xdim)THEN   !SOUTHERN BC
          PDVP=0.5*(PDO(I,J)+PDO(I+1,J))
         ELSEIF(J.EQ.dom_meta%ydim .AND. I.LT.dom_meta%xdim)THEN   !NORTHERN BC
          PDVP=0.5*(PDO(I,J)+PDO(I+1,J))
         ELSEIF(I .EQ. 1 .AND. MOD(J,2) .EQ. 0) THEN   !WESTERN EVEN BC
          PDVP=0.5*(PDO(I,J-1)+PDO(I,J+1))
         ELSEIF(I .EQ. dom_meta%xdim .AND. MOD(J,2) .EQ. 0) THEN  !EASTERN BC
          PDVP=0.5*(PDO(I,J-1)+PDO(I,J+1))
         ELSE IF (MOD(J,2) .LT. 1)THEN
          PDVP=0.25*(PDO(I,J)+PDO(I-1,J)+PDO(I,J+1)+ &
         		PDO(I,J-1))
         ELSE
          PDVP=0.25*(PDO(I,J)+PDO(I+1,J)+PDO(I,J+1)+ &
   		      PDO(I,J-1))
         END IF

!!	PDVP is PD at V points

	pin=0.
	uin=0.

!	swap press3d order
	do L=1, LMAX
	pin(L)=press3d_in(I,J,LMAX-L+1)
!	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
!	write(6,*) 'L, u3d_in(I,J,L): ', L, u3d_in(I,J,L)
!	endif
	uin(L)=u3d_in(I,J,LMAX-L+1)
!	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
!	write(6,*) 'L, uin(L): ', L, uin(L)
!	endif
	vin(L)=v3d_in(I,J,LMAX-L+1)
	enddo


!!	extend at upper bound if needed
      if(pin(1).gt.pmo(dom_out%zdim-1))then
       d1=(pmo(dom_out%zdim-1)-pin(1))/(pin(1)-pin(2))
       uin(1)=uin(1)+d1*(uin(1)-uin(2))
       vin(1)=vin(1)+d1*(vin(1)-vin(2))
       pin(1)=pmo(dom_out%zdim-1)
      end if

	y2=0.

	if(pin(LMAX) .lt. pmo(1)) then
           pin(LMAX+1)=pmo(1)
           uin(LMAX+1)=uin(LMAX)
           vin(LMAX+1)=vin(LMAX)
	   
	CALL SPLINE2(I,J,LMAX+1,pin,uin,y2,dom_out%zdim-1,pmo, &
			u3d_out(I,J,:),dum1,dum2)
	CALL SPLINE2(I,J,LMAX+1,pin,vin,y2,dom_out%zdim-1,pmo, &
			v3d_out(I,J,:),dum1,dum2)

	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
!	write(6,*) 'bonus level for winds'
	do L=1,LMAX+1
!	write(6,*) 'L,pin,uin,vin: ', L, pin(L),uin(L),vin(L)
	enddo

	do L=1,dom_out%zdim-1
	write(6,*) 'LOUT, pmo,uout,vout: ', L,pmo(L),u3d_out(I,J,L),v3d_out(I,J,L)
	enddo

	endif

	else

	CALL SPLINE2(I,J,LMAX,pin,uin,y2,dom_out%zdim-1,pmo, &
			u3d_out(I,J,:),dum1,dum2)
	CALL SPLINE2(I,J,LMAX,pin,vin,y2,dom_out%zdim-1,pmo, &
			v3d_out(I,J,:),dum1,dum2)

	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
!	write(6,*) 'no bonus level for winds'
	do L=1,LMAX
!	write(6,*) 'L,pin,uin,vin: ', L, pin(L),uin(L),vin(L)
	enddo
	do L=1,dom_out%zdim-1
	write(6,*) 'LOUT, pmo,uout,vout: ', L,pmo(L),u3d_out(I,J,L),v3d_out(I,J,L)
	enddo

	endif

	endif

	ENDDO
       ENDDO

	DEALLOCATE (u3d_in,v3d_in,uin,vin)

	L=int(0.8*dom_out%zdim)
!	write(6,*) 'U3d_out, lev 0.8 * nz'
	do J=dom_meta%ydim,1,-dom_meta%ydim/25
!	write(6,633) (u3d_out(I,J,L),  &
!     			I=1,dom_meta%xdim,dom_meta%xdim/12)
	enddo

!	write(6,*) 'V3d_out, lev 0.8 * nz'
	do J=dom_meta%ydim,1,-dom_meta%ydim/25
!	write(6,633) (v3d_out(I,J,L), &
!			I=1,dom_meta%xdim,dom_meta%xdim/12)
	enddo

!	write(6,*) 'mag(obs), knts, level: ', L
	do J=dom_meta%ydim,1,-dom_meta%ydim/25
!	write(6,633) (1.94*((u3d_out(I,J,L)**2.+v3d_out(I,J,L)**2.)**0.5), &
!			I=1,dom_meta%xdim,dom_meta%xdim/12)
	enddo

    ! Diagnose specific humidity from RH/T/P

    ALLOCATE(qv3d_in(dom_out%xdim,dom_out%ydim,LMAX)) 

    DO j = 1, dom_meta%ydim
      DO i = 1, dom_meta%xdim
        DO k = 1, LMAX

       tmp= compute_vapor_mixing_ratio(t3d_in(i,j,k), &
                          press3d_in(i,j,k),rh3d_in(i,j,k),.true.)

	qv3d_in(I,J,K)=tmp/(1.+tmp)

        ENDDO
      ENDDO
    ENDDO

    DEALLOCATE(z3d_in) 
    DEALLOCATE(t3d_in)
    DEALLOCATE(rh3d_in)
    

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	
    ALLOCATE(ALPR(LMAX-1))
    ALLOCATE(ALP(LMAX))
    ALLOCATE (q3d_out(dom_out%xdim,dom_out%ydim,dom_out%zdim)) 

!  Interpolate log(q) with respect to log(p)

	LKO=dom_out%zdim-1

	write(6,*) 'dom_out%zdim: ', dom_out%zdim
	write(6,*) 'set LKO to ', LKO
	write(6,*) 'ALPR defining dimension: ', LMAX-1 

       DO J=1,dom_meta%ydim
       DO I=1,dom_meta%xdim

       DO LD=1,LMAX-1 !LMIN-1
        ALPR(LD)=ALOG(press3d_in(I,J,LD)/press3d_in(I,J,LD+1))
       ENDDO

       DO LD=1,LMAX !LMIN
        ALP(LD)=ALOG(press3d_in(I,J,LD))
       ENDDO

!	integrating from TOA downward...

        DO L=LKO,1,-1
	  ALPOUT=log(pt+sgml1(l)*pdtop+sgml2(l)*pdo(i,j))
	  PMIDO=pt+sgml1(l)*pdtop+sgml2(l)*pdo(i,j)

	q3d_out(I,J,L)=-9999.

	IF (pmido .gt. press3d_in(I,J,1)) THEN  ! extrap downward

	dlnqdlnp= (log(qv3d_in(i,j,1))-log(qv3d_in(i,j,2))) / &
		(log(press3d_in(i,j,1))-log(press3d_in(i,j,2)))

	q3d_out(I,J,L)= exp( &
			log(qv3d_in(i,j,1)) + dlnqdlnp * &
			(log(pmido)-log(press3d_in(i,j,1))) &
			)

	   if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
           write(6,*) 'extrap down Q3DOUT, I,J,L,q3d_out: ',  &
                                I,J,L,q3d_out(I,J,L)
           write(6,*) 'qv3d_in,dlnqdlnp,pmido,press3d_in: ', &
                           qv3d_in(i,j,1),dlnqdlnp,pmido,press3d_in(i,j,1)
	   endif

	   if (q3d_out(I,J,L) .gt. .05 ) then ! 50 g/kg would be extreme, yes?
		write(6,*) 'CRAZY Q3DOUT, I,J,L,q3d_out: ',  &
				I,J,L,q3d_out(I,J,L)	
		write(6,*) 'qv3d_in,dlnqdlnp,pmido,press3d_in: ', &
                           qv3d_in(i,j,1),dlnqdlnp,pmido,press3d_in(i,j,1)
	   endif

	ELSEIF (pmido .lt. press3d_in(I,J,LMAX)) THEN ! extrap up

	   dlnqdlnp= (log(qv3d_in(i,j,LMAX-1))- &
			log(qv3d_in(i,j,LMAX))) / &
		(log(press3d_in(i,j,LMAX-1))- &
			log(press3d_in(i,j,LMAX)))

	   q3d_out(I,J,L)= exp( &
			log(qv3d_in(i,j,LMAX)) + dlnqdlnp * &
			(log(pmido)-log(press3d_in(i,j,LMAX))) &
			)

	   if (q3d_out(I,J,L) .gt. .05 ) then ! 50 g/kg would be extreme, yes?
		write(6,*) 'CRAZY Q3DOUT, I,J,L,q3d_out: ',  &
				I,J,L,q3d_out(I,J,L)	
	   endif


	ELSE ! normal case

	DO LD=LMAX-1,1,-1

	if (pmido .le. press3d_in(I,J,LD) .and.  &
            pmido .ge. press3d_in(I,J,LD+1)) then

	  QLD=qv3d_in(I,J,LD)
!  put in fix for the situation when qv3d_in=0.
        QLD=AMAX1(QLD,1.e-12)  ! to avoid computing log(0.)
	qv3d_in(I,J,LD+1)=amax1(qv3d_in(I,J,LD+1), 1.e-12)

!	is direction here proper?

 	   if (LD+1 .ge. LMAX-1) then

!!! shouldnt be necessary, but trying to use undefined ALPR value
               CF=1
	   else
	       CF=(ALP(LD)-ALPOUT)/ALPR(LD+1)
	   endif

        q3d_out(I,J,L)=EXP(ALOG(QLD)+(ALOG(qv3d_in(I,J,LD+1))-ALOG(QLD))*CF)


	if (I .eq. dom_meta%xdim/2 .and. J .eq. dom_meta%ydim/2) then
	 write(6,*) 'LD, QLD, qv3d_in(LD+1): ', L, QLD,qv3d_in(I,J,LD+1)
	write(6,*) 'CF, q3d_out(I,J,L): ', L, CF, q3d_out(I,J,L)
	endif

	   if (q3d_out(I,J,L) .gt. .05 ) then ! 50 g/kg would be extreme, yes?
		write(6,*) 'CRAZY Q3DOUT, I,J,L,q3d_out: ',  &
				I,J,L,q3d_out(I,J,L)	
		write(6,*) 'qld,qv3d(LD+1), cf: ', &
			QLD,qv3d_in(I,J,LD+1),CF
		write(6,*) 'ALP,ALPOUT,ALPR(LD+1): ', ALP(LD),ALPOUT, &
			ALPR(LD+1)
	   endif
	
	endif  ! check of pressure within range

	ENDDO !LD

	ENDIF

!! Constrain q3d_out
!! q3d_out being used here might be too large, but go with for now

!
! t3d_out above is still virtual temperature.  Convert to sensible
!

	 tmp= 1. + 0.608 * q3d_out(I,J,L)

	if (tmp .gt. 1.03) then
	write(6,*) 'big adjust... ', tmp
	write(6,*) 'I,J,L, q3d_out(I,J,L): ', I,J,L, q3d_out(I,J,L)
	endif

 	 t3d_out(I,J,L)=t3d_out(I,J,L)/ tmp


         CLOGES=-CM1/t3d_out(I,J,L)-CM2*ALOG10(t3d_out(I,J,L))+CM3
         ESE=10.**(CLOGES+2.)
         QSX=EPS*ESE/(PMIDO-ESE*(1.-EPS))
         QSMX=0.98*QSX

	QTMP=q3d_out(i,j,l)
         q3d_out(I,J,L)=AMIN1(QTMP,QSMX)

         if (QTMP.gt.QSMX.and.mod(I,10).eq.0.and.mod(J,10).eq.0 ) then
!           write(6,*) 'I,J,L: ',I,J,L, 'reducing Q from ',QTMP, 'to : ',QSMX
         endif

	if (t3d_out(i,j,l) .gt. 50 .and. t3d_out(i,j,l) .lt. 400) then
	else
	write(6,*) 'corrupted t3d_out, post conv!!!! ', i,j,l,t3d_out(i,j,l)
	write(6,*) 'tmp, q3d_out: ', tmp, q3d_out(i,j,l)
	endif
	
	ENDDO !L
	ENDDO !I & J
	ENDDO

!	write(6,*) 'check t3d_out(sensible), level 4'
	do J=dom_meta%ydim,1,-dom_meta%ydim/20
!	write(6,634) (t3d_out(I,J,4),I=1,dom_meta%xdim,dom_meta%xdim/10)
	enddo

	do L=dom_out%zdim-1,1,-1
	write(6,*) 'L, t3d_out: ', L,  t3d_out(dom_meta%xdim/2,dom_meta%ydim/2,L)
	enddo

    ! At this point, we can free up some memory that is no longer needed
    DEALLOCATE(press3d_in)
    DEALLOCATE(ALPR,ALP,qv3d_in)


	CALL output_all_nmm(t3d_out,q3d_out,u3d_out,v3d_out,pdo,&
           dsg,output_levels(:,zstag_half_index), &
           output_levels(:,zstag_full_index),dfl,dsg1,sgml1,sg1, &
           dsg2,sgml2,sg2,pdtop,pt)

	deallocate(t3d_out,q3d_out,u3d_out,v3d_out,pdo)
	deallocate(dsg,dsg1,dsg2,sg1,sg2,sgml1,sgml2)
	deallocate(pmo,pio,pin,rhin,zin,y2,dum1,dum2,dum2d,dfl)


    RETURN
  END SUBROUTINE interp_state_nmmhyb
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  SUBROUTINE shift_sfc_slab(data3d)
    IMPLICIT NONE
    REAL, INTENT(INOUT)          :: data3d(:,:,:)

    REAL                         :: sfcval
    INTEGER                      :: i,j

    DO j = 1 , dom_meta%ydim
      DO i = 1 , dom_meta%xdim
        IF (sfc_k_ind(i,j) .GT. 1) THEN
          sfcval = data3d(i,j,1)
          data3d(i,j,1:sfc_k_ind(i,j)-1) = data3d(i,j,2:sfc_k_ind(i,j)) 
          data3d(i,j,sfc_k_ind(i,j)) = sfcval
        ENDIF
      ENDDO
    ENDDO 
    RETURN
  END SUBROUTINE shift_sfc_slab
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  SUBROUTINE process_others
  ! This routine scans the file looking for any variables that have not been
  ! processed yet.  It looks at the dimensions, etc. to determine if the
  ! variable needs to be vertically interpolated and/or destaggered into
  ! multiple output fields.  If not, it just passes them on, metadata included
  ! into the new output file.

    IMPLICIT NONE
    INTEGER :: v,s,k
    REAL, ALLOCATABLE        :: dum3d_in(:,:,:),dum3d(:,:,:),dum3ds(:,:,:)
    REAL, ALLOCATABLE        :: dum2d(:,:),dum2ds(:,:)
    CHARACTER (LEN=1) :: stag_string
    LOGICAL :: processed

    !  First, reset the file pointer to the beginning of the input file by
    ! calling get_domain_metadata.  The API should have something like
    ! get_first_variable to eventually replace this kludge method.

    CALL get_domain_metadata(dom_meta%id, setup_info%current_date, &
          setup_info%input_prefix)

    IF(.not.Dryrun)PRINT *, 'Here is what we have processed so far: '
    dumplist: DO k = 1, 200
       IF(.not.Dryrun)PRINT *, processed_var_list(k)
       IF (processed_var_list(k) .EQ. '        ') EXIT dumplist
    ENDDO dumplist
    ! Now, we can loop through calling read_next_variable and using the
    ! status to determine if we have reached the end of the file (module_wrf_io
    ! sets the status=2 when EOF is reached)                    

    status = 0
    CALL read_next_variable
    filescan_loop: DO WHILE (status .EQ. 0)

      ! Compare the variable name with those in the processed_var list
      processed = .false.
      check_var_loop: DO v = 1,num_processed
        IF (var_info%name .EQ. processed_var_list(v))THEN
          processed = .true.
          EXIT check_var_loop
        ENDIF
      ENDDO check_var_loop
      IF (processed) THEN
        CALL read_next_variable
        CYCLE filescan_loop
      ENDIF
      IF(.not.Dryrun)PRINT '(2A)', 'Other Variable: ', var_info%name
      ! We have a variable that has not been processed, so figure out
      ! what we need to do with it.

      IF ((var_info%ndim .EQ. 3).AND.(var_info%array_order.EQ.'+X+Y+Z  '))THEN

	write(6,*) 'PROCESS_OTHERS...DONT WANT TO BE HERE'
	write(6,*) 'var_info%name: ', var_info%name

!!	SOIL FIELD??

      ELSE IF ((var_info%ndim .EQ. 3).AND. &
               (var_info%array_order .EQ. '+X+Y+S  '))THEN

	write(6,*) 'soil field'

        ! Staggered 2D variable
        stag_output_loop: DO s=1,var_info%dim_val(3)
          var_meta_out = var_info

          ! Replace the last character of the variable name with stagger index

          WRITE (stag_string, '(I1)') s
          var_meta_out%name(8:8) = stag_string
          var_meta_out%description = TRIM(var_meta_out%description) // &
              ' on stagger number ' // stag_string
          var_meta_out%ndim = 2
          var_meta_out%dim_val(3) = 0
          var_meta_out%stop_index(3) = 0
          var_meta_out%h_stagger_index = s
          var_meta_out%array_order = '+X+Y    '
          var_meta_out%dim_desc(3) = '    '
          call write_field ( var_info%name, real_array(:,:,s,1,1), var_meta_out)
        ENDDO stag_output_loop
      ELSE IF ( var_info%ndim .EQ. 2) THEN                             
        ALLOCATE(dum2d(dom_out%xdim,dom_out%ydim))
        dum2d = real_array(:,:,1,1,1)
        ! Pass this variable right on through
        var_meta_out = var_info
        
        ! If this variable is background landusec or soilctop, 
        ! we need to set the flags to let our static processor
        ! know we already have it
        IF (var_info%name(1:6) .EQ. 'VEGCAT') have_bg_landusec = .true.
        IF (var_info%name(1:7) .EQ. 'SOILCAT') have_bg_soilctop = .true.


!
        IF ((var_meta_out%h_stagger_index .EQ. n_ind).AND. &
            (setup_info%output_vars .LE. 2) ) THEN
!
        ENDIF
        call write_field ( var_info%name, dum2d , var_meta_out)
        DEALLOCATE(dum2d)                                  
      ELSE IF ( var_info%ndim .EQ. 1) THEN

        ! Pass this variable right on through
        var_meta_out = var_info
        call write_field ( var_info%name, real_array(:,1,1,1,1), var_meta_out)

      ELSE IF (var_info%ndim .EQ. 0) THEN

         ! Pass this variable right on through
         var_meta_out = var_info
         call write_field ( var_info%name, real_array(1,1,1,1,1), var_meta_out)

      ELSE

         IF(.not.Dryrun)PRINT '(A)', 'Unsure how to process this variable...omitting from output:'
         IF(.not.Dryrun)PRINT '(3A,I1,2A)', 'NAME: ', var_info%name, ' NDIM: ', var_info%ndim,&
              ' ARRAY ORDER: ', var_info%array_order
      ENDIF

      CALL read_next_variable
    ENDDO  filescan_loop
    IF(.not.Dryrun)PRINT '(A)', 'NMMH_PROCESS_OTHERS: Reached end of file.'
    RETURN                                                                    
  END SUBROUTINE process_others
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  SUBROUTINE output_all_nmm(to,qo,uo,vo,pdo, &
       dsg,sgml,sg,dfl,dsg1,sgml1,sg1,dsg2,sgml2,sg2,pdtop,pt)

    IMPLICIT NONE
	INTEGER ITMP
    REAL, INTENT(INOUT)                 :: to(:,:,:)
    REAL, INTENT(INOUT)                  :: qo(:,:,:)
    REAL, INTENT(INOUT)                 :: uo(:,:,:)
    REAL, INTENT(INOUT)                  :: vo(:,:,:)
    REAL, INTENT(INOUT)                  :: pdo(:,:), pdtop,pt
    
!    REAL, DIMENSION(:), INTENT(INOUT) :: dsg,sgml,sg,dfl,dsg1, &
!                                         sgml1,sg1,dsg2,sgml2,sg2
    REAL, DIMENSION(:), INTENT(IN) :: dsg,sgml,sg,dfl,dsg1, &
                                         sgml1,sg1,dsg2,sgml2,sg2

	REAL, ALLOCATABLE:: OUT_FULL(:)


	ALLOCATE (OUT_FULL(dom_out%zdim))

	write(6,*) 'enter output_all_nmm'

	do ITMP=1,dom_out%zdim
	write(6,*) 'Z,T(Z),DFL(Z): ', ITMP, &
             TO(dom_meta%xdim/2,dom_meta%ydim/2,ITMP),DFL(ITMP)
	enddo

    ! Output T
    var_meta_out%name = t_id
    var_meta_out%units = 'K  '
    var_meta_out%description = 'Temperature                    '
    var_meta_out%domain_id = dom_meta%id
    var_meta_out%ndim=3
    var_meta_out%dim_val(1) = dom_meta%xdim
    var_meta_out%dim_val(2) = dom_meta%ydim
    var_meta_out%dim_val(3) = dom_out%zdim
    var_meta_out%dim_val(4:var_maxdims) = 1
    var_meta_out%dim_desc(1) = 'E-W'
    var_meta_out%dim_desc(2) = 'N-S'
    var_meta_out%dim_desc(3) = 'VERT'
    var_meta_out%dim_desc(4:var_maxdims) = '    '
    var_meta_out%start_index(1) = 1
    var_meta_out%start_index(2) = 1
    var_meta_out%start_index(3) = 1
    var_meta_out%start_index(4:var_maxdims) = 0
    var_meta_out%stop_index(1) = dom_meta%xdim
    var_meta_out%stop_index(2) = dom_meta%ydim
!!????    var_meta_out%stop_index(3) = dom_meta%zdim
    var_meta_out%stop_index(3) = dom_out%zdim
    var_meta_out%stop_index(4:var_maxdims) = 0
    var_meta_out%h_stagger_index = w_ind
    var_meta_out%v_stagger_index =  zstag_half_index 
    var_meta_out%array_order = '+X+Y+Z'
    var_meta_out%field_type = 'REAL'
    var_meta_out%field_source_prog = 'SI'
    var_meta_out%source_desc = 'Vertical derivation by SI'
    var_meta_out%field_time_type = 'INSTANT'
    var_meta_out%vt_date_start = dom_meta%vt_date
    var_meta_out%vt_time_start = dom_meta%vt_time
    var_meta_out%vt_date_stop = dom_meta%vt_date
    var_meta_out%vt_time_stop = dom_meta%vt_time
    call write_field ( var_meta_out%name, to,var_meta_out,'z                ')

    ! Output q (spec hum)
    var_meta_out%name = spechum_id
    var_meta_out%units = 'kg kg{-1}'
    var_meta_out%description = 'specific humidity             '
    var_meta_out%domain_id = dom_meta%id
    var_meta_out%ndim=3
    var_meta_out%dim_val(1) = dom_meta%xdim
    var_meta_out%dim_val(2) = dom_meta%ydim
    var_meta_out%dim_val(3) = dom_out%zdim
    var_meta_out%dim_val(4:var_maxdims) = 1
    var_meta_out%dim_desc(1) = 'E-W'
    var_meta_out%dim_desc(2) = 'N-S'
    var_meta_out%dim_desc(3) = 'VERT'
    var_meta_out%dim_desc(4:var_maxdims) = '    '
    var_meta_out%start_index(1) = 1
    var_meta_out%start_index(2) = 1
    var_meta_out%start_index(3) = 1
    var_meta_out%start_index(4:var_maxdims) = 0
    var_meta_out%stop_index(1) = dom_meta%xdim
    var_meta_out%stop_index(2) = dom_meta%ydim
    var_meta_out%stop_index(3) = dom_out%zdim
    var_meta_out%stop_index(4:var_maxdims) = 0
    var_meta_out%h_stagger_index = w_ind
    var_meta_out%v_stagger_index = zstag_half_index
    var_meta_out%array_order = '+X+Y+Z'
    var_meta_out%field_type = 'REAL'
    var_meta_out%field_source_prog = 'SI'
    var_meta_out%source_desc = 'Vertical interpolation by SI'
    var_meta_out%field_time_type = 'INSTANT'
    var_meta_out%vt_date_start = dom_meta%vt_date
    var_meta_out%vt_time_start = dom_meta%vt_time
    var_meta_out%vt_date_stop = dom_meta%vt_date
    var_meta_out%vt_time_stop = dom_meta%vt_time
    call write_field ( var_meta_out%name, qo, var_meta_out, 'z                ' )

    ! Output u3d   
    var_meta_out%name = u_id
    var_meta_out%units = 'm s{-1}'
    var_meta_out%description = 'Grid-relative u-component of wind    '
    var_meta_out%domain_id = dom_meta%id
    var_meta_out%ndim=3
    var_meta_out%dim_val(1) = dom_meta%xdim
    var_meta_out%dim_val(2) = dom_meta%ydim
    var_meta_out%dim_val(3) = dom_out%zdim  !??
    var_meta_out%dim_val(4:var_maxdims) = 1
    var_meta_out%dim_desc(1) = 'E-W'
    var_meta_out%dim_desc(2) = 'N-S'
    var_meta_out%dim_desc(3) = 'VERT'
    var_meta_out%dim_desc(4:var_maxdims) = '    '
    var_meta_out%start_index(1) = 1
    var_meta_out%start_index(2) = 1
    var_meta_out%start_index(3) = 1
    var_meta_out%start_index(4:var_maxdims) = 0
    var_meta_out%stop_index(1) = dom_meta%xdim
    var_meta_out%stop_index(2) = dom_meta%ydim
    var_meta_out%stop_index(3) = dom_out%zdim !??
    var_meta_out%stop_index(4:var_maxdims) = 0
    var_meta_out%h_stagger_index = w_ind
    var_meta_out%v_stagger_index = zstag_half_index
    var_meta_out%array_order = '+X+Y+Z'
    var_meta_out%field_type = 'REAL'
    var_meta_out%field_source_prog = 'SI'
    var_meta_out%source_desc = 'Vertical interpolation by SI'
    var_meta_out%field_time_type = 'INSTANT'
    var_meta_out%vt_date_start = dom_meta%vt_date
    var_meta_out%vt_time_start = dom_meta%vt_time
    var_meta_out%vt_date_stop = dom_meta%vt_date
    var_meta_out%vt_time_stop = dom_meta%vt_time
    call write_field ( var_meta_out%name, uo, var_meta_out, 'z                ' )

    ! Output v3d
    var_meta_out%name = v_id
    var_meta_out%units = 'm s{-1}'
    var_meta_out%description = 'Grid-relative v-component of wind    '
    var_meta_out%domain_id = dom_meta%id
    var_meta_out%ndim=3
    var_meta_out%dim_val(1) = dom_meta%xdim
    var_meta_out%dim_val(2) = dom_meta%ydim
    var_meta_out%dim_val(3) = dom_out%zdim
    var_meta_out%dim_val(4:var_maxdims) = 1
    var_meta_out%dim_desc(1) = 'E-W'
    var_meta_out%dim_desc(2) = 'N-S'
    var_meta_out%dim_desc(3) = 'VERT'
    var_meta_out%dim_desc(4:var_maxdims) = '    '
    var_meta_out%start_index(1) = 1
    var_meta_out%start_index(2) = 1
    var_meta_out%start_index(3) = 1
    var_meta_out%start_index(4:var_maxdims) = 0
    var_meta_out%stop_index(1) = dom_meta%xdim
    var_meta_out%stop_index(2) = dom_meta%ydim
    var_meta_out%stop_index(3) = dom_out%zdim
    var_meta_out%stop_index(4:var_maxdims) = 0
    var_meta_out%h_stagger_index = w_ind
    var_meta_out%v_stagger_index = zstag_half_index
    var_meta_out%array_order = '+X+Y+Z'
    var_meta_out%field_type = 'REAL'
    var_meta_out%field_source_prog = 'SI'
    var_meta_out%source_desc = 'Vertical interpolation by SI'
    var_meta_out%field_time_type = 'INSTANT'
    var_meta_out%vt_date_start = dom_meta%vt_date
    var_meta_out%vt_time_start = dom_meta%vt_time
    var_meta_out%vt_date_stop = dom_meta%vt_date
    var_meta_out%vt_time_stop = dom_meta%vt_time
    call write_field ( var_meta_out%name,vo, var_meta_out, 'z                ' )

    ! Output pd
    var_meta_out%name = 'PD      '
    var_meta_out%units = 'hPa  '
    var_meta_out%description = 'Pressure-depth (sigma part) '
    var_meta_out%domain_id = dom_meta%id
    var_meta_out%ndim=2
    var_meta_out%dim_val(1) = dom_meta%xdim
    var_meta_out%dim_val(2) = dom_meta%ydim
    var_meta_out%dim_val(3:var_maxdims) = 1
    var_meta_out%dim_desc(1) = 'E-W'
    var_meta_out%dim_desc(2) = 'N-S'
    var_meta_out%dim_desc(3:var_maxdims) = '    '
    var_meta_out%start_index(1) = 1
    var_meta_out%start_index(2) = 1
    var_meta_out%start_index(3:var_maxdims) = 0
    var_meta_out%stop_index(1) = dom_meta%xdim
    var_meta_out%stop_index(2) = dom_meta%ydim
    var_meta_out%stop_index(3:var_maxdims) = 0
    var_meta_out%h_stagger_index = w_ind
    var_meta_out%array_order = '+X+Y'
    var_meta_out%field_type = 'REAL'
    var_meta_out%field_source_prog = 'SI'
    var_meta_out%source_desc = 'Vertical interpolation by SI'
    var_meta_out%field_time_type = 'INSTANT'
    var_meta_out%vt_date_start = dom_meta%vt_date
    var_meta_out%vt_time_start = dom_meta%vt_time
    var_meta_out%vt_date_stop = dom_meta%vt_date
    var_meta_out%vt_time_stop = dom_meta%vt_time
    call write_field ( var_meta_out%name,pdo,var_meta_out )


!! 1d fields (default)

  var_meta_out%domain_id = dom_meta%id
  var_meta_out%ndim = 1

  var_meta_out%dim_val(1) = dom_out%zdim
  var_meta_out%dim_val(2:var_maxdims) = 0

  var_meta_out%dim_desc(1) = 'VERT'
  var_meta_out%dim_desc(2:var_maxdims) = '    '

  var_meta_out%start_index(1)   = 1
  var_meta_out%start_index(2:var_maxdims) = 0

  var_meta_out%stop_index(1) = dom_out%zdim
  var_meta_out%stop_index(2:var_maxdims) = 0

  var_meta_out%h_stagger_index = 0


!	be careful to specify vert stagger for each field
  var_meta_out%v_stagger_index = zstag_full_index
  var_meta_out%array_order = '+Z      '
  var_meta_out%field_type  = 'REAL'
  var_meta_out%field_source_prog = 'SI      '
  var_meta_out%source_desc = 'User defined levels generated by WRFSI/vinterp'
  var_meta_out%field_time_type = 'CONSTANT'
  var_meta_out%vt_date_start = dom_meta%vt_date
  var_meta_out%vt_date_stop = dom_meta%vt_date
  var_meta_out%vt_time_start = dom_meta%vt_time
  var_meta_out%vt_time_stop = dom_meta%vt_time

	write(6,*) 'writing out 1d fields'

    var_meta_out%name = dsg_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Delta-sigma layer thicknesses        '
     var_meta_out%v_stagger_index = zstag_half_index
	write(6,*) 'want to write DSG'
   var_meta_out%stop_index(1) = dom_out%zdim
!	write(6,*) 'var_meta_out= ', var_meta_out

	call swap_vert(dsg,dom_out%zdim-1,out_full)
    call write_field ( var_meta_out%name,out_full,var_meta_out)

	write(6,*) 'past write_field for dsg'
    num_processed = num_processed + 1
    processed_var_list(num_processed) = dsg_id 

	write(6,*) ' '

    var_meta_out%name = sgml_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Sigma values at middle of vert layer '
    var_meta_out%v_stagger_index = zstag_half_index
  var_meta_out%stop_index(1) = dom_out%zdim-1
	write(6,*) 'want to write SGML'
!	write(6,*) 'var_meta_out= ', var_meta_out

	call swap_vert(SGML,dom_out%zdim-1,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

	write(6,*) 'past write_field for sgml'
    num_processed = num_processed + 1
    processed_var_list(num_processed) = sgml_id 

	write(6,*) ' '

    var_meta_out%name = sg_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Sigma values at layer inferfaces     '
    var_meta_out%v_stagger_index = zstag_full_index
  var_meta_out%stop_index(1) = dom_out%zdim
	write(6,*) 'call write_field for SG'

	call swap_vert(SG,dom_out%zdim,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

	write(6,*) 'past write_field for SG'
    num_processed = num_processed + 1
    processed_var_list(num_processed) = sg_id 

	write(6,*) ' '

    var_meta_out%name = dfl_id
    var_meta_out%units = 'm{2} s{-2}   '
    var_meta_out%description = 'Reference interface geopotential     '
    var_meta_out%v_stagger_index = zstag_full_index
	write(6,*) 'call write_field for DFL'
	
	call swap_vert(DFL,dom_out%zdim,out_full)

	write(6,*) 'DFL now: ',out_full
    call write_field ( var_meta_out%name,out_full, var_meta_out)

	write(6,*) 'past write_field for DFL'
    num_processed = num_processed + 1
    processed_var_list(num_processed) = dfl_id 

	write(6,*) ' '

    var_meta_out%name = dsg1_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Layer thicknesses, pressure zone     '
!0801  var_meta_out%stop_index(1) = dom_out%zdim
  var_meta_out%stop_index(1) = dom_out%zdim-1
    var_meta_out%v_stagger_index = zstag_half_index
!0801    var_meta_out%v_stagger_index = zstag_full_index
	write(6,*) 'call write_field for DSG1'
	write(6,*) 'dsg1_id= ', dsg1_id

	call swap_vert(DSG1,dom_out%zdim-1,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

	write(6,*) 'past write_field for DSG1'
    num_processed = num_processed + 1
    processed_var_list(num_processed) = dsg1_id 


    var_meta_out%name = sgml1_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Mid-layer sig vals, pressure zone    '
    var_meta_out%v_stagger_index = zstag_half_index
  var_meta_out%stop_index(1) = dom_out%zdim-1

	call swap_vert(SGML1,dom_out%zdim-1,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

    num_processed = num_processed + 1
    processed_var_list(num_processed) = sgml1_id 

    var_meta_out%name = sg1_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Interface sig vals, pressure zone    '
  var_meta_out%stop_index(1) = dom_out%zdim
    var_meta_out%v_stagger_index = zstag_full_index

	call swap_vert(SG1,dom_out%zdim,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

    num_processed = num_processed + 1
    processed_var_list(num_processed) = sg1_id 

    var_meta_out%name = dsg2_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Layer thicknesses, sigma zone        '
    var_meta_out%v_stagger_index = zstag_half_index
  var_meta_out%stop_index(1) = dom_out%zdim-1

	call swap_vert(DSG2,dom_out%zdim-1,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

    num_processed = num_processed + 1
    processed_var_list(num_processed) = dsg2_id 

    var_meta_out%name = sgml2_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Mid-layer sig vals, sigma zone       '
    var_meta_out%v_stagger_index = zstag_half_index
  var_meta_out%stop_index(1) = dom_out%zdim-1

	call swap_vert(SGML2,dom_out%zdim-1,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

    num_processed = num_processed + 1
    processed_var_list(num_processed) = sgml2_id 

    var_meta_out%name = sg2_id
    var_meta_out%units = 'Dimensionless   '
    var_meta_out%description = 'Interface sig vals, sigma zone       '
    var_meta_out%v_stagger_index = zstag_full_index
    var_meta_out%stop_index(1) = dom_out%zdim

	call swap_vert(SG2,dom_out%zdim,out_full)
    call write_field ( var_meta_out%name,out_full, var_meta_out)

    num_processed = num_processed + 1
    processed_var_list(num_processed) = sg2_id 

    var_meta_out%name = 'PDTOP   '
    var_meta_out%units = 'hPa   '
    var_meta_out%description = 'Pressure depth of isobaric portion '
    var_meta_out%v_stagger_index = 0
    var_meta_out%stop_index(1) = 1
    call write_field ( var_meta_out%name,PDTOP, var_meta_out)
    num_processed = num_processed + 1
    processed_var_list(num_processed) = var_meta_out%name

    var_meta_out%name = 'PT    '
    var_meta_out%units = 'hPa   '
    var_meta_out%description = 'model top pressure  '
    var_meta_out%v_stagger_index = 0
    var_meta_out%stop_index(1) = 1
    call write_field ( var_meta_out%name,PT, var_meta_out)
    num_processed = num_processed + 1
    processed_var_list(num_processed) = var_meta_out%name

	DEALLOCATE(OUT_FULL)



    RETURN
  END SUBROUTINE output_all_nmm

!-----------------------------------------

   SUBROUTINE swap_vert(arrayin,zdim,arrayout)

   INTEGER:: K,ZDIM
   REAL:: arrayin(zdim),t_hold(zdim),arrayout(zdim)

   do K=1,zdim
   t_hold(K)=arrayin(zdim-K+1)
   enddo

   do K=1,zdim
   ARRAYOUT(K)=T_HOLD(K)
   enddo

   END SUBROUTINE swap_vert

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   SUBROUTINE SPLINE2(i,j,nold,xold,yold,y2,nnew,xnew,ynew,p,q)
!
!     ******************************************************************
!     *                                                                *
!     *  this is a one-dimensional cubic spline fitting routine        *
!     *  programed for a small scalar machine.                         *
!     *                                                                *
!     *  programer: z. janjic                                          *
!     *                                                                *
!     *  nold - number of given values of the function.  Must be ge 3. *
!     *  xold - locations of the points at which the values of the     *
!     *         function are given.  Must be in ascending order.       *
!     *  yold - the given values of the function at the points xold.   *
!     *  y2   - the second derivatives at the points xold.  If natural *
!     *         spline is fitted y2(1)=0. And y2(nold)=0. Must be      *
!     *         specified.                                             *
!     *  nnew - number of values of the function to be calculated.     *
!     *  xnew - locations of the points at which the values of the     *
!     *         function are calculated.  Xnew(k) must be ge xold(1)   *
!     *         and le xold(nold).                                     *
!     *  ynew - the values of the function to be calculated.           *
!     *  p, q - auxiliary vectors of the length nold-2.                *
!     *                                                                *
!     ******************************************************************
!
    INTEGER:: nold,noldm1,nnew,i,j,ii,jj,k,k2,kold,k1,l
     REAL::  xold(nold),yold(nold),y2(nold),p(nold),q(nold)
     REAL::  xnew(nnew),ynew(nnew)
     REAL:: dxl,dxr,dydxl,dydxr,rtdxc,y2k,y2kp1,dxc
     REAL:: dx,rdx,ak,bk,ck,x,xsq,xk, den

      ii=213
      jj=472
!
!mp      if(nnew.eq.1)then
       if(i.eq.ii.and.j.eq.jj)then
        print*,'DEBUG in SPLINE2:HSO= ',xnew
        do l=1,nold
         print*,'DEBUG in SPLINE2:L,ZETAI,PINTI= ' &
       			,L,yold(L),xold(L)
        end do
       end if
!mp      end if
      noldm1=nold-1
!
      dxl=xold(2)-xold(1)
      dxr=xold(3)-xold(2)
      dydxl=(yold(2)-yold(1))/dxl
      dydxr=(yold(3)-yold(2))/dxr
      rtdxc=.5/(dxl+dxr)
!
      p(1)= rtdxc*(6.*(dydxr-dydxl)-dxl*y2(1))
      q(1)=-rtdxc*dxr
!
      if(nold.eq.3) go to 700
!-----------------------------------------------------------------------
      k=3
!
 100  dxl=dxr
      dydxl=dydxr
      dxr=xold(k+1)-xold(k)
      dydxr=(yold(k+1)-yold(k))/dxr
      dxc=dxl+dxr
      den=1./(dxl*q(k-2)+dxc+dxc)
!
      p(k-1)= den*(6.*(dydxr-dydxl)-dxl*p(k-2))
      q(k-1)=-den*dxr
!
      k=k+1
      if(k.lt.nold) go to 100
!----------------------------------------------------------- 
 700  k=noldm1
!
 200  y2(k)=p(k-1)+q(k-1)*y2(k+1)
!
      k=k-1
      if(k.gt.1) go to 200
!-----------------------------------------------------------------------
      k1=1
!
 300  xk=xnew(k1)
!
      do 400 k2=2,nold
      if(xold(k2).le.xk) go to 400
      kold=k2-1
      go to 450
 400  continue
      ynew(k1)=yold(nold)
      go to 600
!
 450  if(k1.eq.1)   go to 500
      if(k.eq.kold) go to 550
!
 500  k=kold
!
      y2k=y2(k)
      y2kp1=y2(k+1)
      dx=xold(k+1)-xold(k)
      rdx=1./dx
!
      ak=.1666667*rdx*(y2kp1-y2k)
      bk=.5*y2k
      ck=rdx*(yold(k+1)-yold(k))-.1666667*dx*(y2kp1+y2k+y2k)
!
 550  x=xk-xold(k)
      xsq=x*x
!
      ynew(k1)=ak*xsq*x+bk*xsq+ck*x+yold(k)

       if(i.eq.ii.and.j.eq.jj)then
	write(6,*) 'DEBUG:: k1,xnew(k1),ynew(k1): ', k1,xnew(k1),ynew(k1)
	endif
!
 600  k1=k1+1
     if(k1.le.nnew) go to 300

	END SUBROUTINE SPLINE2

END MODULE vinterp_nmmhyb
