!dis
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis
!dis                                   
MODULE vinterp_setup
   USE date_pack
   USE vinterp_domain
   USE wrfsi_maxdims
   USE wrfsi_nl
   CHARACTER(LEN=200) :: moad_dataroot
!   CHARACTER(LEN=200) :: installroot
   LOGICAL  :: have_bg_landusec
   LOGICAL  :: have_bg_soilctop
   INTEGER,ALLOCATABLE  :: domain_list(:)
   INTEGER :: num_domains_to_proc
   TYPE r1
      CHARACTER (LEN=19) :: starting_date
      CHARACTER (LEN=19) :: ending_date
      INTEGER :: time_increment_second
      INTEGER :: yyyy_st  , mm_st  , dd_st  , hh_st  , min_st  , sec_st
      INTEGER :: yyyy_end , mm_end , dd_end , hh_end , min_end , sec_end
      INTEGER :: yyyy_now , mm_now , dd_now , hh_now , min_now , sec_now
      INTEGER :: total_times
      CHARACTER (LEN=19) :: current_date
      INTEGER :: starting_date_int , current_date_int , time_period_count
      INTEGER :: wrf_start_date, wrf_stop_date,wrf_current_date
      REAL    :: wrf_start_time, wrf_stop_time,wrf_current_time
      CHARACTER (LEN=255) :: input_prefix
      CHARACTER (LEN=255) :: output_prefix
      CHARACTER (LEN=255) :: wrf_output_prefix
      REAL                :: max_top
      LOGICAL		  :: vstagger_output
      LOGICAL             :: verbose
      INTEGER             :: output_vars
      CHARACTER(LEN=4)    :: output_file_type
      LOGICAL		  :: rh_wrt_liquid
!mp
      LOGICAL             :: nmmcore
!mp
   END TYPE r1
  
   TYPE (r1) :: setup_info
  
 CONTAINS

 SUBROUTINE proc_namelist
    
   IMPLICIT NONE   

   INTEGER                :: start_year       , &
                             start_month      , &
                             start_day        , &
                             start_hour       , &
                             start_minute = 0 , &
                             start_second = 0
   INTEGER                :: end_year         , &
                             end_month        , &
                             end_day          , &
                             end_hour         , &
                             end_minute   = 0 , &
                             end_second   = 0
   INTEGER                :: interval
   INTEGER                :: current_date_wrf
   REAL                   :: current_time_wrf
   INTEGER                           :: nlevels,num_levels
   REAL, ALLOCATABLE                 :: levels_half(:)
   
   CHARACTER(LEN=250) :: file_name_namelist

   NAMELIST / filetimespec / start_year   , start_month  , start_day    , &
                        start_hour   , start_minute , start_second , &
                        end_year     , end_month    , end_day      , &
                        end_hour     , end_minute   , end_second   , &
                        interval

   INTEGER              :: cy1,mm1,dd1,hh1,mi1,ss1
   INTEGER              :: cy2,mm2,dd2,hh2,mi2,ss2
   CHARACTER (LEN=19)   :: current_date , next_date
   INTEGER              :: k, namelist_file, file_index, open_status
   REAL                 :: delta_z_old, delta_z_new
   LOGICAL              :: already_opened
   CHARACTER (LEN=2)    :: suffix


   suffix = 'xx'
   !  Find a spare UNIT number for the NAMELIST file.

   ! Build the namelist file name

   CALL GETENV('MOAD_DATAROOT', moad_dataroot)
!mp
!   CALL GETENV('INSTALLROOT', installroot)

	write(6,*) 'extracted moad_dataroot= ', moad_dataroot

!	write(6,*) 'extracted installroot= ', installroot
!mp
   file_name_namelist = TRIM(moad_dataroot) // '/static/wrfsi.nl'
   namelist_file = -1
   namelist_unit : DO file_index = 10 , 99
      INQUIRE (UNIT=file_index, OPENED=already_opened)
      IF ( .NOT. already_opened) THEN
         namelist_file = file_index
         EXIT namelist_unit
      END IF
   END DO namelist_unit   
   
   IF ( namelist_file .EQ. -1 ) THEN
      PRINT '(A)','Could not find a spare unit for the NAMELIST data.'
      STOP 'namelist_file_unit'
   END IF

   PRINT '(A)','Trying to open file: wrfsi.nl'
   !  OPEN the NAMELIST file with the given name and UNIT.

   OPEN ( UNIT=namelist_file , &
          FILE=TRIM(file_name_namelist) , &
          STATUS = 'OLD' , &
          FORM = 'FORMATTED' , &
          IOSTAT = open_status )
   
   IF ( open_status .NE. 0 ) THEN
      PRINT '(A)' , 'Error opening NAMELIST file.',open_status

      STOP 'namelist_file_open'
   END IF


   !  Read each record from the NAMELIST file.
   REWIND (namelist_file)
   READ ( UNIT = namelist_file , NML = filetimespec )
   CLOSE (UNIT=namelist_file)
   CALL read_interp_nl(moad_dataroot)
  
   ! Total number of domains is always one more than
   ! the number of active domains...we always process
   ! the MOAD.
   num_domains_to_proc = 1 + num_active_subnests
   ALLOCATE(domain_list(num_domains_to_proc))
   domain_list(1) = 1  ! Always do MOAD first...no user spec required
   IF (num_domains_to_proc .GT. 1) THEN
     domain_list(2:num_domains_to_proc) = active_subnests(1:num_active_subnests)
   ENDIF
   PRINT '(A)','Successfully READ the NAMELIST file.'  
   ! Set up the vertical coordinate

!TBDbls: Need to make sure vertical_coord is always uppercase!

!mp
	setup_info%nmmcore=.FALSE.
!mp

   IF (output_coord .EQ.'ZETA    ') THEN
     suffix = 'eh'
     PRINT '(A)', 'Using specified level values.  Checking...'
     nlevels = 0
     level_check_loop1: DO k = 1, max_vertical_levels
       ! See if this is a valid level, if so increment nlevels
       ! and perform additional QC checks
       IF (levels(k) .GE. 0.) THEN
         nlevels = nlevels+1
         ! Check for increasing value of ZETA (after 2nd value found)
         IF (nlevels .GT. 1) THEN  
           IF (levels(k) .LE. levels(k-1)) THEN
             PRINT '(A,I2,A,I2)', 'Level ',k, 'is <= level ' , k-1
             PRINT '(A)', 'Zeta must must be listed in ascending order!'
             STOP 'bad_level_specified'
           ENDIF
         ENDIF
       ELSE
         IF (nlevels .LT. 1) THEN
           PRINT'(A)', 'No specified levels found!. '
           STOP 'no_levels'
         ELSE 
           num_levels = nlevels
           exit level_check_loop1
         ENDIF
       ENDIF
     ENDDO level_check_loop1
   ELSE IF (output_coord .EQ. 'ETAP    ') THEN
     suffix = 'em'
     ! "Eta" Mass Coordinate, ranges from 1.0 at surface to 0.0 at
     ! top.  
     !
     !            eta = Pdry - Ptop
     !                   ----------
     !                      mu
     !  where
     !        mu = Psfc - Pvapor_bottom - Ptop
     !
     ! NOTE:  If we are using META, then the following namelist variables
     !        are defined as:
     !        vertical_increment = meters (estimated on US Std Atmos)
     !        max_vertical_inc   = meters (  "        " "    "     ")
     !        model_top = Pressure in Pa of model top
     !        levels = Eta levels (1.0 -> 0.0 from bottom to top)
     PRINT '(A)', 'Using specified mass-Eta level values.  Checking...'
     nlevels = 0
     ! Make sure first value is 1.0
     IF (levels(1) .NE. 1.0) THEN
       PRINT '(A,F6.3)', 'Bad first level: ',levels(k)
       PRINT '(A)', 'Eta (mass) must range from 1.0 at surface to 0.0 at top'
       STOP 'bad_first_level'
     ELSE 
       nlevels = 1
     ENDIF
     ! Make sure things are decreasing to 0.0 from bottom to top.
     level_check_loop2: DO k = 2, max_vertical_levels
       ! See if this is a valid level, if so increment nlevels
       ! and perform additional QC checks
       IF (levels(k) .GE. 0.) THEN
         ! Check for decreasing value of META (after 2nd value found)
         IF (levels(k) .GE. levels(k-1)) THEN
           PRINT '(A,I2,A,I2)', 'Level ',k, 'is >= level ' , k-1
           PRINT '(A)', 'Mass eta must must be listed in descending order!'
           STOP 'bad_level_specified'
         ELSE 
           nlevels = nlevels + 1
         ENDIF
       ELSE
         IF (nlevels .LT. 2) THEN
           PRINT'(A)', 'Not enough levels specified'
           STOP 'no_levels'
         ELSE
           num_levels = nlevels
           ! Check to make sure top level is 0.0
           IF (levels(num_levels).NE. 0.) THEN
             PRINT '(A,F6.3)', 'Bad top level value: ',levels(num_levels)
             PRINT '(A)', 'Top level must be 0.0 for Mass Eta'
             STOP 'bad_top_level'
           ENDIF
           exit level_check_loop2
         ENDIF
       ENDIF
     ENDDO level_check_loop2
!mp
   ELSE IF (output_coord .EQ. 'NMMH    ') THEN

	write(6,*) 'NMMH branch'
     setup_info%nmmcore=.TRUE.
     suffix = 'nm'
     PRINT '(A)', 'Using specified NMM-hybrid level values. Checking...'
     nlevels = 0
     ! Make sure first value is 1.0
     IF (levels(1) .NE. 1.0) THEN
       PRINT '(A,F6.3)', 'Bad first level: ',levels(k)
       PRINT '(A)', 'Hybrid level value must range from 1.0 at surface to 0.0 at top'
       STOP 'bad_first_level'
     ELSE 
       nlevels = 1
     ENDIF
     ! Make sure things are decreasing to 0.0 from bottom to top.
     level_check_loop3: DO k = 2, max_vertical_levels
       ! See if this is a valid level, if so increment nlevels
       ! and perform additional QC checks
       IF (levels(k) .GE. 0.) THEN
         ! Check for decreasing value of META (after 2nd value found)
         IF (levels(k) .GE. levels(k-1)) THEN
           PRINT '(A,I2,A,I2)', 'Level ',k, 'is >= level ' , k-1
           PRINT '(A)', 'sigma-p hybrid must must be listed in descending order!'
           STOP 'bad_level_specified'
         ELSE 
           nlevels = nlevels + 1
         ENDIF
       ELSE
         IF (nlevels .LT. 2) THEN
           PRINT'(A)', 'Not enough levels specified'
           STOP 'no_levels'
         ELSE
           num_levels = nlevels
           ! Check to make sure top level is 0.0
           IF (levels(num_levels).NE. 0.) THEN
             PRINT '(A,F6.3)', 'Bad top level value: ',levels(num_levels)
             PRINT '(A)', 'Top level must be 0.0 for NMM Hybrid'
             STOP 'bad_top_level'
           ENDIF
           exit level_check_loop3
         ENDIF
       ENDIF
     ENDDO level_check_loop3

   ELSE
     PRINT '(A)', 'Vertical coordinate ' // TRIM(output_coord) // &
             'is not yet supported for output.'
     STOP 'bad_output_vcoord'
   ENDIF
   
   ! Ok, if we have gotten to this point, we have established num_levels and
   ! the values of the levels.  Allocate the levels_half array and compute
   ! their values

   ALLOCATE(levels_half(num_levels))
   make_half_levels: DO k = 1, num_levels - 1
     levels_half(k) = (levels(k) + levels(k+1))*0.5
   ENDDO make_half_levels
   levels_half(num_levels) = levels(num_levels)*2. - levels_half(num_levels-1)

   !  Print them out and if print_setup_only we
   ! will stop after printing.  

   PRINT '(A)', 'LEVELS ON ' // output_coord // ' COORDINATES'
   PRINT '(A)', '-----------------------------------------'
   PRINT '(A)', ' K            FULL             HALF'
   PRINT '(A)', '-----------------------------------------'
   diag_levels_loop: DO k = 1, num_levels
     PRINT '(I4,7x,F15.6,F15.6)', k, levels(k),levels_half(k)
   ENDDO diag_levels_loop

   ! Populate vinterp_domain variables
   ALLOCATE( output_levels (num_levels,2) )
   output_levels(:,zstag_full_index) = levels(1:num_levels)
   output_levels(:,zstag_half_index) = levels_half(1:num_levels)
   output_vcoord = output_coord
   output_nz = num_levels
   setup_info%vstagger_output = .true.     

   !  Assign each local NAMELIST variable to the module name.

   setup_info%yyyy_st               = start_year
   setup_info%mm_st                 = start_month
   setup_info%dd_st                 = start_day
   setup_info%hh_st                 = start_hour
   setup_info%min_st                = start_minute
   setup_info%sec_st                = start_second
   setup_info%yyyy_end              = end_year
   setup_info%mm_end                = end_month
   setup_info%dd_end                = end_day
   setup_info%hh_end                = end_hour
   setup_info%min_end               = end_minute
   setup_info%sec_end               = end_second
   setup_info%time_increment_second = interval
	write(6,*) 'moad_dataroot: ', moad_dataroot
   setup_info%input_prefix          = TRIM(moad_dataroot) // '/siprd/hinterp'
	write(6,*) 'setup_info%input_prefix: ', setup_info%input_prefix
   setup_info%output_prefix         = TRIM(moad_dataroot) // '/siprd/real_input_' // suffix
   setup_info%wrf_output_prefix     = TRIM(moad_dataroot) // '/siprd/wrf_real_input_' // suffix
   setup_info%verbose               = verbose_log
   setup_info%output_vars           = output_vars
   if    (output_file_type == 'wrf' .or. output_file_type == 'Wrf' .or. output_file_type == 'WRF') then
     setup_info%output_file_type      = 'WRF'
   elseif(output_file_type == 'bin' .or. output_file_type == 'Bin' .or. output_file_type == 'BIN') then
     setup_info%output_file_type      = 'BIN'
   else
     setup_info%output_file_type      = 'BOTH'
   endif
   IF (output_coord .EQ. 'ETAP') THEN
     setup_info%max_top               = ptop_pa 
   ELSE IF (output_coord .EQ. 'NMMH') THEN
     setup_info%max_top               = ptop_pa 
   ELSE IF (output_coord .EQ. 'ZETA') THEN
     setup_info%max_top             = levels(num_levels)
   ENDIF
   setup_info%rh_wrt_liquid	    = rh_wrt_liquid

   WRITE (setup_info%starting_date,'(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)') &
     setup_info%yyyy_st , setup_info%mm_st , setup_info%dd_st ,&
     setup_info%hh_st , setup_info%min_st , setup_info%sec_st
   WRITE (setup_info%ending_date,'(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)') &
     setup_info%yyyy_end , setup_info%mm_end , setup_info%dd_end , setup_info%hh_end ,&
     setup_info%min_end , setup_info%sec_end
   CALL mm5_to_wrf_date(setup_info%starting_date, setup_info%wrf_start_date, setup_info%wrf_start_time)
   CALL mm5_to_wrf_date(setup_info%ending_date, setup_info%wrf_stop_date, setup_info%wrf_stop_time)

   !  There are a few checks we can perfom on the input date.

   !  Did the user use a 4-digit year, it is required ya know.

   IF ( ( setup_info%starting_date(1:2) .LT. '19' ) .OR. &
        ( setup_info%starting_date(1:2) .GT. '20' ) .OR. &
        ( setup_info%ending_date(1:2)   .LT. '19' ) .OR. &
        ( setup_info%ending_date(1:2)   .GT. '20' ) ) THEN

      PRINT '(A)','The namelist dates require a 4 digit year that starts' 
      PRINT '(A)','with either "19" or "20".'
      STOP '4_digit_year'
   END IF

   !  Is the ending time before the starting time?

   IF ( setup_info%ending_date .LT. setup_info%starting_date ) THEN
      PRINT '(A,A,A,A,A)','The ending date ',setup_info%ending_date,' is prior to the starting date ',setup_info%starting_date,'.'
      STOP 'prior_ending_date'
   END IF

   !  Print out a nice message letting folks know which particular time
   !  periods we plan to process in this program.  The current date is
   !  set to the requested starting_date, then it is incremented by the
   !  time interval specified in the namelist.  Once the incremented date
   !  is past the requested ending_date, we know we have reached the end
   !  of the number of time periods to process.  

   current_date = setup_info%starting_date
   
   setup_info%total_times = 0
   time_loop : DO WHILE ( current_date .LE. setup_info%ending_date )

      setup_info%total_times = setup_info%total_times + 1
      call mm5_to_wrf_date(current_date, current_date_wrf, current_time_wrf)
      IF ( verbose_log ) THEN
         PRINT '(A,A,A,I7.7,A,F8.2,A)','Time to process:  ',current_date, &
            '   (WRF Date = ',current_date_wrf, ' WRF Time = ',current_time_wrf,')'

      END IF

      CALL geth_newdate ( next_date , current_date , setup_info%time_increment_second ) 

      current_date = next_date

   END DO time_loop

   IF ( verbose_log ) THEN
      PRINT '(A,I8)','The total number of times periods to process (as given in the NAMELIST) is ',&
      setup_info%total_times
   END IF
  
END SUBROUTINE proc_namelist
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
END MODULE vinterp_setup
