!dis   
!dis    Open Source License/Disclaimer, Forecast Systems Laboratory
!dis    NOAA/OAR/FSL, 325 Broadway Boulder, CO 80305
!dis    
!dis    This software is distributed under the Open Source Definition,
!dis    which may be found at http://www.opensource.org/osd.html.
!dis    
!dis    In particular, redistribution and use in source and binary forms,
!dis    with or without modification, are permitted provided that the
!dis    following conditions are met:
!dis    
!dis    - Redistributions of source code must retain this notice, this
!dis    list of conditions and the following disclaimer.
!dis    
!dis    - Redistributions in binary form must provide access to this
!dis    notice, this list of conditions and the following disclaimer, and
!dis    the underlying source code.
!dis    
!dis    - All modifications to this software must be clearly documented,
!dis    and are solely the responsibility of the agent making the
!dis    modifications.
!dis    
!dis    - If significant modifications or enhancements are made to this
!dis    software, the FSL Software Policy Manager
!dis    (softwaremgr@fsl.noaa.gov) should be notified.
!dis    
!dis    THIS SOFTWARE AND ITS DOCUMENTATION ARE IN THE PUBLIC DOMAIN
!dis    AND ARE FURNISHED "AS IS."  THE AUTHORS, THE UNITED STATES
!dis    GOVERNMENT, ITS INSTRUMENTALITIES, OFFICERS, EMPLOYEES, AND
!dis    AGENTS MAKE NO WARRANTY, EXPRESS OR IMPLIED, AS TO THE USEFULNESS
!dis    OF THE SOFTWARE AND DOCUMENTATION FOR ANY PURPOSE.  THEY ASSUME
!dis    NO RESPONSIBILITY (1) FOR THE USE OF THE SOFTWARE AND
!dis    DOCUMENTATION; OR (2) TO PROVIDE TECHNICAL SUPPORT TO USERS.
!dis   
!dis 

SUBROUTINE proc_static_subnest

! Subroutine to read the mandatory WRF static fields from the static
! file and output them to an existing variable domain output file.

  USE wrf_metadata
  USE wrfsi_static
  USE vinterp_setup
  USE wrfsi_io
  USE WriteField

  IMPLICIT NONE
 
  CHARACTER(LEN=2)                  :: dom_id_str
  CHARACTER(LEN=200)                :: output_file
  CHARACTER(LEN=4)                  :: soil_source
  LOGICAL                           :: file_exists
  LOGICAL                           :: unit_used
  REAL, ALLOCATABLE                 :: dum2d(:,:)
  REAL, ALLOCATABLE                 :: dum3d(:,:,:)
  TYPE(wrfvar_metadata)             :: varmeta
  CHARACTER(LEN=10)                 :: SysDepInfo
  INTEGER                           :: n_cat, dim3, Comm, IOComm
  character(LEN=4)                  :: fileType
  INTEGER                           :: nestid

  nestid = dom_meta%id
 
  ! Build the file name, check for existence, and open for appended writing

    dom_meta%zdim = 1  ! or output_nz
    fileType = setup_info%output_file_type
    if(fileType == 'BIN' .or. fileType == 'BOTH') then
      CALL init_new_static_file(dom_meta,setup_info%output_prefix)
      if(setup_info%output_file_type == 'BIN') DryRun=.false.
    endif
    if(fileType == 'WRF' .or. fileType == 'BOTH') then
      CALL init_new_wrf_static_file(dom_meta,setup_info%wrf_output_prefix)
    endif



  ! OK, the file is ready to be written to.  Basically, just get 
  ! each of the variables, one at a time, build their metadata and 
  ! write them to the file.  Some of the metadata fields will be 
  ! the same for all variables, so populate the defaults once and
  ! change by exception

  varmeta%domain_id = dom_meta%id
  varmeta%ndim = 2
  varmeta%dim_val(1) = dom_meta%xdim
  varmeta%dim_val(2) = dom_meta%ydim
  varmeta%dim_val(3:var_maxdims) = 1
  varmeta%dim_desc(1) = 'W-E '
  varmeta%dim_desc(2) = 'S-N '
  varmeta%dim_desc(3:var_maxdims) = '    '
  varmeta%start_index(1)   = 1
  varmeta%start_index(2) = 1
  varmeta%start_index(3:var_maxdims) = 0
  varmeta%stop_index(1) = dom_meta%xdim
  varmeta%stop_index(2) = dom_meta%ydim
  varmeta%stop_index(3:var_maxdims) = 0
  IF (setup_info%output_vars .LE. 2) THEN
    varmeta%h_stagger_index = t_ind
  ELSE
    varmeta%h_stagger_index = n_ind
  ENDIF
  varmeta%v_stagger_index = 0
  varmeta%array_order = '+X+Y    '
  varmeta%field_type  = 'REAL'
  varmeta%field_source_prog = 'SI      '
  varmeta%source_desc = 'WRFSI static file                             '
  varmeta%field_time_type = 'CONSTANT'
  varmeta%vt_date_start = dom_meta%vt_date
  varmeta%vt_date_stop = dom_meta%vt_date
  varmeta%vt_time_start = dom_meta%vt_time
  varmeta%vt_time_stop = dom_meta%vt_time

  ALLOCATE(dum2d(dom_meta%xdim,dom_meta%ydim)) 
  IF (setup_info%output_vars .LE. 2) THEN
    ! Latitude on T grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LAT_T,dum2d)
    varmeta%name = 'LAT_M   '
    varmeta%units = 'deg north       '
    varmeta%description = 'Latitude of each gridpoint of the mass grid                  '   
  ELSE
    ! Latitude on Non-staggered grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LAT_N,dum2d)
    varmeta%name = 'LATITUDE'
    varmeta%units = 'deg north       '
    varmeta%description = 'Latitude of each gridpoint of the non-staggered grid         '
  ENDIF
  call write_field ( varmeta%name, dum2d, varmeta )

  IF (setup_info%output_vars .LE. 2) THEN  
    ! Longitude on T grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LON_T,dum2d) 
    varmeta%name = 'LON_M   '
    varmeta%units = 'deg east        '
    varmeta%description = 'Longitude of each gridpoint of the mass grid                  '   
  ELSE
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LON_N,dum2d)
    varmeta%name = 'LONGITUD'
    varmeta%units = 'deg east        '
    varmeta%description = 'Longitude of each gridpoint of the non-staggered grid         '
  ENDIF
  call write_field ( varmeta%name, dum2d, varmeta )

  ! Landmask on T grid
  CALL get_wrfsi_static_landmask(moad_dataroot,nestid,dum2d) 
  varmeta%name = 'LANDMASK'
  varmeta%units = 'flag: 1=land pt '
  varmeta%description = 'Flag values indicating water(0) or land (1) points            '   
  call write_field ( varmeta%name, dum2d(:,:), varmeta )

  IF (setup_info%output_vars .LE. 2) THEN
    ! Topography on T grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TER_T ,dum2d)
    varmeta%name = 'TOPO_M  '
    varmeta%units = 'meters          '
    varmeta%description = 'Topographic height on the mass grid points                    '   
  ELSE
    ! Topography on non-staggered grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TER_N ,dum2d)
    varmeta%name = 'TOPO_N  '
    varmeta%units = 'meters          '
    varmeta%description = 'Topographic height on the non-staggered grid points           '
  ENDIF
  call write_field ( varmeta%name, dum2d, varmeta )

  ! TOPOSTDV (Standard deviation of topography)
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TERSD_N ,dum2d)
  varmeta%name = 'TOPOSTDV'
  varmeta%units = 'meters          '
  varmeta%description = 'Sub-gridscale standard deviation of topography                '
  call write_field ( varmeta%name, dum2d, varmeta )

  ! TOPOSLPX (Mean slope in x direction)
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TERGRADLN_N ,dum2d)
  varmeta%name = 'TOPOSLPX'
  varmeta%units = 'meters/meters   '
  varmeta%description = 'Sub-gridscale mean topographic slope in x-direction           '
  call write_field ( varmeta%name, dum2d, varmeta )

  ! TOPOSLPY (Mean slope in y direction)
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TERGRADLT_N ,dum2d)
  varmeta%name = 'TOPOSLPY'
  varmeta%units = 'meters/meters   '
  varmeta%description = 'Sub-gridscale mean topographic slope in y-direction           '
  call write_field ( varmeta%name, dum2d, varmeta )
                                                      
  ! COSALPHA
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_COSALPHA_T, dum2d)
  varmeta%name = 'COSALPHA'
  varmeta%units = 'Dimensionless   '
  varmeta%description = 'Cosine of angle between mass point longitudes and std lon     '   
  call write_field ( varmeta%name, dum2d, varmeta )

  ! SINALPHA
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_SINALPHA_T, dum2d)
  varmeta%name = 'SINALPHA'
  varmeta%units = 'Dimensionless   '
  varmeta%description = 'Sin of angle between mass point longitudes and std longitude  '   
  call write_field ( varmeta%name, dum2d, varmeta )
  
  ! H_CORIOL
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_HCOR_T, dum2d)
  varmeta%name = 'H_CORIOL'
  varmeta%units = 's{-1}           '
  varmeta%description = 'Horizontal component of the coriolis acceleration             '   
  call write_field ( varmeta%name, dum2d, varmeta )

  ! V_CORIOL
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_VCOR_T, dum2d) 
  varmeta%name = 'V_CORIOL'
  varmeta%units = 's{-1}           '
  varmeta%description = 'Vertical component of the coriolis acceleration               '   
  call write_field ( varmeta%name, dum2d, varmeta )

  IF (setup_info%output_vars .LE. 2) THEN
    ! MAPFAC_M
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_MAPFAC_T,dum2d)
    varmeta%name = 'MAPFAC_M'
    varmeta%units = 'Dimensionless   '
    varmeta%description = 'Map scale factor on mass grid                                 '   
    call write_field ( varmeta%name, dum2d, varmeta )
    varmeta%h_stagger_index = t_ind

    ! MAPFAC_U
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_MAPFAC_U,dum2d)
    varmeta%name = 'MAPFAC_U'
    varmeta%units = 'Dimensionless   '
    varmeta%description = 'Map scale factor on u grid                                    '   
    varmeta%h_stagger_index = u_ind
    call write_field ( varmeta%name, dum2d, varmeta )
    varmeta%h_stagger_index = t_ind

    ! MAPFAC_V
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_MAPFAC_V,dum2d)
    varmeta%name = 'MAPFAC_V'
    varmeta%units = 'Dimensionless   '
    varmeta%description = 'Map scale factor on v grid                                    '   
    varmeta%h_stagger_index = v_ind
    call write_field ( varmeta%name, dum2d, varmeta )
    varmeta%h_stagger_index = t_ind
  ELSE
    ! MAPFAC_N
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_MAPFAC_N,dum2d)
    varmeta%name = 'MAPFAC_N'
    varmeta%units = 'Dimensionless   '
    varmeta%description = 'Map scale factor on non-staggered grid                        '
    varmeta%h_stagger_index = n_ind
    call write_field ( varmeta%name, dum2d, varmeta )
    varmeta%h_stagger_index = t_ind
  ENDIF  

  ! GRNFRACT (Requires time interpolation)
!  CALL get_wrfsi_static_monthly(moad_dataroot,nestid, "g", time, dum2d)
!  varmeta%name = 'GREENFRC'
!  varmeta%units = 'Percentage     '
!  varmeta%description = 'Time-interpolated monthly greenness fraction                 '   
!  call write_field ( varmeta%name, dum2d, varmeta )

 ! GRNMAX
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, "gnx", dum2d)
  varmeta%name = 'SHDMAX  '
  varmeta%units = 'Percentage     '
  varmeta%description = 'Maximum annual greenness fraction                 '   
  call write_field(varmeta%name,dum2d,varmeta)

 !  GRNMIN
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, "gnn", dum2d)
  varmeta%name = 'SHDMIN  '
  varmeta%units = 'Percentage     '
  varmeta%description = 'Minimum annual greenness fraction                 '   
  call write_field( varmeta%name, dum2d, varmeta)

!  ! ALBEDO (Requires time interpolation)
!  CALL get_wrfsi_static_monthly(moad_dataroot,nestid, "a", time, dum2d)
!  varmeta%name = 'ALBBCK  '
!  varmeta%units = 'Fraction       '
!  varmeta%description = 'Time-interpolated monthly albedo                             '
!  call write_field ( varmeta%name, dum2d, varmeta )

  ! Max snow albedo
  CALL get_wrfsi_static_2d(moad_dataroot,nestid,"alb",dum2d)
  varmeta%name = 'SNOALB  '
  varmeta%units = 'Fraction   '
  varmeta%description = 'Maximum albedo over snow         '
  call write_field( varmeta%name, dum2d, varmeta )

  ! T_AVGANN
  CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_AMT_T,dum2d)
  varmeta%name = 'T_AVGANN'
  varmeta%units = 'K               '
  varmeta%description = 'Average annual temperature                                   '   
  call write_field ( varmeta%name, dum2d, varmeta )

  ! Slope category
  CALL get_wrfsi_static_2d(moad_dataroot,nestid,"slp",dum2d)
  varmeta%name = 'SLOPECAT'
  varmeta%units = 'Category 0-9    '
  varmeta%description = 'Topographical categorical slope                  '   
  call write_field( varmeta%name, dum2d, varmeta )


  DEALLOCATE(dum2d) 

  ! The remaining static variables are 3D

  ! USGSLAND (3D) (Note that the 3D array to hold this data is declared and 
  !                allocated by the wrfsi_static module, which is used by this
  !                subroutine to access all static fields.  Thus, after we get
  !                it and output it, we dellocate it here.)
  CALL get_wrfsi_static_landusef(moad_dataroot, nestid,global_meta%lu_source, dim3, &
                                     global_meta%lu_water, global_meta%lu_ice)
  varmeta%ndim = 3
  varmeta%dim_val(3) = dim3
  varmeta%dim_desc(3) = 'CAT '
  varmeta%start_index(3) = 1
  varmeta%stop_index(3) = dim3
  varmeta%name = 'LANDUSEF'   
  varmeta%units = 'Fraction        '
  varmeta%description = 'Land use categorical fraction on mass grid                        ' 
  call write_field ( varmeta%name, static_landusef, varmeta, 'LanduseCategories' )
  DEALLOCATE(static_landusef)

  ! FAOSOIL (3D) (Note that both 3D arrays to hold these data are declared
  !               and allocated in the wrfsi_static module).

  CALL get_wrfsi_static_soil(moad_dataroot, nestid,soil_source,dim3, &
                             global_meta%st_water)
  varmeta%ndim = 3
  varmeta%dim_val(3) = dim3
  varmeta%dim_desc(3) = 'CAT '
  varmeta%start_index(3) = 1
  varmeta%stop_index(3) = dim3
  varmeta%name = 'SOILCTOP'    
  varmeta%units = 'Fraction        '
  varmeta%description = 'Top layer soil type as a categorical fraction                     ' 
  call write_field ( varmeta%name, static_soiltop, varmeta, 'SoilCategories   ' )
  DEALLOCATE(static_soiltop)
  varmeta%name = 'SOILCBOT'    
  varmeta%units = 'Percentage      '
  varmeta%description = 'Bottom layer soil type as a categorical fraction                   ' 
  call write_field ( varmeta%name, static_soilbot, varmeta, 'SoilCategories   ' )
  DEALLOCATE(static_soilbot)

  ALLOCATE(dum3d(dom_meta%xdim, dom_meta%ydim, 12))
  ! All 12 months of monthly greenness fraction
  CALL get_wrfsi_static_monthly_all(moad_dataroot,nestid,'g',dum3d)
  varmeta%ndim = 3
  varmeta%dim_val(3) = 12
  varmeta%dim_desc(3) = 'MONTH'
  varmeta%start_index(3) = 1
  varmeta%stop_index(3) = 12
  varmeta%name = 'GREEN12M'    
  varmeta%units = 'Fraction        '
  varmeta%description = 'Montly climatological greenness fraction                          ' 
  call write_field ( varmeta%name, dum3d, varmeta, 'MONTH            ' )


  ! All 12 months of monthly climatological albedo
  CALL get_wrfsi_static_monthly_all(moad_dataroot,nestid,'a',dum3d)
  varmeta%name = 'ALBDO12M'
  varmeta%units = 'Fraction        '
  varmeta%description = 'Montly climatological albedo                                      ' 
  call write_field ( varmeta%name, dum3d, varmeta, 'MONTH            ' )
  DEALLOCATE(dum3d)
  
  IF (.NOT.unit_used) CLOSE(domfile_out)

  RETURN
END SUBROUTINE proc_static_subnest
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE proc_static_nmm_subnest(time)

! Subroutine to read the mandatory WRF static fields from the static
! file and output them to an existing variable domain output file.

! As a bonus feature, will process NCEP snow & ice.  This processing
! perhaps would be better done elsewhere, but think have all the pieces
! here very nicely.

  USE wrf_metadata
  USE wrfsi_static
  USE vinterp_setup
  USE wrfsi_io
  USE WriteField

  IMPLICIT NONE
 
  CHARACTER(LEN=19),INTENT(IN)      :: time 
  CHARACTER(LEN=2)                  :: dom_id_str
  CHARACTER(LEN=200)                :: output_file, PATH
  CHARACTER(LEN=4)                  :: soil_source
  LOGICAL                           :: file_exists
  LOGICAL                           :: unit_used
  REAL, ALLOCATABLE                 :: dum2d(:,:)
  REAL, ALLOCATABLE                 :: dum3d(:,:,:)
  TYPE(wrfvar_metadata)             :: varmeta
  CHARACTER(LEN=10)                 :: SysDepInfo
  INTEGER                           :: n_cat, dim3, Comm, IOComm
  INTEGER                           :: I,J,K,IM,JM
  character(LEN=4)                  :: fileType


!	snow/albedo processing related
  REAL, PARAMETER:: ROI=916.6
  REAL, PARAMETER:: CI=2060.0
  REAL, PARAMETER:: AKI=0.000001075
  REAL, PARAMETER:: DZI=2.0
  REAL, PARAMETER:: DTR=3.14159/180.
                                                                                
  REAL, PARAMETER:: ROS=1500.0
  REAL, PARAMETER:: CS=1339.2
  REAL, PARAMETER:: AKS=0.0000005
  REAL, PARAMETER:: DZG=2.85
  REAL, PARAMETER:: SNUP=0.040
  REAL, PARAMETER:: SALP=2.60
  
  REAL, ALLOCATABLE :: SM(:,:),GLAT(:,:),GLON(:,:),MXSNAL(:,:)
  REAL, ALLOCATABLE :: SI(:,:),ALBASE(:,:),ALBEDO(:,:),EPSR(:,:)
  REAL, ALLOCATABLE :: SNO(:,:),SICE(:,:),WFK(:,:),GFFC(:,:)
  integer :: nestid

  nestid = dom_meta%id
  ! Build the file name, check for existence, and open for appended writing
  WRITE(dom_id_str, '(I2.2)') dom_meta%id   
  output_file = TRIM(setup_info%output_prefix) // '.d' //dom_id_str // &
               '.' // time(1:19)       
  INQUIRE(UNIT=domfile_out, OPENED=unit_used)
  if(.not.output_file_opened) then
    INQUIRE(FILE=output_file, EXIST=file_exists) 
    IF (.NOT. file_exists) THEN
      fileType = setup_info%output_file_type
      if(fileType == 'BIN' .or. fileType == 'BOTH') then
        CALL init_new_output_file    (dom_meta, setup_info%output_prefix    ,time)
      endif
      if(fileType == 'WRF' .or. fileType == 'BOTH') then
        CALL init_new_wrf_output_file(dom_meta, setup_info%wrf_output_prefix,time)
      endif
    ELSE
      OPEN(FILE=output_file,UNIT=domfile_out, &
         FORM='UNFORMATTED',ACCESS='SEQUENTIAL', &
         STATUS='OLD', POSITION='APPEND',IOSTAT=status)
      IF (status .NE. 0) THEN
        PRINT '(2a)','PROC_OUTPUT_STATIC: Problem opening ', TRIM(output_file)
        STOP 'PROC_OUTPUT_STATIC'
      ENDIF                                
    ENDIF
  ENDIF
  ! OK, the file is ready to be written to.  Basically, just get 
  ! each of the variables, one at a time, build their metadata and 
  ! write them to the file.  Some of the metadata fields will be 
  ! the same for all variables, so populate the defaults once and
  ! change by exception

  varmeta%domain_id = dom_meta%id
  varmeta%ndim = 2
  varmeta%dim_val(1) = dom_meta%xdim
  varmeta%dim_val(2) = dom_meta%ydim
  varmeta%dim_val(3:var_maxdims) = 1
  varmeta%dim_desc(1) = 'W-E '
  varmeta%dim_desc(2) = 'S-N '
  varmeta%dim_desc(3:var_maxdims) = '    '
  varmeta%start_index(1)   = 1
  varmeta%start_index(2) = 1
  varmeta%start_index(3:var_maxdims) = 0
  varmeta%stop_index(1) = dom_meta%xdim
  varmeta%stop_index(2) = dom_meta%ydim
  varmeta%stop_index(3:var_maxdims) = 0
  IF (setup_info%output_vars .LE. 2) THEN
    varmeta%h_stagger_index = t_ind
  ELSE
    varmeta%h_stagger_index = n_ind
  ENDIF
  varmeta%v_stagger_index = 0
  varmeta%array_order = '+X+Y    '
  varmeta%field_type  = 'REAL'
  varmeta%field_source_prog = 'SI      '
  varmeta%source_desc = 'WRFSI static file                             '
  varmeta%field_time_type = 'CONSTANT'
  varmeta%vt_date_start = dom_meta%vt_date
  varmeta%vt_date_stop = dom_meta%vt_date
  varmeta%vt_time_start = dom_meta%vt_time
  varmeta%vt_time_stop = dom_meta%vt_time

  ALLOCATE(dum2d(dom_meta%xdim,dom_meta%ydim)) 
!  ALLOCATE(GLAT(dom_meta%xdim,dom_meta%ydim)) 
!  ALLOCATE(GLON(dom_meta%xdim,dom_meta%ydim)) 

 IM=dom_meta%xdim
 JM=dom_meta%ydim

  IF (setup_info%output_vars .LE. 2) THEN
    ! Latitude on H grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LAT_H,dum2d)

       do J=1,JM
        do I=1,IM
	dum2d(I,J)=dum2d(I,J)*DTR
        enddo
        enddo

    varmeta%name = 'GLAT    '
    varmeta%units = 'rad north       '
    varmeta%description = 'Latitude of each gridpoint of the mass grid                  '   
  ELSE
	write(6,*) 'wrong branch?'
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LAT_H,dum2d)
    varmeta%name = 'LAT_H   '
    varmeta%units = 'rad north       '
    varmeta%description = 'Latitude of each gridpoint of the mass grid                  '
  ENDIF
  call write_field ( varmeta%name, dum2d, varmeta )


!!!
  IF (setup_info%output_vars .LE. 2) THEN  
    ! Longitude on T grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LON_H,dum2d) 

        do J=1,JM
        do I=1,IM
	dum2d(I,J)=dum2d(I,J)*DTR
        enddo
        enddo

    varmeta%name = 'GLON    '
    varmeta%units = 'deg east        '
    varmeta%description = 'Longitude of each gridpoint of the mass grid                  '   
  ELSE
	write(6,*) 'wrong branch?'
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LON_N,dum2d)
    varmeta%name = 'LONGITUD'
    varmeta%units = 'radians     '
    varmeta%description = 'Longitude of each gridpoint of the mass grid                  '   
  ENDIF
  call write_field ( varmeta%name, dum2d, varmeta )

!!!!!!!!!!

    ! Latitude on V grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LAT_W,dum2d)
    varmeta%name = 'LAT_V   '
    varmeta%h_stagger_index = w_ind
    varmeta%units = 'deg east        '
    varmeta%description = 'Latitude of each gridpoint of the wind grid                  '   
  call write_field ( varmeta%name, dum2d, varmeta )

    ! Longitude on V grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_LON_W,dum2d)
    varmeta%name = 'LON_V   '
    varmeta%h_stagger_index = w_ind
    varmeta%units = 'deg north       '
    varmeta%description = 'Longitude of each gridpoint of the wind grid                 '   
  call write_field ( varmeta%name, dum2d, varmeta )

!!!!!!!!!!

  ALLOCATE(SM(dom_meta%xdim,dom_meta%ydim)) 

  ! Landmask on T grid
  CALL get_wrfsi_static_landmask(moad_dataroot,nestid,dum2d) 
                                                                                
        do J=1,JM
        do I=1,IM
        sm(I,J)=1.0-dum2d(I,J)
        enddo
        enddo

  varmeta%name = 'LANDMASK'
  varmeta%h_stagger_index = t_ind
  varmeta%units = 'flag: 1=land pt '
  varmeta%description = 'Flag values indicating water(0) or land (1) points            '   
  call write_field ( varmeta%name, dum2d(:,:), varmeta )

  varmeta%name = 'SM'
  varmeta%h_stagger_index = t_ind
  varmeta%units = 'flag: 1=watr pt '
  varmeta%description = 'Flag values indicating water(1) or land (0) points            '   
  call write_field ( varmeta%name, sm, varmeta )

  IF (setup_info%output_vars .LE. 2) THEN
    ! Topography on T grid
    CALL get_wrfsi_static_2d(moad_dataroot, nestid,NAME_TER_T ,dum2d)
    varmeta%name = 'TOPO_M  '
    varmeta%units = 'meters          '
    varmeta%description = 'Topographic height on the mass grid points                    '   
  ELSE
	write(6,*) 'unstaggered topo...shouldnt exist'
    ! Topography on non-staggered grid
    CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TER_N ,dum2d)
    varmeta%name = 'TOPO_N  '
    varmeta%units = 'meters          '
    varmeta%description = 'Topographic height on the non-staggered grid points           '
  ENDIF

	do J=1,dom_meta%ydim
	do I=1,dom_meta%xdim
	dum2d(I,J)=dum2d(I,J)*9.806
	enddo
	enddo

    varmeta%name = 'FIS     '
    varmeta%units = 'm{2} s{-2}      '
    varmeta%description = 'Geopotential (g * topography)                                 '   
  
	write(6,*) 'writing FIS'
  call write_field ( varmeta%name, dum2d, varmeta )
	write(6,*) 'return write FIS'

!!!
!!!
!!! Think about which of these fields the NMM or its associated real
!!! code will actually care about
!!!
!!!

  ! TOPOSTDV (Standard deviation of topography)
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TERSD_N ,dum2d)
  varmeta%name = 'TOPOSTDV'
  varmeta%units = 'meters          '
  varmeta%description = 'Sub-gridscale standard deviation of topography                '
!  call write_field ( varmeta%name, dum2d, varmeta )

  ! TOPOSLPX (Mean slope in x direction)
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TERGRADLN_N ,dum2d)
  varmeta%name = 'TOPOSLPX'
  varmeta%units = 'meters/meters   '
  varmeta%description = 'Sub-gridscale mean topographic slope in x-direction           '
!   call write_field ( varmeta%name, dum2d, varmeta )

  ! TOPOSLPY (Mean slope in y direction)
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_TERGRADLT_N ,dum2d)
  varmeta%name = 'TOPOSLPY'
  varmeta%units = 'meters/meters   '
  varmeta%description = 'Sub-gridscale mean topographic slope in y-direction           '
!   call write_field ( varmeta%name, dum2d, varmeta )
                                                      
  ! COSALPHA
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_COSALPHA_T, dum2d)
  varmeta%name = 'COSALPHA'
  varmeta%units = 'Dimensionless   '
  varmeta%description = 'Cosine of angle between mass point longitudes and std lon     '   
!  call write_field ( varmeta%name, dum2d, varmeta )

  ! SINALPHA
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_SINALPHA_T, dum2d)
  varmeta%name = 'SINALPHA'
  varmeta%units = 'Dimensionless   '
  varmeta%description = 'Sin of angle between mass point longitudes and std longitude  '   
!  call write_field ( varmeta%name, dum2d, varmeta )
  
  ! H_CORIOL
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_HCOR_T, dum2d)
  varmeta%name = 'H_CORIOL'
  varmeta%units = 's{-1}           '
  varmeta%description = 'Horizontal component of the coriolis acceleration             '   
!  call write_field ( varmeta%name, dum2d, varmeta )

  ! V_CORIOL
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, NAME_VCOR_T, dum2d) 
  varmeta%name = 'V_CORIOL'
  varmeta%units = 's{-1}           '
  varmeta%description = 'Vertical component of the coriolis acceleration               '   
!  call write_field ( varmeta%name, dum2d, varmeta )

  ! GRNFRACT (Requires time interpolation)
  CALL get_wrfsi_static_monthly(moad_dataroot,nestid, "g", time, dum2d)

!   ALLOCATE(WFK(dom_meta%xdim,dom_meta%ydim)) 

!        do J=1,JM
!        do I=1,IM
!        wfk(I,J)=dum2d(I,J)
!        enddo
!        enddo

  varmeta%name = 'GREENFRC'
  varmeta%units = 'Percentage     '
  varmeta%description = 'Time-interpolated monthly greenness fraction                 '   
  call write_field ( varmeta%name, dum2d, varmeta )

 ! GRNMAX
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, "gnx", dum2d)
  varmeta%name = 'GREENMAX'
  varmeta%units = 'Percentage     '
  varmeta%description = 'Maximum annual greenness fraction                 '   
  call write_field(varmeta%name,dum2d,varmeta)

 !  GRNMIN
  CALL get_wrfsi_static_2d(moad_dataroot,nestid, "gnn", dum2d)
  varmeta%name = 'GREENMIN'
  varmeta%units = 'Percentage     '
  varmeta%description = 'Minimum annual greenness fraction                 '   
  call write_field( varmeta%name, dum2d, varmeta)

  ! ALBEDO (Requires time interpolation)
  CALL get_wrfsi_static_monthly(moad_dataroot,nestid, "a", time, dum2d)

!  ALLOCATE(ALBASE(dom_meta%xdim,dom_meta%ydim)) 

!        do J=1,JM
!        do I=1,IM
!        albase(I,J)=dum2d(I,J)
!        enddo
!        enddo

  varmeta%name = 'ALBASE  '
  varmeta%units = 'Fraction       '
  varmeta%description = 'Time-interpolated monthly albedo                             '
   call write_field ( varmeta%name, dum2d, varmeta )

  ! Max snow albedo
  CALL get_wrfsi_static_2d(moad_dataroot,nestid,"alb",dum2d)

!  ALLOCATE(MXSNAL(dom_meta%xdim,dom_meta%ydim)) 

!        do J=1,JM
!        do I=1,IM
!       mxsnal(I,J)=dum2d(I,J)
!        enddo
!        enddo

  varmeta%name = 'MXSNAL'
  varmeta%units = 'Fraction   '
  varmeta%description = 'Maximum albedo over snow         '
  call write_field( varmeta%name, dum2d, varmeta )

  ! T_AVGANN
  CALL get_wrfsi_static_2d(moad_dataroot,nestid,NAME_AMT_T,dum2d)
  varmeta%name = 'SOILTB'
  varmeta%units = 'K               '
  varmeta%description = 'Average annual temperature                                   '   
  call write_field ( varmeta%name, dum2d, varmeta )

  ! Slope category
  CALL get_wrfsi_static_2d(moad_dataroot,nestid,"slp",dum2d)
  varmeta%name = 'ISLOPE'
  varmeta%units = 'Category 0-9    '
  varmeta%field_type  = 'REAL'
  varmeta%description = 'Topographical categorical slope                  '   


  call write_field( varmeta%name, dum2d, varmeta )



!! process snow
	
!	PATH=trim(moad_dataroot) // '/../../../inputdata/'
!	write(6,*) 'PATH= ', PATH

!	ALLOCATE(ALBEDO(dom_meta%xdim,dom_meta%ydim))
!	ALLOCATE(EPSR(dom_meta%xdim,dom_meta%ydim))
!	ALLOCATE(SICE(dom_meta%xdim,dom_meta%ydim))
!	ALLOCATE(SNO(dom_meta%xdim,dom_meta%ydim))
!	ALLOCATE(GFFC(dom_meta%xdim,dom_meta%ydim))

!	CALL PROCSNOW(GLAT,GLON,SM,ALBASE,MXSNAL,WFK,dom_meta%xdim,& 
!			dom_meta%ydim, &
!                      ALBEDO,EPSR,SICE,SNO,GFFC,trim(PATH))


  varmeta%field_type  = 'REAL'
  varmeta%name = 'ALBEDO'
  varmeta%units = 'Fraction (0-1)    '
  varmeta%description = 'Albedo accounting for snow/ice cover             '   
!   call write_field( varmeta%name, ALBEDO, varmeta )

  varmeta%name = 'EPSR'
  varmeta%units = 'Fraction (0-1)    '
  varmeta%description = 'black body emmissivity                           '   
!   call write_field( varmeta%name, EPSR, varmeta )

!  varmeta%name = seaice_id
  varmeta%name = 'SI'
  varmeta%units = 'Fraction (0-1)    '
  varmeta%description = 'Sea Ice (1=ice, 0= not ice)                      '   
!  call write_field( varmeta%name, SICE, varmeta )

  varmeta%name = 'SNO'
  varmeta%units = 'meters    '
  varmeta%description = 'Water-equivalent depth                           '   
!  call write_field( varmeta%name, SNO, varmeta )

  varmeta%name = 'GFFC'
  varmeta%units = 'Fraction (0-1)    '
  varmeta%description = 'Obsolete field (ignore)                          '   
!  call write_field( varmeta%name, GFFC, varmeta )


!  DEALLOCATE(GLAT,GLON,SM,WFK,ALBASE,MXSNAL,ALBEDO,EPSR,SICE,SNO,GFFC)

	DEALLOCATE(SM)

	DUM2D=0.

  varmeta%name = 'CMC'
  varmeta%units = 'kg m{-2}???   '
  varmeta%description = 'Canopy Water                                     '   
  call write_field( varmeta%name,DUM2D, varmeta )

!! DERIVED HORIZONTAL GRID CONSTANTS

!! HTM, VTM (above ground=1...always true in non-Eta world)

	ALLOCATE(DUM3D(dom_meta%xdim,dom_meta%ydim,dom_out%zdim))

	do K=1,dom_out%zdim
	do J=1,dom_meta%ydim
	do I=1,dom_meta%xdim
	DUM3D(I,J,K)=1.
	enddo
	enddo
	enddo

  varmeta%ndim = 3
  varmeta%dim_val(3) = dom_out%zdim
  varmeta%name = 'HTM      '
  varmeta%units = 'Dimensionless   '
  varmeta%description = '3-D Height Mask (H points, =1 above ground)                   '   
  varmeta%h_stagger_index = t_ind
  call write_field ( varmeta%name, dum3d, varmeta, 'z                ' )

  varmeta%name = 'VTM      '
  varmeta%units = 'Dimensionless   '
  varmeta%description = '3-D Height Mask (V points, =1 above ground)                   '   
  varmeta%h_stagger_index = w_ind
  call write_field ( varmeta%name, dum3d, varmeta, 'z                ' )


	DEALLOCATE(DUM3D)
	DEALLOCATE(DUM2D)

  ! The remaining static variables are 3D

  IF (.NOT. have_bg_landusec) THEN  ! only get landuse data if not in background
    ! USGSLAND (3D) (Note that the 3D array to hold this data is declared and 
    !                allocated by the wrfsi_static module, which is used by this
    !                subroutine to access all static fields.  Thus, after we get
    !                it and output it, we dellocate it here.)
    CALL get_wrfsi_static_landusef(moad_dataroot,nestid, global_meta%lu_source, dim3, &
                                     global_meta%lu_water, global_meta%lu_ice)
    varmeta%ndim = 3
    varmeta%dim_val(3) = dim3
    varmeta%dim_desc(3) = 'CAT '
    varmeta%start_index(3) = 1
    varmeta%stop_index(3) = dim3
    varmeta%name = 'LANDUSEF'   
    varmeta%units = 'Fraction        '
    varmeta%description = 'Land use categorical fraction on mass grid                        ' 
    call write_field ( varmeta%name, static_landusef, varmeta, 'LanduseCategories' )
    DEALLOCATE(static_landusef)
  ENDIF

  ! FAOSOIL (3D) (Note that both 3D arrays to hold these data are declared
  !               and allocated in the wrfsi_static module).

  IF (.NOT. have_bg_soilctop) THEN ! Only get soil types if not in background
    CALL get_wrfsi_static_soil(moad_dataroot,nestid, soil_source,dim3, &
                             global_meta%st_water)
    varmeta%ndim = 3
    varmeta%dim_val(3) = dim3
    varmeta%dim_desc(3) = 'CAT '
    varmeta%start_index(3) = 1
    varmeta%stop_index(3) = dim3
    varmeta%name = 'SOILCTOP'    
    varmeta%units = 'Fraction        '
    varmeta%description = 'Top layer soil type as a categorical fraction                     ' 
    call write_field ( varmeta%name, static_soiltop, varmeta, 'SoilCategories   ' )
    DEALLOCATE(static_soiltop)
    varmeta%name = 'SOILCBOT'    
    varmeta%units = 'Fraction        '
    varmeta%description = 'Bottom layer soil type as a categorical fraction                   ' 
    call write_field ( varmeta%name, static_soilbot, varmeta, 'SoilCategories   ' )
    DEALLOCATE(static_soilbot)
  ENDIF
 
  IF (.NOT.unit_used) CLOSE(domfile_out)
  RETURN
END SUBROUTINE proc_static_nmm_subnest
