PRO get_wrf_variable, infile, varname, data, domain

@wrf_metadata.inc
var = wrf_variable_metadata

data_found = 0
varname_req = STRUPCASE(STRTRIM(varname,2))

OPENR, unit, infile, /GET_LUN, /F77

READU, unit, wrf_domain_metadata
domain = wrf_domain_metadata
WHILE (data_found EQ 0) DO BEGIN
  READU,unit,var
  print, 'Reading ', STRUPCASE(STRTRIM(STRING(var.name),2)) 
  print, 'Dimensions = ', var.dim_val
  CASE var.ndim OF
    0: dummy = FLOAT(0)
    1: dummy = FLTARR(var.dim_val[0])
    2: dummy = FLTARR(var.dim_val[0],var.dim_val[1])
    3: dummy = FLTARR(var.dim_val[0],var.dim_val[1],var.dim_val[2])
    4: dummy = FLTARR(var.dim_val[0],var.dim_val[1],var.dim_val[2],var.dim_val[3])
    ELSE: BEGIN
      print, 'NDIM too big: ', var.ndim
      stop
      END
  ENDCASE
  field_type = STRUPCASE(STRTRIM(STRING(var.field_type),2))
  IF field_type NE 'REAL' THEN BEGIN
    CASE field_type OF
      'INT': dummy = LONG(dummy)
      'DOUB': dummy = DOUBLE(dummy)
      'SHRT': dummy = INT(dummy)
      'BYTE': dummy = BYTE(dummy)
      'COMP': dummy = COMPLEX(dummy)
      ELSE: BEGIN
        print, 'Unrecognized data type: ', field_type
        stop
      END
    ENDCASE
  ENDIF
  READU, unit, dummy
  varname = STRUPCASE(STRTRIM(STRING(var.name),2))
  PRINT, 'Read ', varname
  IF varname EQ varname_req THEN BEGIN
    PRINT, 'Returning it to you in a structure'
    data = { meta:var, data:dummy }
    data_found = 1
  ENDIF ELSE BEGIN
    PRINT, 'Skipping it since you did not request it'
  ENDELSE
ENDWHILE
CLOSE, unit
FREE_LUN,unit
RETURN
END



