; IDL include file defining interim WRF metadata

; 14 Aug 2000 - V1.0 - Brent Shaw, NOAA/OAR/FSL/FRD/LAPB

; Set maximum dimensions for some things below

var_maxdims = 5L
max_staggers_xy = 4L
max_staggers_z = 2L
max_standard_lats = 4L
max_standard_lons = 4L

; Note that the items specified as byte arrays are actually character
; strings, but we use bytarr to ensure the structure size doesn't 
; get changed if some non-character data is accidentally read into
; something defined as a character.  Also, this structure is currently
; written to the wrf meta data file using F77 unformatted, so if the file
; is not opened with the /F77_UNFORMATTED keyword, then you need to read
; a long int before and after the read of this structure.


wrf_global_metadata =  { simulation_name: BYTARR(80), $
			user_desc: BYTARR(80), $
			si_version: LONG(0), $
			anal_version: LONG(0), $
			wrf_version: LONG(0), $
			post_version: LONG(0), $
			map_projection: BYTARR(32), $
			moad_known_lat: FLOAT(-99.), $
                        moad_known_lon: FLOAT(-999.), $
			moad_known_loc: BYTARR(8), $
			moad_stand_lats: FLTARR(max_standard_lats), $
			moad_stand_lons: FLTARR(max_standard_lons), $
                        moad_delta_x: FLOAT(0), $
                        moad_delta_y: FLOAT(0), $
			horiz_stagger_type: BYTARR(4), $
			num_stagger_xy: LONG(0), $
			stagger_dir_x: FLTARR(max_staggers_xy), $
			stagger_dir_y: FLTARR(max_staggers_xy), $
			num_stagger_z: LONG(0), $
 			stagger_dir_z: FLTARR(max_staggers_z), $
			vertical_coord: BYTARR(8), $
			num_domains: LONG(0), $
			init_date: LONG(0), $
			init_time: FLOAT(0), $
			end_date:  LONG(0), $
			end_time:  FLOAT(0), $
                        lu_source: BYTARR(4), $
                        lu_water: LONG(0), $
                        lu_ice: LONG(0), $
                        st_water: LONG(0) }

wrf_domain_metadata =	{ id: LONG(0), $
			parent_id: LONG(0), $
			dynamic_init_src: BYTARR(8), $
                        static_init_src: BYTARR(8), $
			vt_date: LONG(0), $
			vt_time: FLOAT(0), $
			origin_parent_x: LONG(0), $
			origin_parent_y: LONG(0), $
			ratio_to_parent: LONG(0), $
                        delta_x: FLOAT(0), $
                        delta_y: FLOAT(0),$
                        top_level:FLOAT(0), $
                        origin_parent_z: LONG(0), $
                        corner_lats: FLTARR(4,max_staggers_xy), $
                        corner_lons: FLTARR(4,max_staggers_xy), $
			xdim: LONG(0), $
			ydim: LONG(0),$
			zdim: LONG(0) }

wrf_variable_metadata= 	{ name: BYTARR(8) , $
			units: BYTARR(16), $
			description: BYTARR(80), $
			domain_id: LONG(0), $
			ndim: LONG(0), $
			dim_val: LONARR(var_maxdims), $
			dim_desc: BYTARR(4,var_maxdims), $
			start_index: LONARR(var_maxdims), $
			stop_index: LONARR(var_maxdims), $
			h_stagger_index: LONG(0), $
			v_stagger_index: LONG(0), $
			array_order: BYTARR(8), $
			field_type: BYTARR(4), $
			field_source_prog: BYTARR(8), $
			source_desc: BYTARR(80), $
			field_time_type: BYTARR(8), $
			vt_date_start: LONG(0), $
			vt_time_start: FLOAT(0), $
			vt_date_stop: LONG(0), $
			vt_time_stop: FLOAT(0) }

