#!/bin/csh
#
#BSUB -P 64000400           # account
#BSUB -n 4                  # number of tasks
#BSUB -J test4_0            # job name
#BSUB -o test4_0.%J.out     # stdout redirect
#BSUB -e test4_0.%J.err     # stderr redirect
#BSUB -q share              # queue
#BSUB -N                    # send email report
#BSUB -W 1:00               # wall-clock limit (HH:MM)
#

# This is a LSF script to run WRF for a simple MPI-only em_real case 
# on bluevista.  jan00 case is used.  
# Only wrf.exe is run.  
# To use it, type "bsub < test4_0.csh" from the test/em_esmf_exp 
# subdirectory.  

unalias cd cp rm ls pushd popd mv

# Modify namelist if needed...  
cp -f ../em_real/namelist.input.jan00 namelist.input

# Run WRF
mpirun.lsf ./wrf.exe

