      SUBROUTINE SKEWT_WNDBARB (XBASE,YBASE,U,V)

C***********************************************************************
C WNDBARB - FOR THE GRAPH PORTION OF GRIN
C  THIS ROUTINE DRAWS A SINGLE WIND BARB PER CALL.
C
C ON INPUT - FOUR VARIABLES COME IN.  XBASE CONTAINS THE HORIZONTAL COOR
C            DINATE OF THE BASE OF THE WIND BARB.  YBASE CONTAINS THE
C            VERTICAL COORDINATE OF THE BASE OF THE WIND BARB.  U CONTAI
C            THE EAST-WEST WIND COMPONENT IN METERS PER SECOND.  V CONTA
C            THE NORTH-SOUTH WIND COMPONENT IN METERS PER SECOND.
C
C ON OUTPUT - ONE BARB HAS BEEN DRAWN TO UNIT NUMBER 2, WHICH CORRESPOND
C            TO GMETA.CGM, THE GKS OUTPUT META CODE FILE.
C
C ASSUMPTIONS - THIS ROUTINE ASSUMES THAT GKS HAS BEEN OPENED AND A WORK
C            STATION HAS BEEN SET.
C
C REVISED BY - JEREMY ASBILL ON MAY 3, 1990.
C***********************************************************************

C  INPUT VARIABLE DECLARATIONS ...

      REAL      XBASE,YBASE,
     *          U,V

C  LOCAL PARAMETER ...
C    SC SPECIFIES IN THE NORMALIZED (FRACTIONAL) GRAPHICS COORDINATE
C       SYSTEM HOW LONG THE BARB SHAFT IS TO BE
C    COORDINATE SYSTEMS ARE EXPLAINED IN NCAR GRAPHICS USER'S GUIDE VERS
C    2.00 ON PAGE 46.

      PARAMETER (SC = 0.05493)

C  LOCAL VARIABLE DECLARATIONS ...

      INTEGER   LLSV                 ! SAVE VARIABLE, SCALING FOR SET

      LOGICAL DONE                   ! T => SUBROUTINE ENDS, F => LOOP A

      REAL      WINDVCT,             ! WIND VECTOR MAGNITUDE
     *          FLSV,FRSV,FBSV,FTSV, ! SAVE VARIABLES, FRACTIONAL COORDI
     *          ULSV,URSV,UBSV,UTSV, ! SAVE VARIABLES, INCOMING USER COO
     *          NEWXBASE,            ! FRACTIONAL X COORD. FOR BARB BASE
     *          NEWYBASE,            ! FRACTIONAL Y COORD. FOR BARB BASE
     *          XCOMP,               ! X COMPONENT OF GRAPHICAL VECTOR (
     *          YCOMP,               ! Y COMPONENT OF GRAPHICAL VECTOR (
     *          PK,                  ! PLACE KEEPER
     *          FETHLENX,            ! X COMPONENT OF GRAPHICAL VECT. (F
     *          FETHLENY             ! Y COMPONENT OF GRAPHICAL VECT. (F

C  LOCAL ARRAY DECLARATIONS ...

      INTEGER   IJUNK(5)             ! CALCULATION ARRAY FOR SFSGFA

      REAL      POINTX(3),           ! USED TO SPECIFY POINTS TO DRAW BE
     *          POINTY(3),           ! USED TO SPECIFY POINTS TO DRAW BE
     *          JUNK(7)              ! CALCULATION ARRAY FOR SFSGFA

C***************************** SUBROUTINE BEGIN ************************

C  INITIALIZE LOOP, BOOLEAN INDICATOR

      DONE = .FALSE.

C  CALCULATE THE WIND VECTOR MAGNITUDE IN KNOTS

      IF ((U .EQ. 0) .AND. (V .EQ. 0)) THEN
        WINDVCT = 1.0
      ELSE
        WINDVCT = SQRT(U**2 + V**2) * 1.94
      END IF

C  SAVE INCOMING USER COORDINATES AND CHANGE BACK TO NORMALIZED COORDINA
C  DOCUMENTATION FOR SET AND GETSET CAN BE FOUND IN NCAR GRAPHICS USER'S
C  GUIDE VERSION 2.00 ON PAGES 49 (GETSET) AND 53 (SET).

      CALL GETSET (FLSV,FRSV,FBSV,FTSV,ULSV,URSV,UBSV,UTSV,LLSV)
      CALL SET    (FLSV,FRSV,FBSV,FTSV, 0.0, 1.0, 0.0, 1.0, 1)

C  DETERMINE WHERE THE BASE OF THE BARB IS IN THE NORMALIZED COORDINATES

      NEWXBASE = (XBASE - ULSV)/(URSV - ULSV)
      NEWYBASE = (YBASE - UBSV)/(UTSV - UBSV)

C  CALCULATE THE X DISTANCE AND Y DISTANCE FROM THE BASE OF THE BARB THA
C  DEFINES THE BARBS TIP (NORMALIZED COORD'S)

      XCOMP = -SC * U * 1.94/WINDVCT
      YCOMP = -SC * V * 1.94/WINDVCT

C  DETERMINE THE ACTUAL LOCATION IN NORMALIZED COORDINATES OF THE BARB'S

      POINTX(1) = NEWXBASE + XCOMP
      POINTY(1) = NEWYBASE + YCOMP

C  DRAW THE BARB SHAFT, DOCUMENTATION FOR THE LINE SUBROUTINE CAN BE FOU
C  IN NCAR GRAPHICS USER'S GUIDE VERSION 2.00 ON PAGE 50

      CALL LINE (NEWXBASE,NEWYBASE,POINTX(1),POINTY(1))

C  DETERMINE THE FEATHER LENGTH

      FETHLENX = 0.3 * YCOMP
      FETHLENY = -0.3 * XCOMP

C  SET THE PLACE KEEPER AND BOOST THE WIND MAGNITUDE

      PK = 0.9
      WINDVCT = WINDVCT + 2.5

C  BEGIN MAKING FEATHERS

10    CONTINUE

C    DRAW A FLAG FOR EVERY 50 KNOTS WIND MAGNITUDE

      IF (WINDVCT .GE. 50.0) THEN

C      DETERMINE THE POSITION OF THE FLAG TIP, POINT_(2)
C      AND DETERMINE POSITION WHERE FLAG BOTTOM MEETS THE SHAFT, POINT_(

        POINTX(2) = POINTX(1) + FETHLENX + 0.0005
        POINTY(2) = POINTY(1) + FETHLENY + 0.0005
        POINTX(3) = PK * XCOMP + NEWXBASE
        POINTY(3) = PK * YCOMP + NEWYBASE

C      DRAW FLAG

        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))
        CALL LINE (POINTX(3),POINTY(3),POINTX(2),POINTY(2))

C      FILL IN FLAG, DOCUMENTATION FOR SFSGFA CAN BE FOUND IN NCAR
C      GRAPHICS GUIDE TO NEW UTILITIES VERSION 3.00 ON PAGE 4-8

        CALL SFSETR ('SP',0.000001)
        CALL SFSGFA (POINTX,POINTY,3,JUNK,5,IJUNK,7,2)

C      REMOVE 50 KNOTS FROM WIND MAGNITUDE (ALREADY DRAWN IN)

        WINDVCT = WINDVCT - 50.0

C      DETERMINE NEW BEGIN POINT FOR NEXT FLAG OR FEATHER

        PK = PK - 0.05
        POINTX(1) = PK * XCOMP + NEWXBASE
        POINTY(1) = PK * YCOMP + NEWYBASE
        PK = PK - 0.1

C    DRAW A FULL FEATHER FOR WIND MAGNITUDE OF EVERY 10 KNOTS

      ELSE IF (WINDVCT .GE. 10.0) THEN

C      CALCULATE POSITION OF FEATHER END

        POINTX(2) = POINTX(1) + FETHLENX + 0.0005
        POINTY(2) = POINTY(1) + FETHLENY + 0.0005

C      DRAW FEATHER

        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))

C      REMOVE 10 KNOTS FROM WIND MAGNITUDE (ALREADY DRAWN IN)

        WINDVCT = WINDVCT - 10.0

C      DETERMINE NEW START POINT FOR NEXT FEATHER OR FLAG

        POINTX(1) = PK * XCOMP + NEWXBASE
        POINTY(1) = PK * YCOMP + NEWYBASE
        PK = PK - 0.1

C    DRAW A HALF FEATHER FOR EVERY 5 KNOTS OF WIND MAGNITUDE

      ELSE IF (WINDVCT .GE. 5.0) THEN

C      CALCULATE POSITION OF TIP OF HALF FEATHER

        POINTX(2) = POINTX(1) + 0.5 * FETHLENX + 0.0005
        POINTY(2) = POINTY(1) + 0.5 * FETHLENY + 0.0005

C      DRAW IN FEATHER

        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))

C      TELL LOOP TO QUIT

        DONE = .TRUE.
      ELSE
        DONE = .TRUE.
      END IF

C  IF THERE IS STILL MORE WIND MAGNITUDE (>= 5 KNOTS) LOOP AGAIN

      IF (.NOT. DONE) GOTO 10

C  RESET USER COORDINATES TO THE INCOMING VALUES

      CALL SET (FLSV,FRSV,FBSV,FTSV,ULSV,URSV,UBSV,UTSV,LLSV)

C****************************** SUBROUTINE END *************************

      RETURN
      END
