subroutine da_calc_flow_dependence_xa_adj_dual_res (ne, ep, grid, xa, vp, nobwin)

   !-----------------------------------------------------------------------
   ! Purpose: adjoint of calculating flow-dependent increments in model space (xa)
   !          for a certain sub-window for dual-resolution hybrid
   !-----------------------------------------------------------------------

   implicit none

   integer, intent(in)                  :: ne  ! Ensemble size.
   type (ep_type), intent(in)           :: ep  ! Ensemble perturbations.
   type (domain), intent(in)            :: grid  ! for getting grid dimensions
   type (x_type), intent(inout)         :: xa  ! Analysis increments
   type (vp_type), intent(inout)        :: vp  ! CV on grid structure.

   integer                              :: i, j, k, n ! Loop counters.
   real                                 :: alpha       ! Local alpha copy.
   integer, intent(in), optional        :: nobwin
   integer                              :: iobwin, ii
   real, allocatable, dimension(:,:,:)  :: output_u,output_v,output_t,output_q, output_p
   real, allocatable, dimension(:,:,:)  :: input_u,input_v,input_t,input_q,input_p
   real, allocatable, dimension(:,:,:)  :: output_qcw,output_qrn,output_qci,output_qsn, output_qgr
   real, allocatable, dimension(:,:,:)  :: input_qcw,input_qrn,input_qci,input_qsn,input_qgr

   integer  :: cids, cide, ckds, ckde, cjds, cjde, &
               cims, cime, ckms, ckme, cjms, cjme, &
               cips, cipe, ckps, ckpe, cjps, cjpe, &
               nids, nide, nkds, nkde, njds, njde, &
               nims, nime, nkms, nkme, njms, njme, &
               nips, nipe, nkps, nkpe, njps, njpe
   integer  :: nvar

#ifdef DM_PARALLEL
   ! HALO STUFF
   integer :: rsl_sendw_p, rsl_sendbeg_p, rsl_recvw_p, rsl_recvbeg_p
   integer :: rsl_sendw_m, rsl_sendbeg_m, rsl_recvw_m, rsl_recvbeg_m
   logical, external :: rsl_comm_iter
#endif

   if (trace_use) call da_trace_entry("da_calc_flow_dependence_xa_adj_dual_res")

   iobwin = 1
   if ( present(nobwin) ) then
      iobwin = nobwin
   end if

   ! Get coarse (ensemble) grid dimensions ( grid%intermediate_grid)
   CALL get_ijk_from_grid (  grid%intermediate_grid ,               &
                             cids, cide, cjds, cjde, ckds, ckde,    &
                             cims, cime, cjms, cjme, ckms, ckme,    &
                             cips, cipe, cjps, cjpe, ckps, ckpe    )

   ! Get fine (analysis) grid dimensions (grid)
   CALL get_ijk_from_grid (  grid,                                  &
                             nids, nide, njds, njde, nkds, nkde,    &
                             nims, nime, njms, njme, nkms, nkme,    &
                             nips, nipe, njps, njpe, nkps, nkpe   )

   !
   ! Allocate and initialize arrays
   !

   ! Input is hi-res domain
   allocate( input_u(nims:nime,nkms:nkme,njms:njme) )
   allocate( input_v(nims:nime,nkms:nkme,njms:njme) )
   allocate( input_t(nims:nime,nkms:nkme,njms:njme) )
   allocate( input_q(nims:nime,nkms:nkme,njms:njme) )
   allocate( input_p(nims:nime,1:1,njms:njme) )
   if ( alpha_hydrometeors ) then
      allocate( input_qcw(nims:nime,nkms:nkme,njms:njme) )
      allocate( input_qrn(nims:nime,nkms:nkme,njms:njme) )
      allocate( input_qci(nims:nime,nkms:nkme,njms:njme) )
      allocate( input_qsn(nims:nime,nkms:nkme,njms:njme) )
      allocate( input_qgr(nims:nime,nkms:nkme,njms:njme) )
   end if

   ! Output is low-res domain
   allocate( output_u(cims:cime,ckms:ckme,cjms:cjme) )
   allocate( output_v(cims:cime,ckms:ckme,cjms:cjme) )
   allocate( output_t(cims:cime,ckms:ckme,cjms:cjme) )
   allocate( output_q(cims:cime,ckms:ckme,cjms:cjme) )
   allocate( output_p(cims:cime,1:1,cjms:cjme) )
   if ( alpha_hydrometeors ) then
      allocate( output_qcw(cims:cime,ckms:ckme,cjms:cjme) )
      allocate( output_qrn(cims:cime,ckms:ckme,cjms:cjme) )
      allocate( output_qci(cims:cime,ckms:ckme,cjms:cjme) )
      allocate( output_qsn(cims:cime,ckms:ckme,cjms:cjme) )
      allocate( output_qgr(cims:cime,ckms:ckme,cjms:cjme) )
   end if

   output_u = 0. ; input_u = 0.
   output_v = 0. ; input_v = 0.
   output_t = 0. ; input_t = 0.
   output_q = 0. ; input_q = 0.
   output_p = 0. ; input_p = 0.
   if ( alpha_hydrometeors ) then
      output_qcw = 0. ; input_qcw = 0.
      output_qrn = 0. ; input_qrn = 0.
      output_qci = 0. ; input_qci = 0.
      output_qsn = 0. ; input_qsn = 0.
      output_qgr = 0. ; input_qgr = 0.
   end if

   !
   ! Get input (hi-res) data into (x,z,y) order for interpolation
   !

   do j = jte, jts, -1
      do k = kte, kts, -1
         do i = ite, its, -1
            input_u(i,k,j) = xa%u(i,j,k)
            input_v(i,k,j) = xa%v(i,j,k)
            input_t(i,k,j) = xa%t(i,j,k)
            input_q(i,k,j) = xa%q(i,j,k)
         end do
      end do
   end do

   input_p(:,1,:) = xa%psfc(:,:)

   if ( alpha_hydrometeors ) then
      do j = jte, jts, -1
         do k = kte, kts, -1
            do i = ite, its, -1
               input_qcw(i,k,j) = xa%qcw(i,j,k)
               input_qrn(i,k,j) = xa%qrn(i,j,k)
               input_qci(i,k,j) = xa%qci(i,j,k)
               input_qsn(i,k,j) = xa%qsn(i,j,k)
               input_qgr(i,k,j) = xa%qgr(i,j,k)
            end do
         end do
      end do
   end if ! alpha_hydrometeors

   write (unit=message(1),fmt='(A,2I8)')' istart, jstart = ',grid%i_parent_start, grid%j_parent_start
   call wrf_debug(2, message(1))
   write (unit=message(2),fmt='(A,4I8)')' grid%j_start(1), grid%j_end(1), jts_int, jte_int', grid%j_start(1), grid%j_end(1),jts_int,jte_int
   call wrf_debug(2, message(2))
   write (unit=message(3),fmt='(A,2F12.5)')' min/max  Input U = ',minval(input_u),maxval(input_u)
   call wrf_debug(2, message(3))
   !call da_message(message(1:3))

#ifdef DM_PARALLEL
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   !!!!!! DO HALO STUFF !!!!!!!!!!!!!!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   nvar = 4
   if ( alpha_hydrometeors ) then
      nvar = 9
   end if

   CALL rsl_comm_iter_init(4,njps,njpe)
   DO WHILE ( rsl_comm_iter( grid%id , grid%is_intermediate, 4 , &
                         0 , njds,njde,njps,njpe, grid%njds, grid%njde, &
                         rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p,   &
                         rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p    ))

      CALL RSL_LITE_INIT_EXCH ( local_communicator, 4, 0,          &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           nvar, 1, RWORDSIZE, &
           0, 0, IWORDSIZE, &
           0, 0, DWORDSIZE, &
           0, 0, LWORDSIZE, &
           myproc, ntasks, ntasks_x, ntasks_y,   &
           nips, nipe, njps, njpe, nkps, MAX(1,1,nkpe) )

        IF ( SIZE(input_u,1)*SIZE(input_u,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_u, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_v,1)*SIZE(input_v,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_v, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_t,1)*SIZE(input_t,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_t, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_q,1)*SIZE(input_q,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_q, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_p,1)*SIZE(input_p,2) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_p(:,1,:), 4,                                      &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XY, 0,                      &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, 1, 1,                           &
           nims, nime, njms, njme, 1, 1,                           &
           nips, nipe, njps, njpe, 1, 1   )
        ENDIF
if ( alpha_hydrometeors ) then
        IF ( SIZE(input_qcw,1)*SIZE(input_qcw,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qcw, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qrn,1)*SIZE(input_qrn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qrn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qci,1)*SIZE(input_qci,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qci, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qsn,1)*SIZE(input_qsn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qsn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qgr,1)*SIZE(input_qgr,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qgr, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
end if ! alpha_hydrometeors

        CALL RSL_LITE_EXCH_Y ( local_communicator , myproc, ntasks, ntasks_x, ntasks_y, &
                          rsl_sendw_m,  rsl_sendw_p, rsl_recvw_m,  rsl_recvw_p    )

        IF ( SIZE(input_u,1)*SIZE(input_u,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_u, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_v,1)*SIZE(input_v,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_v, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_t,1)*SIZE(input_t,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_t, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_q,1)*SIZE(input_q,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_q, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_p,1)*SIZE(input_p,2) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_p(:,1,:), 4,                                      &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XY, 0,                      &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, 1, 1,                           &
           nims, nime, njms, njme, 1, 1,                           &
           nips, nipe, njps, njpe, 1, 1   )
        ENDIF
if ( alpha_hydrometeors ) then
        IF ( SIZE(input_qcw,1)*SIZE(input_qcw,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qcw, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qrn,1)*SIZE(input_qrn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qrn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qci,1)*SIZE(input_qci,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qci, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qsn,1)*SIZE(input_qsn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qsn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qgr,1)*SIZE(input_qgr,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qgr, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 0, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
end if ! alpha_hydrometeors

      ENDDO

   CALL rsl_comm_iter_init(4,nips,nipe)
   DO WHILE ( rsl_comm_iter( grid%id , grid%is_intermediate, 4 , &
                         1 , nids,nide,nips,nipe, grid%nids, grid%nide, &
                         rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p,   &
                         rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p    ))

      CALL RSL_LITE_INIT_EXCH ( local_communicator, 4, 1,          &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           nvar, 1, RWORDSIZE, &
           0, 0, IWORDSIZE, &
           0, 0, DWORDSIZE, &
           0, 0, LWORDSIZE, &
           myproc, ntasks, ntasks_x, ntasks_y,   &
           nips, nipe, njps, njpe, nkps, MAX(1,1,nkpe) )

        IF ( SIZE(input_u,1)*SIZE(input_u,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_u, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_v,1)*SIZE(input_v,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_v, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_t,1)*SIZE(input_t,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_t, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_q,1)*SIZE(input_q,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_q, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_p,1)*SIZE(input_p,2) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_p(:,1,:), 4,                                      &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XY, 0,                      &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, 1, 1,                           &
           nims, nime, njms, njme, 1, 1,                           &
           nips, nipe, njps, njpe, 1, 1   )
        ENDIF
if ( alpha_hydrometeors ) then
        IF ( SIZE(input_qcw,1)*SIZE(input_qcw,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qcw, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qrn,1)*SIZE(input_qrn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qrn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qci,1)*SIZE(input_qci,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qci, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qsn,1)*SIZE(input_qsn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qsn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qgr,1)*SIZE(input_qgr,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qgr, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 0, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
end if ! alpha_hydrometeors

      CALL RSL_LITE_EXCH_X ( local_communicator , myproc, ntasks, ntasks_x, ntasks_y, &
                          rsl_sendw_m,  rsl_sendw_p, rsl_recvw_m,  rsl_recvw_p    )

        IF ( SIZE(input_u,1)*SIZE(input_u,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_u, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_v,1)*SIZE(input_v,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_v, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_t,1)*SIZE(input_t,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_t, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_q,1)*SIZE(input_q,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_q, 4,                                             &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_p,1)*SIZE(input_p,2) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_p(:,1,:), 4,                                      &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XY, 0,                      &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, 1, 1,                           &
           nims, nime, njms, njme, 1, 1,                           &
           nips, nipe, njps, njpe, 1, 1   )
        ENDIF
if ( alpha_hydrometeors ) then
        IF ( SIZE(input_qcw,1)*SIZE(input_qcw,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qcw, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qrn,1)*SIZE(input_qrn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qrn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qci,1)*SIZE(input_qci,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qci, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qsn,1)*SIZE(input_qsn,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qsn, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
        IF ( SIZE(input_qgr,1)*SIZE(input_qgr,3) .GT. 1 ) THEN
           CALL RSL_LITE_PACK ( local_communicator,                &
           input_qgr, 4,                                           &
           rsl_sendbeg_m, rsl_sendw_m, rsl_sendbeg_p, rsl_sendw_p, &
           rsl_recvbeg_m, rsl_recvw_m, rsl_recvbeg_p, rsl_recvw_p, &
           RWORDSIZE, 1, 1, DATA_ORDER_XZY, 0,                     &
           myproc, ntasks, ntasks_x, ntasks_y,                     &
           nids, nide, njds, njde, nkds, nkde,                     &
           nims, nime, njms, njme, nkms, nkme,                     &
           nips, nipe, njps, njpe, nkps, nkpe   )
        ENDIF
end if ! alpha_hydrometeors

   ENDDO

   !!!!!!!!! END HALO STUFF !!!!!!!!!!!!!!!!!!!!!!!!!!!
#endif

   !
   ! Now interpolate grid%xa from hi-res to low-res
   !
      !call da_message((/'Using adjoint of bilinear interpolation'/))
      do n=1,total_here
         do k = kts,kte
            output_u(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_u( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_u(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_u(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_u( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_u(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_u(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_u( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_u(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_u(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_u( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_u(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_v(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_v( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_v(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_v(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_v( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_v(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_v(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_v( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_v(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_v(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_v( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_v(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_t(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_t( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_t(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_t(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_t( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_t(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_t(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_t( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_t(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_t(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_t( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_t(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_q(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_q( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_q(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_q(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_q( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_q(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_q(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_q( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_q(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_q(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_q( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_q(ob_locs(n)%i+1,k,ob_locs(n)%j+1)
         end do

         output_p(ob_locs(n)%i  ,1,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_p( ob_locs(n)%xx,1,ob_locs(n)%yy) + output_p(ob_locs(n)%i  ,1,ob_locs(n)%j)
         output_p(ob_locs(n)%i+1,1,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_p( ob_locs(n)%xx,1,ob_locs(n)%yy) + output_p(ob_locs(n)%i+1,1,ob_locs(n)%j)
         output_p(ob_locs(n)%i  ,1,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_p( ob_locs(n)%xx,1,ob_locs(n)%yy) + output_p(ob_locs(n)%i  ,1,ob_locs(n)%j+1)
         output_p(ob_locs(n)%i+1,1,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_p( ob_locs(n)%xx,1,ob_locs(n)%yy) + output_p(ob_locs(n)%i+1,1,ob_locs(n)%j+1)

      end do

   if ( alpha_hydrometeors ) then
      do n=1,total_here
         do k = kts,kte
            output_qcw(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_qcw( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qcw(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_qcw(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_qcw( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qcw(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_qcw(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_qcw( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qcw(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_qcw(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_qcw( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qcw(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_qrn(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_qrn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qrn(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_qrn(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_qrn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qrn(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_qrn(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_qrn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qrn(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_qrn(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_qrn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qrn(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_qci(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_qci( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qci(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_qci(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_qci( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qci(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_qci(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_qci( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qci(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_qci(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_qci( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qci(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_qsn(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_qsn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qsn(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_qsn(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_qsn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qsn(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_qsn(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_qsn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qsn(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_qsn(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_qsn( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qsn(ob_locs(n)%i+1,k,ob_locs(n)%j+1)

            output_qgr(ob_locs(n)%i  ,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dxm  * input_qgr( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qgr(ob_locs(n)%i  ,k,ob_locs(n)%j)
            output_qgr(ob_locs(n)%i+1,k,ob_locs(n)%j)   = ob_locs(n)%dym * ob_locs(n)%dx   * input_qgr( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qgr(ob_locs(n)%i+1,k,ob_locs(n)%j)
            output_qgr(ob_locs(n)%i  ,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dxm  * input_qgr( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qgr(ob_locs(n)%i  ,k,ob_locs(n)%j+1)
            output_qgr(ob_locs(n)%i+1,k,ob_locs(n)%j+1) = ob_locs(n)%dy  * ob_locs(n)%dx   * input_qgr( ob_locs(n)%xx,k,ob_locs(n)%yy) + output_qgr(ob_locs(n)%i+1,k,ob_locs(n)%j+1)
         end do
      end do
   end if ! alpha_hydrometeors

   write (unit=message(1), fmt='(A,2F12.5)') ' min/max U  Input = ',minval(input_u),maxval(input_u)
   call wrf_debug(2, message(1))
   write (unit=message(2), fmt='(A,2F12.5)') ' min/max U Output = ',minval(output_u),maxval(output_u)
   call wrf_debug(2, message(2))
   write (unit=message(3), fmt='(A,2F12.5)') ' min/max V  Input = ',minval(input_v),maxval(input_v)
   call wrf_debug(2, message(3))
   write (unit=message(4), fmt='(A,2F12.5)') ' min/max V Output = ',minval(output_v),maxval(output_v)
   call wrf_debug(2, message(4))
   write (unit=message(5), fmt='(A,2F12.5)') ' min/max T  Input = ',minval(input_t),maxval(input_t)
   call wrf_debug(2, message(5))
   write (unit=message(6), fmt='(A,2F12.5)') ' min/max T Output = ',minval(output_t),maxval(output_t)
   call wrf_debug(2, message(6))
   write (unit=message(7), fmt='(A,2F12.5)') ' min/max Q  Input = ',minval(input_q),maxval(input_q)
   call wrf_debug(2, message(7))
   write (unit=message(8), fmt='(A,2F12.5)') ' min/max Q Output = ',minval(output_q),maxval(output_q)
   call wrf_debug(2, message(8))
   write (unit=message(9), fmt='(A,2F12.5)') ' min/max P  Input = ',minval(input_p),maxval(input_p)
   call wrf_debug(2, message(9))
   write (unit=message(10),fmt='(A,2F12.5)') ' min/max P Output = ',minval(output_p),maxval(output_p)
   call wrf_debug(2, message(10))
   !call da_message(message(1:10))

   !
   ! Now compute alpha on the low-res domain
   !

   !done outside this subroutine
   !vp % alpha = 0.0

   do n = ne, 1, -1
      ii = (iobwin-1)*ensdim_alpha + n

      if ( alpha_hydrometeors ) then
         do j = jte_int, jts_int, -1
            do k = kte_int, kts_int, -1
               do i = ite_int, its_int, -1
                  alpha = 0.0
                  alpha = alpha + ep % gr(i,j,k,ii) * output_qgr(i,k,j)
                  alpha = alpha + ep % sn(i,j,k,ii) * output_qsn(i,k,j)
                  alpha = alpha + ep % ci(i,j,k,ii) * output_qci(i,k,j)
                  alpha = alpha + ep % rn(i,j,k,ii) * output_qrn(i,k,j)
                  alpha = alpha + ep % cw(i,j,k,ii) * output_qcw(i,k,j)
                  vp % alpha(i,j,k,n) = vp % alpha(i,j,k,n) + alpha
               end do
            end do
         end do
      end if ! alpha_hydrometeors

      ! ps:
      vp % alpha(its_int:ite_int,jts_int:jte_int,1,n) =      &
           vp % alpha(its_int:ite_int,jts_int:jte_int,1,n) + &
           ep % v5(its_int:ite_int,jts_int:jte_int,1,ii) *   & ! v5 = ps
           output_p(its_int:ite_int,1,jts_int:jte_int)

      do j = jte_int, jts_int, -1
         do k = kte_int, kts_int, -1
            do i = ite_int, its_int, -1

                  alpha = 0.0
                  alpha = alpha + ep % v4(i,j,k,ii) * output_q(i,k,j)
                  alpha = alpha + ep % v3(i,j,k,ii) * output_t(i,k,j)
                  alpha = alpha + ep % v2(i,j,k,ii) * output_v(i,k,j)
                  alpha = alpha + ep % v1(i,j,k,ii) * output_u(i,k,j)

                  vp % alpha(i,j,k,n) = vp % alpha(i,j,k,n) + alpha

            end do
         end do
      end do
   end do !n loop

   ! Clean-up
   deallocate(output_u,output_v,output_t,output_q,output_p)
   deallocate(input_u,input_v,input_t,input_q,input_p)
   if ( alpha_hydrometeors ) then
      deallocate(output_qcw,output_qrn,output_qci,output_qsn,output_qgr)
      deallocate(input_qcw,input_qrn,input_qci,input_qsn,input_qgr)
   end if

   if (trace_use) call da_trace_exit("da_calc_flow_dependence_xa_adj_dual_res")

end subroutine da_calc_flow_dependence_xa_adj_dual_res

