      SUBROUTINE UFBQCP(LUNIT,QCP,NEMO)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    UFBQCP
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE READS IN A FXY DESCRIPTOR ENTRY (Y) FOR A
C   SEQUENCE DESCRIPTOR (F=3) WITH TABLE D CATEGORY 63 (X=63) WHEN THE
C   DESCRIPTOR IS KNOWN TO BE IN THE BUFR TABLE IN LOGICAL UNIT LUNIT,
C   AND RETURNS THE MNEMONIC ASSOCIATED WITH IT.  THIS ROUTINE WILL NOT
C   WORK FOR ANY OTHER TYPE OF DESCRIPTOR OR ANY OTHER SEQUENCE
C   DESCRIPTOR TABLE D CATEGORY.  LUNIT MUST ALREADY BE OPENED FOR
C   INPUT OR OUTPUT VIA A CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE
C   OPENBF.  THIS ROUTINE IS ESPECIALLY USEFUL WHEN THE CALLING PROGRAM
C   IS READING "EVENTS" FROM AN INPUT BUFR FILE IN LUNIT (USUALLY THE
C   "PREPBUFR" FILE) SINCE THE DESCRIPTOR ENTRY (Y) HERE DEFINES THE
C   EVENT PROGRAM CODE.  THUS, THE CALLING PROGRAM CAN OBTAIN THE
C   MNEMONIC NAME ASSOCIATED WITH AN EVENT PROGRAM CODE.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT"
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY
C
C USAGE:    CALL UFBQCP (LUNIT, QCP, NEMO)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C                (ASSOCIATED BUFR TABLE MAY BE INTERNAL OR EXTERNAL)
C     QCP      - REAL: SEQUENCE DESCRIPTOR ENTRY (I.E., EVENT PROGRAM
C                CODE) (Y IN FXY DESCRIPTOR)
C
C   OUTPUT ARGUMENT LIST:
C     NEMO     - CHARACTER*(*): MNEMONIC IN BUFR TABLE ASSOCIATED WITH
C                SEQUENCE DESCRIPTOR FXY WHERE F=3 AND X=63 AND
C                Y=INT(QCP)
C
C REMARKS:
C    THIS SUBROUTINE IS THE INVERSE OF BUFR ARCHIVE LIBRARY ROUTINE
C    UFBQCD.
C
C    THIS ROUTINE CALLS:        BORT     IFXY     NUMTAB   STATUS
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      CHARACTER*(*) NEMO
      CHARACTER*1   TAB

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(IL.EQ.0) GOTO 900

      IDN = IFXY('363000')+IFIX(QCP)
c  .... get NEMO from IDN
      CALL NUMTAB(LUN,IDN,NEMO,TAB,IRET)

C  EXITS
C  -----

      RETURN
900   CALL BORT('BUFRLIB: UFBQCP - BUFR FILE IS CLOSED, IT MUST BE'//
     . ' OPEN')
      END
