#!/bin/csh

foreach case ( global jan00 jun01 chem )

	echo case = $case
	set prog = geogrid
	echo "	$prog"
	cp namelist.wps_$case namelist.wps
	${prog}.exe >&! print_${case}_${prog}.log

	set ok = $status
	if ( $ok != 0 ) then
		echo "     ==> problems in $prog"
		exit ( 1 )
	endif

	set prog = ungrib
	echo "	$prog"
	./link_grib.csh /mmm/users/gill/WRF_regression_data/RAW_GRIB_DATA/${case}/*
	cp Vtable_$case Vtable
	${prog}.exe >&! print_${case}_${prog}.log

	set ok = $status
	if ( $ok != 0 ) then
		echo "     ==> problems in $prog"
		exit ( 2 )
	endif

	set prog = metgrid
	echo "	$prog"
	${prog}.exe >&! print_${case}_${prog}.log

	set ok = $status
	if ( $ok != 0 ) then
		echo "     ==> problems in $prog"
		exit ( 3 )
	endif

	set prog = clean_up
	echo "	$prog"
	mv met_em* /mmm/users/gill/WRF_regression_data/processed/$case

	set ok = $status
	if ( $ok != 0 ) then
		echo "     ==> problems in $prog"
		exit ( 4 )
	endif

	rm FILE* 
	rm PFILE* 
	rm GRIB* 

	rm geo_em*

	echo " " 
end
