!-------------------------------------------------------------------------------
! Configure subroutine interface argument lists for subroutine ADVPNT     
! Last Revised: 07 Sep 2001 (RRD) - simultaneous multiple meteorology
!               26 Feb 2002 (RRD) - downward shortwave flux: metinp, advmet
!               21 May 2002 (RRD) - divergence options: metwnd
!               23 Jul 2002 (RRD) - terrain correction eta: metwnd
!               10 Apr 2003 (RRD) - advmet, adviec temporal interpolation
!               16 Sep 2003 (RRD) - added routine advsfc
!               10 Nov 2003 (RRD) - velocity variances through metinp
!               25 Oct 2004 (RRD) - pass through tratio
!               12 Oct 2005 (RRD) - added routine adviso
!               08 Mar 2006 (RRD) - static stability (prfcom, advmet)
!               22 May 2006 (RRD) - mixed layer depth (metinp)
!               21 Nov 2006 (RRD) - day night tke partition
!               04 Jun 2008 (RRD) - additional mixing options prfcom
!               20 Mar 2009 (RRD) - fraction cloud to metinp
!               04 Apr 2009 (RRD) - inout for surface wind and temp
!               24 Jan 2011 (GDR) - inout for 2 meter RH
!               29 Aug 2011 (RRD) - temporal averaging flag for velocities
!               01 Nov 2011 (RRD) - conversion ICHEM to argument advmet
!                  Sep 2012 (FN)  - WRF-HYSPLIT coupling
!-------------------------------------------------------------------------------

INTERFACE

!-------------------------------------------------------------------------------
  SUBROUTINE ADVIEC(XU,XV,XW,XX,YY,ZZ,ZX,DT,            &
                    ids , ide , jds , jde , kds , kde , &
                    ims , ime , jms , jme , kms , kme , &
                    ips , ipe , jps , jpe , kps , kpe   )
  IMPLICIT NONE
  REAL,    INTENT(IN)    :: dt              ! integration step (minutes)
  REAL,    INTENT(INOUT) :: xx,yy,zz        ! old (t) and new (t+dt) position
  REAL,    INTENT(OUT)   :: zx              ! last estimate of vertical index
  INTEGER, INTENT(IN)    ::  ids , ide , jds , jde , kds , kde , &
                             ims , ime , jms , jme , kms , kme , &
                             ips , ipe , jps , jpe , kps , kpe
  REAL, DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: xu,xv,xw
  END SUBROUTINE adviec
!-------------------------------------------------------------------------------
  SUBROUTINE ADVMET(METZ,METO,VMIX,CDEP,RDEP,TRAJ,DSWF,XP,YP,     &
                    KCYCLE,NLVL,ICHEM,XGX,XGY,XZ0,XLU,XZT,        &
                    XXA,XXT,XXQ,XXP,XLVLZZ,XXE,XXX,XXH,           &
                    XCOLMS,XU0,XV0,XSS,XT0,XP0,XH0,XUF,XVF,XSF,   &
                    XZI,XRT,XCF,XDS,                              &
                    ids, ide, jds, jde, kds, kde,    &
                    ims, ime, jms, jme, kms, kme,    &
                    ips, ipe, jps, jpe, kps, kpe     )
  IMPLICIT NONE
  INCLUDE 'DEFMETO.INC'
  TYPE(bset),INTENT(OUT)   :: metz (:)   ! profile advection variables
  TYPE(aset),INTENT(INOUT) :: meto       ! surface advection variables
  LOGICAL,   INTENT(IN)    :: vmix,cdep,rdep,traj
  LOGICAL,   INTENT(IN)    :: dswf          ! downward shortwave flag
  REAL,      INTENT(IN)    :: xp,yp
  INTEGER,   INTENT(IN)    :: kcycle,nlvl
  INTEGER,   INTENT(IN)    :: ichem         ! special conversion options
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN)   :: xgx,xgy,  &
                                                    xz0,xlu,xzt
  REAL, DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: xxa,xxt,xxq,xxp,   &
                                                          xlvlzz,xxe,xxx,xxh
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN)   :: xcolms,       &
                                                    xu0,xv0,xss,  &
                                                    xt0,xp0,xh0,  &
                                                    xuf,xvf,xsf,  &
                                                    xzi,xrt,xcf,xds
  INTEGER, INTENT(IN)    ::  ids , ide , jds , jde , kds , kde , &
                             ims , ime , jms , jme , kms , kme , &
                             ips , ipe , jps , jpe , kps , kpe
  END SUBROUTINE advmet
!-------------------------------------------------------------------------------
  SUBROUTINE PRFCOM(VSCALE,HSCALE,TKERD,TKERN,KSFC,XGX,XGY,XZ0,XZT, &
                    VMIX,KMIXD,KMIX0,XZI,XP0,XT0,XU0,XV0,       &
                    XUF,XVF,XHF,XSF,XSS,XXU,XXV,XXW,            &
                    XXA,XXT,XXQ,XXP,XLVLZZ,XXE,XXH,XXX,         &
                    ids, ide, jds, jde, kds, kde,    &
                    ims, ime, jms, jme, kms, kme,    &
                    ips, ipe, jps, jpe, kps, kpe    )
  IMPLICIT NONE
  INCLUDE 'DEFGRID.INC' ! meteorological array
  INCLUDE 'DEFARG4.INC' ! interface statements for local subroutines
  REAL,    INTENT(IN)    :: vscale     ! vertical Lagrangian time scale (sec)  !FN-20140610
  REAL,    INTENT(IN)    :: hscale     ! horizontal Lagrangian time scale (sec)!FN-20140610 
  REAL,    INTENT(IN)    :: tkerd      ! day turbulent kinetic eneregy ratio
  REAL,    INTENT(IN)    :: tkern      ! night turbulent kinetic eneregy ratio
  INTEGER, INTENT(IN)    :: ksfc       ! index top of the sfc layer
  LOGICAL, INTENT(IN)    :: vmix       ! indicator for mixing computation
  INTEGER, INTENT(IN)    :: kmixd      ! mixed layer depth options
  INTEGER, INTENT(IN)    :: kmix0      ! minimum mixing depth
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN)   :: xgx,  &
                                                    xgy,  &
                                                    xz0,  &
                                                    xzt
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(INOUT) :: xzi,               &
                                                     xp0,xt0,xu0,xv0,   &
                                                     xuf,xvf,xsf,xss
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN)    :: xhf
  REAL, DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(INOUT) :: xxu,xxv,xxw,       &
                                                             xxa,xxt,xxq,xxp,   &
                                                             xxe,xxh,xxx,xlvlzz
  INTEGER, INTENT(IN)    ::  ids , ide , jds , jde , kds , kde , &
                             ims , ime , jms , jme , kms , kme , &
                             ips , ipe , jps , jpe , kps , kpe
  END SUBROUTINE prfcom
!-------------------------------------------------------------------------------
END INTERFACE
