!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  AVGCON           CONcentration SUMmation puffs or particles
!   PRGMMR:    ROLAND DRAXLER   ORG: R/ARL       DATE:96-06-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: ...
!                 07 Jan 2014 (FN) - vertical coupling
!                 15 May 2014 (FN) - change min => sec
!                 28 May 2014 (FN) - add KMSL=1 opt
!                 01 Jul 2015 (FN) - clean up
!
!$$$

SUBROUTINE AVGCON(conc,numgrd,xpar,ypar,zagl,dt,jet,zsfc,kmsl,         &
                  cgsize,mass,dept,sigh,sigw,hdwp,ptyp,                & 
                  xsum,ims,ime,jms,jme )

  USE metval

  IMPLICIT NONE 

  INCLUDE 'DEFCONC.INC'             ! pollutant and concentration grid

!-------------------------------------------------------------------------------
! argument list definitions
!-------------------------------------------------------------------------------

  TYPE(cset), INTENT(IN) :: conc(:)           ! for each concentration grid 
  INTEGER, INTENT(IN)    :: numgrd            ! number of concentration grids
  REAL,    INTENT(IN)    :: xpar,ypar         ! particle position x & y of WRF grid
  REAL,    INTENT(IN)    :: zagl              ! particle position at height (m)
  REAL,    INTENT(IN)    :: dt                ! time step (min)
  REAL,    INTENT(IN)    :: zsfc              ! height of ground surface (m)
  INTEGER, INTENT(IN)    :: kmsl              ! agl=0 or msl=1 height units
  REAL,    INTENT(INOUT) :: cgsize            ! minimum sampling grid size (km)
  REAL,    INTENT(IN)    :: mass (:)          ! mass of pollutant 
  REAL,    INTENT(IN)    :: dept (:)          ! deposition amount of mass
  REAL,    INTENT(IN)    :: sigh,sigw         ! horiz (m) and vert sigma (sigma)
  INTEGER, INTENT(IN)    :: hdwp              ! horiz distribution in pollutant
  INTEGER, INTENT(IN)    :: ptyp              ! pollutant type index number
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  INTEGER,   INTENT(IN)                           :: ims , ime , jms , jme
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(INOUT) :: xsum

!-------------------------------------------------------------------------------
! internal variable definitions
!-------------------------------------------------------------------------------

  REAL,   PARAMETER      :: sigr   = 1.54         ! distribution
  REAL,   PARAMETER      :: ympd   = 111198.323   ! meters/deg 
  REAL,   PARAMETER      :: twopi  = 6.283185     ! Gaussian constants (2 PI)
  REAL,   PARAMETER      :: PI     = 3.14159265358979
  REAL,   PARAMETER      :: DGPR   = 180.0/PI  ! deg per radian

  INTEGER                :: ksb,ksd
  REAL                   :: xmpd,zpar,radius
  INTEGER                :: kt,kg,ii,jj,i1,i2,j1,j2
  REAL                   :: dfxy0,dfxyz,zbot,ztop
  REAL                   :: vdist,sfact,glon,gfact
  REAL                   :: xp,yp,xi1,yj1,xi2,yj2
  REAL                   :: cval,clat,clon,delx,dely,dist
  INTEGER                :: kl,kk,nlvl,maxdim
  REAL                   :: pbot,ptop

!-------------------------------------------------------------------------------

  IF(HDWP.EQ.6) RETURN        ! 10/12/05 lagrangian sampling option uses CONPAR
  KT=PTYP                     ! pollutant type (over-ride if MAXDIM>1)
  MAXDIM = SIZE (mass,1)      ! number of species per single particle

!-------------------------------------------------------------------------------
! main loop through the number of concentration grids and set grid factors
!-------------------------------------------------------------------------------

  KG=1    !FN-20140909

    IF(INT(DT).GT.0)THEN
       KSB=JET-CONC(KG)%START%SACC
    ELSE
       KSB=CONC(KG)%START%SACC-JET
    END IF
    KSD=ABS(CONC(KG)%STOP%SACC-CONC(KG)%START%SACC)

!!   test for time within sampling interval
!    IF(KSB.LT.0.OR.KSB.GE.KSD) CYCLE gloop
    IF(KSB.LT.0.OR.KSB.GE.KSD) RETURN

    IF(CONC(KG)%SNAP.EQ.0)THEN
!      factors for integrations per sampling interval
       SFACT=ABS(DT)/CONC(KG)%DELTA%SACC
    ELSEIF(CONC(KG)%SNAP.EQ.1)THEN
!      no factor required for snapshot maps
       SFACT=1.0
    ELSEIF(CONC(KG)%SNAP.EQ.2)THEN
!!      maximum value set in calling program
!       CYCLE gloop
        RETURN                  !FN-20140909
    ELSEIF(CONC(KG)%SNAP.LT.0)THEN
!      shorter averaging time options
       SFACT=ABS(DT)/ABS(CONC(KG)%SNAP)
    ELSE
!      unsupported option default to averaging
       SFACT=ABS(DT)/CONC(KG)%DELTA%SACC
    END IF

!-------------------------------------------------------------------------------
!   vertical plume factors
!-------------------------------------------------------------------------------

    ZPAR=ZAGL

    !FN-20140528
    IF(KMSL.EQ.1) ZPAR=ZAGL+ZSFC ! adjust vertical units MSL rather than AGL

!-------------------------------------------------------------------------------
!   find the grid position on current concentration grid
!-------------------------------------------------------------------------------

    XI1=FLOAT(NINT(XPAR))
    YJ1=FLOAT(NINT(YPAR))
    XI2=XI1
    YJ2=YJ1
 
!   convert real grid to nearest integer value
    I1=INT(XI1)
    I2=NINT(XI2)
    J1=INT(YJ1)
    J2=NINT(YJ2)

!-------------------------------------------------------------------------------
! second nested loop for species
!-------------------------------------------------------------------------------

  sloop: DO KK=1,MAXDIM

!   grid pollutant species (kt) must match particle pollutant species (kk)
    IF(MAXDIM.GT.1)KT=KK  ! defaults (kt=ptyp) if multiple species not defined

!-------------------------------------------------------------------------------
! third nested loop for levels  
!-------------------------------------------------------------------------------

  ZBOT=0.0

    ZTOP=FLOAT(CONC(KG)%HEIGHT(1))   !FN-20140909, check
    VDIST=MAX(ZTOP-ZBOT,1.0)         ! particle type

!!-------------------------------------------------------------------------------
!! loop through grid (sampling) points within plume
!!-------------------------------------------------------------------------------
!
  jloop : DO JJ=J1,J2
  iloop : DO II=I1,I2

      GFACT=1.0
      IF(ZPAR.GT.ZBOT.AND.ZPAR.LE.ZTOP)THEN
         CVAL=MASS(KK)*SFACT*GFACT/(VDIST*CELLA(II,JJ))
         XSUM(II,JJ)=XSUM(II,JJ)+CVAL
      ELSE
         CYCLE iloop
      END IF
   
  END DO iloop
  END DO jloop

  ZBOT=ZTOP

  END DO sloop

END SUBROUTINE avgcon
