!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  CONZRO           CONcentration array set to ZeRO
!   PRGMMR:    ROLAND DRAXLER   ORG: R/ARL       DATE:96-06-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!   MATRIX ELEMENTS ARE SET TO ZERO FOR THE NEXT CYLCE ACCUMULATION.
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: ...
!                 15 May 2014 (FN) - change min => sec
!                 01 Jul 2015 (FN) - clean up
!
!$$$

SUBROUTINE CONZRO(conc,numgrd,dt,jet,ifhr,csum)
  
  IMPLICIT NONE

  INCLUDE 'DEFCONC.INC'           ! pollutant and concentration grid

!-------------------------------------------------------------------------------
! argument list definitions
!-------------------------------------------------------------------------------

  TYPE(cset), INTENT(INOUT)   :: conc(:)             ! each concentration grid 
  INTEGER,     INTENT(IN)     :: numgrd              ! number of concen grids
  REAL,        INTENT(IN)     :: dt                  ! time step (min)
  INTEGER,     INTENT(IN)     :: ifhr                ! current forecast hour
  REAL,        INTENT(INOUT)  :: csum (:,:,:,:,:)    ! summation matrix
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515

!-------------------------------------------------------------------------------
! internal variables definitions
!-------------------------------------------------------------------------------

  INTEGER                     :: ksb,ksd
  INTEGER                     :: kg,mtime
  INTEGER                     :: iyr,imo,ida,ihr,imn
  INTEGER                     :: mjet

  INTERFACE
!-------------------------------------------------------------------------------
  SUBROUTINE TM2DAY(MACM,IY,IM,ID,IH,MN)
  IMPLICIT NONE
  INTEGER,   INTENT(IN)    :: macm            ! accumulate minutes
  INTEGER,   INTENT(OUT)   :: iy,im,id,ih,mn  ! current date/time
  END SUBROUTINE tm2day
!-------------------------------------------------------------------------------
  END INTERFACE

!-------------------------------------------------------------------------------
! go through each grid
!-------------------------------------------------------------------------------

  gloop : DO KG=1,NUMGRD

!FN-20140515
    IF(CONC(KG)%SNAP.EQ.1)THEN
       MJET=INT((JET+INT(DT))/60)
    ELSE
       MJET=INT(JET/60)
    END IF
    print *,'sss conzro mjet=',mjet,jet
    CALL TM2DAY(MJET,IYR,IMO,IDA,IHR,IMN)


!FN-20140515
!   sample start stop
    IF(INT(DT).GT.0)THEN
       KSB=JET-CONC(KG)%START%SACC
    ELSE
       KSB=CONC(KG)%START%SACC-JET
    END IF
    KSD=ABS(CONC(KG)%STOP%SACC-CONC(KG)%START%SACC)

!   test for time within sampling interval
    IF(KSB.LT.0.OR.KSB.GE.KSD) CYCLE gloop

!   zero data array according to the type of averaging for each grid 

!FN-20140515
    IF(CONC(KG)%SNAP.EQ.0)THEN
!      with averaging (SNAP=0) the current time must be at the output interval
       MTIME=ABS(JET-CONC(KG)%START%SACC)
       IF(MOD(MTIME,CONC(KG)%DELTA%SACC).NE.0) CYCLE gloop

    ELSEIF(CONC(KG)%SNAP.EQ.2)THEN
!      for maximum values current time must be at the output interval
       MTIME=ABS(JET-CONC(KG)%START%SACC)
       IF(MOD(MTIME,CONC(KG)%DELTA%SACC).NE.0) CYCLE gloop

    ELSEIF(CONC(KG)%SNAP.LT.0)THEN
!      with shortened averaging time option zero out summation array
!      at ABS(SNAP) minutes prior to the end of the averaging period
       MTIME=ABS(JET+ABS(CONC(KG)%SNAP)-CONC(KG)%START%SACC)
       IF(MOD(MTIME,CONC(KG)%DELTA%SACC).NE.0) CYCLE gloop

    ELSE
!      with snapshot maps (SNAP=1) always zero out array
       CONTINUE
    END IF

!   zero out that level pollutant (3/6/2002)
    csum(:,:,:,:,KG) = 0.0

!   save end time as start of next sampling period
    CONC(KG)%NOW%YR=IYR
    CONC(KG)%NOW%MO=IMO
    CONC(KG)%NOW%DA=IDA
    CONC(KG)%NOW%HR=IHR
    CONC(KG)%NOW%MN=IMN
    CONC(KG)%NOW%IC=IFHR

    print *,'sss conzro iyr=',IYR,IMO,IDA,IHR,IMN

  END DO gloop

END SUBROUTINE conzro 
