!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  eta2ht           compute height for given fractional vertical index
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:13-08-12
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!
! USAGE:  call eta2ht(aa,wgt)
!
!   INPUT ARGUMENT LIST:      see below
!   OUTPUT ARGUMENT LIST:     see below
!   INPUT FILES:              none
!   OUTPUT FILES:             none
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!
!$$$
   
subroutine eta2ht(x1,y1,z1,agl)

  USE metval

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------

  real, intent(in)   :: x1,y1   ! particle position in grid index
  real, intent(in)   :: z1      ! particle position in eta coordinate
  real, intent(out)  :: agl     ! corresponding AGL

  real               :: zx

!-------------------------------------------------------------------------------
  INTERFACE
  SUBROUTINE ADV3NT(S,X1,Y1,ZX,SS,ims,ime,jms,jme,kms,kme)
  IMPLICIT NONE
  REAL,      INTENT(IN)    :: x1,y1         ! position of interpolated value
  REAL,      INTENT(IN)    :: zx            ! vertical interpolation fraction
  REAL,      INTENT(OUT)   :: ss            ! value of S at x1,y1,z1
  INTEGER,   INTENT(IN)    :: ims , ime , jms , jme , kms , kme
  REAL, DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: s
  END SUBROUTINE adv3nt
  END INTERFACE
!-------------------------------------------------------------------------------

   CALL ETA2ZX(Z1,ZX)

   CALL ADV3NT(LVLZZ,X1,Y1,ZX,AGL,mdims(1),mdims(2),mdims(3),mdims(4),mdims(5),mdims(6))

RETURN
end subroutine eta2ht
