!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  eta2zx           compute fractional index for given eta
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:14-02-20
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!
! USAGE:  call eta2zx(eta,zx)
!
!   INPUT ARGUMENT LIST:      see below
!   OUTPUT ARGUMENT LIST:     see below
!   INPUT FILES:              none
!   OUTPUT FILES:             none
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!
!$$$
   
subroutine eta2zx(eta,zx)

  USE metval

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------

  real, intent(in)   :: eta     ! particle's vertical position (eta)
  real, intent(out)  :: zx      ! corresponding fractional index

  integer            :: idx1,idx2
  integer            :: kk

!-------------------------------------------------------------------------------

     IDX1=1
     DO KK=1,NETA
        IDX2=KK
        IF (ETA .GE. HYETA(KK)) GOTO 2999
        IDX1=KK
     END DO
     2999 CONTINUE

     IF (IDX1 .EQ. IDX2) THEN
        ZX=IDX1
     ELSE
        ZX=FLOAT(IDX1)+((FLOAT(IDX2)-FLOAT(IDX1))*(ETA-HYETA(IDX1))/(HYETA(IDX2)-HYETA(IDX1)))
     ENDIF

RETURN
end subroutine eta2zx
