!-----------------------------------------------------------
! Module to define FORTRAN I/O Unit Numbers 
!-----------------------------------------------------------
! Last Revised: 01 Apr 2004 (RRD) - initial version 
!               15 Jun 2005 (RRD) - split control & message
!               25 Jul 2008 (RRD) - gem routines
!               01 Jun 2011 (RRD) - particle file (KF20)
!               25 Jul 2011 (BS)  - vertical mass distribution file (KF30)
!-----------------------------------------------------------

MODULE funits
   
  INTEGER, PARAMETER :: KF01 = 10 ! Meteorological base 
  INTEGER, PARAMETER :: KF02 = 49 ! Meteorological maximum

  INTEGER, PARAMETER :: KF11 = 60 ! Conc or Traj base    
  INTEGER, PARAMETER :: KF12 = 69 ! Concentration maximum

  INTEGER, PARAMETER :: KF20 = 76 ! PARTICLE.DAT 
  INTEGER, PARAMETER :: KF21 = 70 ! MESSAGE 
  INTEGER, PARAMETER :: KF22 = 71 ! STARTUP  
  INTEGER, PARAMETER :: KF23 = 72 ! Particle Dump Input
  INTEGER, PARAMETER :: KF24 = 73 ! Particle Dump Output
  INTEGER, PARAMETER :: KF25 = 74 ! CONTROL 
  INTEGER, PARAMETER :: KF26 = 75 ! namelist: SETUP.CFG
  INTEGER, PARAMETER :: KF30 = 83 ! VMSDIST		! kf number and 83 out of order in this list

  INTEGER, PARAMETER :: KF27 = 87 ! GEM concentration output
  INTEGER, PARAMETER :: KF28 = 88 ! GEM concentration dump
  INTEGER, PARAMETER :: KF29 = 89 ! GEM integrated profile 

  INTEGER, PARAMETER :: KF41 = 77 ! Landuse & ASCDATA.CFG
  INTEGER, PARAMETER :: KF42 = 78 ! Roughness length
  INTEGER, PARAMETER :: KF43 = 79 ! Terrain height

  INTEGER, PARAMETER :: KF31 = 80 ! Gridded emission array
  INTEGER, PARAMETER :: KF32 = 81 ! Temporal emission values
  INTEGER, PARAMETER :: KF33 = 82 ! IER | CHEM | PRCHEM

  INTEGER, PARAMETER :: KF50 = 90 ! lagrangian: LAGSET.CFG
  INTEGER, PARAMETER :: KF51 = 91 ! lagrangian: min out file
  INTEGER, PARAMETER :: KF52 = 99 ! lagrangian: max out file

END MODULE funits 
