!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  ht2eta           compute fractional eta according to height
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:13-07-17
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!
! USAGE:  call ht2eta(aa,wgt)
!
!   INPUT ARGUMENT LIST:      see below
!   OUTPUT ARGUMENT LIST:     see below
!   INPUT FILES:              none
!   OUTPUT FILES:             none
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!
!$$$
   
subroutine ht2eta(x1,y1,hgt,eta)

  USE metval

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------

  real, intent(in)   :: x1,y1   ! particle position in grid index
  real, intent(in)   :: hgt     ! particle position in height (m, above ground level)
  real, intent(out)  :: eta     ! corresponding eta value

!-------------------------------------------------------------------------------
! internal variables
!-------------------------------------------------------------------------------

  real, allocatable        :: vlay(:) ! WRF eta levels
  integer                  :: nn      ! number of levels in subgrid

  INTEGER                  :: kk
  real                     :: ht1,ht2
  integer                  :: idx1,idx2
  real                     :: stmp

!-------------------------------------------------------------------------------
  INTERFACE
  SUBROUTINE ADV2NT(S,X1,Y1,SS,ims,ime,jms,jme,kms,kme)
  IMPLICIT NONE
  REAL,      INTENT(IN)    :: x1,y1         ! position of interpolated value
  REAL,      INTENT(OUT)   :: ss            ! value of S at x1,y1,z1
  INTEGER,   INTENT(IN)    :: ims , ime , jms , jme , kms , kme
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN) :: s
  END SUBROUTINE adv2nt
  END INTERFACE
!-------------------------------------------------------------------------------

  IDX1=1
  DO KK=1,NETA

       CALL ADV2NT(LVLZZ(:,KK,:),X1,Y1,STMP,mdims(1),mdims(2),mdims(3),mdims(4),mdims(5),mdims(6))

       HT2  = STMP
       IDX2 = KK

       IF (STMP .GE. HGT) GOTO 2999

       HT1  = STMP
       IDX1 = KK

  END DO

  2999 CONTINUE

  !FN-20140122
  IF (IDX1 .EQ. IDX2) THEN
     ETA = ETAF(IDX1)
  ELSE
     ETA = HYETA(IDX1)+((HYETA(IDX2)-HYETA(IDX1))*(HGT-HT1)/(HT2-HT1))
  ENDIF

  ETA = MIN(1.0,MAX(0.0,ETA))

RETURN
end subroutine ht2eta
