!WRF-HYSPLIT main interface
!Base on hymodelw.F
!
!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  HYMAIN           HYsplit MAIN subroutine
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:12-08-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: 03 Aug 2012 (FN) - WRF-HYSPLIT coupling initial implementation
!                 28 Aug 2013 (FN) - save time and met variables
!                 28 Oct 2013 (FN) - modify for eta coordinate
!                 28 Mar 2014 (FN) - clean up
!                 15 Apr 2014 (FN) - modify based on hymain.F for tight coupling
!                 10 Jun 2014 (FN) - Merge SETUP to namelist.input
!                 26 Sep 2014 (FN) - clean up
!                 03 Jun 2015 (FN) - include more variables for hyconc.F
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!   MACHINE:  IBM RS6000
!
!$$$

  SUBROUTINE hymain ( grid , config_flags )

    USE metval

    USE module_domain
    USE module_configure
    USE module_em

    IMPLICIT NONE

!-------------------------------------------------------------------------------
! WRF related variables
!-------------------------------------------------------------------------------

    TYPE(proj_info)         :: proj

    ! input data
    TYPE(domain)            :: grid

    !  Structure that contains run-time configuration (namelist) data for domain
    TYPE(grid_config_rec_type) , INTENT(IN)          :: config_flags

    INTEGER                         :: ids , ide , jds , jde , kds , kde , &
                                       ims , ime , jms , jme , kms , kme , &
                                       ips , ipe , jps , jpe , kps , kpe

    integer  :: ii,kk

    real :: dtmp

!-------------------------------------------------------------------------------

  print *,'aaa hysp/hymain  ===================================================='
  print *,'aaa time_step=',config_flags%time_step,grid%dt

  CALL get_ijk_from_grid (  grid ,                           &
                            ids, ide, jds, jde, kds, kde,    &
                            ims, ime, jms, jme, kms, kme,    &
                            ips, ipe, jps, jpe, kps, kpe     )

!-------------------------------------------------------------------------------
! meteorological data header
!-------------------------------------------------------------------------------

  !FN-20140610
  CALL METINI(grid,config_flags)

  call trajmapproj(grid,config_flags,proj)

!-------------------------------------------------------------------------------
! read meteorological data
!-------------------------------------------------------------------------------

  !FN-20140610
  CALL METDUM(grid,config_flags)

!-------------------------------------------------------------------------------
! call HYSPLIT as a subroutine
!-------------------------------------------------------------------------------

  print *,'aaa hymacc=',grid%hvar%hymacc,grid%hvar%emmacc,config_flags%run_traj
  CALL HYCONC(hyeta, neta, grid%hycsum, grid%hyxpos, grid%hyypos, grid%hyzpos,   &
                                        grid%hyolat, grid%hyolon, grid%hyohgt,   &
              ids , ide , jds , jde,                                             &
              ims , ime , jms , jme,                                             &
              ips , ipe , jps , jpe, proj, isfc, config_flags%run_traj,          &
              grid%dt,            config_flags%initd, config_flags%kpuff,                        &
              config_flags%khmax, config_flags%numpar,config_flags%maxpar,config_flags%nbptyp,   &
              config_flags%qcycle,config_flags%kdef,  config_flags%kzmix, config_flags%kbls,     &
              config_flags%kblt,  config_flags%vscale,config_flags%hscale,config_flags%tvmix,    &
              config_flags%tkerd, config_flags%tkern, config_flags%kmix0, config_flags%kmixd,    &
              config_flags%ninit, config_flags%ndump, config_flags%ncycl, config_flags%conage,   &
              config_flags%kmsl,  config_flags%ichem, config_flags%cpack, config_flags%cmass,    &
              config_flags%kspl,  config_flags%krnd,  config_flags%frhmax,config_flags%splitf,   &
              config_flags%frhs,  config_flags%frvs,  config_flags%frts,  config_flags%dxf,      &
              config_flags%dyf,   config_flags%dzf,                                              &
              config_flags%numloc,config_flags%numtyp,config_flags%numgrd,config_flags%numhgt,   &
              config_flags%numpol,config_flags%numems,config_flags%efile,                        &
              grid%hvar%hymacc,   grid%hvar%hylat,    grid%hvar%hylon,    grid%hvar%hylvl, &
              grid%hvar%emmacc,   grid%hvar%ident,    grid%hvar%qrate,    grid%hvar%qhrs,  &
              grid%hvar%cnstma,   grid%hvar%cnenma,   grid%hvar%cnlat,    grid%hvar%cnlon, & 
              grid%hvar%dellat,   grid%hvar%dellon,   grid%hvar%splat,    grid%hvar%splon, & 
              grid%hvar%cnhgt,    grid%hvar%snap,     grid%hvar%cndhr,    grid%hvar%cndmn, &
              grid%hvar%pdiam,    grid%hvar%pdens,    grid%hvar%shape,    grid%hvar%dryvl, &
              grid%hvar%gpmol,    grid%hvar%acvty,    grid%hvar%difty,    grid%hvar%henry, &
              grid%hvar%wetgs,    grid%hvar%wetin,    grid%hvar%wetlo,    grid%hvar%rhalf, grid%hvar%srate, &
              grid%evar%nmsst,    grid%evar%nmsen,    grid%evar%emlat,    grid%evar%emlon, &
              grid%evar%emlvl,    grid%evar%erate,    grid%evar%earea,    grid%evar%eheat  )

 print *,'aaa end of hymain => return back to WRF!'
 RETURN
 END SUBROUTINE hymain
