!WRF:MEDIATION_LAYER:IO
!
!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  HYRCTL           Read ConTroL FiLe
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:07-10-14
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: 03 Aug 2012 (FN) - WRF-HYSPLIT coupling
!                 01 Jul 2015 (FN) - clean up
!
! USAGE:  CALL hyrctl ( grid , config_flags )
!     
!   INPUT ARGUMENT LIST:    see below
!   OUTPUT ARGUMENT LIST:   see below
!   INPUT FILES:            CONTRL
!   OUTPUT FILES:           none
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!   MACHINE:  IBM RS6000
!
!$$$

  subroutine hyrctl ( grid , config_flags )

    use module_domain
    use module_configure

    implicit none

!-------------------------------------------------------------------------------
! wrf related variables
!-------------------------------------------------------------------------------

    ! input data
    type(domain)            :: grid

    !  structure that contains run-time configuration (namelist) data for domain
    type (grid_config_rec_type) , intent(in)          :: config_flags

!-------------------------------------------------------------------------------
! internal variables
!-------------------------------------------------------------------------------

  logical           :: cntl
  character(20)     :: label
  character(200)    :: msg
  integer           :: ilabel
  integer           :: iunit
  integer           :: iyr,ida,imo,ihr,imn
  integer           :: nn

  character(20)     :: ctmp

!-------------------------------------------------------------------------------

  print *,'nnn hysp/hyrctl'
  print *,'nnn numloc=',config_flags%numloc,config_flags%nummet,config_flags%numtyp
  print *,'nnn numgrd=',config_flags%numgrd,config_flags%numhgt,config_flags%numpol
 
  label='CONTROL'
  inquire(file=label,exist=cntl)

  if(cntl)then
     iunit=25
     open(iunit,file=label)
     write(msg,*) 'opening CONTROL file for hysplit!'
     call wrf_message(msg)
  else
     call wrf_error_fatal('CONTROL file not found!')
  end if

  call tminit

  call decodi(iunit,iyr,imo,ida,ihr,imn)   !1 starting date
  call tm2min(iyr,imo,ida,ihr,imn,grid%hvar%hymacc)
  print *,'nnn hymacc=',grid%hvar%hymacc

  read (iunit,'(i2)') ilabel  !2 nloc
  if (ilabel .ne. config_flags%numloc) then
     call wrf_error_fatal('numloc does not match in CONTROL file!')
  endif

  do nn=1,config_flags%numloc !3 lat lon lvl
     call decodr(iunit,grid%hvar%hylat(nn),grid%hvar%hylon(nn),grid%hvar%hylvl(nn))
     print *,'nnn hylat=',grid%hvar%hylat(nn),grid%hvar%hylon(nn),grid%hvar%hylvl(nn)
  end do

  if (config_flags%run_traj .eq. 1) return !FN-20150610

  read (iunit,'(a)') label !4 nhrs
  read (iunit,'(a)') label !5 kvel
  read (iunit,'(a)') label !6 zdata

  read (iunit,'(i2)') ilabel !7 nmet

  do nn=1,ilabel
     read (iunit,'(a)') label !8 met file dir, not used
     read (iunit,'(a)') label !9 met file, not used
  end do

  read (iunit,'(i2)') ilabel  !10 ntyp
  if (ilabel .ne. config_flags%numtyp) then
     call wrf_error_fatal('numtyp does not match in CONTROL file!')
  endif

  do nn=1,config_flags%numtyp

     read (iunit,'(a)') label !11 ident
     grid%hvar%ident(nn)=nn

     read (iunit,*) grid%hvar%qrate(nn) !12 qrate
     read (iunit,*) grid%hvar%qhrs(nn)  !13 qhrs

     print *,'nnn ident=',grid%hvar%ident(nn),grid%hvar%qrate(nn),grid%hvar%qhrs(nn)

     call decodi(iunit,iyr,imo,ida,ihr,imn)  !14 emission starting date
     if (imo .eq. 0) then
        grid%hvar%emmacc(nn)=grid%hvar%hymacc
     else
        call tm2min(iyr,imo,ida,ihr,imn,grid%hvar%emmacc(nn))
     endif

     print *,'nnn emmacc=',grid%hvar%emmacc(nn)

  enddo

  read (iunit,'(i2)') ilabel !15 numgrd
  if (ilabel .ne. config_flags%numgrd) then
     call wrf_error_fatal('numgrd does not match in CONTROL file!')
  endif

  do nn=1,config_flags%nummet
     read (iunit,*) grid%hvar%cnlat(nn),grid%hvar%cnlon(nn)   !16 cnlat cnlon 
     read (iunit,*) grid%hvar%dellat(nn),grid%hvar%dellon(nn) !17 delt_lat delt_lon
     read (iunit,*) grid%hvar%splat(nn),grid%hvar%splon(nn)   !18 splat splon
     read (iunit,'(a)') label !19 dir
     read (iunit,'(a)') label !20 file

     read (iunit,'(i2)') ilabel !21 levels
     if (ilabel .ne. config_flags%numhgt) then
        call wrf_error_fatal('numhgt does not match in CONTROL file!')
     endif

     read (iunit,*) grid%hvar%cnhgt !22 height

     call decodi(iunit,iyr,imo,ida,ihr,imn) !23 conc starting date
     if (imo .eq. 0) then
        grid%hvar%cnstma(nn)=grid%hvar%hymacc
     else
        call tm2min(iyr,imo,ida,ihr,imn,grid%hvar%cnstma(nn))
     endif

     call decodi(iunit,iyr,imo,ida,ihr,imn) !24 conc ending date
     if (imo .eq. 0) then
        grid%hvar%cnenma(nn)=grid%hvar%cnstma(nn)+(60*24*365)     !add one year
     else
        call tm2min(iyr,imo,ida,ihr,imn,grid%hvar%cnenma(nn))
     endif

     print *,'nnn cnstma=',grid%hvar%cnstma(nn),grid%hvar%cnenma(nn)

     read (iunit,*) grid%hvar%snap(nn),grid%hvar%cndhr(nn),grid%hvar%cndmn(nn) !25 snap del_hr del_mn
     print *,'nnn snap=',grid%hvar%snap(nn),grid%hvar%cndhr(nn),grid%hvar%cndmn(nn)

     ilabel=(grid%hvar%cndhr(nn)*60)+grid%hvar%cndmn(nn)
  end do

  read (iunit,'(i2)') ilabel  !26 numpol
  if (ilabel .ne. config_flags%numpol) then
     call wrf_error_fatal('numpol does not match in CONTROL file!')
  endif
  if (config_flags%numpol .ne. config_flags%numtyp) then
     call wrf_error_fatal('numpol .ne. numtyp!')
  endif

  do nn=1,config_flags%numpol
     read (iunit,*) grid%hvar%pdiam(nn),grid%hvar%pdens(nn),grid%hvar%shape(nn) !27
     read (iunit,*) grid%hvar%dryvl(nn),grid%hvar%gpmol(nn),grid%hvar%acvty(nn), &
                    grid%hvar%difty(nn),grid%hvar%henry(nn)                     !28
     read (iunit,*) grid%hvar%wetgs(nn),grid%hvar%wetin(nn),grid%hvar%wetlo(nn) !29
     read (iunit,*) grid%hvar%rhalf(nn)                                         !30
     read (iunit,*) grid%hvar%srate(nn)                                         !31
  end do

  close(iunit)

  print *,'nnn end of hyrctl => return back to wrf!'
  return
  end subroutine hyrctl
