!WRF-HYSPLIT main interface
!Base on hymodelw.F
!
!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  HYMAIN           HYsplit MAIN subroutine
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:12-08-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: 03 Aug 2012 (FN) - WRF-HYSPLIT coupling initial implementation
!                 28 Aug 2013 (FN) - save time and met variables
!                 28 Oct 2013 (FN) - modify for eta coordinate
!                 28 Mar 2014 (FN) - clean up
!
! USAGE:  CALL HYMAIN(grid)  
!     
!   INPUT ARGUMENT LIST:    see below
!   OUTPUT ARGUMENT LIST:   see below
!   INPUT FILES:            none 
!   OUTPUT FILES:           none
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!   MACHINE:  IBM RS6000
!
!$$$

  SUBROUTINE hymain ( grid )

    USE funits
    USE metval

    USE module_io
    USE module_wrf_error
    USE module_io_wrf
    USE module_domain
    USE module_domain_type, ONLY : fieldlist
    USE module_state_description
    USE module_configure

    IMPLICIT NONE

INCLUDE 'mpif.h'
INCLUDE 'DEFGRID.INC' ! meteorology grid and file

! meteorolgical grid, record, and file information
  COMMON /GBLGRD/ HYGD, DREC, HYFL
! mixing length scales
  COMMON /stblen/ vscale,hscale

!-------------------------------------------------------------------------------
! WRF related variables
!-------------------------------------------------------------------------------

    TYPE(domain)            :: grid

    integer                 :: history_interval

    integer                 :: mpi_comm_here, mytask, ierr
    logical                 :: mpi_inited

!-------------------------------------------------------------------------------
  INTERFACE
!-------------------------------------------------------------------------------
 SUBROUTINE METINI(grid,                     &
                   KDEF,KZMIX,TVMIX,KBLS,KBLT)
    USE module_io
    USE module_wrf_error
    USE module_io_wrf
    USE module_domain
    USE module_domain_type, ONLY : fieldlist
    USE module_state_description
    USE module_configure
   IMPLICIT NONE
   INCLUDE 'DEFGRID.INC' ! meteorology grid and file
   TYPE(domain)             :: grid
   INTEGER,   INTENT(IN)    :: kdef                 ! deformation horizontal mix
   INTEGER,   INTENT(IN)    :: kzmix                ! vertical mixing averaging
   REAL,      INTENT(IN)    :: tvmix                ! tropospheric mixing scale
   INTEGER,   INTENT(IN)    :: kbls                 ! pbl stability derived from
   INTEGER,   INTENT(IN)    :: kblt                 ! pbl scheme for mixing
   END SUBROUTINE metini
!-------------------------------------------------------------------------------
 SUBROUTINE METDUM(grid,                           &
                   VMIX,KSFC,TKERD,TKERN,ZSG,NLVL, &
                   KMIXD,KMIX0,KRET)
    USE module_io
    USE module_wrf_error
    USE module_io_wrf
    USE module_domain
    USE module_domain_type, ONLY : fieldlist
    USE module_state_description
    USE module_configure
  IMPLICIT NONE
  INCLUDE 'DEFARG2.INC' ! subroutine interfaces
  INCLUDE 'DEFGRID.INC' ! meteorology grid and file
  INCLUDE 'DEFMETO.INC' ! meteo variables returned at advection point
  TYPE(domain)             :: grid
  LOGICAL,   INTENT(IN)    :: vmix         ! return mixing profile flag
  INTEGER,   INTENT(IN)    :: ksfc         ! top of surface layer index
  REAL,      INTENT(IN)    :: tkerd        ! day turbulent kinetic eneregy ratio
  REAL,      INTENT(IN)    :: tkern        ! night turbulent kinetic eneregy ratio
  REAL,      INTENT(IN)    :: zsg (:)      ! vertical sigma levels
  INTEGER,   INTENT(IN)    :: nlvl         ! number of vertical levels
  INTEGER,   INTENT(IN)    :: kmixd        ! mixed layer depth options
  INTEGER,   INTENT(IN)    :: kmix0        ! minimum mixing depth
  INTEGER,   INTENT(OUT)   :: kret         ! return for point off grid
  END SUBROUTINE metdum
!-------------------------------------------------------------------------------
  SUBROUTINE HYCONC(NGRD,NTIM,ZSG,NLVL,HIST)
  IMPLICIT NONE
  INCLUDE 'DEFARG1.INC' ! main program subroutine interface
  INCLUDE 'DEFGRID.INC' ! meteorology grid and file
  INCLUDE 'DEFCONC.INC' ! pollutants and concentration grid
  INCLUDE 'DEFMETO.INC' ! meteo variables returned after advection
  INCLUDE 'DEFSPOT.INC' ! multiple source structure
  INCLUDE 'DEFSPRT.INC' ! source-pollutant definition matrix
  INTEGER,   INTENT(IN) :: ngrd              ! number of meteo grids
  INTEGER,   INTENT(IN) :: ntim              ! number of meteo times
  REAL,      INTENT(IN) :: zsg (:)           ! vertical sigma levels,     !FN-20131125
  INTEGER,   INTENT(IN) :: nlvl              ! number of vertical levels, !FN-20131125
  INTEGER,   INTENT(IN) :: hist              ! WRF output history interval
  END SUBROUTINE hyconc
!-------------------------------------------------------------------------------
  END INTERFACE
!-------------------------------------------------------------------------------

INTEGER nn
INTEGER ngrd,ntim,kret
INTEGER ksfc,nlvl
INTEGER kdef,kblt,kbls
INTEGER kzmix,kmixd,kmix0
LOGICAL vmix

REAL    tkerd,tkern,tvmix
REAL    vscale,hscale

REAL, ALLOCATABLE :: zsig(:)

!-------------------------------------------------------------------------------

    print *,'aaa in hysp/hymain  ==========================',KF01,grid%id

    call nl_get_history_interval ( grid%id,  history_interval)
    print *,'aaa history_interval=',history_interval

    mpi_comm_here = MPI_COMM_WORLD
    CALL MPI_Comm_rank ( mpi_comm_here, mytask, ierr )
    print *,'aaa mpi=',mpi_comm_here,mytask,ierr


!-------------------------------------------------------------------------------

VSCALE=200.0
HSCALE=10800.0
KDEF=0
KBLT=2
KBLS=1
KZMIX=0
KMIXD=0
KMIX0=250
TKERD=0.18     ! day (unstable) turbulent kinetic energy ratio
TKERN=0.18
TVMIX=1.0
NGRD=1         ! hysplit grid index
NTIM=1         ! hysplit time index
VMIX=.TRUE.

!-------------------------------------------------------------------------------
! meteorological data header
!-------------------------------------------------------------------------------
 CALL METINI(grid,                     &
             KDEF,KZMIX,TVMIX,KBLS,KBLT)

!-------------------------------------------------------------------------------
! set up HYSPLIT vertical layer 
! ETAH - eta values on half levels
!-------------------------------------------------------------------------------
!FN-20130828
 NLVL=size(ETAH)+1
 ALLOCATE(zsig(nlvl))
 ZSIG(1)=1.0
 DO NN=2,NLVL
    ZSIG(NN)=ETAH(NN-1)
 END DO

 KSFC=3

!-------------------------------------------------------------------------------
! dummy call to read meterological data
!-------------------------------------------------------------------------------
 CALL METDUM(grid,                                  &
             VMIX,KSFC,TKERD,TKERN,ZSIG,NLVL,   &
             KMIXD,KMIX0,KRET)

!-------------------------------------------------------------------------------
! call HYSPLIT as a subroutine
!-------------------------------------------------------------------------------
 IF ( mytask .EQ. 0 ) THEN
  CALL HYCONC(NGRD,NTIM,ZSIG,NLVL,history_interval)
 ENDIF

 print *,'aaa back to WRF =========================='
    RETURN
  END SUBROUTINE hymain
