!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  wrftrc           load WRF 2d variable
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:12-08-08
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!   This subroutine loads WRF 2d data such as roughness length(z0),
!   landuse(lu) and terrain height(zt)
!
! PROGRAM HISTORY LOG:
!
! USAGE:  call wrftrc(grid,vname,nxt,nyt,nlvl,data3d)
!
!   INPUT ARGUMENT LIST:      see below
!   OUTPUT ARGUMENT LIST:     see below
!   INPUT FILES:              none
!   OUTPUT FILES:             unit KF21 diagnostic MESSAGE file
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!   MACHINE:  IBM RS6000
!
!$$$
   
subroutine wrftrc(grid,vname,nxt,nyt,nlvl,data3d)

    USE module_io
    USE module_wrf_error
    USE module_io_wrf
    USE module_domain
    USE module_domain_type, ONLY : fieldlist
    USE module_state_description
    USE module_configure

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------

  TYPE(domain)                              :: grid
  character(8), intent(in)                  :: vname         ! variable name
  integer                                   :: nxt,nyt,nlvl
  real, intent(out)                         :: data3d (:,:,:)

  real, allocatable           :: hybuf3d(:,:,:)  ! grid size array (m)
  real, allocatable           :: globbuf(:)

  INTEGER  :: fid, switch
  INTEGER  :: ftype
  INTEGER  :: Status
  INTEGER  :: ierr
  INTEGER  :: newswitch, itrace
  LOGICAL  :: dryrun

  INTEGER , DIMENSION(3)      :: domain_start, domain_end
  INTEGER , DIMENSION(3)      :: memory_start, memory_end
  INTEGER , DIMENSION(3)      :: patch_start , patch_end
  CHARACTER*80 , DIMENSION(3) :: dimnames
  CHARACTER*80                :: dname, memord

  type( fieldlist ), pointer  :: p

  TYPE(WRFU_Time)             :: next_time, currentTime, startTime

  INTEGER           :: i,j,k,n , icurs

  INTEGER ids , ide , jds , jde , kds , kde , &
          ims , ime , jms , jme , kms , kme , &
          ips , ipe , jps , jpe , kps , kpe

!-------------------------------------------------------------------------------
! external variables
!-------------------------------------------------------------------------------

  CALL get_ijk_from_grid (  grid ,                        &
                            ids, ide, jds, jde, kds, kde,    &
                            ims, ime, jms, jme, kms, kme,    &
                            ips, ipe, jps, jpe, kps, kpe    )

  CALL domain_clock_get( grid, current_time=currentTime, &
                               start_time=startTime,     &
                               current_timestr=current_date )

  newswitch = 1
  p => grid%head_statevars%next

  DO WHILE ( ASSOCIATED( p ) )

       fid    = grid%oid
       ftype  = 104    ! hardwire
       dryrun = .false.

         domain_start(1) = p%sd1 ; domain_end(1) = p%ed1 ;
         patch_start(1)  = p%sp1 ; patch_end(1)  = p%ep1 ;
         memory_start(1) = p%sm1 ; memory_end(1) = p%em1 ;
         domain_start(2) = p%sd2 ; domain_end(2) = p%ed2 ;
         patch_start(2)  = p%sp2 ; patch_end(2)  = p%ep2 ;
         memory_start(2) = p%sm2 ; memory_end(2) = p%em2 ;
         domain_start(3) = p%sd3 ; domain_end(3) = p%ed3 ;
         patch_start(3)  = p%sp3 ; patch_end(3)  = p%ep3 ;
         memory_start(3) = p%sm3 ; memory_end(3) = p%em3 ;

         dimnames(1) = TRIM(p%dimname1)
         dimnames(2) = TRIM(p%dimname2)
         dimnames(3) = TRIM(p%dimname3)

     IF ( p%ProcOrient .NE. 'X' .AND. p%ProcOrient .NE. 'Y' ) THEN   ! no I/O for xposed variables

      if ( p%Ndim .EQ. 4 .AND. p%scalar_array ) THEN
        IF (switch.EQ.restart_only.OR.p%Ntl/100.EQ.mod(p%Ntl,100)) THEN

           DO itrace = PARAM_FIRST_SCALAR , p%num_table(grid%id)
            IF ((p%Restart.AND.switch.EQ.restart_only).OR.on_stream(p%streams_table(grid%id,itrace)%stream,newswitch)) THEN
               dname = p%dname_table( grid%id, itrace )
               IF (p%Ntl.GT.0.AND.switch.NE.restart_only)dname=dname(1:len(TRIM(dname))-2)
                  memord = p%MemoryOrder

                 if ( TRIM(dname) .EQ. vname ) then

                    ALLOCATE( globbuf( (domain_end(1)-domain_start(1)+3)*(domain_end(2)-domain_start(2)+3)* &
                                       (domain_end(3)-domain_start(3)+3) ) )

                    CALL wrf_ext_write_trace ( globbuf      , &
                                    fid                     , & ! DataHandle
                                    current_date(1:19)      , & ! DateStr
                                    TRIM(p%dname_table( grid%id, itrace ))         , & ! Data Name
                                    p%rfield_4d             , & ! Field
                                    itrace, 1, 1, 1         , & ! see comment above
                                    1, 1, 1                 , & ! see comment above
                                    RWORDSIZE               , &
                                    ftype                   , & ! FieldType, !FN-0803
                                    grid%communicator       , & ! Comm
                                    grid%iocommunicator     , & ! Comm
                                    grid%domdesc            , & ! Comm
                                    grid%bdy_mask           , & ! bdy_mask
                                    dryrun                  , & ! flag
                                    TRIM(memord)            , & ! MemoryOrder
                                    TRIM(p%Stagger)         , & ! Stagger
                                    TRIM(p%dimname1)        , & ! Dimname 1
                                    TRIM(p%dimname2)        , & ! Dimname 2
                                    TRIM(p%dimname3)        , & ! Dimname 3
                                    TRIM(p%desc_table( grid%id, itrace))     , & ! Desc
                                    TRIM(p%units_table( grid%id, itrace))           , & ! Units
                     __FILE__ // ' writing 4d real ' // TRIM(p%dname_table(grid%id,itrace))     , & ! Debug message
                     p%sd1 , p%ed1 , p%sd2 , p%ed2 , p%sd3 , p%ed3 ,  &
                     p%sm1 , p%em1 , p%sm2 , p%em2 , p%sm3 , p%em3 ,  &
                     p%sp1 , p%ep1 , p%sp2 , p%ep2 , p%sp3 , p%ep3 ,  &
                     ierr )

                    ALLOCATE( hybuf3d ( (ide-ids+1),(jde-jds+1),(kde-kds+1) ) )
                    icurs = 1
                       DO j = jds,jde
                       DO k = kds,kde
                          DO i = ids,ide
                             hybuf3d(i,j,k) = globbuf(icurs)
                             icurs = icurs+1
                          ENDDO !i
                       ENDDO    !k
                       ENDDO    !j

                       DO k = kds,kde-1
                          DO j = jds,jde-1
                          DO i = ids,ide-1
                             data3d(i,j,k) = hybuf3d(i,j,k)
                          ENDDO
                          ENDDO
                       ENDDO

                    DEALLOCATE ( hybuf3d )

                    DEALLOCATE ( globbuf )

                   goto 3999
                 endif  ! dname

            ENDIF       !switch
           ENDDO        !loop itrace
        ENDIF           !p%streams
      endif             !p%Ndim

     ENDIF    !p%ProcOrient

    p => p%next
  ENDDO !associated(p)

3999 print *,'>>> wrftrc got ',vname,' done!'

return
end subroutine wrftrc
