!-------------------------------------------------------------------------------
! Configure subroutine interface argument lists for main programs         
! Last Revised: ...
!               11 Aug 2014 (FN) - modify for inline coupling
!-------------------------------------------------------------------------------

INTERFACE

!-------------------------------------------------------------------------------
  SUBROUTINE PARDSP(umix,vmix,gdisx,gdisy,tomu,dtm,zsfc,nlvl,wmix,zsg,       &
                    pres,zhgt,vscale,hscale,                                 &
                    xpps,ypps,zpps,vprime,wprime,uprimex,hdwp,zndx,iseed)
  IMPLICIT NONE
  REAL,         INTENT(IN)     :: umix        ! u-component turbulence (m2/s2)
  REAL,         INTENT(IN)     :: vmix        ! v-component turbulence (m2/s2)
  REAL,         INTENT(IN)     :: gdisx       ! horizontal grid distance (m) 
  REAL,         INTENT(IN)     :: gdisy       ! horizontal grid distance (m) 
  REAL,         INTENT(IN)     :: tomu        ! column mass (mu, Pa), !FN-20140107
  REAL,         INTENT(IN)     :: dtm         ! advection time step (min)  
  REAL,         INTENT(IN)     :: zsfc        ! terrain height (m)         
  INTEGER,      INTENT(IN)     :: nlvl        ! number of levels in subgrid
  REAL,         INTENT(IN)     :: wmix (:)    ! vertical turbulence (m2/s2)
  REAL,         INTENT(IN)     :: zsg  (:)    ! internal model sigma levels
  REAL,         INTENT(IN)     :: pres (:)    ! pressure profile, !FN-20131209
  REAL,         INTENT(IN)     :: zhgt (:)    ! height profile,   !FN-20131209
  REAL,         INTENT(IN)     :: vscale      ! vert time scale (sec)  !FN-20140610
  REAL,         INTENT(IN)     :: hscale      ! horz time scale (sec)  !FN-20140610
  REAL,         INTENT(INOUT)  :: xpps        ! EW horizontal particle position
  REAL,         INTENT(INOUT)  :: ypps        ! NS horizontal particle position
  REAL,         INTENT(INOUT)  :: zpps        ! vertical particle position (sig)
  REAL,         INTENT(INOUT)  :: vprime      ! last v turbulent velocity (y)
  REAL,         INTENT(INOUT)  :: wprime      ! last w turbulent velocity (z)
  REAL,         INTENT(INOUT)  :: uprimex      ! last u turbulent velocity (x)
  INTEGER,      INTENT(IN)     :: hdwp        ! horizontal distribution index
  REAL,         INTENT(IN)     :: zndx        ! fractional vertical index  
  INTEGER,      INTENT(INOUT)  :: iseed       ! random generator seed
  END SUBROUTINE pardsp
!-------------------------------------------------------------------------------
  SUBROUTINE CONSUM(conc,numgrd,plat,plon,dt,jet,zsfc,kmsl,     &
                  cgsize,mass,dept,zpos,sigh,sigw,hdwp,ptyp,csum)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset), INTENT(IN) :: conc(:)           ! for each concentration grid
  INTEGER, INTENT(IN)    :: numgrd            ! number of concentration grids
  REAL,    INTENT(IN)    :: plat,plon         ! particle position lat & long
  REAL,    INTENT(IN)    :: dt                ! time step (min)
  REAL,    INTENT(IN)    :: zsfc              ! height of ground surface (m)
  INTEGER, INTENT(IN)    :: kmsl              ! agl=0 or msl=1 height units
  REAL,    INTENT(INOUT) :: cgsize            ! minimum sampling grid size (km)
  REAL,    INTENT(IN)    :: mass (:)          ! mass of pollutant
  REAL,    INTENT(IN)    :: dept (:)          ! deposition amount of mass
  REAL,    INTENT(IN)    :: zpos              ! puff center height (sigma)
  REAL,    INTENT(IN)    :: sigh,sigw         ! horiz (m) and vert sigma (sigma)
  INTEGER, INTENT(IN)    :: hdwp              ! horiz distribution in pollutant
  INTEGER, INTENT(IN)    :: ptyp              ! pollutant type index number
  REAL,    INTENT(INOUT) :: csum (:,:,:,:,:)  ! concentration summation matrix
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  END SUBROUTINE consum
!-------------------------------------------------------------------------------
  SUBROUTINE AVGCON(conc,numgrd,xpar,ypar,zagl,dt,jet,zsfc,kmsl,     &
                    cgsize,mass,dept,sigh,sigw,hdwp,ptyp,            &
                    xsum,ims,ime,jms,jme )
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset), INTENT(IN) :: conc(:)           ! for each concentration grid
  INTEGER, INTENT(IN)    :: numgrd            ! number of concentration grids
  REAL,    INTENT(IN)    :: xpar,ypar         ! particle position lat & long
  REAL,    INTENT(IN)    :: zagl              ! particle position at height (m)
  REAL,    INTENT(IN)    :: dt                ! time step (min)
  REAL,    INTENT(IN)    :: zsfc              ! height of ground surface (m)
  INTEGER, INTENT(IN)    :: kmsl              ! agl=0 or msl=1 height units
  REAL,    INTENT(INOUT) :: cgsize            ! minimum sampling grid size (km)
  REAL,    INTENT(IN)    :: mass (:)          ! mass of pollutant
  REAL,    INTENT(IN)    :: dept (:)          ! deposition amount of mass
  REAL,    INTENT(IN)    :: sigh,sigw         ! horiz (m) and vert sigma (sigma)
  INTEGER, INTENT(IN)    :: hdwp              ! horiz distribution in pollutant
  INTEGER, INTENT(IN)    :: ptyp              ! pollutant type index number
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  INTEGER,   INTENT(IN)                           :: ims , ime , jms , jme
  REAL, DIMENSION(ims:ime,jms:jme), INTENT(INOUT) :: xsum
  END SUBROUTINE avgcon
!-------------------------------------------------------------------------------
  SUBROUTINE CONINI(spot,conc,dirt,nloc,numgrd,numtyp,nbptyp,cpack)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  INCLUDE 'DEFSPOT.INC'
  TYPE(rset), INTENT(IN)    :: spot(:)   ! source location characteristics
  TYPE(cset), INTENT(INOUT) :: conc(:)   ! for each concentration grid 
  TYPE(pset), INTENT(IN)    :: dirt(:)   ! for each pollutant type 
  INTEGER,    INTENT(IN)    :: nloc      ! number of sources
  INTEGER,    INTENT(IN)    :: numgrd    ! number of concentration grids
  INTEGER,    INTENT(IN)    :: numtyp    ! number of pollutants
  INTEGER,    INTENT(IN)    :: nbptyp    ! number bins per type
  INTEGER,    INTENT(IN)    :: cpack     ! concentration packing flag
  END SUBROUTINE conini
!-------------------------------------------------------------------------------
  SUBROUTINE CONDSK(conc,dirt,ichem,kgm,ktm,numgrd,numtyp,nbptyp,dt,jet,ifhr,  &
                    cpack,csum,taskid)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset),  INTENT(IN)     :: conc(:)  ! for each concentration grid 
  TYPE(pset),  INTENT(IN)     :: dirt(:)  ! for each pollutant type 
  INTEGER,     INTENT(IN)     :: ichem               ! chemistry parameter
  INTEGER,     INTENT(IN)     :: kgm                 ! current meteo grid number
  INTEGER,     INTENT(IN)     :: ktm                 ! current meteo time number
  INTEGER,     INTENT(IN)     :: numgrd              ! number of concen grids
  INTEGER,     INTENT(IN)     :: numtyp              ! number of pollutants
  INTEGER,     INTENT(IN)     :: nbptyp              ! number bins per type
  REAL,        INTENT(IN)     :: dt                  ! time step
  INTEGER,     INTENT(IN)     :: ifhr                ! current forecast hour
  INTEGER,     INTENT(IN)     :: cpack               ! concen packing flag
  REAL,        INTENT(INOUT)  :: csum (:,:,:,:,:)    ! summation matrix
  INTEGER,     INTENT(IN)     :: taskid
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  END SUBROUTINE condsk
!-------------------------------------------------------------------------------
  SUBROUTINE CONSET(CONC,NUMGRD,CGSIZE,CPACK,OLAT,OLON, &
                    XCNLAT,XCNLON,XDELLAT,XDELLON,XSPLAT,XSPLON)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset), INTENT(OUT) :: conc(:)              ! for each concentration grid 
  INTEGER, INTENT(IN)     :: numgrd               ! number concentration grids
  REAL,    INTENT(INOUT)  :: cgsize               ! minimum grid spacing (km) 
  INTEGER, INTENT(IN)     :: cpack                ! concentration grid packing
  REAL,    INTENT(IN)     :: olat, olon           ! starting point
  REAL,DIMENSION(NUMGRD), INTENT(IN)  :: xcnlat,xcnlon,xdellat,xdellon,xsplat,xsplon
  END SUBROUTINE conset 
!-------------------------------------------------------------------------------
  SUBROUTINE GRDSET(CONC,NUMGRD,CGSIZE,CPACK,OLAT,OLON, &
                    XCNLAT,XCNLON,XDELLAT,XDELLON,NXP,NYP,NZP)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset), INTENT(OUT) :: conc(:)              ! for each concentration grid
  INTEGER, INTENT(IN)     :: numgrd               ! number concentration grids
  REAL,    INTENT(INOUT)  :: cgsize               ! minimum grid spacing (km)
  INTEGER, INTENT(IN)     :: cpack                ! concentration grid packing
  REAL,    INTENT(IN)     :: olat, olon           ! starting point
  REAL                    :: xcnlat,xcnlon,xdellat,xdellon
  INTEGER                 :: nxp,nyp,nzp
  END SUBROUTINE grdset
!-------------------------------------------------------------------------------
  SUBROUTINE CONZRO(conc,numgrd,dt,jet,ifhr,csum)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset), INTENT(INOUT)   :: conc(:)             ! each concentration grid 
  INTEGER,     INTENT(IN)     :: numgrd              ! number of concen grids
  REAL,        INTENT(IN)     :: dt                  ! time step (min)
  INTEGER,     INTENT(IN)     :: ifhr                ! current forecast hour
  REAL,        INTENT(INOUT)  :: csum (:,:,:,:,:)    ! summation matrix
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  END SUBROUTINE conzro
!-------------------------------------------------------------------------------
  SUBROUTINE DEPRAD(CONC,DIRT,NUMGRD,NUMTYP,DT,CSUM)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(cset),   INTENT(IN)    :: conc(:)   ! for each concentration grid
  TYPE(pset),   INTENT(IN)    :: dirt(:)   ! for each pollutant type
  INTEGER,      INTENT(IN)    :: numgrd    ! number of concentration grids
  INTEGER,      INTENT(IN)    :: numtyp    ! number of pollutants
  REAL,         INTENT(IN)    :: dt        ! intgration time step (sec)
  REAL,         INTENT(INOUT) :: csum (:,:,:,:,:)
  END SUBROUTINE deprad
!-------------------------------------------------------------------------------
  SUBROUTINE ADVPNT(METZ,METO,VMIX,CDEP,RDEP,TRAJ,TKERD,TKERN,HDWP,   &
                    XP,YP,ZP,DT,KG,ZSG,NLVL,  &
                    UBAR,IFHR,ICHEM,KRET)
  IMPLICIT NONE
  INCLUDE 'DEFGRID.INC' ! meteorology grid and file
  INCLUDE 'DEFMETO.INC'
  TYPE(bset),INTENT(OUT)   :: metz (:)     ! profile advection variables
  TYPE(aset),INTENT(OUT)   :: meto         ! surface advection variables
  LOGICAL,   INTENT(IN)    :: vmix         ! return mixing profile flag
  LOGICAL,   INTENT(IN)    :: cdep         ! return deposition variable flag
  LOGICAL,   INTENT(IN)    :: rdep         ! resistance deposition flag
  LOGICAL,   INTENT(IN)    :: traj         ! return trajectory variables flag
  REAL,      INTENT(IN)    :: tkerd        ! day turbulent kinetic eneregy ratio
  REAL,      INTENT(IN)    :: tkern        ! night turbulent kinetic eneregy ratio
  INTEGER,   INTENT(IN)    :: hdwp         ! puff/particle distribution type
  REAL,      INTENT(INOUT) :: xp,yp,zp     ! particle position for advection
  REAL,      INTENT(IN)    :: dt           ! advection time step (min)
  INTEGER,   INTENT(INOUT) :: kg           ! grid index for calculation
  REAL,      INTENT(IN)    :: zsg (:)      ! vertical sigma levels
  INTEGER,   INTENT(IN)    :: nlvl         ! number of vertical levels
  REAL,      INTENT(OUT)   :: ubar         ! advection velocity for component
  INTEGER,   INTENT(OUT)   :: ifhr         ! current forecast hour
  INTEGER,   INTENT(IN)    :: ichem        ! special conversion options
  INTEGER,   INTENT(OUT)   :: kret         ! return for point off grid
  END SUBROUTINE advpnt
!-------------------------------------------------------------------------------
  SUBROUTINE TM2DAY(MACM,IY,IM,ID,IH,MN)
  IMPLICIT NONE
  INTEGER,   INTENT(IN)    :: macm            ! accumulate minutes
  INTEGER,   INTENT(OUT)   :: iy,im,id,ih,mn  ! current date/time
  END SUBROUTINE tm2day
!-------------------------------------------------------------------------------
  SUBROUTINE TM2MIN(IY,IM,ID,IH,MN,MACC)
  IMPLICIT NONE
  INTEGER,  INTENT(IN)   :: iy,im,id,ih,mn       ! date and time
  INTEGER,  INTENT(OUT)  :: macc                 ! minutes since 1 Jan 1970
  END SUBROUTINE tm2min
!-------------------------------------------------------------------------------
  SUBROUTINE DEPSET(DIRT,NUMPOL,CDEP,RDEP,SDEP,PDIAM,PDENS,SHAPE, &
                    DRYVL,GPMOL,ACVTY,DIFTY,HENRY,WETGS,WETIN,WETLO,RHALF,SRATE)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(pset), INTENT(INOUT) :: dirt(:)   ! for each pollutant type 
  INTEGER,    INTENT(IN)    :: numpol    ! number of pollutant types
  LOGICAL,    INTENT(OUT)   :: cdep      ! indicate wet or dry deposition
  LOGICAL,    INTENT(OUT)   :: rdep      ! resistance deposition
  LOGICAL,    INTENT(OUT)   :: sdep      ! resuspension option
  REAL,    DIMENSION(NUMPOL), INTENT(IN)  :: pdiam,pdens,shape
  REAL,    DIMENSION(NUMPOL), INTENT(IN)  :: dryvl,gpmol,acvty,difty,henry
  REAL,    DIMENSION(NUMPOL), INTENT(IN)  :: wetgs,wetin,wetlo,rhalf,srate
  END SUBROUTINE depset
!-------------------------------------------------------------------------------
  SUBROUTINE EMSSET(DIRT,NUMTYP,IUNIT,IBYR,IBMO,IBDA,IBHR,OLAT,OLON,BACK)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(pset),   INTENT(OUT)   :: dirt(:)             ! for each pollutant type 
  INTEGER,      INTENT(IN)    :: numtyp              ! numb of pollutant types
  INTEGER,      INTENT(IN)    :: iunit               ! unit numb for input data
  INTEGER,      INTENT(IN)    :: ibyr,ibmo,ibda,ibhr ! starting time
  REAL,         INTENT(INOUT) :: olat,olon           ! emission location
  LOGICAL,      INTENT(IN)    :: back                ! integration direction
  END SUBROUTINE emsset
!-------------------------------------------------------------------------------
  SUBROUTINE EMSPNT(SPOT,DIRT,NLOC,NUMTYP,NBPTYP,KPM,INITD,DT,JET,NSORT,MASS, &
             XPOS,YPOS,ZPOS,SIGH,SIGU,SIGV,SIGW,HDWP,PAGE,PTYP,PGRD,QCYCLE,   &
             NUMPAR,MAXPAR,job_id,num_job,ichem,kret,GDISX,GDISY)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  INCLUDE 'DEFSPOT.INC'
  TYPE(rset),INTENT(INOUT) :: spot(:) ! source location characteristics
  TYPE(pset),INTENT(INOUT) :: dirt(:) ! for each pollutant type 
  INTEGER,   INTENT(IN)    :: nloc    ! total number of source locations
  INTEGER,   INTENT(IN)    :: numtyp  ! number of pollutant types
  INTEGER,   INTENT(IN)    :: nbptyp  ! number of bins per type   
  INTEGER,   INTENT(INOUT) :: kpm     ! number of puffs or particles
  INTEGER,   INTENT(IN)    :: initd   ! initial distribution type
  REAL,      INTENT(IN)    :: dt      ! time step (min)
  REAL,      INTENT(IN)    :: qcycle  ! optional emission cycle time in hours
  INTEGER,   INTENT(IN)    :: numpar  ! maximum number of particles permitted
  INTEGER,   INTENT(INOUT) :: nsort (:)   ! index of sorted elements
  REAL,      INTENT(INOUT) :: mass  (:,:) ! mass of pollutant (arbitrary units)
  REAL,      INTENT(INOUT) :: xpos  (:)   ! horizontal position (grid units)
  REAL,      INTENT(INOUT) :: ypos  (:)   ! horizontal position (grid units)
  REAL,      INTENT(INOUT) :: zpos  (:)   ! puff center height (sigma)
  REAL,      INTENT(INOUT) :: sigh  (:)   ! horizontal sigma    
  REAL,      INTENT(INOUT) :: sigu  (:)   ! turbulence
  REAL,      INTENT(INOUT) :: sigv  (:)   ! turbulence
  REAL,      INTENT(INOUT) :: sigw  (:)   ! vertical sigma
  INTEGER,   INTENT(INOUT) :: hdwp  (:)   ! Horizontal distribution pollutant
  INTEGER,   INTENT(INOUT) :: page  (:)   ! pollutant age since release (min)
  INTEGER,   INTENT(INOUT) :: ptyp  (:)   ! pollutant type index number
  INTEGER,   INTENT(INOUT) :: pgrd  (:)   ! meteorological grid of puff position
  INTEGER,   INTENT(IN)    :: maxpar      ! maximum particle number
  INTEGER,   INTENT(IN)    :: job_id      ! mpi implementation 
  INTEGER,   INTENT(IN)    :: num_job     ! mpi implementation
  INTEGER,   INTENT(IN)    :: ichem       ! chemistry options index
  INTEGER,   INTENT(OUT)   :: kret        ! emit denial return code
  REAL,      INTENT(IN)    :: gdisx,gdisy ! meteorology grid spacing (m)
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  END SUBROUTINE emspnt
!-------------------------------------------------------------------------------
  SUBROUTINE EMSTMP(DIRT,SPRT,KG,NLOC,NUMTYP,NBPTYP,KPM,INITD,DT,JET,NUMPAR,  &
                    MAXPAR,NSORT,MASS,XPOS,YPOS,ZPOS,SIGH,SIGU,SIGV,SIGW,     &
                    HDWP,PAGE,PTYP,PGRD,job_id,num_job,kret,GDISX,GDISY)
  IMPLICIT NONE
  INCLUDE 'DEFSPRT.INC' ! source emissions matrix
  INCLUDE 'DEFCONC.INC' ! pollutant characteristics
  TYPE(pset),INTENT(IN)    :: dirt(:)   ! for each pollutant type
  TYPE(qset),INTENT(INOUT) :: sprt(:,:) ! source location characteristics
  INTEGER,   INTENT(IN)    :: kg        ! active grid number
  INTEGER,   INTENT(IN)    :: nloc      ! total number of source locations
  INTEGER,   INTENT(IN)    :: numtyp    ! number of pollutant types
  INTEGER,   INTENT(IN)    :: nbptyp  ! number of bins per type
  INTEGER,   INTENT(INOUT) :: kpm       ! number of puffs or particles
  INTEGER,   INTENT(IN)    :: initd     ! initial distribution type
  REAL,      INTENT(IN)    :: dt        ! time step (min)
  INTEGER,   INTENT(IN)    :: numpar    ! maximum number of particles permitted
  INTEGER,   INTENT(IN)    :: maxpar    ! maximum particle number
  INTEGER,   INTENT(INOUT) :: nsort (:)   ! index of sorted elements
  REAL,      INTENT(INOUT) :: mass  (:,:) ! mass of pollutant (arbitrary units)
  REAL,      INTENT(INOUT) :: xpos  (:)   ! horizontal position (grid units)
  REAL,      INTENT(INOUT) :: ypos  (:)   ! horizontal position (grid units)
  REAL,      INTENT(INOUT) :: zpos  (:)   ! puff center height (sigma)
  REAL,      INTENT(INOUT) :: sigh  (:)   ! horizontal puff sigma
  REAL,      INTENT(INOUT) :: sigu  (:)   ! turbulence u'2
  REAL,      INTENT(INOUT) :: sigv  (:)   ! turbulence v'2
  REAL,      INTENT(INOUT) :: sigw  (:)   ! turbulence w'2 or vertical puff sigma
  INTEGER,   INTENT(INOUT) :: hdwp  (:)   ! Horizontal distribution pollutant
  INTEGER,   INTENT(INOUT) :: page  (:)   ! pollutant age since release (min)
  INTEGER,   INTENT(INOUT) :: ptyp  (:)   ! pollutant type index number
  INTEGER,   INTENT(INOUT) :: pgrd  (:)   ! meteorological grid of puff position
  INTEGER,   INTENT(IN)    :: job_id      ! mpi implementation
  INTEGER,   INTENT(IN)    :: num_job     ! mpi implementation
  INTEGER,   INTENT(OUT)   :: kret        ! emit denial return code
  REAL,      INTENT(IN)    :: gdisx,gdisy ! meteorology grid spacing (m)
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20150520
  END SUBROUTINE emstmp
!-------------------------------------------------------------------------------
  SUBROUTINE EMSINI(NLOC,OLAT,OLON,QFILE,NQLON,NQLAT,NPVAL)
  IMPLICIT NONE
  INTEGER,   INTENT(IN)    :: nloc      ! total number of source locations
  REAL,      INTENT(IN)    :: olat(:)   ! source subgrid domain limits 
  REAL,      INTENT(IN)    :: olon(:)   ! source subgrid domain limits 
  LOGICAL,   INTENT(OUT)   :: qfile     ! indicates area source emission file
  INTEGER,   INTENT(OUT)   :: nqlon     ! number of long in subgrid
  INTEGER,   INTENT(OUT)   :: nqlat     ! number of lats in subgrid
  INTEGER,   INTENT(OUT)   :: npval     ! number of pollutants in file
  END SUBROUTINE emsini
!-------------------------------------------------------------------------------
  SUBROUTINE PUFDEL(KPM,MASS,XPOS,YPOS,ZPOS,XPRT,YPRT,PAGL,SIGH,SIGU,SIGV,SIGW,HDWP,PAGE, &
                    PTYP,PGRD,NSORT,KHMAX,FMASS)
  IMPLICIT NONE
  INTEGER, INTENT(INOUT) :: kpm        ! total number of puffs or particles
  INTEGER, INTENT(IN)    :: khmax      ! maximum hours limit
  REAL,    INTENT(IN)    :: fmass      ! lower mass limit per particle/puff
  REAL,    INTENT(INOUT) :: mass (:,:) ! mass of pollutant (arbitrary units)
  REAL,    INTENT(INOUT) :: xpos (:)   ! puff center positions (grid units)
  REAL,    INTENT(INOUT) :: ypos (:)   ! puff center positions (grid units)
  REAL,    INTENT(INOUT) :: zpos (:)   ! puff center height (sigma)
  REAL,    INTENT(INOUT) :: xprt (:)   ! particle latitude            !FN-20140620
  REAL,    INTENT(INOUT) :: yprt (:)   ! particle longitude           !FN-20140620
  REAL,    INTENT(INOUT) :: pagl (:)   ! particle position at AGL (m) !FN-20140303
  REAL,    INTENT(INOUT) :: sigh (:)   ! horizontal sigma   
  REAL,    INTENT(INOUT) :: sigu (:)   ! turbulence
  REAL,    INTENT(INOUT) :: sigv (:)   ! turbulence
  REAL,    INTENT(INOUT) :: sigw (:)   ! vertical sigma   
  INTEGER, INTENT(INOUT) :: hdwp (:)   ! Horizontal distribution pollutant
  INTEGER, INTENT(INOUT) :: page (:)   ! pollutant age since release (min)
  INTEGER, INTENT(INOUT) :: ptyp (:)   ! pollutant type index number
  INTEGER, INTENT(INOUT) :: pgrd (:)   ! meteorological grid of puff position
  INTEGER, INTENT(INOUT) :: nsort(:)   ! sort index array by position
  END SUBROUTINE pufdel
!-------------------------------------------------------------------------------
  SUBROUTINE PAROUT(JET,KPM,MASS,XPRT,YPRT,ZPOS,SIGH,SIGU,SIGV,    &
                    SIGW,HDWP,PAGE,PTYP,PGRD,NSORT)
  IMPLICIT NONE
  INTEGER, INTENT(INOUT) :: kpm        ! total number of puffs or particles
  REAL,    INTENT(INOUT) :: mass (:,:) ! mass of pollutant (arbitrary units)
  REAL,    INTENT(INOUT) :: xprt (:)   ! particle latitude
  REAL,    INTENT(INOUT) :: yprt (:)   ! particle longitude
  REAL,    INTENT(INOUT) :: zpos (:)   ! particle height (AGL)
  REAL,    INTENT(INOUT) :: sigh (:)   ! horizontal sigma   
  REAL,    INTENT(INOUT) :: sigu (:)   ! turbulence
  REAL,    INTENT(INOUT) :: sigv (:)   ! turbulence
  REAL,    INTENT(INOUT) :: sigw (:)   ! vertical sigma
  INTEGER, INTENT(INOUT) :: hdwp (:)   ! Horizontal distribution pollutant
  INTEGER, INTENT(INOUT) :: page (:)   ! pollutant age since release (min)
  INTEGER, INTENT(INOUT) :: ptyp (:)   ! pollutant type index number
  INTEGER, INTENT(INOUT) :: pgrd (:)   ! meteorological grid of puff position
  INTEGER, INTENT(INOUT) :: nsort(:)   ! sort index array by position
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515
  END SUBROUTINE parout
!-------------------------------------------------------------------------------
  SUBROUTINE DEPELM(DIRT,OLAT,IBMO,NLVL,DT,ZSFC,MASS,DEPT,XPOS,YPOS,ZPOS,PAGL, &
                    SIGW,ICHEM,KTYP,LAND,ROUG,USTR,PSI,SFLX,HDWP,RAIN,     &
                    RHB,RHT,DD,TT,QQ,KSFC,ZHGT,DRYD)
  IMPLICIT NONE
  INCLUDE 'DEFCONC.INC'
  TYPE(pset), INTENT(IN)   :: dirt (:) ! for each pollutant type
  REAL,     INTENT(IN)     :: olat     ! origin location
  INTEGER,  INTENT(IN)     :: ibmo     ! computational month
  INTEGER,  INTENT(IN)     :: nlvl     ! number of vertical levels
  REAL,     INTENT(IN)     :: dt       ! time step (sec)                  !FN-20150511
  REAL,     INTENT(IN)     :: zsfc     ! height of terrain surface (m)
  REAL,     INTENT(INOUT)  :: mass (:) ! mass (arbitrary units)
  REAL,     INTENT(IN)     :: xpos
  REAL,     INTENT(IN)     :: ypos
  REAL,     INTENT(INOUT)  :: zpos     ! praticle vertical position (eta) !FN-20150511
  REAL,     INTENT(IN)     :: pagl     ! particle position at height (m)  !FN-20150511
  REAL,     INTENT(INOUT)  :: sigw     ! vert sigma (sigma)
  INTEGER,  INTENT(IN)     :: ichem    ! special depositon options
  INTEGER,  INTENT(IN)     :: ktyp     ! pollutant type index number
  INTEGER,  INTENT(IN)     :: land     ! land use category (1-11)
  REAL,     INTENT(IN)     :: roug     ! aerodynamic roughness length (m)
  REAL,     INTENT(IN)     :: ustr     ! friction velocity (m/s)
  REAL,     INTENT(IN)     :: psi      ! integrated stability function for heat
  REAL,     INTENT(IN)     :: sflx     ! incident short wave flux (w/m2)
  INTEGER,  INTENT(INOUT)  :: hdwp     ! pollutant distribution type (index)
  REAL,     INTENT(IN)     :: rain     ! precipitation value (m/min)
  INTEGER,  INTENT(IN)     :: rhb,rht  ! rh limits for cloud bottom and top (%)
  INTEGER,  INTENT(IN)     :: ksfc     ! top of surface layer index
  REAL,     INTENT(IN)     :: dd   (:) ! air density profile (kg/m3)
  REAL,     INTENT(IN)     :: tt   (:) ! temperature profile
  REAL,     INTENT(IN)     :: qq   (:) ! humidity profile (fraction 0-1)
  REAL,     INTENT(IN)     :: zhgt (:) ! height profile (m)                !FN-20150511
  REAL,     INTENT(OUT)    :: dept (:) ! deposition total (mass units)
  REAL,     INTENT(OUT)    :: dryd (:) ! deposition velocity as computed
  END SUBROUTINE depelm
!-------------------------------------------------------------------------------
  SUBROUTINE DEPSUS(CONC,DIRT,INITD,KGM,KTM,NUMGRD,NUMTYP,DT,ICHEM,KPM,  &
                    CSUM,MASS,XPOS,YPOS,ZPOS,SIGH,SIGU,SIGV,SIGW,HDWP,   &
                    PAGE,PTYP,PGRD,NSORT,MAXPAR,CGRDXP,CGRDYP)
  IMPLICIT NONE
  INCLUDE 'DEFGRID.INC'
  INCLUDE 'DEFCONC.INC'
  TYPE(cset), INTENT(IN)    :: conc(:)      ! for each concentration grid
  TYPE(pset), INTENT(IN)    :: dirt(:)      ! for each pollutant type
  INTEGER,    INTENT(IN)    :: initd        ! initial puff/particle distribution
  INTEGER,    INTENT(IN)    :: kgm          ! current meteorological grid number
  INTEGER,    INTENT(IN)    :: ktm          ! current meteorological time number
  INTEGER,    INTENT(IN)    :: numgrd       ! number of concentration grids
  INTEGER,    INTENT(IN)    :: numtyp       ! number of pollutants
  REAL,       INTENT(IN)    :: dt           ! time step (sec)    !FN-20150529
  INTEGER,    INTENT(IN)    :: ichem        ! chemistry option parameter
  INTEGER,    INTENT(INOUT) :: kpm          ! total number of puffs or particles
  REAL,       INTENT(INOUT) :: csum  (:,:,:,:,:)
  REAL,       INTENT(INOUT) :: mass  (:,:)  ! (species, particles)
  REAL,       INTENT(INOUT) :: xpos  (:)    ! x position (numb part)
  REAL,       INTENT(INOUT) :: ypos  (:)    ! y position (numb part)
  REAL,       INTENT(INOUT) :: zpos  (:)    ! z position (numb part)
  REAL,       INTENT(INOUT) :: sigh  (:)    ! horiz sigma (meters)
  REAL,       INTENT(INOUT) :: sigu  (:)    ! u'2 turbulence
  REAL,       INTENT(INOUT) :: sigv  (:)    ! v'2 turbulence
  REAL,       INTENT(INOUT) :: sigw  (:)    ! vertical sigma
  INTEGER,    INTENT(INOUT) :: hdwp  (:)    ! Horizontal distribution
  INTEGER,    INTENT(INOUT) :: page  (:)    ! pollutant age (min)
  INTEGER,    INTENT(INOUT) :: ptyp  (:)    ! pollutant type index numb
  INTEGER,    INTENT(INOUT) :: pgrd  (:)    ! particle on this grid numb
  INTEGER,    INTENT(INOUT) :: nsort (:)    ! sorted array index values
  INTEGER,    INTENT(IN)    :: maxpar       ! maximum number of particles
  REAL,       INTENT(IN)    :: cgrdxp(:,:,:)
  REAL,       INTENT(IN)    :: cgrdyp(:,:,:)
  END SUBROUTINE depsus
!-------------------------------------------------------------------------------
  SUBROUTINE DEPDRY(KPOL,LAND,ROUG,SFCL,USTR,PSI,SFLX,AIRD,TEMP,PDIA,VG,VD)
  IMPLICIT NONE
  INTEGER,  INTENT(IN)    :: kpol       ! polluant index number
  INTEGER,  INTENT(IN)    :: land       ! land-use category
  REAL,     INTENT(IN)    :: roug       ! aerodynamic roughness length (m)
  REAL,     INTENT(IN)    :: sfcl       ! height of constant flux layer (m)
  REAL,     INTENT(IN)    :: ustr       ! friction velocity (m/s)
  REAL,     INTENT(IN)    :: psi        ! integrated stability function heat
  REAL,     INTENT(IN)    :: sflx       ! solar irradiation at sfc (watts/m2)
  REAL,     INTENT(IN)    :: aird       ! ambient air density (g/m3)
  REAL,     INTENT(IN)    :: temp       ! canopy air temperature (deg K)
  REAL,     INTENT(IN)    :: pdia       ! particle diameter (meters)
  REAL,     INTENT(IN)    :: vg         ! gravitational settling velocity (m/s)
  REAL,     INTENT(OUT)   :: vd         ! total deposition velocity (m/s)
  END SUBROUTINE depdry
!-------------------------------------------------------------------------------
END INTERFACE
