!-------------------------------------------------------------------------------
! Configure subroutine interface argument lists stb routines 
! Last Revised: 02 Dec 2003 (RRD) - initial version extracted from sub prfcom
!               02 Jul 2004 (RRD) - stbanl argument list for hflx
!               11 May 2005 (RRD) - revised argument list stbsnd
!               08 Mar 2006 (RRD) - static stability parameter (stbanl)
!               14 Apr 2006 (RRD) - wrf interface issues 
!               21 Nov 2006 (RRD) - tke day night partition
!               04 Jun 2008 (RRD) - minimum mixing depth into stbanl
!               15 Aug 2008 (RRD) - more mixing options through stb routines
!               04 Apr 2009 (RRD) - inout for sfc wind and temp prf??? routines
!               21 Aug 2009 (RRD) - save index for data extrapolation region
!-------------------------------------------------------------------------------

  INTERFACE
!-------------------------------------------------------------------------------
  SUBROUTINE STBANL(KBLS,I,J,KS,KMIX0,KMIXD,MIXD,TKEN,HFLX,EFLX,UFLX,USTAR, &
                    TSTAR,Z0T,FMU,FMV,FHS,NL,UVAR,VVAR,TVAR,ZVAR,EVAR,DVAR, &
                    MIXH,PSIR,SSP)
  IMPLICIT NONE
  INTEGER,   INTENT(IN)    :: kbls         ! stability compuation method
  INTEGER,   INTENT(IN)    :: i,j          ! horizontal grid point proccesed
  INTEGER,   INTENT(IN)    :: ks           ! index top of surface layer
  INTEGER,   INTENT(IN)    :: kmix0        ! minimum mixing depth
  INTEGER,   INTENT(IN)    :: kmixd        ! mixed layer depth options
  LOGICAL,   INTENT(IN)    :: mixd         ! mixed layer depth in data file
  LOGICAL,   INTENT(IN)    :: tken         ! tke field available         
  LOGICAL,   INTENT(IN)    :: hflx         ! fluxes available (heat)     
  LOGICAL,   INTENT(IN)    :: eflx         ! momentum flux as scalar exchange
  LOGICAL,   INTENT(IN)    :: uflx         ! fluxes available (momentum)
  LOGICAL,   INTENT(IN)    :: ustar,tstar  ! friction veloc and temp available
  REAL,      INTENT(IN)    :: z0t          ! roughness length (m)
  REAL,      INTENT(INOUT) :: fmu          ! u-component momentum flux (N/m2)
  REAL,      INTENT(INOUT) :: fmv          ! v-component momentum flux (N/m2)
  REAL,      INTENT(IN)    :: fhs          ! sensible heat flux (W/m2)
  INTEGER,   INTENT(IN)    :: nl           ! number of output sigma levels
  REAL,      INTENT(IN)    :: uvar(:)      ! horizontal wind component (m/s)
  REAL,      INTENT(IN)    :: vvar(:)      ! horizontal wind component (m/s)
  REAL,      INTENT(IN)    :: tvar(:)      ! virtual potential temp (deg K)
  REAL,      INTENT(INOUT) :: zvar(:)      ! height at levels (m)
  REAL,      INTENT(IN)    :: evar(:)      ! turbulent kinetic energy (J/kg)
  REAL,      INTENT(IN)    :: dvar(:)      ! air density (kg/m3)
  REAL,      INTENT(INOUT) :: mixh         ! mixed layer depth (m)
  REAL,      INTENT(OUT)   :: psir         ! integrated stability function heat
  REAL,      INTENT(OUT)   :: ssp          ! static stability parameter (1/s2)
  END SUBROUTINE stbanl
!-------------------------------------------------------------------------------
  SUBROUTINE STBVAR(VSCALE,HSCALE,TKERD,TKERN,KZMIX,TVMIX,KSFC,NL, &
                    UVAR,VVAR,TVAR,ZVAR,EVAR,HVAR,XVAR)
  IMPLICIT NONE
  REAL,      INTENT(IN)    :: vscale    ! vertical Lagrangian time scale (sec)  !FN-20140610
  REAL,      INTENT(IN)    :: hscale    ! horizontal Lagrangian time scale (sec)!FN-20140610
  REAL,      INTENT(IN)    :: tkerd     ! day ratio of vert to horiz turb
  REAL,      INTENT(IN)    :: tkern     ! noght ratio of vert to horiz turb
  INTEGER,   INTENT(IN)    :: kzmix     ! height averaged mixing   
  REAL,      INTENT(IN)    :: tvmix     ! tropospheric mixing scale factor
  INTEGER,   INTENT(IN)    :: ksfc      ! index of top of surface layer
  INTEGER,   INTENT(IN)    :: nl        ! number of sigma levels
  REAL,      INTENT(IN)    :: uvar (:)    ! horizontal wind component
  REAL,      INTENT(IN)    :: vvar (:)    ! horizontal wind component
  REAL,      INTENT(IN)    :: tvar (:)    ! virtual potential temperature (pot K)
  REAL,      INTENT(IN)    :: zvar (:)    ! height at levels (m)
  REAL,      INTENT(INOUT) :: evar (:)    ! in TKE (J/kg), output  - V'2 (m2/s2)
  REAL,      INTENT(INOUT) :: hvar (:)    ! U component turbulence - U'2 (m2/s2)
  REAL,      INTENT(INOUT) :: xvar (:)    ! vertical turbulence    - W'2 (m2/s2)
  END SUBROUTINE stbvar
!-------------------------------------------------------------------------------
  END INTERFACE 
