!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  ADV2NT           ADVection INTerpolation of 2D meteo variable
!   PRGMMR:    ROLAND DRAXLER   ORG: R/ARL       DATE:96-06-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!   ADVECTION INTERPOLATION OF 3D METEO VARIABLES TO A POINT IN X,Y,
!   USING LINEAR METHODS.
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: ...
!                 17 Oct 2014 (FN)  - WRF-HYSPLIT inline coupling
!
!$$$

SUBROUTINE ADV2NT(S,X1,Y1,SS,ims,ime,jms,jme,kms,kme)

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------


  REAL,      INTENT(IN)    :: x1,y1         ! position of interpolated value
  REAL,      INTENT(OUT)   :: ss            ! value of S at x1,y1,z1

  INTEGER, INTENT(IN)      :: ims , ime , jms , jme , kms , kme

  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN) :: s

!-------------------------------------------------------------------------------
! internal variables
!-------------------------------------------------------------------------------

  INTEGER                  :: i1,j1,i1p,j1p
  REAL                     :: xf,yf,sb,st

! grid index values
  I1=INT(X1)
  J1=INT(Y1)

! assign dummy interpolation factors
  XF=X1
  YF=Y1

! set upper index
  I1P=I1+1
  J1P=J1+1

! to avoid array bounds violations:
  I1P=MIN(I1+1,ime)
  J1P=MIN(J1+1,jme)
  I1=MAX(I1,ims)
  J1=MAX(J1,jms)

! fractional interpolation factors to x1,y1,zx
  XF=XF-FLOAT(I1)
  YF=YF-FLOAT(J1)

! value at x1 bottom
  SB=(S(I1P,J1 )-S(I1,J1 ))*XF+S(I1,J1)
! value at x1 top 
  ST=(S(I1P,J1P)-S(I1,J1P))*XF+S(I1,J1P)
! value at x1,y1 
  SS=(ST-SB)*YF+SB

END SUBROUTINE adv2nt
