!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  ADV2PT           ADVection nearest PoinT of 2D meteo variable
!   PRGMMR:    ROLAND DRAXLER   ORG: R/ARL       DATE:96-06-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!   FINDS 2D METEO VARIABLES NEAREST TO A POINT IN X,Y 
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: 18 May 2011 (RRD) - initial version from adv2nt
!                 08 May 2014 (FN)  - WRF-HYSPLIT inline coupling
!
!$$$

SUBROUTINE ADV2PT(S,X1,Y1,SS,ims,ime,jms,jme,kms,kme)

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------


  REAL,      INTENT(IN)    :: x1,y1         ! position of interpolated value
  REAL,      INTENT(OUT)   :: ss            ! value of S at x1,y1,z1

  INTEGER,   INTENT(IN)    :: ims , ime , jms , jme , kms , kme

  REAL, DIMENSION(ims:ime,jms:jme), INTENT(IN) :: s

!-------------------------------------------------------------------------------
! internal variables
!-------------------------------------------------------------------------------

  INTEGER                  :: i1,j1

! grid index values
  I1=NINT(X1)
  J1=NINT(Y1)

! value at point
  SS=S(I1,J1)

END SUBROUTINE adv2pt
