!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  ADV3NT           ADVection iNTerpolation of 3D meteo variable
!   PRGMMR:    ROLAND DRAXLER   ORG: R/ARL       DATE:96-06-01
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!   ADVECTION INTERPOLATION OF 3D METEO VARIABLES TO A POINT IN X,Y,
!   USING LINEAR METHODS.
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: 14 Feb 1997 (RRD)
!                 17 Oct 2014 (FN)  - WRF-HYSPLIT inline coupling
!
!$$$

SUBROUTINE ADV3NT(S,X1,Y1,ZX,SS,ims,ime,jms,jme,kms,kme)

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------

  REAL,      INTENT(IN)    :: x1,y1         ! position of interpolated value
  REAL,      INTENT(IN)    :: zx            ! vertical interpolation fraction
  REAL,      INTENT(OUT)   :: ss            ! value of S at x1,y1,z1

  INTEGER,   INTENT(IN)    :: ims , ime , jms , jme , kms , kme

  REAL, DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: s
!-------------------------------------------------------------------------------
! internal variables
!-------------------------------------------------------------------------------

  INTEGER                  :: i1,j1,k1,i1p,j1p 
  REAL                     :: xf,yf,zf,sb,st,sh 

! grid index values
  I1=INT(X1)
  J1=INT(Y1)
  K1=INT(ZX)

! assign dummy interpolation factors
  XF=X1
  YF=Y1
  ZF=ZX

! set upper index
  I1P=I1+1
  J1P=J1+1

!! cyclic boundary conditions
!  IF(GLOBAL.AND.I1P.GT.NXP)I1P=1

! to avoid array bounds violations:
  I1P=MIN(I1+1,ime)
  J1P=MIN(J1+1,jme)
  I1=MAX(I1,ims)
  J1=MAX(J1,jms)

! fractional interpolation factors to x1,y1,zx
  XF=XF-FLOAT(I1)
  YF=YF-FLOAT(J1)
  ZF=ZF-FLOAT(K1)

! value at x1 along bottom of lowest layer
  SB=(S(I1P,K1, J1)-S(I1,K1, J1))*XF+S(I1,K1, J1)
! value at x1 along top of lowest layer
  ST=(S(I1P,K1,J1P)-S(I1,K1,J1P))*XF+S(I1,K1,J1P)
! value at x1,y1 of lowest layer
  SS=(ST-SB)*YF+SB

! value requested on lower boundary
  IF(ZF.EQ.0.0)RETURN

! value at x1 along bottom of upper layer
  SB=(S(I1P,K1+1, J1)-S(I1,K1+1, J1))*XF+S(I1,K1+1, J1)
! value at x1 along top of upper layer
  ST=(S(I1P,K1+1,J1P)-S(I1,K1+1,J1P))*XF+S(I1,K1+1,J1P)
! value at x1,y1 of upper layer
  SH=(ST-SB)*YF+SB

! value at x1,y1,z1
  SS=(SH-SS)*ZF+SS

END SUBROUTINE adv3nt
