!WRF:MEDIATION_LAYER:IO
!
!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  HYREMS           Read EMiSsion file
!   PRGMMR:    Fantine Ngan     ORG: R/ARL       DATE:05-20-15
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: 20 May 2015 (FN) - WRF-HYSPLIT coupling
!
! USAGE:  CALL hyrems ( grid , config_flags )
!     
!   INPUT ARGUMENT LIST:    see below
!   OUTPUT ARGUMENT LIST:   see below
!   INPUT FILES:            CONTRL
!   OUTPUT FILES:           none
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!   MACHINE:  IBM RS6000
!
!$$$

  subroutine hyrems ( grid , config_flags )

    use module_domain
    use module_configure

    implicit none

!-------------------------------------------------------------------------------
! wrf related variables
!-------------------------------------------------------------------------------

    ! input data
    type(domain)            :: grid

    !  structure that contains run-time configuration (namelist) data for domain
    type (grid_config_rec_type) , intent(in)          :: config_flags

!-------------------------------------------------------------------------------
! internal variables
!-------------------------------------------------------------------------------

  logical           :: flag
  character(200)    :: msg,label
  integer           :: ilabel,iunit,nn,kk
  integer           :: kdh,kdm,kdur
  integer           :: kyr,kmo,kda,khr,kmn,kqinc,nrec
  integer           :: nct

  character(200)    :: fname

!-------------------------------------------------------------------------------

  print *,'nnn hysp/hyrems',config_flags%numems,size(grid%evar%emlon)

  fname=config_flags%efile

  if ( trim(fname) .eq. "NONE_SPECIFIED" ) return

  print *,'nnn efile=',trim(fname)
 
  inquire(file=fname,exist=flag)

  if(flag)then
     iunit=25
     open(iunit,file=trim(fname),action='read')
     write(msg,*) 'opening EFILE for hysplit!'
     call wrf_message(msg)
  else
     call wrf_error_fatal('EFILE not found!')
  end if

  read(iunit,'(a)') label
  read(iunit,'(a)') label

  call tminit

  nct=0
  do nn=1,config_flags%numems

    read(iunit,*,end=2999) kyr,kmo,kda,khr,kqinc,nrec

    do kk=1,nrec

       nct=nct+1
       read(iunit,*,end=2999) kyr,kmo,kda,khr,kmn,kdur,   &
           grid%evar%emlat(nct),grid%evar%emlon(nct),grid%evar%emlvl(nct), &
           grid%evar%erate(nct),grid%evar%earea(nct),grid%evar%eheat(nct)

       kdh=kdur/100
       kdm=kdur-kdh*100
       kdur=kdh*60+kdm
       call tm2min(kyr,kmo,kda,khr,kmn,grid%evar%nmsst(nct))
       grid%evar%nmsen(nct)=grid%evar%nmsst(nct)+kdur
       print *,nct,grid%evar%nmsst(nct),grid%evar%nmsen(nct), &
                   grid%evar%emlat(nct),grid%evar%emlon(nct),grid%evar%emlvl(nct), &
                   grid%evar%erate(nct),grid%evar%earea(nct),grid%evar%eheat(nct)

    enddo

  enddo 
  2999 continue

  close(iunit)

  print *,'nnn end of hyrems => return back to wrf!'
  return
  end subroutine hyrems
