!-------------------------------------------------------------------------------
! Module for meteorological data arrays     
! Primarily referenced in subroutine advpnt and conditional compilation
! chemistry routines.
! Last Revised: ...
!               09 Dec 2013 (FN) - add variables for vertical coupling
!               28 Mar 2014 (FN) - rename variables 
!-------------------------------------------------------------------------------

MODULE metval

  REAL,    ALLOCATABLE :: hy_u  (:,:,:) ! x wind (inp m/s; out grid/min)
  REAL,    ALLOCATABLE :: hy_v  (:,:,:) ! v wind (inp m/s; out grid/min)
  REAL,    ALLOCATABLE :: hy_w  (:,:,:) ! z wind (inp dp/dt; out sigma/min)
  REAL,    ALLOCATABLE :: hy_a  (:,:,:) ! ambient temp (deg-K)
  REAL,    ALLOCATABLE :: hy_t  (:,:,:) ! potential temp (deg-K)
  REAL,    ALLOCATABLE :: hy_q  (:,:,:) ! humid (inp rh or kg/kg; out rh/100)
  REAL,    ALLOCATABLE :: hy_p  (:,:,:) ! local air pressure (mb)
  REAL,    ALLOCATABLE :: hy_e  (:,:,:) ! input TKE (J/kg), output V'2 (m2/s2)
  REAL,    ALLOCATABLE :: hy_x  (:,:,:) ! vertical turbulence      W'2 (m2/s2)
  REAL,    ALLOCATABLE :: hy_h  (:,:,:) ! horizontal turbulence    U'2 (m2/s2)

!FN-20131209
  REAL,    ALLOCATABLE :: etaf  (:)       ! eta values on full levels
  REAL,    ALLOCATABLE :: etah  (:)       ! eta values on half levels
  REAL,    ALLOCATABLE :: hyeta (:)       ! eta values for HYSPLIT
  REAL,    ALLOCATABLE :: colms (:,:  )   ! column mass per unit area (Pa)
  REAL,    ALLOCATABLE :: lvlzz (:,:,:)   ! layer height at half levels (m)

  REAL,    ALLOCATABLE :: pp0 (:,:)     ! model sfc press (mb)
  REAL,    ALLOCATABLE :: rt0 (:,:)     ! rainfall total (m)
  REAL,    ALLOCATABLE :: cf0 (:,:)     ! cloud fraction (%)
  REAL,    ALLOCATABLE :: uu0 (:,:)     ! low-level u horizontal wind (m/s)
  REAL,    ALLOCATABLE :: vv0 (:,:)     ! low-level v horizontal wind (m/s)
  REAL,    ALLOCATABLE :: tt0 (:,:)     ! low-level ambient temp (deg-K)
  REAL,    ALLOCATABLE :: rh0 (:,:)     ! 2 meter relative humidity 

                                            ! u,v flux replaced by U* in prfcom
  REAL,    ALLOCATABLE :: hy_uf (:,:) ! u momentum flux (n/m2) or (kg/m2-s)
  REAL,    ALLOCATABLE :: hy_vf (:,:) ! v momentum flux (n/m2) 
  REAL,    ALLOCATABLE :: hy_hf (:,:) ! sensible heat flux (w/m2)
  REAL,    ALLOCATABLE :: hy_sf (:,:) ! normalized stability function 
  REAL,    ALLOCATABLE :: hy_zi (:,:) ! mixed layer depth  (m)     
  REAL,    ALLOCATABLE :: hy_ds (:,:) ! downward shortwave flux (w/m2)
  REAL,    ALLOCATABLE :: hy_ss (:,:) ! static stability (1/s2)       

  REAL,    ALLOCATABLE :: hy_gx (:,:) ! grid dist (m)
  REAL,    ALLOCATABLE :: hy_gy (:,:) ! grid dist (m)
  REAL,    ALLOCATABLE :: hy_z0 (:,:) ! roughness length (m)
  REAL,    ALLOCATABLE :: hy_zt (:,:) ! terrain elevation (m)
  REAL,    ALLOCATABLE :: hy_lu (:,:) ! land use category

!FN-20140505
  INTEGER              :: neta              ! number of eta layer
  INTEGER              :: ddims(6)          ! WRF domain dimension (ids,ide, jds,jde, kds,kde)
  INTEGER              :: mdims(6)          ! WRF memory dimension (ims,ime, jms,jme, kms,kme)
  INTEGER              :: pdims(6)          ! WRF patch dimension  (ips,ipe, jps,jpe, kps,kpe)

!FN-20150506
  INTEGER              :: isfc              ! top of surface layer index

!FN-20140909
  REAL,    ALLOCATABLE :: cella (:,:)       ! cell area of WRF grid

  SAVE hy_u,hy_v,hy_w,hy_a,hy_t,hy_q,hy_e,hy_p,hy_x,hy_h, &
       etaf,etah,hyeta,colms,lvlzz,cella,                 & !FN-20131209
       pp0,rt0,cf0,uu0,vv0,tt0,hh0,                       &
       hy_uf,hy_vf,hy_hf,hy_sf,hy_zi,hy_ds,hy_ss,         &
       hy_gx,hy_gy,hy_z0,hy_zt,hy_lu,                     &
       neta,isfc

END MODULE metval
