!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  PAROUT           PARticle OUTput to file
!   PRGMMR:    ROLAND DRAXLER   ORG: R/ARL       DATE:05-08-03
!
! ABSTRACT:  THIS CODE WRITTEN AT THE AIR RESOURCES LABORATORY ...
!   WRITES ALL THE POLLUTANT PARTICLE INFORMATION TO A FILE WHICH
!   CAN BE USED TO INITIALIZE THE MODEL OR POSTPROCESSING GRPAHICS.
!   THE FILE MAY CONTAIN ONE OR MORE TIME PERIODS. 
!
! PROGRAM HISTORY LOG:
!   LAST REVISED: ...
!                 07 Jan 2014 (FN) - vertical couplng
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!   MACHINE:  IBM RS6000
!
!$$$

SUBROUTINE PAROUT(JET,KPM,MASS,XPRT,YPRT,ZPOS,SIGH,SIGU,    &
                  SIGV,SIGW,HDWP,PAGE,PTYP,PGRD,NSORT)

  USE funits

  IMPLICIT NONE

  INCLUDE 'DEFGRID.INC'

!-------------------------------------------------------------------------------
! argument list variables
!-------------------------------------------------------------------------------

  INTEGER, INTENT(INOUT) :: kpm        ! total number of puffs or particles
  REAL,    INTENT(INOUT) :: mass (:,:) ! mass of pollutant (arbitrary units)
  REAL,    INTENT(INOUT) :: xprt (:)   ! particle latitude
  REAL,    INTENT(INOUT) :: yprt (:)   ! particle longitude
  REAL,    INTENT(INOUT) :: zpos (:)   ! particle height (AGL)
  REAL,    INTENT(INOUT) :: sigh (:)   ! horizontal puff sigma 
  REAL,    INTENT(INOUT) :: sigu (:)   ! turbulence u'2    
  REAL,    INTENT(INOUT) :: sigv (:)   ! turbulence v'2
  REAL,    INTENT(INOUT) :: sigw (:)   ! turbulence w'2 or vertical puff sigma
  INTEGER, INTENT(INOUT) :: hdwp (:)   ! Horizontal distribution pollutant
  INTEGER, INTENT(INOUT) :: page (:)   ! pollutant age since release (min)
  INTEGER, INTENT(INOUT) :: ptyp (:)   ! pollutant type index number
  INTEGER, INTENT(INOUT) :: pgrd (:)   ! meteorological grid of puff position
  INTEGER, INTENT(INOUT) :: nsort(:)   ! sort index array by position
  INTEGER(KIND=8),   INTENT(IN)    :: jet     ! current elapsed time (sec) !FN-20140515

!-------------------------------------------------------------------------------

  REAL     :: TLAT,TLON  ! particle position
  REAL     :: ZTMP       ! particle height
  INTEGER  :: NUMPOL     ! number of different pollutants
  INTEGER  :: IYR        ! file year
  INTEGER  :: IMO        ! file month
  INTEGER  :: IDA        ! file day 
  INTEGER  :: IHR        ! file hour 
  INTEGER  :: IMN        ! file minutes
  INTEGER  :: I,J        ! local indicies
  INTEGER  :: mjet

  COMMON /GBLGRD/ HYGD, DREC, HYFL

!-------------------------------------------------------------------------------

! set pollutant dimension
  NUMPOL=SIZE(mass,1)

  MJET=INT(JET/60)
  print *,'sss parout mjet=',mjet,jet

  CALL TM2DAY(MJET,IYR,IMO,IDA,IHR,IMN)
  WRITE(KF24)KPM,NUMPOL,IYR,IMO,IDA,IHR

  DO J=1,KPM

!FN-20140321
!!    convert positions to lat/lon before dump
!     IF(HYGD(PGRD(J),1)%LATLON)THEN
!        CALL GBL2LL(PGRD(J),1,XPOS(J),YPOS(J),TLAT,TLON)
!     ELSE
!        CALL CXY2LL(HYGD(PGRD(J),1)%GBASE,XPOS(J),YPOS(J),TLAT,TLON)
!     END IF

!FN-20140620, input xpos & ypps are lat/long
!     CALL CXY2LL(HYGD%GBASE,XPOS(J),YPOS(J),TLAT,TLON)

     TLAT=XPRT(J)     ! particle latitude               !FN-20140620
     TLON=YPRT(J)     ! particle longitude              !FN-20140620

!FN-20140107
!!    convert sigma to agl assuming terrain height = 0
!     ZTMP=(1.0-ZPOS(J))*ZMDL

     ZTMP=ZPOS(J)     ! particle position at height (m) !FN-20140107

     WRITE(KF24)(MASS(I,J),I=1,NUMPOL)
!    additional variables not yet supported in supplemental programs
!    WRITE(KF24)TLAT,TLON,ZTMP,SIGH(J),SIGW(J),SIGV(J),SIGU(J)
     WRITE(KF24)TLAT,TLON,ZTMP,SIGH(J),SIGW(J),SIGV(J)
     WRITE(KF24)PAGE(J),HDWP(J),PTYP(J),PGRD(J),NSORT(J)

  END DO

  print *,'sss parout iyr=',IYR,IMO,IDA,IHR,IMN
  print *,'sss KPM=',KPM

END SUBROUTINE parout
