!-------------------------------------------------------------------------------
! Configure subroutine interface argument lists for subroutine ADVPNT     
! Last Revised: 07 Sep 2001 (RRD) - simultaneous multiple meteorology
!               26 Feb 2002 (RRD) - downward shortwave flux: metinp, advmet
!               21 May 2002 (RRD) - divergence options: metwnd
!               23 Jul 2002 (RRD) - terrain correction eta: metwnd
!               10 Apr 2003 (RRD) - advmet, adviec temporal interpolation
!               16 Sep 2003 (RRD) - added routine advsfc
!               10 Nov 2003 (RRD) - velocity variances through metinp
!               25 Oct 2004 (RRD) - pass through tratio
!               12 Oct 2005 (RRD) - added routine adviso
!               08 Mar 2006 (RRD) - static stability (prfcom, advmet)
!               22 May 2006 (RRD) - mixed layer depth (metinp)
!               21 Nov 2006 (RRD) - day night tke partition
!               04 Jun 2008 (RRD) - additional mixing options prfcom
!               20 Mar 2009 (RRD) - fraction cloud to metinp
!               04 Apr 2009 (RRD) - inout for surface wind and temp
!               24 Jan 2011 (GDR) - inout for 2 meter RH
!               29 Aug 2011 (RRD) - temporal averaging flag for velocities
!               01 Nov 2011 (RRD) - conversion ICHEM to argument advmet
!                  Sep 2012 (FN)  - WRF-HYSPLIT coupling
!-------------------------------------------------------------------------------

INTERFACE

!-------------------------------------------------------------------------------
  SUBROUTINE ADVIEC(XU,XV,XW,XX,YY,ZZ,ZX,DT,TRATIO,GLOBAL,   &
                    ids, ide, jds, jde, kds, kde,    &
                    ims, ime, jms, jme, kms, kme,    &
                    ips, ipe, jps, jpe, kps, kpe     )
  IMPLICIT NONE
  REAL, DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: xu,xv,xw
  REAL,    INTENT(IN)    :: dt              ! integration step (minutes)
  REAL,    INTENT(IN)    :: tratio          ! time step stability criterion
  LOGICAL, INTENT(IN)    :: global          ! global cyclic boundary conditions
  REAL,    INTENT(INOUT) :: xx,yy,zz        ! old (t) and new (t+dt) position
  REAL,    INTENT(OUT)   :: zx              ! last estimate of vertical index
  INTEGER, INTENT(IN)    ::  ids , ide , jds , jde , kds , kde , &
                             ims , ime , jms , jme , kms , kme , &
                             ips , ipe , jps , jpe , kps , kpe
  END SUBROUTINE adviec
!-------------------------------------------------------------------------------
  SUBROUTINE ADVMET(METZ,METO,VMIX,CDEP,RDEP,TRAJ,XP,YP,JET,       &
                  KCYCLE,NLVL,XGX,XGY,XZ0,XLU,XZT,               &
                  XXA,XXT,XXQ,XXP,XLVLZZ,XCOLMS,XXE,XXX,         &
                  XZI,XXH,XU0,XV0,XRT,XCF,XUF,XVF,XSF,XSS,XDS,   &
                  DSWF,GLOBAL,NXP,NYP,XT0,XP0,XH0,ICHEM)
  IMPLICIT NONE
  INCLUDE 'DEFMETO.INC'
  TYPE(bset),INTENT(OUT)   :: metz (:)   ! profile advection variables
  TYPE(aset),INTENT(INOUT) :: meto       ! surface advection variables
  LOGICAL,   INTENT(IN)    :: vmix,cdep,rdep,traj
  REAL,      INTENT(IN)    :: xp,yp
  INTEGER,   INTENT(IN)    :: jet
  INTEGER,   INTENT(IN)    :: kcycle,nlvl
  REAL,      INTENT(IN)    :: xgx(:,:), xgy(:,:), xz0(:,:), xlu(:,:), xzt(:,:)
  REAL,      INTENT(IN)    :: xxa(:,:,:), xxt(:,:,:), xxq(:,:,:), xxp(:,:,:)
  REAL,      INTENT(IN)    :: xcolms(:,:)
  REAL,      INTENT(IN)    :: xlvlzz(:,:,:)  !FN-20140107
  REAL,      INTENT(IN)    :: xxe(:,:,:), xxx(:,:,:), xxh(:,:,:)
  REAL,      INTENT(IN)    :: xu0(:,:),  xv0(:,:),  xss(:,:)
  REAL,      INTENT(IN)    :: xt0(:,:),  xp0(:,:),  xh0(:,:)
  REAL,      INTENT(IN)    :: xuf(:,:),  xvf(:,:),  xsf(:,:)
  REAL,      INTENT(IN)    :: xzi(:,:),  xrt(:,:),  xcf(:,:), xds(:,:)
  LOGICAL,   INTENT(IN)    :: dswf          ! downward shortwave flag
  LOGICAL,   INTENT(IN)    :: global        ! global cyclic boundary conditions
  INTEGER,   INTENT(IN)    :: nxp,nyp       ! global boundary values
  INTEGER,   INTENT(IN)    :: ichem         ! special conversion options
  END SUBROUTINE advmet
!-------------------------------------------------------------------------------
END INTERFACE
