
!*  GENERAL CONFORMAL MAP ROUTINES FOR METEOROLOGICAL MODELERS
!*  WRITTEN ON 3/31/94 BY

!* Dr. Albion Taylor
!* NOAA / OAR / ARL                  Phone: (301) 713-0295 x 132
!* Rm. 3151, 1315 East-West Highway  Fax:   (301) 713-0119
!* Silver Spring, MD 20910           E-mail: ADTaylor@arlrisc.ssmc.noaa.gov

!*  SUBROUTINE STLMBR (STRCMP, TNGLAT, CLONG)
!*    THIS ROUTINE INITIALIZES THE MAP STRUCTURE ARRAY STRCMP TO
!*    THE FORM OF A SPECIFIC MAP PROJECTION
!*  INPUTS:
!*    TNGLAT - THE LATITUDE AT WHICH THE PROJECTION WILL BE TANGENT
!*             TO THE EARTH.  +90. FOR NORTH POLAR STEREOGRAPHIC,
!*             -90. FOR SOUTH POLAR STEREOGRAPHIC, 0. FOR MERCATOR,
!*             AND OTHER VALUES FOR LAMBERT CONFORMAL.
!*             -90 <= TNGLAT <= 90.
!*    CLONG -  A LONGITUDE IN THE REGION UNDER CONSIDERATION.  LONGITUDES
!*             BETWEEN CLONG-180. AND CLONG+180.  WILL BE MAPPED IN ONE
!*             CONNECTED REGION
!*  OUTPUTS:
!*    STRCMP - A 9-VALUE MAP STRUCTURE ARRAY FOR USE WITH SUBSEQUENT
!*             CALLS TO THE COORDINATE TRANSFORM ROUTINES.
!*
!*  REAL FUNCTION EQVLAT (XLAT1,XLAT2)
!*    THIS FUNCTION IS PROVIDED TO ASSIST IN FINDING THE TANGENT LATITUDE
!*    EQUIVALENT TO THE 2-REFERENCE LATITUDE SPECIFICATION IN THE LEGEND
!*    OF MOST LAMBERT CONFORMAL MAPS.  IF THE MAP SPECIFIES "SCALE
!*    1:XXXXX TRUE AT 40N AND 60N", THEN EQVLAT(40.,60.) WILL RETURN THE
!*    EQUIVALENT TANGENT LATITUDE.
!*  INPUTS:
!*    XLAT1,XLAT2:  THE TWO LATITUDES SPECIFIED IN THE MAP LEGEND
!*  RETURNS:
!*    THE EQUIVALENT TANGENT LATITUDE
!*  EXAMPLE:  CALL STLMBR(STRCMP, EQVLAT(40.,60.), 90.)

!*  SUBROUTINE STCM2P (STRCMP, X1,Y1, XLAT1,XLONG1,
!*          X2,Y2, XLAT2,XLONG2)
!*  SUBROUTINE STCM1P (STRCMP, X1,Y1, XLAT1,XLONG1,
!*          XLATG,XLONGG, GRIDSZ, ORIENT)
!*    THESE ROUTINES COMPLETE THE SPECIFICATION OF THE MAP STRUCTURE
!*    ARRAY BY CONFORMING THE MAP COORDINATES TO THE SPECIFICATIONS
!*    OF A PARTICULAR GRID.  EITHER STCM1P OR STCM2P MUST BE CALLED,
!*    BUT NOT BOTH
!*  INPUTS:
!*    STRCMP - A 9-VALUE MAP STRUCTURE ARRAY, SET TO A PARTICULAR MAP
!*             FORM BY A PREVIOUS CALL TO STLMBR
!*    FOR STCM2P:
!*      X1,Y1, X2,Y2 - THE MAP COORDINATES OF TWO POINTS ON THE GRID
!*      XLAT1,XLONG1, XLAT2,XLONG2 - THE GEOGRAPHIC COORDINATES OF THE
!*             SAME TWO POINTS
!*    FOR STCM1P:
!*      X1,Y1 - THE MAP COORDINATES OF ONE POINT ON THE GRID
!*      XLAT1,XLONG1 - THE GEOGRAPHIC COORDINATES OF THE SAME POINT
!*      XLATG,XLONGG - LATITUDE AND LONGITUDE OF REFERENCE POINT FOR
!*             GRIDSZ AND ORIENTATION SPECIFICATION.
!*      GRIDSZ - THE DESIRED GRID SIZE IN KILOMETERS, AT XLATG,XLONGG
!*      ORIENT - THE ANGLE, WITH RESPECT TO NORTH, OF A Y-GRID LINE, AT
!*             THE POINT XLATG,XLONGG
!*  OUTPUTS:
!*    STRCMP - A 9-VALUE MAP STRUCTURE ARRAY, FULLY SET FOR USE BY
!*             OTHER SUBROUTINES IN THIS SYSTEM

!*  SUBROUTINE CLL2XY (STRCMP, XLAT,XLONG, X,Y)
!*  SUBROUTINE CXY2LL (STRCMP, X,Y, XLAT,XLONG)
!*     THESE ROUTINES CONVERT BETWEEN MAP COORDINATES X,Y
!*     AND GEOGRAPHIC COORDINATES XLAT,XLONG
!*  INPUTS:
!*     STRCMP(9) - 9-VALUE MAP STRUCTURE ARRAY
!*     FOR CLL2XY:  XLAT,XLONG - GEOGRAPHIC COORDINATES
!*     FOR CXY2LL:  X,Y - MAP COORDINATES
!*  OUTPUTS:
!*     FOR CLL2XY:  X,Y - MAP COORDINATES
!*     FOR CXY2LL:  XLAT,XLONG - GEOGRAPHIC COORDINATES

!*  SUBROUTINE CC2GXY (STRCMP, X,Y, UE,VN, UG,VG)
!*  SUBROUTINE CG2CXY (STRCMP, X,Y, UG,VG, UE,VN)
!*  SUBROUTINE CC2GLL (STRCMP, XLAT,XLONG, UE,VN, UG,VG)
!*  SUBROUTINE CG2CLL (STRCMP, XLAT,XLONG, UG,VG, UE,VN)
!*     THESE SUBROUTINES CONVERT VECTOR WIND COMPONENTS FROM
!*     GEOGRAPHIC, OR COMPASS, COORDINATES, TO MAP OR
!*     GRID COORDINATES.  THE SITE OF THE WIND TO BE
!*     CONVERTED MAY BE GIVEN EITHER IN GEOGRAPHIC OR
!*     MAP COORDINATES.  WIND COMPONENTS ARE ALL IN KILOMETERS
!*     PER HOUR, WHETHER GEOGRAPHIC OR MAP COORDINATES.
!*  INPUTS:
!*    STRCMP(9) - 9-VALUE MAP STRUCTURE ARRAY
!*    FOR CC2GXY AND CG2CXY:  X,Y        -  MAP COORDINATES OF SITE
!*    FOR CC2GLL AND CG2CLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
!*    FOR CC2GXY AND CC2GLL:  UE,VN - EAST AND NORTH WIND COMPONENTS
!*    FOR CG2CXY AND CG2CLL:  UG,VG - X- AND Y- DIRECTION WIND COMPONENTS
!*  OUTPUTS:
!*    FOR CC2GXY AND CC2GLL:  UG,VG - X- AND Y- DIRECTION WIND COMPONENTS
!*    FOR CG2CXY AND CG2CLL:  UE,VN - EAST AND NORTH WIND COMPONENTS
!*  3/9/99 CHANGES MADE IN THE C C2G AND G2C ROUTINES TO ALLOW UG,VG AND UE,VN T
!* SHARE THE SAME STORAGE BEFORE AND AFTER BEING CALLED

!*  SUBROUTINE CCRVXY (STRCMP, X, Y,       GX,GY)
!*  SUBROUTINE CCRVLL (STRCMP, XLAT,XLONG, GX,GY)
!*    THESE SUBROUTINES RETURN THE CURVATURE VECTOR (GX,GY), AS REFERENCED
!*    TO MAP COORDINATES, INDUCED BY THE MAP TRANSFORMATION.  WHEN
!*    NON-LINEAR TERMS IN WIND SPEED ARE IMPORTANT, A "GEODESIC" FORCE
!*    SHOULD BE INCLUDED IN THE VECTOR FORM [ (U,U) G - (U,G) U ] WHERE THE
!*    INNER PRODUCT (U,G) IS DEFINED AS UX*GX + UY*GY.
!*  INPUTS:
!*    STRCMP(9) - 9-VALUE MAP STRUCTURE ARRAY
!*    FOR CCRVXY:  X,Y        -  MAP COORDINATES OF SITE
!*    FOR CCRVLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
!*  OUTPUTS:
!*    GX,GY       - VECTOR COEFFICIENTS OF CURVATURE, IN UNITS RADIANS
!*                  PER KILOMETER

!*  REAL FUNCTION CGSZLL (STRCMP, XLAT,XLONG)
!*  REAL FUNCTION CGSZXY (STRCMP, X,Y)
!*    THESE FUNCTIONS RETURN THE SIZE, IN KILOMETERS, OF EACH UNIT OF
!*    MOTION IN MAP COORDINATES (GRID SIZE).  THE GRID SIZE AT ANY
!*    LOCATION DEPENDS ON THAT LOCATION; THE POSITION MAY BE GIVEN IN
!*    EITHER MAP OR GEOGRAPHIC COORDINATES.
!*  INPUTS:
!*    STRCMP(9) - 9-VALUE MAP STRUCTURE ARRAY
!*    FOR CGSZXY:  X,Y        -  MAP COORDINATES OF SITE
!*    FOR CGSZLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
!*  RETURNS:
!*    GRIDSIZE IN KILOMETERS AT GIVEN SITE.

!*  SUBROUTINE CPOLXY (STRCMP, X,Y, ENX,ENY,ENZ)
!*  SUBROUTINE CPOLLL (STRCMP, XLAT,XLONG, ENX,ENY,ENZ)
!*    THESE SUBROUTINES PROVIDE 3-D VECTOR COMPONENTS OF A UNIT VECTOR
!*    IN THE DIRECTION OF THE NORTH POLAR AXIS.  WHEN MULTIPLIED
!*    BY TWICE THE ROTATION RATE OF THE EARTH (2 * PI/24 HR), THE
!*    VERTICAL COMPONENT YIELDS THE CORIOLIS FACTOR.
!*  INPUTS:
!*    STRCMP(9) - 9-VALUE MAP STRUCTURE ARRAY
!*    FOR CPOLXY:  X,Y        -  MAP COORDINATES OF SITE
!*    FOR CPOLLL:  XLAT,XLONG -  GEOGRAPHIC COORDINATES OF SITE
!*  RETURNS:
!*    ENX,ENY,ENZ THE DIRECTION COSINES OF A UNIT VECTOR IN THE
!*    DIRECTION OF THE ROTATION AXIS OF THE EARTH

!*  SUBROUTINE CNLLXY (STRCMP, XLAT,XLONG, XI,ETA)
!*  SUBROUTINE CNXYLL (STRCMP, XI,ETA, XLAT,XLONG)
!*    THESE SUBROUTINES PERFORM THE UNDERLYING TRANSFORMATIONS FROM
!*    GEOGRAPHIC COORDINATES TO AND FROM CANONICAL (EQUATOR CENTERED)
!*    COORDINATES.  THEY ARE CALLED BY CXY2LL AND CLL2XY, BUT ARE NOT
!*    INTENDED TO BE CALLED DIRECTLY

!*  REAL FUNCTION CSPANF (VALUE, BEGIN, END)
!*    THIS FUNCTION ASSISTS OTHER ROUTINES IN PROVIDING A LONGITUDE IN
!*    THE PROPER RANGE.  IT ADDS TO VALUE WHATEVER MULTIPLE OF
!*    (END - BEGIN) IS NEEDED TO RETURN A NUMBER BEGIN < CSPANF <= END

      SUBROUTINE STLMBR(STRCMP, TNGLAT, XLONG)
!*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL
      PARAMETER (PI=3.14159265358979,RADPDG=PI/180,DGPRAD=180/PI)
      PARAMETER (REARTH=6371.2)
      REAL STRCMP(9)
      STRCMP(1) = SIN(RADPDG * TNGLAT)
!*  GAMMA = SINE OF THE TANGENT LATITUDE
      STRCMP(2) = CSPANF( XLONG, -180., +180.)
!* LAMBDA_0 = REFERENCE LONGITUDE
      STRCMP(3) = 0.
!* X_0 = X- GRID COORDINATE OF ORIGIN (XI,ETA) = (0.,0.)
      STRCMP(4) = 0.
!* y_0 = Y-GRID COORDINATE OF ORIGIN (XI,ETA) = (0.,0.)
      STRCMP(5) = 1.
!* COSINE OF ROTATION ANGLE FROM XI,ETA TO X,Y
      STRCMP(6) = 0.
!* SINE OF ROTATION ANGLE FROM XI,ETA TO X,Y
      STRCMP(7) = REARTH
!* GRIDSIZE IN KILOMETERS AT THE EQUATOR
      CALL CNLLXY(STRCMP, 89.,XLONG, XI,ETA)
      STRCMP(8) = 2. * ETA - STRCMP(1) * ETA * ETA
!* RADIAL COORDINATE FOR 1 DEGREE FROM NORTH POLE
      CALL CNLLXY(STRCMP, -89.,XLONG, XI,ETA)
         STRCMP(9) = 2. * ETA - STRCMP(1) * ETA * ETA
!* RADIAL COORDINATE FOR 1 DEGREE FROM SOUTH POLE
      RETURN
      END
